/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;

public class GestureDetector {
    private static final int DOUBLE_TAP_TIMEOUT = 0;
    private static final int LONGPRESS_TIMEOUT = 0;
    private static final int LONG_PRESS = 2;
    private static final int SHOW_PRESS = 1;
    private static final int TAP = 3;
    private static final int TAP_TIMEOUT;
    private boolean mAlwaysInBiggerTapRegion;
    private boolean mAlwaysInTapRegion;
    private int mBiggerTouchSlopSquare;
    private MotionEvent mCurrentDownEvent;
    private OnDoubleTapListener mDoubleTapListener;
    private int mDoubleTapSlopSquare;
    private final Handler mHandler;
    private boolean mIgnoreMultitouch;
    private boolean mInLongPress;
    private boolean mIsDoubleTapping;
    private boolean mIsLongpressEnabled;
    private float mLastMotionX;
    private float mLastMotionY;
    private final OnGestureListener mListener;
    private int mMaximumFlingVelocity;
    private int mMinimumFlingVelocity;
    private MotionEvent mPreviousUpEvent;
    private boolean mStillDown;
    private int mTouchSlopSquare;
    private VelocityTracker mVelocityTracker;

    static {
        LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener) {
        this(context, onGestureListener, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler) {
        boolean bl = context != null && context.getApplicationInfo().targetSdkVersion >= 8;
        this(context, onGestureListener, handler, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler, boolean bl) {
        this.mBiggerTouchSlopSquare = 400;
        if (handler != null) {
            GestureHandler gestureHandler = new GestureHandler(handler);
            this.mHandler = gestureHandler;
        } else {
            GestureHandler gestureHandler = new GestureHandler();
            this.mHandler = gestureHandler;
        }
        this.mListener = onGestureListener;
        if (onGestureListener instanceof OnDoubleTapListener) {
            OnDoubleTapListener onDoubleTapListener = (OnDoubleTapListener)((Object)onGestureListener);
            this.setOnDoubleTapListener(onDoubleTapListener);
        }
        this.init(context, bl);
    }

    @Deprecated
    public GestureDetector(OnGestureListener onGestureListener) {
        this(null, onGestureListener, null);
    }

    @Deprecated
    public GestureDetector(OnGestureListener onGestureListener, Handler handler) {
        this(null, onGestureListener, handler);
    }

    private void cancel() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mIsDoubleTapping = false;
        this.mStillDown = false;
        if (!this.mInLongPress) {
            return;
        }
        this.mInLongPress = false;
    }

    private void dispatchLongPress() {
        this.mHandler.removeMessages(3);
        this.mInLongPress = true;
        OnGestureListener onGestureListener = this.mListener;
        MotionEvent motionEvent = this.mCurrentDownEvent;
        onGestureListener.onLongPress(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(Context context, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mListener == null) {
            throw new NullPointerException("OnGestureListener must not be null");
        }
        this.mIsLongpressEnabled = true;
        this.mIgnoreMultitouch = bl;
        if (context == null) {
            int n5;
            int n6;
            n4 = ViewConfiguration.getTouchSlop();
            n3 = ViewConfiguration.getDoubleTapSlop();
            this.mMinimumFlingVelocity = n6 = ViewConfiguration.getMinimumFlingVelocity();
            this.mMaximumFlingVelocity = n5 = ViewConfiguration.getMaximumFlingVelocity();
        } else {
            int n7;
            int n8;
            ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
            n4 = viewConfiguration.getScaledTouchSlop();
            n3 = viewConfiguration.getScaledDoubleTapSlop();
            this.mMinimumFlingVelocity = n8 = viewConfiguration.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = n7 = viewConfiguration.getScaledMaximumFlingVelocity();
        }
        this.mTouchSlopSquare = n2 = n4 * n4;
        this.mDoubleTapSlopSquare = n = n3 * n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConsideredDoubleTap(MotionEvent motionEvent, MotionEvent motionEvent2, MotionEvent motionEvent3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l;
        long l2;
        if (!this.mAlwaysInBiggerTapRegion) {
            return false;
        }
        long l3 = motionEvent3.getEventTime();
        long l4 = l3 - (l2 = motionEvent2.getEventTime());
        if (l4 > (l = (long)DOUBLE_TAP_TIMEOUT)) {
            return false;
        }
        int n7 = (int)motionEvent.getX();
        int n8 = n7 - (n6 = (int)motionEvent3.getX());
        int n9 = n8 * n8;
        int n10 = n9 + (n5 = (n4 = (n3 = (int)motionEvent.getY()) - (n2 = (int)motionEvent3.getY())) * n4);
        if (n10 >= (n = this.mDoubleTapSlopSquare)) return false;
        return true;
    }

    public boolean isLongpressEnabled() {
        return this.mIsLongpressEnabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        float f = motionEvent.getY();
        float f2 = motionEvent.getX();
        if (this.mVelocityTracker == null) {
            VelocityTracker velocityTracker;
            this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        MotionEvent motionEvent2 = motionEvent;
        velocityTracker.addMovement(motionEvent2);
        boolean bl = false;
        switch (n & 0xFF) {
            case 5: {
                if (!this.mIgnoreMultitouch) return bl;
                this.cancel();
                return bl;
            }
            case 6: {
                VelocityTracker velocityTracker2;
                float f3;
                float f4;
                int n2;
                if (!this.mIgnoreMultitouch) return bl;
                int n3 = motionEvent.getPointerCount();
                if (n3 != (n2 = 2)) return bl;
                int n4 = (0xFF00 & n) >> 8 == 0 ? 1 : 0;
                MotionEvent motionEvent3 = motionEvent;
                int n5 = n4;
                this.mLastMotionX = f4 = motionEvent3.getX(n5);
                MotionEvent motionEvent4 = motionEvent;
                int n6 = n4;
                this.mLastMotionY = f3 = motionEvent4.getY(n6);
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = velocityTracker2 = VelocityTracker.obtain();
                return bl;
            }
            case 0: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                MotionEvent motionEvent5;
                float f5;
                float f6;
                if (this.mDoubleTapListener != null) {
                    MotionEvent motionEvent6;
                    MotionEvent motionEvent7;
                    MotionEvent motionEvent8;
                    MotionEvent motionEvent9;
                    MotionEvent motionEvent10;
                    GestureDetector gestureDetector;
                    boolean bl6 = this.mHandler.hasMessages(3);
                    if (bl6) {
                        this.mHandler.removeMessages(3);
                    }
                    if (this.mCurrentDownEvent != null && this.mPreviousUpEvent != null && bl6 && (gestureDetector = this).isConsideredDoubleTap(motionEvent10 = (motionEvent9 = this.mCurrentDownEvent), motionEvent8 = (motionEvent7 = this.mPreviousUpEvent), motionEvent6 = motionEvent)) {
                        boolean bl7;
                        this.mIsDoubleTapping = bl7 = true;
                        OnDoubleTapListener onDoubleTapListener = this.mDoubleTapListener;
                        MotionEvent motionEvent11 = this.mCurrentDownEvent;
                        boolean bl8 = onDoubleTapListener.onDoubleTap(motionEvent11);
                        boolean bl9 = bl | bl8;
                        OnDoubleTapListener onDoubleTapListener2 = this.mDoubleTapListener;
                        MotionEvent motionEvent12 = motionEvent;
                        boolean bl10 = onDoubleTapListener2.onDoubleTapEvent(motionEvent12);
                        bl = bl9 | bl10;
                    } else {
                        Handler handler = this.mHandler;
                        long l = DOUBLE_TAP_TIMEOUT;
                        boolean bl11 = handler.sendEmptyMessageDelayed(3, l);
                    }
                }
                this.mLastMotionX = f6 = f2;
                this.mLastMotionY = f5 = f;
                if (this.mCurrentDownEvent != null) {
                    this.mCurrentDownEvent.recycle();
                }
                this.mCurrentDownEvent = motionEvent5 = MotionEvent.obtain(motionEvent);
                this.mAlwaysInTapRegion = bl5 = true;
                this.mAlwaysInBiggerTapRegion = bl4 = true;
                this.mStillDown = bl3 = true;
                this.mInLongPress = bl2 = false;
                if (this.mIsLongpressEnabled) {
                    this.mHandler.removeMessages(2);
                    Handler handler = this.mHandler;
                    long l = this.mCurrentDownEvent.getDownTime();
                    long l2 = TAP_TIMEOUT;
                    long l3 = l + l2;
                    long l4 = LONGPRESS_TIMEOUT;
                    long l5 = l3 + l4;
                    boolean bl12 = handler.sendEmptyMessageAtTime(2, l5);
                }
                Handler handler = this.mHandler;
                long l = this.mCurrentDownEvent.getDownTime();
                long l6 = TAP_TIMEOUT;
                long l7 = l + l6;
                boolean bl13 = handler.sendEmptyMessageAtTime(1, l7);
                OnGestureListener onGestureListener = this.mListener;
                MotionEvent motionEvent13 = motionEvent;
                boolean bl14 = onGestureListener.onDown(motionEvent13);
                return bl |= bl14;
            }
            case 2: {
                float f7;
                float f8;
                if (this.mInLongPress) return bl;
                if (this.mIgnoreMultitouch) {
                    int n7;
                    int n8 = motionEvent.getPointerCount();
                    if (n8 > (n7 = 1)) return bl;
                }
                float f9 = this.mLastMotionX - f2;
                float f10 = this.mLastMotionY - f;
                if (this.mIsDoubleTapping) {
                    OnDoubleTapListener onDoubleTapListener = this.mDoubleTapListener;
                    MotionEvent motionEvent14 = motionEvent;
                    boolean bl15 = onDoubleTapListener.onDoubleTapEvent(motionEvent14);
                    return bl |= bl15;
                }
                if (this.mAlwaysInTapRegion) {
                    boolean bl16;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    float f11;
                    int n14;
                    int n15;
                    float f12 = this.mCurrentDownEvent.getX();
                    int n16 = (int)(f2 - f12);
                    int n17 = n16 * n16;
                    int n18 = n17 + (n15 = (n14 = (int)(f - (f11 = this.mCurrentDownEvent.getY()))) * n14);
                    int n19 = n18;
                    if (n19 > (n13 = (n12 = this.mTouchSlopSquare))) {
                        boolean bl17;
                        float f13;
                        float f14;
                        OnGestureListener onGestureListener = this.mListener;
                        MotionEvent motionEvent15 = this.mCurrentDownEvent;
                        OnGestureListener onGestureListener2 = onGestureListener;
                        MotionEvent motionEvent16 = motionEvent15;
                        MotionEvent motionEvent17 = motionEvent;
                        float f15 = f9;
                        float f16 = f10;
                        bl = onGestureListener2.onScroll(motionEvent16, motionEvent17, f15, f16);
                        this.mLastMotionX = f14 = f2;
                        this.mLastMotionY = f13 = f;
                        this.mAlwaysInTapRegion = bl17 = false;
                        this.mHandler.removeMessages(3);
                        this.mHandler.removeMessages(1);
                        this.mHandler.removeMessages(2);
                    }
                    if ((n11 = n18) <= (n10 = (n9 = this.mBiggerTouchSlopSquare))) return bl;
                    this.mAlwaysInBiggerTapRegion = bl16 = false;
                    return bl;
                }
                if (!(Math.abs(f9) >= 1.0f)) {
                    if (!(Math.abs(f10) >= 1.0f)) return bl;
                }
                OnGestureListener onGestureListener = this.mListener;
                MotionEvent motionEvent18 = this.mCurrentDownEvent;
                OnGestureListener onGestureListener3 = onGestureListener;
                MotionEvent motionEvent19 = motionEvent18;
                MotionEvent motionEvent20 = motionEvent;
                float f17 = f9;
                float f18 = f10;
                bl = onGestureListener3.onScroll(motionEvent19, motionEvent20, f17, f18);
                this.mLastMotionX = f8 = f2;
                this.mLastMotionY = f7 = f;
                return bl;
            }
            case 1: {
                boolean bl18;
                MotionEvent motionEvent21;
                boolean bl19;
                this.mStillDown = bl19 = false;
                MotionEvent motionEvent22 = MotionEvent.obtain(motionEvent);
                if (this.mIsDoubleTapping) {
                    OnDoubleTapListener onDoubleTapListener = this.mDoubleTapListener;
                    MotionEvent motionEvent23 = motionEvent;
                    boolean bl20 = onDoubleTapListener.onDoubleTapEvent(motionEvent23);
                    bl |= bl20;
                } else if (this.mInLongPress) {
                    boolean bl21;
                    this.mHandler.removeMessages(3);
                    this.mInLongPress = bl21 = false;
                } else if (this.mAlwaysInTapRegion) {
                    OnGestureListener onGestureListener = this.mListener;
                    MotionEvent motionEvent24 = motionEvent;
                    bl = onGestureListener.onSingleTapUp(motionEvent24);
                } else {
                    float f19;
                    float f20;
                    VelocityTracker velocityTracker3 = this.mVelocityTracker;
                    float f21 = this.mMaximumFlingVelocity;
                    VelocityTracker velocityTracker4 = velocityTracker3;
                    int n20 = 1000;
                    float f22 = f21;
                    velocityTracker4.computeCurrentVelocity(n20, f22);
                    float f23 = velocityTracker3.getYVelocity();
                    float f24 = velocityTracker3.getXVelocity();
                    float f25 = Math.abs(f23);
                    float f26 = this.mMinimumFlingVelocity;
                    if (f25 > f26 || (f20 = Math.abs(f24)) > (f19 = (float)this.mMinimumFlingVelocity)) {
                        OnGestureListener onGestureListener = this.mListener;
                        MotionEvent motionEvent25 = this.mCurrentDownEvent;
                        OnGestureListener onGestureListener4 = onGestureListener;
                        MotionEvent motionEvent26 = motionEvent25;
                        MotionEvent motionEvent27 = motionEvent;
                        float f27 = f24;
                        float f28 = f23;
                        bl = onGestureListener4.onFling(motionEvent26, motionEvent27, f27, f28);
                    }
                }
                if (this.mPreviousUpEvent != null) {
                    this.mPreviousUpEvent.recycle();
                }
                this.mPreviousUpEvent = motionEvent21 = motionEvent22;
                this.mVelocityTracker.recycle();
                Object var114_105 = null;
                this.mVelocityTracker = var114_105;
                this.mIsDoubleTapping = bl18 = false;
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(2);
                return bl;
            }
            case 3: {
                this.cancel();
                return bl;
            }
        }
        return bl;
    }

    public void setIsLongpressEnabled(boolean bl) {
        this.mIsLongpressEnabled = bl;
    }

    public void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.mDoubleTapListener = onDoubleTapListener;
    }

    private class GestureHandler
    extends Handler {
        GestureHandler() {
        }

        GestureHandler(Handler handler) {
            Looper looper = handler.getLooper();
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    String string2 = "Unknown message " + message;
                    throw new RuntimeException(string2);
                }
                case 1: {
                    OnGestureListener onGestureListener = GestureDetector.this.mListener;
                    MotionEvent motionEvent = GestureDetector.this.mCurrentDownEvent;
                    onGestureListener.onShowPress(motionEvent);
                    return;
                }
                case 2: {
                    GestureDetector.this.dispatchLongPress();
                    return;
                }
                case 3: 
            }
            if (GestureDetector.this.mDoubleTapListener == null) {
                return;
            }
            if (GestureDetector.this.mStillDown) {
                return;
            }
            OnDoubleTapListener onDoubleTapListener = GestureDetector.this.mDoubleTapListener;
            MotionEvent motionEvent = GestureDetector.this.mCurrentDownEvent;
            boolean bl = onDoubleTapListener.onSingleTapConfirmed(motionEvent);
        }
    }

    public static class SimpleOnGestureListener
    implements OnGestureListener,
    OnDoubleTapListener {
        @Override
        public boolean onDoubleTap(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            return false;
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
        }

        @Override
        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            return false;
        }

        @Override
        public void onShowPress(MotionEvent motionEvent) {
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return false;
        }
    }

    public static interface OnDoubleTapListener {
        public boolean onDoubleTap(MotionEvent var1);

        public boolean onDoubleTapEvent(MotionEvent var1);

        public boolean onSingleTapConfirmed(MotionEvent var1);
    }

    public static interface OnGestureListener {
        public boolean onDown(MotionEvent var1);

        public boolean onFling(MotionEvent var1, MotionEvent var2, float var3, float var4);

        public void onLongPress(MotionEvent var1);

        public boolean onScroll(MotionEvent var1, MotionEvent var2, float var3, float var4);

        public void onShowPress(MotionEvent var1);

        public boolean onSingleTapUp(MotionEvent var1);
    }
}

