/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.IWindow;
import android.view.InputChannel;
import android.view.Surface;
import android.view.WindowManager;

public interface IWindowSession
extends IInterface {
    public int add(IWindow var1, WindowManager.LayoutParams var2, int var3, Rect var4, InputChannel var5) throws RemoteException;

    public int addWithoutInputChannel(IWindow var1, WindowManager.LayoutParams var2, int var3, Rect var4) throws RemoteException;

    public void finishDrawing(IWindow var1) throws RemoteException;

    public void getDisplayFrame(IWindow var1, Rect var2) throws RemoteException;

    public boolean getInTouchMode() throws RemoteException;

    public boolean performHapticFeedback(IWindow var1, int var2, boolean var3) throws RemoteException;

    public int relayout(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, boolean var6, Rect var7, Rect var8, Rect var9, Configuration var10, Surface var11) throws RemoteException;

    public void remove(IWindow var1) throws RemoteException;

    public Bundle sendWallpaperCommand(IBinder var1, String var2, int var3, int var4, int var5, Bundle var6, boolean var7) throws RemoteException;

    public void setInTouchMode(boolean var1) throws RemoteException;

    public void setInsets(IWindow var1, int var2, Rect var3, Rect var4) throws RemoteException;

    public void setTransparentRegion(IWindow var1, Region var2) throws RemoteException;

    public void setWallpaperPosition(IBinder var1, float var2, float var3, float var4, float var5) throws RemoteException;

    public void wallpaperCommandComplete(IBinder var1, Bundle var2) throws RemoteException;

    public void wallpaperOffsetsComplete(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSession {
        private static final String DESCRIPTOR = "android.view.IWindowSession";
        static final int TRANSACTION_add = 1;
        static final int TRANSACTION_addWithoutInputChannel = 2;
        static final int TRANSACTION_finishDrawing = 8;
        static final int TRANSACTION_getDisplayFrame = 7;
        static final int TRANSACTION_getInTouchMode = 10;
        static final int TRANSACTION_performHapticFeedback = 11;
        static final int TRANSACTION_relayout = 4;
        static final int TRANSACTION_remove = 3;
        static final int TRANSACTION_sendWallpaperCommand = 14;
        static final int TRANSACTION_setInTouchMode = 9;
        static final int TRANSACTION_setInsets = 6;
        static final int TRANSACTION_setTransparentRegion = 5;
        static final int TRANSACTION_setWallpaperPosition = 12;
        static final int TRANSACTION_wallpaperCommandComplete = 15;
        static final int TRANSACTION_wallpaperOffsetsComplete = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IWindowSession asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IWindowSession) {
                IWindowSession iWindowSession = (IWindowSession)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            Bundle bundle;
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    Parcel parcel3 = parcel2;
                    String string2 = DESCRIPTOR;
                    parcel3.writeString(string2);
                    return true;
                }
                case 1: {
                    WindowManager.LayoutParams layoutParams;
                    Parcel parcel4 = parcel;
                    String string3 = DESCRIPTOR;
                    parcel4.enforceInterface(string3);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<WindowManager.LayoutParams> creator = WindowManager.LayoutParams.CREATOR;
                        Parcel parcel5 = parcel;
                        layoutParams = creator.createFromParcel(parcel5);
                    } else {
                        layoutParams = null;
                    }
                    int n3 = parcel.readInt();
                    Rect rect = new Rect();
                    InputChannel inputChannel = new InputChannel();
                    int n4 = this.add(iWindow, layoutParams, n3, rect, inputChannel);
                    parcel2.writeNoException();
                    Parcel parcel6 = parcel2;
                    int n5 = n4;
                    parcel6.writeInt(n5);
                    if (rect != null) {
                        Parcel parcel7 = parcel2;
                        int n6 = 1;
                        parcel7.writeInt(n6);
                        Rect rect2 = rect;
                        Parcel parcel8 = parcel2;
                        int n7 = 1;
                        rect2.writeToParcel(parcel8, n7);
                    } else {
                        Parcel parcel9 = parcel2;
                        int n8 = 0;
                        parcel9.writeInt(n8);
                    }
                    if (inputChannel != null) {
                        Parcel parcel10 = parcel2;
                        int n9 = 1;
                        parcel10.writeInt(n9);
                        InputChannel inputChannel2 = inputChannel;
                        Parcel parcel11 = parcel2;
                        int n10 = 1;
                        inputChannel2.writeToParcel(parcel11, n10);
                        return true;
                    } else {
                        Parcel parcel12 = parcel2;
                        int n11 = 0;
                        parcel12.writeInt(n11);
                    }
                    return true;
                }
                case 2: {
                    WindowManager.LayoutParams layoutParams;
                    Parcel parcel13 = parcel;
                    String string4 = DESCRIPTOR;
                    parcel13.enforceInterface(string4);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<WindowManager.LayoutParams> creator = WindowManager.LayoutParams.CREATOR;
                        Parcel parcel14 = parcel;
                        layoutParams = creator.createFromParcel(parcel14);
                    } else {
                        layoutParams = null;
                    }
                    int n12 = parcel.readInt();
                    Rect rect = new Rect();
                    Stub stub = this;
                    IWindow iWindow2 = iWindow;
                    WindowManager.LayoutParams layoutParams2 = layoutParams;
                    int n13 = n12;
                    Rect rect3 = rect;
                    int n14 = stub.addWithoutInputChannel(iWindow2, layoutParams2, n13, rect3);
                    parcel2.writeNoException();
                    Parcel parcel15 = parcel2;
                    int n15 = n14;
                    parcel15.writeInt(n15);
                    if (rect != null) {
                        Parcel parcel16 = parcel2;
                        int n16 = 1;
                        parcel16.writeInt(n16);
                        Rect rect4 = rect;
                        Parcel parcel17 = parcel2;
                        int n17 = 1;
                        rect4.writeToParcel(parcel17, n17);
                        return true;
                    } else {
                        Parcel parcel18 = parcel2;
                        int n18 = 0;
                        parcel18.writeInt(n18);
                    }
                    return true;
                }
                case 3: {
                    Parcel parcel19 = parcel;
                    String string5 = DESCRIPTOR;
                    parcel19.enforceInterface(string5);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IWindow iWindow3 = iWindow;
                    stub.remove(iWindow3);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    void var64_92;
                    WindowManager.LayoutParams layoutParams;
                    Parcel parcel20 = parcel;
                    String string6 = DESCRIPTOR;
                    parcel20.enforceInterface(string6);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<WindowManager.LayoutParams> creator = WindowManager.LayoutParams.CREATOR;
                        Parcel parcel21 = parcel;
                        layoutParams = creator.createFromParcel(parcel21);
                    } else {
                        layoutParams = null;
                    }
                    int n19 = parcel.readInt();
                    int n20 = parcel.readInt();
                    int n21 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Object var64_91 = null;
                    } else {
                        Object var64_93 = null;
                    }
                    Rect rect = new Rect();
                    Rect rect5 = new Rect();
                    Rect rect6 = new Rect();
                    Configuration configuration = new Configuration();
                    Surface surface = new Surface();
                    int n22 = this.relayout(iWindow, layoutParams, n19, n20, n21, (boolean)var64_92, rect, rect5, rect6, configuration, surface);
                    parcel2.writeNoException();
                    Parcel parcel22 = parcel2;
                    int n23 = n22;
                    parcel22.writeInt(n23);
                    if (rect != null) {
                        Parcel parcel23 = parcel2;
                        int n24 = 1;
                        parcel23.writeInt(n24);
                        Rect rect7 = rect;
                        Parcel parcel24 = parcel2;
                        int n25 = 1;
                        rect7.writeToParcel(parcel24, n25);
                    } else {
                        Parcel parcel25 = parcel2;
                        int n26 = 0;
                        parcel25.writeInt(n26);
                    }
                    if (rect5 != null) {
                        Parcel parcel26 = parcel2;
                        int n27 = 1;
                        parcel26.writeInt(n27);
                        Rect rect8 = rect5;
                        Parcel parcel27 = parcel2;
                        int n28 = 1;
                        rect8.writeToParcel(parcel27, n28);
                    } else {
                        Parcel parcel28 = parcel2;
                        int n29 = 0;
                        parcel28.writeInt(n29);
                    }
                    if (rect6 != null) {
                        Parcel parcel29 = parcel2;
                        int n30 = 1;
                        parcel29.writeInt(n30);
                        Rect rect9 = rect6;
                        Parcel parcel30 = parcel2;
                        int n31 = 1;
                        rect9.writeToParcel(parcel30, n31);
                    } else {
                        Parcel parcel31 = parcel2;
                        int n32 = 0;
                        parcel31.writeInt(n32);
                    }
                    if (configuration != null) {
                        Parcel parcel32 = parcel2;
                        int n33 = 1;
                        parcel32.writeInt(n33);
                        Configuration configuration2 = configuration;
                        Parcel parcel33 = parcel2;
                        int n34 = 1;
                        configuration2.writeToParcel(parcel33, n34);
                    } else {
                        Parcel parcel34 = parcel2;
                        int n35 = 0;
                        parcel34.writeInt(n35);
                    }
                    if (surface != null) {
                        Parcel parcel35 = parcel2;
                        int n36 = 1;
                        parcel35.writeInt(n36);
                        Surface surface2 = surface;
                        Parcel parcel36 = parcel2;
                        int n37 = 1;
                        surface2.writeToParcel(parcel36, n37);
                        return true;
                    } else {
                        Parcel parcel37 = parcel2;
                        int n38 = 0;
                        parcel37.writeInt(n38);
                    }
                    return true;
                }
                case 5: {
                    Region region;
                    Parcel parcel38 = parcel;
                    String string7 = DESCRIPTOR;
                    parcel38.enforceInterface(string7);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Region> creator = Region.CREATOR;
                        Parcel parcel39 = parcel;
                        region = creator.createFromParcel(parcel39);
                    } else {
                        region = null;
                    }
                    Stub stub = this;
                    IWindow iWindow4 = iWindow;
                    Region region2 = region;
                    stub.setTransparentRegion(iWindow4, region2);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    Rect rect;
                    Rect rect10;
                    Parcel parcel40 = parcel;
                    String string8 = DESCRIPTOR;
                    parcel40.enforceInterface(string8);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n39 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Rect> creator = Rect.CREATOR;
                        Parcel parcel41 = parcel;
                        rect10 = creator.createFromParcel(parcel41);
                    } else {
                        rect10 = null;
                    }
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Rect> creator = Rect.CREATOR;
                        Parcel parcel42 = parcel;
                        rect = creator.createFromParcel(parcel42);
                    } else {
                        rect = null;
                    }
                    Stub stub = this;
                    IWindow iWindow5 = iWindow;
                    int n40 = n39;
                    Rect rect11 = rect10;
                    Rect rect12 = rect;
                    stub.setInsets(iWindow5, n40, rect11, rect12);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    Parcel parcel43 = parcel;
                    String string9 = DESCRIPTOR;
                    parcel43.enforceInterface(string9);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Rect rect = new Rect();
                    Stub stub = this;
                    IWindow iWindow6 = iWindow;
                    Rect rect13 = rect;
                    stub.getDisplayFrame(iWindow6, rect13);
                    parcel2.writeNoException();
                    if (rect != null) {
                        Parcel parcel44 = parcel2;
                        int n41 = 1;
                        parcel44.writeInt(n41);
                        Rect rect14 = rect;
                        Parcel parcel45 = parcel2;
                        int n42 = 1;
                        rect14.writeToParcel(parcel45, n42);
                        return true;
                    } else {
                        Parcel parcel46 = parcel2;
                        int n43 = 0;
                        parcel46.writeInt(n43);
                    }
                    return true;
                }
                case 8: {
                    Parcel parcel47 = parcel;
                    String string10 = DESCRIPTOR;
                    parcel47.enforceInterface(string10);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Stub stub = this;
                    IWindow iWindow7 = iWindow;
                    stub.finishDrawing(iWindow7);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    void var10_16;
                    Parcel parcel48 = parcel;
                    String string11 = DESCRIPTOR;
                    parcel48.enforceInterface(string11);
                    if (parcel.readInt() != 0) {
                        Object var10_15 = null;
                    } else {
                        Object var10_17 = null;
                    }
                    Stub stub = this;
                    void var147_181 = var10_16;
                    stub.setInTouchMode((boolean)var147_181);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    Parcel parcel49 = parcel;
                    String string12 = DESCRIPTOR;
                    parcel49.enforceInterface(string12);
                    boolean bl = this.getInTouchMode();
                    parcel2.writeNoException();
                    int n44 = bl ? 1 : 0;
                    Parcel parcel50 = parcel2;
                    int n45 = n44;
                    parcel50.writeInt(n45);
                    return true;
                }
                case 11: {
                    Parcel parcel51 = parcel;
                    String string13 = DESCRIPTOR;
                    parcel51.enforceInterface(string13);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n46 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    Stub stub = this;
                    IWindow iWindow8 = iWindow;
                    int n47 = n46;
                    boolean bl2 = bl;
                    boolean bl3 = stub.performHapticFeedback(iWindow8, n47, bl2);
                    parcel2.writeNoException();
                    int n48 = bl3 ? 1 : 0;
                    Parcel parcel52 = parcel2;
                    int n49 = n48;
                    parcel52.writeInt(n49);
                    return true;
                }
                case 12: {
                    Parcel parcel53 = parcel;
                    String string14 = DESCRIPTOR;
                    parcel53.enforceInterface(string14);
                    IBinder iBinder = parcel.readStrongBinder();
                    float f = parcel.readFloat();
                    float f2 = parcel.readFloat();
                    float f3 = parcel.readFloat();
                    float f4 = parcel.readFloat();
                    this.setWallpaperPosition(iBinder, f, f2, f3, f4);
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    Parcel parcel54 = parcel;
                    String string15 = DESCRIPTOR;
                    parcel54.enforceInterface(string15);
                    IBinder iBinder = parcel.readStrongBinder();
                    Stub stub = this;
                    IBinder iBinder2 = iBinder;
                    stub.wallpaperOffsetsComplete(iBinder2);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    void var64_95;
                    Rect rect;
                    Parcel parcel55 = parcel;
                    String string16 = DESCRIPTOR;
                    parcel55.enforceInterface(string16);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string17 = parcel.readString();
                    int n50 = parcel.readInt();
                    int n51 = parcel.readInt();
                    int n52 = parcel.readInt();
                    if (parcel.readInt() != 0) {
                        Parcelable.Creator<Bundle> creator = Bundle.CREATOR;
                        Parcel parcel56 = parcel;
                        Bundle bundle2 = creator.createFromParcel(parcel56);
                    } else {
                        Object var64_96 = null;
                    }
                    if (parcel.readInt() != 0) {
                        Object var65_98 = null;
                    } else {
                        boolean bl = false;
                    }
                    Bundle bundle3 = this.sendWallpaperCommand(iBinder, string17, n50, n51, n52, (Bundle)var64_95, (boolean)rect);
                    parcel2.writeNoException();
                    if (bundle3 != null) {
                        Parcel parcel57 = parcel2;
                        int n53 = 1;
                        parcel57.writeInt(n53);
                        Bundle bundle4 = bundle3;
                        Parcel parcel58 = parcel2;
                        int n54 = 1;
                        bundle4.writeToParcel(parcel58, n54);
                        return true;
                    } else {
                        Parcel parcel59 = parcel2;
                        int n55 = 0;
                        parcel59.writeInt(n55);
                    }
                    return true;
                }
                case 15: 
            }
            Parcel parcel60 = parcel;
            String string18 = DESCRIPTOR;
            parcel60.enforceInterface(string18);
            IBinder iBinder = parcel.readStrongBinder();
            if (parcel.readInt() != 0) {
                Parcelable.Creator<Bundle> creator = Bundle.CREATOR;
                Parcel parcel61 = parcel;
                bundle = creator.createFromParcel(parcel61);
            } else {
                bundle = null;
            }
            Stub stub = this;
            IBinder iBinder3 = iBinder;
            Bundle bundle5 = bundle;
            stub.wallpaperCommandComplete(iBinder3, bundle5);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IWindowSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int add(IWindow iWindow, WindowManager.LayoutParams layoutParams, int n, Rect rect, InputChannel inputChannel) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        inputChannel.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addWithoutInputChannel(IWindow iWindow, WindowManager.LayoutParams layoutParams, int n, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void finishDrawing(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getDisplayFrame(IWindow iWindow, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean getInTouchMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean performHapticFeedback(IWindow iWindow, int n, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    boolean bl2 = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl3 = n2 != 0;
                    return bl3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int relayout(IWindow iWindow, WindowManager.LayoutParams layoutParams, int n, int n2, int n3, boolean bl, Rect rect, Rect rect2, Rect rect3, Configuration configuration, Surface surface) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    boolean bl2 = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        Rect rect4 = rect2;
                        Parcel parcel3 = parcel2;
                        rect4.readFromParcel(parcel3);
                    }
                    if (parcel2.readInt() != 0) {
                        Rect rect5 = rect3;
                        Parcel parcel4 = parcel2;
                        rect5.readFromParcel(parcel4);
                    }
                    if (parcel2.readInt() != 0) {
                        Configuration configuration2 = configuration;
                        Parcel parcel5 = parcel2;
                        configuration2.readFromParcel(parcel5);
                    }
                    if (parcel2.readInt() != 0) {
                        Surface surface2 = surface;
                        Parcel parcel6 = parcel2;
                        surface2.readFromParcel(parcel6);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void remove(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle sendWallpaperCommand(IBinder iBinder, String string2, int n, int n2, int n3, Bundle bundle, boolean bl) throws RemoteException {
                Bundle bundle2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n4;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        n4 = 0;
                        parcel.writeInt(n4);
                    }
                    n4 = bl ? 1 : 0;
                    parcel.writeInt(n4);
                    boolean bl2 = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    bundle2 = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bundle2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInTouchMode(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInsets(IWindow iWindow, int n, Rect rect, Rect rect2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    if (rect2 != null) {
                        parcel.writeInt(1);
                        rect2.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    boolean bl = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTransparentRegion(IWindow iWindow, Region region) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (region != null) {
                        parcel.writeInt(1);
                        region.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setWallpaperPosition(IBinder iBinder, float f, float f2, float f3, float f4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeFloat(f);
                    parcel.writeFloat(f2);
                    parcel.writeFloat(f3);
                    parcel.writeFloat(f4);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void wallpaperCommandComplete(IBinder iBinder, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void wallpaperOffsetsComplete(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

