/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;

public final class InputDevice
implements Parcelable {
    public static final Parcelable.Creator<InputDevice> CREATOR = new Parcelable.Creator<InputDevice>(){

        @Override
        public InputDevice createFromParcel(Parcel parcel) {
            InputDevice inputDevice = new InputDevice();
            inputDevice.readFromParcel(parcel);
            return inputDevice;
        }

        public InputDevice[] newArray(int n) {
            return new InputDevice[n];
        }
    };
    public static final int KEYBOARD_TYPE_ALPHABETIC = 2;
    public static final int KEYBOARD_TYPE_NONE = 0;
    public static final int KEYBOARD_TYPE_NON_ALPHABETIC = 1;
    private static final int MOTION_RANGE_LAST = 8;
    public static final int MOTION_RANGE_ORIENTATION = 8;
    public static final int MOTION_RANGE_PRESSURE = 2;
    public static final int MOTION_RANGE_SIZE = 3;
    public static final int MOTION_RANGE_TOOL_MAJOR = 6;
    public static final int MOTION_RANGE_TOOL_MINOR = 7;
    public static final int MOTION_RANGE_TOUCH_MAJOR = 4;
    public static final int MOTION_RANGE_TOUCH_MINOR = 5;
    public static final int MOTION_RANGE_X = 0;
    public static final int MOTION_RANGE_Y = 1;
    public static final int SOURCE_ANY = 65280;
    public static final int SOURCE_CLASS_BUTTON = 1;
    public static final int SOURCE_CLASS_MASK = 255;
    public static final int SOURCE_CLASS_POINTER = 2;
    public static final int SOURCE_CLASS_POSITION = 8;
    public static final int SOURCE_CLASS_TRACKBALL = 4;
    public static final int SOURCE_DPAD = 513;
    public static final int SOURCE_KEYBOARD = 257;
    public static final int SOURCE_MOUSE = 8194;
    public static final int SOURCE_TOUCHPAD = 0x100008;
    public static final int SOURCE_TOUCHSCREEN = 4098;
    public static final int SOURCE_TRACKBALL = 65540;
    public static final int SOURCE_UNKNOWN;
    private int mId;
    private int mKeyboardType;
    private MotionRange[] mMotionRanges;
    private String mName;
    private int mSources;

    private InputDevice() {
        MotionRange[] motionRangeArray = new MotionRange[9];
        this.mMotionRanges = motionRangeArray;
    }

    private void addMotionRange(int n, float f, float f2, float f3, float f4) {
        MotionRange motionRange;
        if (n < 0) {
            return;
        }
        if (n > 8) {
            return;
        }
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        this.mMotionRanges[n] = motionRange = new MotionRange(f5, f6, f7, f8);
    }

    private void appendRangeDescriptionIfApplicable(StringBuilder stringBuilder, int n, String string2) {
        MotionRange motionRange = this.mMotionRanges[n];
        if (motionRange == null) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder.append("  Range[").append(string2);
        StringBuilder stringBuilder3 = stringBuilder.append("]: min=");
        float f = motionRange.mMin;
        StringBuilder stringBuilder4 = stringBuilder3.append(f);
        StringBuilder stringBuilder5 = stringBuilder.append(" max=");
        float f2 = motionRange.mMax;
        StringBuilder stringBuilder6 = stringBuilder5.append(f2);
        StringBuilder stringBuilder7 = stringBuilder.append(" flat=");
        float f3 = motionRange.mFlat;
        StringBuilder stringBuilder8 = stringBuilder7.append(f3);
        StringBuilder stringBuilder9 = stringBuilder.append(" fuzz=");
        float f4 = motionRange.mFuzz;
        StringBuilder stringBuilder10 = stringBuilder9.append(f4);
        StringBuilder stringBuilder11 = stringBuilder.append("\n");
    }

    private void appendSourceDescriptionIfApplicable(StringBuilder stringBuilder, int n, String string2) {
        if ((this.mSources & n) != n) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(" ");
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
    }

    public static InputDevice getDevice(int n) {
        IWindowManager iWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            InputDevice inputDevice = iWindowManager.getInputDevice(n);
            return inputDevice;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Could not get input device information from Window Manager.", remoteException);
        }
    }

    public static int[] getDeviceIds() {
        IWindowManager iWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            int[] nArray = iWindowManager.getInputDeviceIds();
            return nArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Could not get input device ids from Window Manager.", remoteException);
        }
    }

    private void readFromParcel(Parcel parcel) {
        int n;
        int n2;
        String string2;
        int n3;
        this.mId = n3 = parcel.readInt();
        this.mName = string2 = parcel.readString();
        this.mSources = n2 = parcel.readInt();
        this.mKeyboardType = n = parcel.readInt();
        int n4;
        while ((n4 = parcel.readInt()) >= 0) {
            float f = parcel.readFloat();
            float f2 = parcel.readFloat();
            float f3 = parcel.readFloat();
            float f4 = parcel.readFloat();
            this.addMotionRange(n4, f, f2, f3, f4);
        }
        return;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getId() {
        return this.mId;
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return KeyCharacterMap.load(this.mId);
    }

    public int getKeyboardType() {
        return this.mKeyboardType;
    }

    public MotionRange getMotionRange(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Requested range is out of bounds.");
        }
        return this.mMotionRanges[n];
    }

    public String getName() {
        return this.mName;
    }

    public int getSources() {
        return this.mSources;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Input Device ");
        int n = this.mId;
        StringBuilder stringBuilder3 = stringBuilder2.append(n).append(": ");
        String string2 = this.mName;
        StringBuilder stringBuilder4 = stringBuilder3.append(string2).append("\n");
        StringBuilder stringBuilder5 = stringBuilder.append("  Keyboard Type: ");
        switch (this.mKeyboardType) {
            case 0: {
                StringBuilder stringBuilder6 = stringBuilder.append("none");
                break;
            }
            case 1: {
                StringBuilder stringBuilder7 = stringBuilder.append("non-alphabetic");
                break;
            }
            case 2: {
                StringBuilder stringBuilder8 = stringBuilder.append("alphabetic");
                break;
            }
        }
        StringBuilder stringBuilder9 = stringBuilder.append("\n");
        StringBuilder stringBuilder10 = stringBuilder.append("  Sources:");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 257, "keyboard");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 513, "dpad");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 4098, "touchscreen");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 8194, "mouse");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 65540, "trackball");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 0x100008, "touchpad");
        StringBuilder stringBuilder11 = stringBuilder.append("\n");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 0, "x");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 1, "y");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 2, "pressure");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 3, "size");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 4, "touchMajor");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 5, "touchMinor");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 6, "toolMajor");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 7, "toolMinor");
        this.appendRangeDescriptionIfApplicable(stringBuilder, 8, "orientation");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mId;
        parcel.writeInt(n2);
        String string2 = this.mName;
        parcel.writeString(string2);
        int n3 = this.mSources;
        parcel.writeInt(n3);
        int n4 = this.mKeyboardType;
        parcel.writeInt(n4);
        for (int i = 0; i <= 8; ++i) {
            MotionRange motionRange = this.mMotionRanges[i];
            if (motionRange == null) continue;
            parcel.writeInt(i);
            float f = motionRange.mMin;
            parcel.writeFloat(f);
            float f2 = motionRange.mMax;
            parcel.writeFloat(f2);
            float f3 = motionRange.mFlat;
            parcel.writeFloat(f3);
            float f4 = motionRange.mFuzz;
            parcel.writeFloat(f4);
        }
        parcel.writeInt(-1);
    }

    public static final class MotionRange {
        private float mFlat;
        private float mFuzz;
        private float mMax;
        private float mMin;

        private MotionRange(float f, float f2, float f3, float f4) {
            this.mMin = f;
            this.mMax = f2;
            this.mFlat = f3;
            this.mFuzz = f4;
        }

        public float getFlat() {
            return this.mFlat;
        }

        public float getFuzz() {
            return this.mFuzz;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getRange() {
            float f = this.mMax;
            float f2 = this.mMin;
            return f - f2;
        }
    }
}

