/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.MessageQueue;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.KeyEvent;
import android.view.MotionEvent;

public final class InputQueue {
    private static final boolean DEBUG = false;
    private static final String TAG = "InputQueue";
    private static final Object sLock = new Object();
    final InputChannel mChannel;

    public InputQueue(InputChannel inputChannel) {
        this.mChannel = inputChannel;
    }

    private static void dispatchKeyEvent(InputHandler inputHandler, KeyEvent keyEvent, long l) {
        FinishedCallback finishedCallback = FinishedCallback.obtain(l);
        inputHandler.handleKey(keyEvent, finishedCallback);
    }

    private static void dispatchMotionEvent(InputHandler inputHandler, MotionEvent motionEvent, long l) {
        FinishedCallback finishedCallback = FinishedCallback.obtain(l);
        inputHandler.handleMotion(motionEvent, finishedCallback);
    }

    private static native void nativeFinished(long var0);

    private static native void nativeRegisterInputChannel(InputChannel var0, InputHandler var1, MessageQueue var2);

    private static native void nativeUnregisterInputChannel(InputChannel var0);

    public static void registerInputChannel(InputChannel inputChannel, InputHandler inputHandler, MessageQueue messageQueue) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (inputHandler == null) {
            throw new IllegalArgumentException("inputHandler must not be null");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("messageQueue must not be null");
        }
        Object object = sLock;
        synchronized (object) {
            InputQueue.nativeRegisterInputChannel(inputChannel, inputHandler, messageQueue);
            return;
        }
    }

    public static void unregisterInputChannel(InputChannel inputChannel) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        Object object = sLock;
        synchronized (object) {
            InputQueue.nativeUnregisterInputChannel(inputChannel);
            return;
        }
    }

    public InputChannel getInputChannel() {
        return this.mChannel;
    }

    private static class FinishedCallback
    implements Runnable {
        private static final boolean DEBUG_RECYCLING = false;
        private static final int RECYCLE_MAX_COUNT = 4;
        private static int sRecycleCount;
        private static FinishedCallback sRecycleHead;
        private long mFinishedToken;
        private FinishedCallback mRecycleNext;

        private FinishedCallback() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static FinishedCallback obtain(long l) {
            Object object = sLock;
            synchronized (object) {
                FinishedCallback finishedCallback = sRecycleHead;
                if (finishedCallback != null) {
                    sRecycleHead = finishedCallback.mRecycleNext;
                    --sRecycleCount;
                    finishedCallback.mRecycleNext = null;
                } else {
                    finishedCallback = new FinishedCallback();
                }
                finishedCallback.mFinishedToken = l;
                return finishedCallback;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = sLock;
            synchronized (object) {
                if (this.mFinishedToken == 65535L) {
                    throw new IllegalStateException("Event finished callback already invoked.");
                }
                InputQueue.nativeFinished(this.mFinishedToken);
                this.mFinishedToken = 65535L;
                if (sRecycleCount < 4) {
                    FinishedCallback finishedCallback;
                    this.mRecycleNext = finishedCallback = sRecycleHead;
                    sRecycleHead = this;
                    ++sRecycleCount;
                }
                return;
            }
        }
    }

    public static interface Callback {
        public void onInputQueueCreated(InputQueue var1);

        public void onInputQueueDestroyed(InputQueue var1);
    }
}

