/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.IWindowManager;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;

public class KeyCharacterMap {
    private static final int ACUTE = 0xB40000;
    public static final int ALPHA = 3;
    public static final int BUILT_IN_KEYBOARD = 0;
    private static final int CIRCUMFLEX = 0x5E0000;
    private static SparseIntArray COMBINING;
    public static final int COMBINING_ACCENT = Integer.MIN_VALUE;
    public static final int COMBINING_ACCENT_MASK = Integer.MAX_VALUE;
    private static SparseIntArray DEAD;
    private static final int GRAVE = 0x600000;
    public static final char HEX_INPUT = '\uef00';
    public static final int NUMERIC = 1;
    public static final char PICKER_DIALOG_INPUT = '\uef01';
    public static final int PREDICTIVE = 2;
    private static final int TILDE = 0x7E0000;
    private static final int UMLAUT = 0xA80000;
    private static SparseArray<WeakReference<KeyCharacterMap>> sInstances;
    private static Object sLock;
    private int mKeyboardDevice;
    private int mPointer;

    static {
        sLock = new Object();
        sInstances = new SparseArray();
        COMBINING = new SparseIntArray();
        DEAD = new SparseIntArray();
        COMBINING.put(768, -2147483552);
        COMBINING.put(769, -2147483468);
        COMBINING.put(770, -2147483554);
        COMBINING.put(771, -2147483522);
        COMBINING.put(776, -2147483480);
        DEAD.put(11796545, 193);
        DEAD.put(11796547, 262);
        DEAD.put(11796549, 201);
        DEAD.put(11796551, 500);
        DEAD.put(11796553, 205);
        DEAD.put(0xB4004B, 7728);
        DEAD.put(11796556, 313);
        DEAD.put(11796557, 7742);
        DEAD.put(11796558, 323);
        DEAD.put(11796559, 211);
        DEAD.put(11796560, 7764);
        DEAD.put(11796562, 340);
        DEAD.put(11796563, 346);
        DEAD.put(11796565, 218);
        DEAD.put(11796567, 7810);
        DEAD.put(11796569, 221);
        DEAD.put(11796570, 377);
        DEAD.put(11796577, 225);
        DEAD.put(11796579, 263);
        DEAD.put(11796581, 233);
        DEAD.put(11796583, 501);
        DEAD.put(11796585, 237);
        DEAD.put(11796587, 7729);
        DEAD.put(11796588, 314);
        DEAD.put(11796589, 7743);
        DEAD.put(11796590, 324);
        DEAD.put(11796591, 243);
        DEAD.put(11796592, 7765);
        DEAD.put(11796594, 341);
        DEAD.put(11796595, 347);
        DEAD.put(11796597, 250);
        DEAD.put(11796599, 7811);
        DEAD.put(11796601, 253);
        DEAD.put(11796602, 378);
        DEAD.put(6160449, 194);
        DEAD.put(6160451, 264);
        DEAD.put(6160453, 202);
        DEAD.put(6160455, 284);
        DEAD.put(6160456, 292);
        DEAD.put(6160457, 206);
        DEAD.put(6160458, 308);
        DEAD.put(6160463, 212);
        DEAD.put(6160467, 348);
        DEAD.put(0x5E0055, 219);
        DEAD.put(6160471, 372);
        DEAD.put(6160473, 374);
        DEAD.put(6160474, 7824);
        DEAD.put(6160481, 226);
        DEAD.put(6160483, 265);
        DEAD.put(6160485, 234);
        DEAD.put(6160487, 285);
        DEAD.put(6160488, 293);
        DEAD.put(6160489, 238);
        DEAD.put(6160490, 309);
        DEAD.put(6160495, 244);
        DEAD.put(6160499, 349);
        DEAD.put(6160501, 251);
        DEAD.put(6160503, 373);
        DEAD.put(6160505, 375);
        DEAD.put(6160506, 7825);
        DEAD.put(6291521, 192);
        DEAD.put(6291525, 200);
        DEAD.put(6291529, 204);
        DEAD.put(6291534, 504);
        DEAD.put(6291535, 210);
        DEAD.put(0x600055, 217);
        DEAD.put(6291543, 7808);
        DEAD.put(6291545, 7922);
        DEAD.put(0x600061, 224);
        DEAD.put(0x600065, 232);
        DEAD.put(0x600069, 236);
        DEAD.put(0x60006E, 505);
        DEAD.put(0x60006F, 242);
        DEAD.put(6291573, 249);
        DEAD.put(0x600077, 7809);
        DEAD.put(6291577, 7923);
        DEAD.put(8257601, 195);
        DEAD.put(8257605, 7868);
        DEAD.put(8257609, 296);
        DEAD.put(8257614, 209);
        DEAD.put(8257615, 213);
        DEAD.put(8257621, 360);
        DEAD.put(8257622, 7804);
        DEAD.put(8257625, 7928);
        DEAD.put(8257633, 227);
        DEAD.put(8257637, 7869);
        DEAD.put(8257641, 297);
        DEAD.put(8257646, 241);
        DEAD.put(8257647, 245);
        DEAD.put(8257653, 361);
        DEAD.put(8257654, 7805);
        DEAD.put(8257657, 7929);
        DEAD.put(11010113, 196);
        DEAD.put(11010117, 203);
        DEAD.put(11010120, 7718);
        DEAD.put(11010121, 207);
        DEAD.put(11010127, 214);
        DEAD.put(11010133, 220);
        DEAD.put(11010135, 7812);
        DEAD.put(11010136, 7820);
        DEAD.put(11010137, 376);
        DEAD.put(11010145, 228);
        DEAD.put(11010149, 235);
        DEAD.put(11010152, 7719);
        DEAD.put(11010153, 239);
        DEAD.put(11010159, 246);
        DEAD.put(11010164, 7831);
        DEAD.put(11010165, 252);
        DEAD.put(11010167, 7813);
        DEAD.put(11010168, 7821);
        DEAD.put(11010169, 255);
    }

    private KeyCharacterMap(int n) {
        int n2;
        this.mKeyboardDevice = n;
        this.mPointer = n2 = KeyCharacterMap.ctor_native(n);
    }

    private static native int ctor_native(int var0);

    public static boolean deviceHasKey(int n) {
        int[] nArray = new int[]{n};
        return KeyCharacterMap.deviceHasKeys(nArray)[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean[] deviceHasKeys(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        IWindowManager iWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            boolean bl = iWindowManager.hasKeys(nArray, blArray);
            return blArray;
        }
        catch (RemoteException remoteException) {
            return blArray;
        }
    }

    private static native void dtor_native(int var0);

    public static int getDeadChar(int n, int n2) {
        SparseIntArray sparseIntArray = DEAD;
        int n3 = n << 16 | n2;
        return sparseIntArray.get(n3);
    }

    private static native char getDisplayLabel_native(int var0, int var1);

    private static native long[] getEvents_native(int var0, char[] var1);

    private static native boolean getKeyData_native(int var0, int var1, KeyData var2);

    private static native int getKeyboardType_native(int var0);

    private static native char getMatch_native(int var0, int var1, char[] var2, int var3);

    private static native char getNumber_native(int var0, int var1);

    private static native char get_native(int var0, int var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyCharacterMap load(int n) {
        Object object = sLock;
        synchronized (object) {
            KeyCharacterMap keyCharacterMap;
            WeakReference<KeyCharacterMap> weakReference = sInstances.get(n);
            if (weakReference != null && (keyCharacterMap = (KeyCharacterMap)weakReference.get()) != null) {
                return keyCharacterMap;
            }
            KeyCharacterMap keyCharacterMap2 = new KeyCharacterMap(n);
            SparseArray<WeakReference<KeyCharacterMap>> sparseArray = sInstances;
            WeakReference<KeyCharacterMap> weakReference2 = new WeakReference<KeyCharacterMap>(keyCharacterMap2);
            sparseArray.put(n, weakReference2);
            return keyCharacterMap2;
        }
    }

    protected void finalize() throws Throwable {
        KeyCharacterMap.dtor_native(this.mPointer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int get(int n, int n2) {
        char c;
        int n3;
        char c2;
        char c3;
        if ((n2 & 0x100) != 0) {
            n2 |= 1;
        }
        if ((n2 & 0x200) != 0) {
            n2 |= 2;
        }
        if ((n2 & 0x100) != 0 && (c3 = KeyCharacterMap.get_native(this.mPointer, n, 1)) != (c2 = KeyCharacterMap.get_native(this.mPointer, n, 2))) {
            n2 &= 0xFFFFFFFE;
        }
        if ((n3 = COMBINING.get(c = KeyCharacterMap.get_native(this.mPointer, n, n2))) == null) return c;
        return n3;
    }

    public char getDisplayLabel(int n) {
        return KeyCharacterMap.getDisplayLabel_native(this.mPointer, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public KeyEvent[] getEvents(char[] cArray) {
        int n;
        int n2;
        if (cArray == null) {
            throw new NullPointerException();
        }
        int n3 = this.mPointer;
        char[] cArray2 = cArray;
        long[] lArray = KeyCharacterMap.getEvents_native(n3, cArray2);
        if (lArray == null) {
            return null;
        }
        int n4 = lArray.length * 2;
        int n5 = lArray.length;
        int n6 = 0;
        while ((n2 = ++n6) < (n = n5)) {
            int n7 = (int)(lArray[n6] >> 32);
            if ((n7 & 2) != 0) {
                n4 += 2;
            }
            if ((n7 & 1) != 0) {
                n4 += 2;
            }
            if ((n7 & 4) == 0) continue;
            n4 += 2;
        }
        KeyEvent[] keyEventArray = new KeyEvent[n4];
        int n8 = 0;
        long l = SystemClock.uptimeMillis();
        int n9 = this.mKeyboardDevice;
        int n10 = 0;
        int n11;
        int n12;
        while ((n12 = ++n10) < (n11 = n5)) {
            KeyEvent keyEvent;
            KeyEvent keyEvent2;
            KeyEvent keyEvent3;
            int n13 = (int)(lArray[n10] >> 32);
            int n14 = 0;
            if ((n13 & 2) != 0) {
                KeyEvent keyEvent4;
                long l2 = l;
                keyEventArray[n8] = keyEvent4 = new KeyEvent(l, l2, 0, 57, 0, n14 |= 2, n9, 0);
                ++n8;
            }
            if ((n13 & 1) != 0) {
                KeyEvent keyEvent5;
                long l3 = l;
                keyEventArray[n8] = keyEvent5 = new KeyEvent(l, l3, 0, 59, 0, n14 |= 1, n9, 0);
                ++n8;
            }
            if ((n13 & 4) != 0) {
                KeyEvent keyEvent6;
                long l4 = l;
                keyEventArray[n8] = keyEvent6 = new KeyEvent(l, l4, 0, 63, 0, n14 |= 4, n9, 0);
                ++n8;
            }
            int n15 = (int)lArray[n10];
            long l5 = l;
            keyEventArray[n8] = keyEvent3 = new KeyEvent(l, l5, 0, n15, 0, n14, n9, 0);
            int n16 = n8 + 1;
            long l6 = l;
            keyEventArray[n16] = keyEvent2 = new KeyEvent(l, l6, 1, n15, 0, n14, n9, 0);
            n8 = n16 + 1;
            if ((n13 & 2) != 0) {
                KeyEvent keyEvent7;
                long l7 = l;
                long l8 = l;
                int n17 = n14 &= 0xFFFFFFFD;
                int n18 = n9;
                keyEventArray[n8] = keyEvent7 = new KeyEvent(l7, l8, 1, 57, 0, n17, n18, 0);
                int n19 = n8 + 1;
            }
            if ((n13 & 1) != 0) {
                KeyEvent keyEvent8;
                long l9 = l;
                long l10 = l;
                int n20 = n14 &= 0xFFFFFFFE;
                int n21 = n9;
                keyEventArray[n8] = keyEvent8 = new KeyEvent(l9, l10, 1, 59, 0, n20, n21, 0);
                int n22 = n8 + 1;
            }
            if ((n13 & 4) == 0) continue;
            int n23 = n14 & 0xFFFFFFFB;
            long l11 = l;
            long l12 = l;
            int n24 = n23;
            int n25 = n9;
            keyEventArray[n8] = keyEvent = new KeyEvent(l11, l12, 1, 63, 0, n24, n25, 0);
            int n26 = n8 + 1;
        }
        return keyEventArray;
    }

    public boolean getKeyData(int n, KeyData keyData) {
        if (keyData.meta.length >= 4) {
            return KeyCharacterMap.getKeyData_native(this.mPointer, n, keyData);
        }
        throw new IndexOutOfBoundsException("results.meta.length must be >= 4");
    }

    public int getKeyboardType() {
        return KeyCharacterMap.getKeyboardType_native(this.mPointer);
    }

    public char getMatch(int n, char[] cArray) {
        return this.getMatch(n, cArray, 0);
    }

    public char getMatch(int n, char[] cArray, int n2) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        return KeyCharacterMap.getMatch_native(this.mPointer, n, cArray, n2);
    }

    public char getNumber(int n) {
        return KeyCharacterMap.getNumber_native(this.mPointer, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPrintingKey(int n) {
        switch (Character.getType(this.get(n, 0))) {
            default: {
                return true;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
        }
        return false;
    }

    public static class KeyData {
        public static final int META_LENGTH = 4;
        public char displayLabel;
        public char[] meta;
        public char number;

        public KeyData() {
            char[] cArray = new char[4];
            this.meta = cArray;
        }
    }
}

