/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import android.view.InputEvent;
import android.view.KeyCharacterMap;

public class KeyEvent
extends InputEvent
implements Parcelable {
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_MULTIPLE = 2;
    public static final int ACTION_UP = 1;
    public static final Parcelable.Creator<KeyEvent> CREATOR = new Parcelable.Creator<KeyEvent>(){

        @Override
        public KeyEvent createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            return KeyEvent.createFromParcelBody(parcel);
        }

        public KeyEvent[] newArray(int n) {
            return new KeyEvent[n];
        }
    };
    static final boolean DEBUG = false;
    public static final int FLAG_CANCELED = 32;
    public static final int FLAG_CANCELED_LONG_PRESS = 256;
    public static final int FLAG_EDITOR_ACTION = 16;
    public static final int FLAG_FROM_SYSTEM = 8;
    public static final int FLAG_KEEP_TOUCH_MODE = 4;
    public static final int FLAG_LONG_PRESS = 128;
    public static final int FLAG_SOFT_KEYBOARD = 2;
    public static final int FLAG_START_TRACKING = 0x40000000;
    public static final int FLAG_TRACKING = 512;
    public static final int FLAG_VIRTUAL_HARD_KEY = 64;
    public static final int FLAG_WOKE_HERE = 1;
    public static final int KEYCODE_0 = 7;
    public static final int KEYCODE_1 = 8;
    public static final int KEYCODE_2 = 9;
    public static final int KEYCODE_3 = 10;
    public static final int KEYCODE_4 = 11;
    public static final int KEYCODE_5 = 12;
    public static final int KEYCODE_6 = 13;
    public static final int KEYCODE_7 = 14;
    public static final int KEYCODE_8 = 15;
    public static final int KEYCODE_9 = 16;
    public static final int KEYCODE_A = 29;
    public static final int KEYCODE_ALT_LEFT = 57;
    public static final int KEYCODE_ALT_RIGHT = 58;
    public static final int KEYCODE_APOSTROPHE = 75;
    public static final int KEYCODE_AT = 77;
    public static final int KEYCODE_B = 30;
    public static final int KEYCODE_BACK = 4;
    public static final int KEYCODE_BACKSLASH = 73;
    public static final int KEYCODE_BUTTON_A = 96;
    public static final int KEYCODE_BUTTON_B = 97;
    public static final int KEYCODE_BUTTON_C = 98;
    public static final int KEYCODE_BUTTON_L1 = 102;
    public static final int KEYCODE_BUTTON_L2 = 104;
    public static final int KEYCODE_BUTTON_MODE = 110;
    public static final int KEYCODE_BUTTON_R1 = 103;
    public static final int KEYCODE_BUTTON_R2 = 105;
    public static final int KEYCODE_BUTTON_SELECT = 109;
    public static final int KEYCODE_BUTTON_START = 108;
    public static final int KEYCODE_BUTTON_THUMBL = 106;
    public static final int KEYCODE_BUTTON_THUMBR = 107;
    public static final int KEYCODE_BUTTON_X = 99;
    public static final int KEYCODE_BUTTON_Y = 100;
    public static final int KEYCODE_BUTTON_Z = 101;
    public static final int KEYCODE_C = 31;
    public static final int KEYCODE_CALL = 5;
    public static final int KEYCODE_CAMERA = 27;
    public static final int KEYCODE_CLEAR = 28;
    public static final int KEYCODE_COMMA = 55;
    public static final int KEYCODE_D = 32;
    public static final int KEYCODE_DEL = 67;
    public static final int KEYCODE_DPAD_CENTER = 23;
    public static final int KEYCODE_DPAD_DOWN = 20;
    public static final int KEYCODE_DPAD_LEFT = 21;
    public static final int KEYCODE_DPAD_RIGHT = 22;
    public static final int KEYCODE_DPAD_UP = 19;
    public static final int KEYCODE_E = 33;
    public static final int KEYCODE_ENDCALL = 6;
    public static final int KEYCODE_ENTER = 66;
    public static final int KEYCODE_ENVELOPE = 65;
    public static final int KEYCODE_EQUALS = 70;
    public static final int KEYCODE_EXPLORER = 64;
    public static final int KEYCODE_F = 34;
    public static final int KEYCODE_FOCUS = 80;
    public static final int KEYCODE_G = 35;
    public static final int KEYCODE_GRAVE = 68;
    public static final int KEYCODE_H = 36;
    public static final int KEYCODE_HEADSETHOOK = 79;
    public static final int KEYCODE_HOME = 3;
    public static final int KEYCODE_I = 37;
    public static final int KEYCODE_J = 38;
    public static final int KEYCODE_K = 39;
    public static final int KEYCODE_L = 40;
    public static final int KEYCODE_LEFT_BRACKET = 71;
    public static final int KEYCODE_M = 41;
    public static final int KEYCODE_MEDIA_FAST_FORWARD = 90;
    public static final int KEYCODE_MEDIA_NEXT = 87;
    public static final int KEYCODE_MEDIA_PLAY_PAUSE = 85;
    public static final int KEYCODE_MEDIA_PREVIOUS = 88;
    public static final int KEYCODE_MEDIA_REWIND = 89;
    public static final int KEYCODE_MEDIA_STOP = 86;
    public static final int KEYCODE_MENU = 82;
    public static final int KEYCODE_MINUS = 69;
    public static final int KEYCODE_MUTE = 91;
    public static final int KEYCODE_N = 42;
    public static final int KEYCODE_NOTIFICATION = 83;
    public static final int KEYCODE_NUM = 78;
    public static final int KEYCODE_O = 43;
    public static final int KEYCODE_P = 44;
    public static final int KEYCODE_PAGE_DOWN = 93;
    public static final int KEYCODE_PAGE_UP = 92;
    public static final int KEYCODE_PERIOD = 56;
    public static final int KEYCODE_PICTSYMBOLS = 94;
    public static final int KEYCODE_PLUS = 81;
    public static final int KEYCODE_POUND = 18;
    public static final int KEYCODE_POWER = 26;
    public static final int KEYCODE_Q = 45;
    public static final int KEYCODE_R = 46;
    public static final int KEYCODE_RIGHT_BRACKET = 72;
    public static final int KEYCODE_S = 47;
    public static final int KEYCODE_SEARCH = 84;
    public static final int KEYCODE_SEMICOLON = 74;
    public static final int KEYCODE_SHIFT_LEFT = 59;
    public static final int KEYCODE_SHIFT_RIGHT = 60;
    public static final int KEYCODE_SLASH = 76;
    public static final int KEYCODE_SOFT_LEFT = 1;
    public static final int KEYCODE_SOFT_RIGHT = 2;
    public static final int KEYCODE_SPACE = 62;
    public static final int KEYCODE_STAR = 17;
    public static final int KEYCODE_SWITCH_CHARSET = 95;
    public static final int KEYCODE_SYM = 63;
    public static final int KEYCODE_T = 48;
    public static final int KEYCODE_TAB = 61;
    public static final int KEYCODE_U = 49;
    public static final int KEYCODE_UNKNOWN = 0;
    public static final int KEYCODE_V = 50;
    public static final int KEYCODE_VOLUME_DOWN = 25;
    public static final int KEYCODE_VOLUME_UP = 24;
    public static final int KEYCODE_W = 51;
    public static final int KEYCODE_X = 52;
    public static final int KEYCODE_Y = 53;
    public static final int KEYCODE_Z = 54;
    private static final int LAST_KEYCODE = 110;
    @Deprecated
    public static final int MAX_KEYCODE = 84;
    public static final int META_ALT_LEFT_ON = 16;
    public static final int META_ALT_ON = 2;
    public static final int META_ALT_RIGHT_ON = 32;
    public static final int META_SHIFT_LEFT_ON = 64;
    public static final int META_SHIFT_ON = 1;
    public static final int META_SHIFT_RIGHT_ON = 128;
    public static final int META_SYM_ON = 4;
    static final String TAG = "KeyEvent";
    private int mAction;
    private String mCharacters;
    private long mDownTime;
    private long mEventTime;
    private int mFlags;
    private int mKeyCode;
    private int mMetaState;
    private int mRepeatCount;
    private int mScanCode;

    public KeyEvent(int n, int n2) {
        this.mAction = n;
        this.mKeyCode = n2;
        this.mRepeatCount = 0;
    }

    public KeyEvent(long l, long l2, int n, int n2, int n3) {
        this.mDownTime = l;
        this.mEventTime = l2;
        this.mAction = n;
        this.mKeyCode = n2;
        this.mRepeatCount = n3;
    }

    public KeyEvent(long l, long l2, int n, int n2, int n3, int n4) {
        this.mDownTime = l;
        this.mEventTime = l2;
        this.mAction = n;
        this.mKeyCode = n2;
        this.mRepeatCount = n3;
        this.mMetaState = n4;
    }

    public KeyEvent(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.mDownTime = l;
        this.mEventTime = l2;
        this.mAction = n;
        this.mKeyCode = n2;
        this.mRepeatCount = n3;
        this.mMetaState = n4;
        this.mDeviceId = n5;
        this.mScanCode = n6;
    }

    public KeyEvent(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mDownTime = l;
        this.mEventTime = l2;
        this.mAction = n;
        this.mKeyCode = n2;
        this.mRepeatCount = n3;
        this.mMetaState = n4;
        this.mDeviceId = n5;
        this.mScanCode = n6;
        this.mFlags = n7;
    }

    public KeyEvent(long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.mDownTime = l;
        this.mEventTime = l2;
        this.mAction = n;
        this.mKeyCode = n2;
        this.mRepeatCount = n3;
        this.mMetaState = n4;
        this.mDeviceId = n5;
        this.mScanCode = n6;
        this.mFlags = n7;
        this.mSource = n8;
    }

    public KeyEvent(long l, String string2, int n, int n2) {
        this.mDownTime = l;
        this.mEventTime = l;
        this.mCharacters = string2;
        this.mAction = 2;
        this.mKeyCode = 0;
        this.mRepeatCount = 0;
        this.mDeviceId = n;
        this.mFlags = n2;
        this.mSource = 257;
    }

    private KeyEvent(Parcel parcel) {
        long l;
        long l2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.readBaseFromParcel(parcel);
        this.mAction = n6 = parcel.readInt();
        this.mKeyCode = n5 = parcel.readInt();
        this.mRepeatCount = n4 = parcel.readInt();
        this.mMetaState = n3 = parcel.readInt();
        this.mScanCode = n2 = parcel.readInt();
        this.mFlags = n = parcel.readInt();
        this.mDownTime = l2 = parcel.readLong();
        this.mEventTime = l = parcel.readLong();
    }

    public KeyEvent(KeyEvent keyEvent) {
        String string2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long l;
        long l2;
        this.mDownTime = l2 = keyEvent.mDownTime;
        this.mEventTime = l = keyEvent.mEventTime;
        this.mAction = n8 = keyEvent.mAction;
        this.mKeyCode = n7 = keyEvent.mKeyCode;
        this.mRepeatCount = n6 = keyEvent.mRepeatCount;
        this.mMetaState = n5 = keyEvent.mMetaState;
        this.mDeviceId = n4 = keyEvent.mDeviceId;
        this.mSource = n3 = keyEvent.mSource;
        this.mScanCode = n2 = keyEvent.mScanCode;
        this.mFlags = n = keyEvent.mFlags;
        this.mCharacters = string2 = keyEvent.mCharacters;
    }

    private KeyEvent(KeyEvent keyEvent, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long l;
        long l2;
        this.mDownTime = l2 = keyEvent.mDownTime;
        this.mEventTime = l = keyEvent.mEventTime;
        this.mAction = n;
        this.mKeyCode = n8 = keyEvent.mKeyCode;
        this.mRepeatCount = n7 = keyEvent.mRepeatCount;
        this.mMetaState = n6 = keyEvent.mMetaState;
        this.mDeviceId = n5 = keyEvent.mDeviceId;
        this.mSource = n4 = keyEvent.mSource;
        this.mScanCode = n3 = keyEvent.mScanCode;
        this.mFlags = n2 = keyEvent.mFlags;
    }

    @Deprecated
    public KeyEvent(KeyEvent keyEvent, long l, int n) {
        String string2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long l2;
        this.mDownTime = l2 = keyEvent.mDownTime;
        this.mEventTime = l;
        this.mAction = n8 = keyEvent.mAction;
        this.mKeyCode = n7 = keyEvent.mKeyCode;
        this.mRepeatCount = n;
        this.mMetaState = n6 = keyEvent.mMetaState;
        this.mDeviceId = n5 = keyEvent.mDeviceId;
        this.mSource = n4 = keyEvent.mSource;
        this.mScanCode = n3 = keyEvent.mScanCode;
        this.mFlags = n2 = keyEvent.mFlags;
        this.mCharacters = string2 = keyEvent.mCharacters;
    }

    static /* synthetic */ int access$076(KeyEvent keyEvent, int n) {
        int n2;
        keyEvent.mFlags = n2 = keyEvent.mFlags | n;
        return n2;
    }

    public static KeyEvent changeAction(KeyEvent keyEvent, int n) {
        return new KeyEvent(keyEvent, n);
    }

    public static KeyEvent changeFlags(KeyEvent keyEvent, int n) {
        KeyEvent keyEvent2 = new KeyEvent(keyEvent);
        keyEvent2.mFlags = n;
        return keyEvent2;
    }

    public static KeyEvent changeTimeRepeat(KeyEvent keyEvent, long l, int n) {
        return new KeyEvent(keyEvent, l, n);
    }

    public static KeyEvent changeTimeRepeat(KeyEvent keyEvent, long l, int n, int n2) {
        KeyEvent keyEvent2 = new KeyEvent(keyEvent);
        keyEvent2.mEventTime = l;
        keyEvent2.mRepeatCount = n;
        keyEvent2.mFlags = n2;
        return keyEvent2;
    }

    public static KeyEvent createFromParcelBody(Parcel parcel) {
        return new KeyEvent(parcel);
    }

    public static int getDeadChar(int n, int n2) {
        return KeyCharacterMap.getDeadChar(n, n2);
    }

    public static int getMaxKeyCode() {
        return 110;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isModifierKey(int n) {
        if (n == 59) return true;
        if (n == 60) return true;
        if (n == 57) return true;
        if (n == 58) return true;
        if (n != 63) return false;
        return true;
    }

    private native boolean native_hasDefaultAction(int var1);

    private native boolean native_isSystemKey(int var1);

    @Deprecated
    public final boolean dispatch(Callback callback) {
        return this.dispatch(callback, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean dispatch(Callback callback, DispatcherState dispatcherState, Object object) {
        switch (this.mAction) {
            default: {
                return false;
            }
            case 0: {
                int n;
                this.mFlags = n = this.mFlags & 0xBFFFFFFF;
                int n2 = this.mKeyCode;
                boolean bl = callback.onKeyDown(n2, this);
                if (dispatcherState == null) return bl;
                if (bl && this.mRepeatCount == 0 && (this.mFlags & 0x40000000) != 0) {
                    dispatcherState.startTracking(this, object);
                    return bl;
                }
                if (!this.isLongPress()) return bl;
                if (!dispatcherState.isTracking(this)) return bl;
                try {
                    int n3 = this.mKeyCode;
                    if (!callback.onKeyLongPress(n3, this)) return bl;
                    dispatcherState.performedLongPress(this);
                    return true;
                }
                catch (AbstractMethodError abstractMethodError) {}
                return bl;
            }
            case 1: {
                if (dispatcherState != null) {
                    dispatcherState.handleUpEvent(this);
                }
                int n = this.mKeyCode;
                return callback.onKeyUp(n, this);
            }
            case 2: 
        }
        int n = this.mRepeatCount;
        int n4 = this.mKeyCode;
        if (callback.onKeyMultiple(n4, n, this)) {
            return true;
        }
        if (n4 == 0) {
            return false;
        }
        this.mAction = 0;
        this.mRepeatCount = 0;
        boolean bl2 = callback.onKeyDown(n4, this);
        if (bl2) {
            this.mAction = 1;
            boolean bl3 = callback.onKeyUp(n4, this);
        }
        this.mAction = 2;
        this.mRepeatCount = n;
        return bl2;
    }

    public final int getAction() {
        return this.mAction;
    }

    public final String getCharacters() {
        return this.mCharacters;
    }

    public char getDisplayLabel() {
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(this.mDeviceId);
        int n = this.mKeyCode;
        return keyCharacterMap.getDisplayLabel(n);
    }

    public final long getDownTime() {
        return this.mDownTime;
    }

    public final long getEventTime() {
        return this.mEventTime;
    }

    public final int getFlags() {
        return this.mFlags;
    }

    public final int getKeyCode() {
        return this.mKeyCode;
    }

    public boolean getKeyData(KeyCharacterMap.KeyData keyData) {
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(this.mDeviceId);
        int n = this.mKeyCode;
        return keyCharacterMap.getKeyData(n, keyData);
    }

    public final int getKeyboardDevice() {
        return this.mDeviceId;
    }

    public char getMatch(char[] cArray) {
        return this.getMatch(cArray, 0);
    }

    public char getMatch(char[] cArray, int n) {
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(this.mDeviceId);
        int n2 = this.mKeyCode;
        return keyCharacterMap.getMatch(n2, cArray, n);
    }

    public final int getMetaState() {
        return this.mMetaState;
    }

    public char getNumber() {
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(this.mDeviceId);
        int n = this.mKeyCode;
        return keyCharacterMap.getNumber(n);
    }

    public final int getRepeatCount() {
        return this.mRepeatCount;
    }

    public final int getScanCode() {
        return this.mScanCode;
    }

    public int getUnicodeChar() {
        int n = this.mMetaState;
        return this.getUnicodeChar(n);
    }

    public int getUnicodeChar(int n) {
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(this.mDeviceId);
        int n2 = this.mKeyCode;
        return keyCharacterMap.get(n2, n);
    }

    public final boolean hasDefaultAction() {
        int n = this.mKeyCode;
        return this.native_hasDefaultAction(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAltPressed() {
        if ((this.mMetaState & 2) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCanceled() {
        if ((this.mFlags & 0x20) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public final boolean isDown() {
        if (this.mAction != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLongPress() {
        if ((this.mFlags & 0x80) == 0) return false;
        return true;
    }

    public boolean isPrintingKey() {
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(this.mDeviceId);
        int n = this.mKeyCode;
        return keyCharacterMap.isPrintingKey(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isShiftPressed() {
        if ((this.mMetaState & 1) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSymPressed() {
        if ((this.mMetaState & 4) == 0) return false;
        return true;
    }

    public final boolean isSystem() {
        int n = this.mKeyCode;
        return this.native_isSystemKey(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTracking() {
        if ((this.mFlags & 0x200) == 0) return false;
        return true;
    }

    public final void startTracking() {
        int n;
        this.mFlags = n = this.mFlags | 0x40000000;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("KeyEvent{action=");
        int n = this.mAction;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(" code=");
        int n2 = this.mKeyCode;
        StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(" repeat=");
        int n3 = this.mRepeatCount;
        StringBuilder stringBuilder4 = stringBuilder3.append(n3).append(" meta=");
        int n4 = this.mMetaState;
        StringBuilder stringBuilder5 = stringBuilder4.append(n4).append(" scancode=");
        int n5 = this.mScanCode;
        StringBuilder stringBuilder6 = stringBuilder5.append(n5).append(" mFlags=");
        int n6 = this.mFlags;
        return stringBuilder6.append(n6).append("}").toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(2);
        this.writeBaseToParcel(parcel);
        int n2 = this.mAction;
        parcel.writeInt(n2);
        int n3 = this.mKeyCode;
        parcel.writeInt(n3);
        int n4 = this.mRepeatCount;
        parcel.writeInt(n4);
        int n5 = this.mMetaState;
        parcel.writeInt(n5);
        int n6 = this.mScanCode;
        parcel.writeInt(n6);
        int n7 = this.mFlags;
        parcel.writeInt(n7);
        long l = this.mDownTime;
        parcel.writeLong(l);
        long l2 = this.mEventTime;
        parcel.writeLong(l2);
    }

    public static class DispatcherState {
        SparseIntArray mActiveLongPresses;
        int mDownKeyCode;
        Object mDownTarget;

        public DispatcherState() {
            SparseIntArray sparseIntArray;
            this.mActiveLongPresses = sparseIntArray = new SparseIntArray();
        }

        public void handleUpEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = this.mActiveLongPresses.indexOfKey(n);
            if (n2 >= 0) {
                int n3 = KeyEvent.access$076(keyEvent, 288);
                this.mActiveLongPresses.removeAt(n2);
            }
            if (this.mDownKeyCode != n) {
                return;
            }
            int n4 = KeyEvent.access$076(keyEvent, 512);
            this.mDownKeyCode = 0;
            this.mDownTarget = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isTracking(KeyEvent keyEvent) {
            int n = this.mDownKeyCode;
            int n2 = keyEvent.getKeyCode();
            if (n == n2) return false;
            return true;
        }

        public void performedLongPress(KeyEvent keyEvent) {
            SparseIntArray sparseIntArray = this.mActiveLongPresses;
            int n = keyEvent.getKeyCode();
            sparseIntArray.put(n, 1);
        }

        public void reset() {
            this.mDownKeyCode = 0;
            this.mDownTarget = null;
            this.mActiveLongPresses.clear();
        }

        public void reset(Object object) {
            if (this.mDownTarget != object) {
                return;
            }
            this.mDownKeyCode = 0;
            this.mDownTarget = null;
        }

        public void startTracking(KeyEvent keyEvent, Object object) {
            int n;
            if (keyEvent.getAction() != 0) {
                throw new IllegalArgumentException("Can only start tracking on a down event");
            }
            this.mDownKeyCode = n = keyEvent.getKeyCode();
            this.mDownTarget = object;
        }
    }

    public static interface Callback {
        public boolean onKeyDown(int var1, KeyEvent var2);

        public boolean onKeyLongPress(int var1, KeyEvent var2);

        public boolean onKeyMultiple(int var1, int var2, KeyEvent var3);

        public boolean onKeyUp(int var1, KeyEvent var2);
    }
}

