/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputEvent;

public final class MotionEvent
extends InputEvent
implements Parcelable {
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_OUTSIDE = 4;
    @Deprecated
    public static final int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static final int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static final int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static final int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static final int ACTION_POINTER_3_UP = 518;
    public static final int ACTION_POINTER_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_UP = 1;
    private static final int BASE_AVAIL_POINTERS = 5;
    private static final int BASE_AVAIL_SAMPLES = 8;
    public static final Parcelable.Creator<MotionEvent> CREATOR;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int EDGE_TOP = 1;
    public static final int FLAG_WINDOW_IS_OBSCURED = 1;
    private static final int MAX_RECYCLED = 10;
    private static final long MS_PER_NS = 1000000L;
    private static final int NUM_SAMPLE_DATA = 9;
    private static final int SAMPLE_ORIENTATION = 8;
    private static final int SAMPLE_PRESSURE = 2;
    private static final int SAMPLE_SIZE = 3;
    private static final int SAMPLE_TOOL_MAJOR = 6;
    private static final int SAMPLE_TOOL_MINOR = 7;
    private static final int SAMPLE_TOUCH_MAJOR = 4;
    private static final int SAMPLE_TOUCH_MINOR = 5;
    private static final int SAMPLE_X = 0;
    private static final int SAMPLE_Y = 1;
    private static final boolean TRACK_RECYCLED_LOCATION;
    private static Object gRecyclerLock;
    private static MotionEvent gRecyclerTop;
    private static int gRecyclerUsed;
    private int mAction;
    private float[] mDataSamples;
    private long mDownTimeNano;
    private int mEdgeFlags;
    private long[] mEventTimeNanoSamples;
    private int mFlags;
    private int mLastDataSampleIndex;
    private int mLastEventTimeNanoSampleIndex;
    private int mMetaState;
    private MotionEvent mNext;
    private int mNumPointers;
    private int mNumSamples;
    private int[] mPointerIdentifiers;
    private boolean mRecycled;
    private RuntimeException mRecycledLocation;
    private float mXOffset;
    private float mXPrecision;
    private float mYOffset;
    private float mYPrecision;

    static {
        gRecyclerLock = new Object();
        gRecyclerUsed = 0;
        gRecyclerTop = null;
        CREATOR = new Parcelable.Creator<MotionEvent>(){

            @Override
            public MotionEvent createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                return MotionEvent.createFromParcelBody(parcel);
            }

            public MotionEvent[] newArray(int n) {
                return new MotionEvent[n];
            }
        };
    }

    private MotionEvent(int n, int n2) {
        int[] nArray = new int[n];
        this.mPointerIdentifiers = nArray;
        float[] fArray = new float[n * n2 * 9];
        this.mDataSamples = fArray;
        int n3 = n2;
        this.mEventTimeNanoSamples = (long[])n3;
    }

    public static MotionEvent createFromParcelBody(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        long l;
        int n7 = parcel.readInt();
        int n8 = parcel.readInt();
        int n9 = n7 * n8 * 9;
        MotionEvent motionEvent = MotionEvent.obtain(n7, n8);
        motionEvent.mNumPointers = n7;
        motionEvent.mNumSamples = n8;
        motionEvent.readBaseFromParcel(parcel);
        motionEvent.mDownTimeNano = l = parcel.readLong();
        motionEvent.mAction = n6 = parcel.readInt();
        motionEvent.mXOffset = f4 = parcel.readFloat();
        motionEvent.mYOffset = f3 = parcel.readFloat();
        motionEvent.mXPrecision = f2 = parcel.readFloat();
        motionEvent.mYPrecision = f = parcel.readFloat();
        motionEvent.mEdgeFlags = n5 = parcel.readInt();
        motionEvent.mMetaState = n4 = parcel.readInt();
        motionEvent.mFlags = n3 = parcel.readInt();
        int[] nArray = motionEvent.mPointerIdentifiers;
        for (int i = 0; i < n7; ++i) {
            int n10;
            nArray[i] = n10 = parcel.readInt();
        }
        long[] lArray = motionEvent.mEventTimeNanoSamples;
        for (int i = 0; i < n8; ++i) {
            long l2;
            lArray[i] = l2 = parcel.readLong();
        }
        float[] fArray = motionEvent.mDataSamples;
        for (int i = 0; i < n9; ++i) {
            float f5;
            fArray[i] = f5 = parcel.readFloat();
        }
        motionEvent.mLastEventTimeNanoSampleIndex = n2 = n8 - 1;
        motionEvent.mLastDataSampleIndex = n = (n8 - 1) * n7 * 9;
        return motionEvent;
    }

    private final void getPointerCoordsAtSampleIndex(int n, PointerCoords pointerCoords) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float[] fArray = this.mDataSamples;
        int n2 = n + 0;
        float f10 = fArray[n2];
        float f11 = this.mXOffset;
        pointerCoords.x = f9 = f10 + f11;
        int n3 = n + 1;
        float f12 = fArray[n3];
        float f13 = this.mYOffset;
        pointerCoords.y = f8 = f12 + f13;
        int n4 = n + 2;
        pointerCoords.pressure = f7 = fArray[n4];
        int n5 = n + 3;
        pointerCoords.size = f6 = fArray[n5];
        int n6 = n + 4;
        pointerCoords.touchMajor = f5 = fArray[n6];
        int n7 = n + 5;
        pointerCoords.touchMinor = f4 = fArray[n7];
        int n8 = n + 6;
        pointerCoords.toolMajor = f3 = fArray[n8];
        int n9 = n + 7;
        pointerCoords.toolMinor = f2 = fArray[n9];
        int n10 = n + 8;
        pointerCoords.orientation = f = fArray[n10];
    }

    private final void incrementNumSamplesAndReserveStorage(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.mNumSamples;
        int n8 = this.mEventTimeNanoSamples.length;
        if (n7 != n8) {
            int n9 = this.mNumSamples + 8;
            long[] lArray = this.mEventTimeNanoSamples;
            int n10 = this.mNumSamples;
            System.arraycopy(lArray, 0, n9, 0, n10);
            this.mEventTimeNanoSamples = (long[])n9;
        }
        if ((n6 = (n5 = this.mLastDataSampleIndex + n) + n) > (n4 = this.mDataSamples.length)) {
            float[] fArray = new float[n * 8 + n5];
            System.arraycopy(this.mDataSamples, 0, fArray, 0, n5);
            this.mDataSamples = fArray;
        }
        this.mLastEventTimeNanoSampleIndex = n3 = this.mNumSamples;
        this.mLastDataSampleIndex = n5;
        this.mNumSamples = n2 = this.mNumSamples + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MotionEvent obtain(int n, int n2) {
        int n3;
        MotionEvent motionEvent;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerTop == null) {
                if (n < 5) {
                    n = 5;
                }
                if (n2 < 8) {
                    n2 = 8;
                }
                MotionEvent motionEvent2 = new MotionEvent(n, n2);
                return motionEvent2;
            }
            motionEvent = gRecyclerTop;
            gRecyclerTop = motionEvent.mNext;
            --gRecyclerUsed;
        }
        motionEvent.mRecycledLocation = null;
        motionEvent.mRecycled = false;
        motionEvent.mNext = null;
        if (motionEvent.mPointerIdentifiers.length < n) {
            int[] nArray = new int[n];
            motionEvent.mPointerIdentifiers = nArray;
        }
        if (motionEvent.mEventTimeNanoSamples.length < n2) {
            int n4 = n2;
            motionEvent.mEventTimeNanoSamples = (long[])n4;
        }
        if (motionEvent.mDataSamples.length >= (n3 = n * n2 * 9)) return motionEvent;
        float[] fArray = new float[n3];
        motionEvent.mDataSamples = fArray;
        return motionEvent;
    }

    public static MotionEvent obtain(long l, long l2, int n, float f, float f2, float f3, float f4, int n2, float f5, float f6, int n3, int n4) {
        long l3;
        float f7;
        float f8;
        int n5;
        long l4;
        int n6;
        int n7;
        int n8;
        MotionEvent motionEvent = MotionEvent.obtain(1, 1);
        motionEvent.mDeviceId = n8 = n3;
        motionEvent.mSource = n7 = 0;
        motionEvent.mEdgeFlags = n6 = n4;
        motionEvent.mDownTimeNano = l4 = l * 1000000L;
        motionEvent.mAction = n;
        motionEvent.mFlags = 0;
        motionEvent.mMetaState = n5 = n2;
        motionEvent.mXOffset = 0.0f;
        motionEvent.mYOffset = 0.0f;
        motionEvent.mXPrecision = f8 = f5;
        motionEvent.mYPrecision = f7 = f6;
        motionEvent.mNumPointers = 1;
        motionEvent.mNumSamples = 1;
        motionEvent.mLastDataSampleIndex = 0;
        motionEvent.mLastEventTimeNanoSampleIndex = 0;
        motionEvent.mPointerIdentifiers[0] = 0;
        long[] lArray = motionEvent.mEventTimeNanoSamples;
        lArray[0] = l3 = l2 * 1000000L;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        motionEvent.setPointerCoordsAtSampleIndex(0, f9, f10, f11, f12);
        return motionEvent;
    }

    public static MotionEvent obtain(long l, long l2, int n, float f, float f2, int n2) {
        long l3 = l;
        long l4 = l2;
        int n3 = n;
        float f3 = f;
        float f4 = f2;
        int n4 = n2;
        return MotionEvent.obtain(l3, l4, n3, f3, f4, 1.0f, 1.0f, n4, 1.0f, 1.0f, 0, 0);
    }

    @Deprecated
    public static MotionEvent obtain(long l, long l2, int n, int n2, float f, float f2, float f3, float f4, int n3, float f5, float f6, int n4, int n5) {
        long l3 = l;
        long l4 = l2;
        int n6 = n;
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        int n7 = n3;
        float f11 = f5;
        float f12 = f6;
        int n8 = n4;
        int n9 = n5;
        return MotionEvent.obtain(l3, l4, n6, f7, f8, f9, f10, n7, f11, f12, n8, n9);
    }

    public static MotionEvent obtain(long l, long l2, int n, int n2, int[] nArray, PointerCoords[] pointerCoordsArray, int n3, float f, float f2, int n4, int n5, int n6, int n7) {
        long l3;
        long l4;
        MotionEvent motionEvent = MotionEvent.obtain(n2, 1);
        motionEvent.mDeviceId = n4;
        motionEvent.mSource = n6;
        motionEvent.mEdgeFlags = n5;
        motionEvent.mDownTimeNano = l4 = l * 1000000L;
        motionEvent.mAction = n;
        motionEvent.mFlags = n7;
        motionEvent.mMetaState = n3;
        motionEvent.mXOffset = 0.0f;
        motionEvent.mYOffset = 0.0f;
        motionEvent.mXPrecision = f;
        motionEvent.mYPrecision = f2;
        motionEvent.mNumPointers = n2;
        motionEvent.mNumSamples = 1;
        motionEvent.mLastDataSampleIndex = 0;
        motionEvent.mLastEventTimeNanoSampleIndex = 0;
        int[] nArray2 = motionEvent.mPointerIdentifiers;
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        long[] lArray = motionEvent.mEventTimeNanoSamples;
        lArray[0] = l3 = l2 * 1000000L;
        motionEvent.setPointerCoordsAtSampleIndex(0, pointerCoordsArray);
        return motionEvent;
    }

    public static MotionEvent obtain(MotionEvent motionEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        float f;
        float f2;
        float f3;
        float f4;
        int n5;
        int n6;
        int n7;
        long l;
        int n8;
        int n9;
        int n10;
        int n11 = motionEvent.mNumPointers;
        int n12 = motionEvent.mNumSamples;
        MotionEvent motionEvent2 = MotionEvent.obtain(n11, n12);
        motionEvent2.mDeviceId = n10 = motionEvent.mDeviceId;
        motionEvent2.mSource = n9 = motionEvent.mSource;
        motionEvent2.mEdgeFlags = n8 = motionEvent.mEdgeFlags;
        motionEvent2.mDownTimeNano = l = motionEvent.mDownTimeNano;
        motionEvent2.mAction = n7 = motionEvent.mAction;
        motionEvent2.mFlags = n6 = motionEvent.mFlags;
        motionEvent2.mMetaState = n5 = motionEvent.mMetaState;
        motionEvent2.mXOffset = f4 = motionEvent.mXOffset;
        motionEvent2.mYOffset = f3 = motionEvent.mYOffset;
        motionEvent2.mXPrecision = f2 = motionEvent.mXPrecision;
        motionEvent2.mYPrecision = f = motionEvent.mYPrecision;
        motionEvent2.mNumPointers = n4 = motionEvent.mNumPointers;
        motionEvent2.mNumSamples = n3 = motionEvent.mNumSamples;
        motionEvent2.mLastDataSampleIndex = n2 = motionEvent.mLastDataSampleIndex;
        motionEvent2.mLastEventTimeNanoSampleIndex = n = motionEvent.mLastEventTimeNanoSampleIndex;
        int[] nArray = motionEvent.mPointerIdentifiers;
        int[] nArray2 = motionEvent2.mPointerIdentifiers;
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        long[] lArray = motionEvent.mEventTimeNanoSamples;
        long[] lArray2 = motionEvent2.mEventTimeNanoSamples;
        System.arraycopy(lArray, 0, lArray2, 0, n3);
        float[] fArray = motionEvent.mDataSamples;
        float[] fArray2 = motionEvent2.mDataSamples;
        int n13 = n4 * n3 * 9;
        System.arraycopy(fArray, 0, fArray2, 0, n13);
        return motionEvent2;
    }

    public static MotionEvent obtainNoHistory(MotionEvent motionEvent) {
        long l;
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3;
        int n4;
        long l2;
        int n5;
        int n6;
        int n7;
        MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent.mNumPointers, 1);
        motionEvent2.mDeviceId = n7 = motionEvent.mDeviceId;
        motionEvent2.mSource = n6 = motionEvent.mSource;
        motionEvent2.mEdgeFlags = n5 = motionEvent.mEdgeFlags;
        motionEvent2.mDownTimeNano = l2 = motionEvent.mDownTimeNano;
        motionEvent2.mAction = n4 = motionEvent.mAction;
        motionEvent.mFlags = n3 = motionEvent.mFlags;
        motionEvent2.mMetaState = n2 = motionEvent.mMetaState;
        motionEvent2.mXOffset = f4 = motionEvent.mXOffset;
        motionEvent2.mYOffset = f3 = motionEvent.mYOffset;
        motionEvent2.mXPrecision = f2 = motionEvent.mXPrecision;
        motionEvent2.mYPrecision = f = motionEvent.mYPrecision;
        motionEvent2.mNumPointers = n = motionEvent.mNumPointers;
        motionEvent2.mNumSamples = 1;
        motionEvent2.mLastDataSampleIndex = 0;
        motionEvent2.mLastEventTimeNanoSampleIndex = 0;
        int[] nArray = motionEvent.mPointerIdentifiers;
        int[] nArray2 = motionEvent2.mPointerIdentifiers;
        System.arraycopy(nArray, 0, nArray2, 0, n);
        long[] lArray = motionEvent2.mEventTimeNanoSamples;
        long[] lArray2 = motionEvent.mEventTimeNanoSamples;
        int n8 = motionEvent.mLastEventTimeNanoSampleIndex;
        lArray[0] = l = lArray2[n8];
        float[] fArray = motionEvent.mDataSamples;
        int n9 = motionEvent.mLastDataSampleIndex;
        float[] fArray2 = motionEvent2.mDataSamples;
        int n10 = n * 9;
        System.arraycopy(fArray, n9, fArray2, 0, n10);
        return motionEvent2;
    }

    private final void setPointerCoordsAtSampleIndex(int n, float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float[] fArray = this.mDataSamples;
        int n2 = n + 0;
        float f7 = this.mXOffset;
        fArray[n2] = f6 = f - f7;
        int n3 = n + 1;
        float f8 = this.mYOffset;
        fArray[n3] = f5 = f2 - f8;
        int n4 = n + 2;
        fArray[n4] = f3;
        int n5 = n + 3;
        fArray[n5] = f4;
        int n6 = n + 4;
        fArray[n6] = f3;
        int n7 = n + 5;
        fArray[n7] = f3;
        int n8 = n + 6;
        fArray[n8] = f4;
        int n9 = n + 7;
        fArray[n9] = f4;
        int n10 = n + 8;
        fArray[n10] = 0.0f;
    }

    private final void setPointerCoordsAtSampleIndex(int n, PointerCoords pointerCoords) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float[] fArray = this.mDataSamples;
        int n2 = n + 0;
        float f10 = pointerCoords.x;
        float f11 = this.mXOffset;
        fArray[n2] = f9 = f10 - f11;
        int n3 = n + 1;
        float f12 = pointerCoords.y;
        float f13 = this.mYOffset;
        fArray[n3] = f8 = f12 - f13;
        int n4 = n + 2;
        fArray[n4] = f7 = pointerCoords.pressure;
        int n5 = n + 3;
        fArray[n5] = f6 = pointerCoords.size;
        int n6 = n + 4;
        fArray[n6] = f5 = pointerCoords.touchMajor;
        int n7 = n + 5;
        fArray[n7] = f4 = pointerCoords.touchMinor;
        int n8 = n + 6;
        fArray[n8] = f3 = pointerCoords.toolMajor;
        int n9 = n + 7;
        fArray[n9] = f2 = pointerCoords.toolMinor;
        int n10 = n + 8;
        fArray[n10] = f = pointerCoords.orientation;
    }

    private final void setPointerCoordsAtSampleIndex(int n, PointerCoords[] pointerCoordsArray) {
        int n2 = this.mNumPointers;
        int n3 = 0;
        while (n3 < n2) {
            PointerCoords pointerCoords = pointerCoordsArray[n3];
            this.setPointerCoordsAtSampleIndex(n, pointerCoords);
            n += 9;
            ++n3;
        }
        return;
    }

    public final void addBatch(long l, float f, float f2, float f3, float f4, int n) {
        int n2;
        long l2;
        this.incrementNumSamplesAndReserveStorage(9);
        long[] lArray = this.mEventTimeNanoSamples;
        int n3 = this.mLastEventTimeNanoSampleIndex;
        lArray[n3] = l2 = 1000000L * l;
        int n4 = this.mLastDataSampleIndex;
        MotionEvent motionEvent = this;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        motionEvent.setPointerCoordsAtSampleIndex(n4, f5, f6, f7, f8);
        this.mMetaState = n2 = this.mMetaState | n;
    }

    public final void addBatch(long l, PointerCoords[] pointerCoordsArray, int n) {
        int n2;
        long l2;
        int n3 = this.mNumPointers * 9;
        this.incrementNumSamplesAndReserveStorage(n3);
        long[] lArray = this.mEventTimeNanoSamples;
        int n4 = this.mLastEventTimeNanoSampleIndex;
        lArray[n4] = l2 = 1000000L * l;
        int n5 = this.mLastDataSampleIndex;
        this.setPointerCoordsAtSampleIndex(n5, pointerCoordsArray);
        this.mMetaState = n2 = this.mMetaState | n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int findPointerIndex(int n) {
        int n2 = this.mNumPointers;
        do {
            if (n2 <= 0) return -1;
        } while (this.mPointerIdentifiers[n2 += -1] == n);
        return n2;
    }

    public final int getAction() {
        return this.mAction;
    }

    public final int getActionIndex() {
        return (this.mAction & 0xFF00) >> 8;
    }

    public final int getActionMasked() {
        return this.mAction & 0xFF;
    }

    public final long getDownTime() {
        return this.mDownTimeNano / 1000000L;
    }

    public final int getEdgeFlags() {
        return this.mEdgeFlags;
    }

    public final long getEventTime() {
        long[] lArray = this.mEventTimeNanoSamples;
        int n = this.mLastEventTimeNanoSampleIndex;
        return lArray[n] / 1000000L;
    }

    public final long getEventTimeNano() {
        long[] lArray = this.mEventTimeNanoSamples;
        int n = this.mLastEventTimeNanoSampleIndex;
        return lArray[n];
    }

    public final int getFlags() {
        return this.mFlags;
    }

    public final long getHistoricalEventTime(int n) {
        return this.mEventTimeNanoSamples[n] / 1000000L;
    }

    public final float getHistoricalOrientation(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 8;
        return fArray[n2];
    }

    public final float getHistoricalOrientation(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 8;
        return fArray[n3];
    }

    public final void getHistoricalPointerCoords(int n, int n2, PointerCoords pointerCoords) {
        int n3 = (this.mNumPointers * n2 + n) * 9;
        this.getPointerCoordsAtSampleIndex(n3, pointerCoords);
    }

    public final float getHistoricalPressure(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 2;
        return fArray[n2];
    }

    public final float getHistoricalPressure(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 2;
        return fArray[n3];
    }

    public final float getHistoricalSize(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 3;
        return fArray[n2];
    }

    public final float getHistoricalSize(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 3;
        return fArray[n3];
    }

    public final float getHistoricalToolMajor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 6;
        return fArray[n2];
    }

    public final float getHistoricalToolMajor(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 6;
        return fArray[n3];
    }

    public final float getHistoricalToolMinor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 7;
        return fArray[n2];
    }

    public final float getHistoricalToolMinor(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 7;
        return fArray[n3];
    }

    public final float getHistoricalTouchMajor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 4;
        return fArray[n2];
    }

    public final float getHistoricalTouchMajor(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 4;
        return fArray[n3];
    }

    public final float getHistoricalTouchMinor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 5;
        return fArray[n2];
    }

    public final float getHistoricalTouchMinor(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 5;
        return fArray[n3];
    }

    public final float getHistoricalX(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 0;
        float f = fArray[n2];
        float f2 = this.mXOffset;
        return f + f2;
    }

    public final float getHistoricalX(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 0;
        float f = fArray[n3];
        float f2 = this.mXOffset;
        return f + f2;
    }

    public final float getHistoricalY(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mNumPointers * n * 9 + 1;
        float f = fArray[n2];
        float f2 = this.mYOffset;
        return f + f2;
    }

    public final float getHistoricalY(int n, int n2) {
        float[] fArray = this.mDataSamples;
        int n3 = (this.mNumPointers * n2 + n) * 9 + 1;
        float f = fArray[n3];
        float f2 = this.mYOffset;
        return f + f2;
    }

    public final int getHistorySize() {
        return this.mLastEventTimeNanoSampleIndex;
    }

    public final int getMetaState() {
        return this.mMetaState;
    }

    public final float getOrientation() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 8;
        return fArray[n];
    }

    public final float getOrientation(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 8;
        return fArray[n4];
    }

    public final void getPointerCoords(int n, PointerCoords pointerCoords) {
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3;
        this.getPointerCoordsAtSampleIndex(n4, pointerCoords);
    }

    public final int getPointerCount() {
        return this.mNumPointers;
    }

    public final int getPointerId(int n) {
        return this.mPointerIdentifiers[n];
    }

    public final float getPressure() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 2;
        return fArray[n];
    }

    public final float getPressure(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 2;
        return fArray[n4];
    }

    public final float getRawX() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 0;
        return fArray[n];
    }

    public final float getRawY() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 1;
        return fArray[n];
    }

    public final float getSize() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 3;
        return fArray[n];
    }

    public final float getSize(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 3;
        return fArray[n4];
    }

    public final float getToolMajor() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 6;
        return fArray[n];
    }

    public final float getToolMajor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 6;
        return fArray[n4];
    }

    public final float getToolMinor() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 7;
        return fArray[n];
    }

    public final float getToolMinor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 7;
        return fArray[n4];
    }

    public final float getTouchMajor() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 4;
        return fArray[n];
    }

    public final float getTouchMajor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 4;
        return fArray[n4];
    }

    public final float getTouchMinor() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 5;
        return fArray[n];
    }

    public final float getTouchMinor(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 5;
        return fArray[n4];
    }

    public final float getX() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 0;
        float f = fArray[n];
        float f2 = this.mXOffset;
        return f + f2;
    }

    public final float getX(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 0;
        float f = fArray[n4];
        float f2 = this.mXOffset;
        return f + f2;
    }

    public final float getXPrecision() {
        return this.mXPrecision;
    }

    public final float getY() {
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex + 1;
        float f = fArray[n];
        float f2 = this.mYOffset;
        return f + f2;
    }

    public final float getY(int n) {
        float[] fArray = this.mDataSamples;
        int n2 = this.mLastDataSampleIndex;
        int n3 = n * 9;
        int n4 = n2 + n3 + 1;
        float f = fArray[n4];
        float f2 = this.mYOffset;
        return f + f2;
    }

    public final float getYPrecision() {
        return this.mYPrecision;
    }

    public final void offsetLocation(float f, float f2) {
        float f3;
        float f4;
        this.mXOffset = f4 = this.mXOffset + f;
        this.mYOffset = f3 = this.mYOffset + f2;
    }

    public final void recycle() {
        if (this.mRecycled) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.toString();
            String string3 = stringBuilder.append(string2).append(" recycled twice!").toString();
            throw new RuntimeException(string3);
        }
        this.mRecycled = true;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                MotionEvent motionEvent;
                ++gRecyclerUsed;
                this.mNumSamples = 0;
                this.mNext = motionEvent = gRecyclerTop;
                gRecyclerTop = this;
            }
            return;
        }
    }

    public final void scale(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        this.mXOffset = f5 = this.mXOffset * f;
        this.mYOffset = f4 = this.mYOffset * f;
        this.mXPrecision = f3 = this.mXPrecision * f;
        this.mYPrecision = f2 = this.mYPrecision * f;
        float[] fArray = this.mDataSamples;
        int n = this.mNumPointers;
        int n2 = this.mNumSamples;
        int n3 = n * n2 * 9;
        int n4 = 0;
        while (n4 < n3) {
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            float f12;
            int n5 = n4 + 0;
            fArray[n5] = f12 = fArray[n5] * f;
            int n6 = n4 + 1;
            fArray[n6] = f11 = fArray[n6] * f;
            int n7 = n4 + 3;
            fArray[n7] = f10 = fArray[n7] * f;
            int n8 = n4 + 4;
            fArray[n8] = f9 = fArray[n8] * f;
            int n9 = n4 + 5;
            fArray[n9] = f8 = fArray[n9] * f;
            int n10 = n4 + 6;
            fArray[n10] = f7 = fArray[n10] * f;
            int n11 = n4 + 7;
            fArray[n11] = f6 = fArray[n11] * f;
            n4 += 9;
        }
        return;
    }

    public final void setAction(int n) {
        this.mAction = n;
    }

    public final void setEdgeFlags(int n) {
        this.mEdgeFlags = n;
    }

    public final void setLocation(float f, float f2) {
        float f3;
        float f4;
        float[] fArray = this.mDataSamples;
        int n = this.mLastDataSampleIndex;
        int n2 = n + 0;
        float f5 = fArray[n2];
        this.mXOffset = f4 = f - f5;
        int n3 = n + 1;
        float f6 = fArray[n3];
        this.mYOffset = f3 = f2 - f6;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("MotionEvent{");
        String string2 = Integer.toHexString(System.identityHashCode(this));
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" action=");
        int n = this.mAction;
        StringBuilder stringBuilder3 = stringBuilder2.append(n).append(" x=");
        float f = this.getX();
        StringBuilder stringBuilder4 = stringBuilder3.append(f).append(" y=");
        float f2 = this.getY();
        StringBuilder stringBuilder5 = stringBuilder4.append(f2).append(" pressure=");
        float f3 = this.getPressure();
        StringBuilder stringBuilder6 = stringBuilder5.append(f3).append(" size=");
        float f4 = this.getSize();
        return stringBuilder6.append(f4).append("}").toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(1);
        int n2 = this.mNumPointers;
        int n3 = this.mNumSamples;
        int n4 = n2 * n3 * 9;
        parcel.writeInt(n2);
        parcel.writeInt(n3);
        this.writeBaseToParcel(parcel);
        long l = this.mDownTimeNano;
        parcel.writeLong(l);
        int n5 = this.mAction;
        parcel.writeInt(n5);
        float f = this.mXOffset;
        parcel.writeFloat(f);
        float f2 = this.mYOffset;
        parcel.writeFloat(f2);
        float f3 = this.mXPrecision;
        parcel.writeFloat(f3);
        float f4 = this.mYPrecision;
        parcel.writeFloat(f4);
        int n6 = this.mEdgeFlags;
        parcel.writeInt(n6);
        int n7 = this.mMetaState;
        parcel.writeInt(n7);
        int n8 = this.mFlags;
        parcel.writeInt(n8);
        int[] nArray = this.mPointerIdentifiers;
        for (int i = 0; i < n2; ++i) {
            int n9 = nArray[i];
            parcel.writeInt(n9);
        }
        long[] lArray = this.mEventTimeNanoSamples;
        for (int i = 0; i < n3; ++i) {
            long l2 = lArray[i];
            parcel.writeLong(l2);
        }
        float[] fArray = this.mDataSamples;
        int n10 = 0;
        while (n10 < n4) {
            float f5 = fArray[n10];
            parcel.writeFloat(f5);
            ++n10;
        }
        return;
    }

    public static final class PointerCoords {
        public float orientation;
        public float pressure;
        public float size;
        public float toolMajor;
        public float toolMinor;
        public float touchMajor;
        public float touchMinor;
        public float x;
        public float y;
    }
}

