/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.OrientationListener;

public abstract class OrientationEventListener {
    private static final boolean DEBUG = false;
    public static final int ORIENTATION_UNKNOWN = 255;
    private static final String TAG = "OrientationEventListener";
    private static final boolean localLOGV;
    private boolean mEnabled = false;
    private OrientationListener mOldListener;
    private int mOrientation = -1;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListener mSensorEventListener;
    private SensorManager mSensorManager;

    public OrientationEventListener(Context context) {
        this(context, 3);
    }

    public OrientationEventListener(Context context, int n) {
        Sensor sensor;
        SensorManager sensorManager;
        this.mSensorManager = sensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = n;
        this.mSensor = sensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor == null) {
            return;
        }
        SensorEventListenerImpl sensorEventListenerImpl = new SensorEventListenerImpl();
        this.mSensorEventListener = sensorEventListenerImpl;
    }

    static /* synthetic */ int access$102(OrientationEventListener orientationEventListener, int n) {
        orientationEventListener.mOrientation = n;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDetectOrientation() {
        if (this.mSensor == null) return false;
        return true;
    }

    public void disable() {
        if (this.mSensor == null) {
            int n = Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (!this.mEnabled) {
            return;
        }
        SensorManager sensorManager = this.mSensorManager;
        SensorEventListener sensorEventListener = this.mSensorEventListener;
        sensorManager.unregisterListener(sensorEventListener);
        this.mEnabled = false;
    }

    public void enable() {
        if (this.mSensor == null) {
            int n = Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (this.mEnabled) {
            return;
        }
        SensorManager sensorManager = this.mSensorManager;
        SensorEventListener sensorEventListener = this.mSensorEventListener;
        Sensor sensor = this.mSensor;
        int n = this.mRate;
        boolean bl = sensorManager.registerListener(sensorEventListener, sensor, n);
        this.mEnabled = true;
    }

    public abstract void onOrientationChanged(int var1);

    void registerListener(OrientationListener orientationListener) {
        this.mOldListener = orientationListener;
    }

    class SensorEventListenerImpl
    implements SensorEventListener {
        private static final int _DATA_X = 0;
        private static final int _DATA_Y = 1;
        private static final int _DATA_Z = 2;

        SensorEventListenerImpl() {
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            int n;
            float[] fArray = sensorEvent.values;
            int n2 = -1;
            float f = -fArray[0];
            float f2 = f * f;
            float f3 = -fArray[1];
            float f4 = f3 * f3;
            float f5 = f2 + f4;
            float f6 = 4.0f * f5;
            float f7 = -fArray[2];
            float f8 = f7 * f7;
            if (f6 >= f8) {
                double d = -f3;
                double d2 = f;
                int n3 = Math.round((float)Math.atan2(d, d2) * 57.29578f);
                n2 = 90 - n3;
                while (n2 >= 360) {
                    int n4 = n2 + -360;
                }
                while (n2 < 0) {
                    n2 += 360;
                }
            }
            if (OrientationEventListener.this.mOldListener != null) {
                OrientationListener orientationListener = OrientationEventListener.this.mOldListener;
                float[] fArray2 = sensorEvent.values;
                orientationListener.onSensorChanged(1, fArray2);
            }
            if (n2 != (n = OrientationEventListener.this.mOrientation)) {
                return;
            }
            int n5 = OrientationEventListener.access$102(OrientationEventListener.this, n2);
            OrientationEventListener.this.onOrientationChanged(n2);
        }
    }
}

