/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.FloatMath;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private float mBottomSlopEdge;
    private final Context mContext;
    private MotionEvent mCurrEvent;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mCurrPressure;
    private final float mEdgeSlop;
    private float mFocusX;
    private float mFocusY;
    private boolean mGestureInProgress;
    private final OnScaleGestureListener mListener;
    private MotionEvent mPrevEvent;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mPrevLen;
    private float mPrevPressure;
    private float mRightSlopEdge;
    private float mScaleFactor;
    private boolean mSloppyGesture;
    private long mTimeDelta;

    public ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener) {
        float f;
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.mContext = context;
        this.mListener = onScaleGestureListener;
        this.mEdgeSlop = f = (float)viewConfiguration.getScaledEdgeSlop();
    }

    private static float getRawX(MotionEvent motionEvent, int n) {
        float f = motionEvent.getRawX();
        float f2 = motionEvent.getX();
        float f3 = f - f2;
        return motionEvent.getX(n) + f3;
    }

    private static float getRawY(MotionEvent motionEvent, int n) {
        float f = motionEvent.getRawY();
        float f2 = motionEvent.getY();
        float f3 = f - f2;
        return motionEvent.getY(n) + f3;
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
    }

    private void setContext(MotionEvent motionEvent) {
        float f;
        float f2;
        long l;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        MotionEvent motionEvent2;
        float f9;
        float f10;
        float f11;
        MotionEvent motionEvent3;
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = motionEvent3 = MotionEvent.obtain(motionEvent);
        this.mCurrLen = f11 = -1.0f;
        this.mPrevLen = f10 = -1.0f;
        this.mScaleFactor = f9 = -1.0f;
        MotionEvent motionEvent4 = motionEvent2 = this.mPrevEvent;
        int n = 0;
        float f12 = motionEvent4.getX(n);
        MotionEvent motionEvent5 = motionEvent2;
        int n2 = 0;
        float f13 = motionEvent5.getY(n2);
        MotionEvent motionEvent6 = motionEvent2;
        int n3 = 1;
        float f14 = motionEvent6.getX(n3);
        MotionEvent motionEvent7 = motionEvent2;
        int n4 = 1;
        float f15 = motionEvent7.getY(n4);
        MotionEvent motionEvent8 = motionEvent;
        int n5 = 0;
        float f16 = motionEvent8.getX(n5);
        MotionEvent motionEvent9 = motionEvent;
        int n6 = 0;
        float f17 = motionEvent9.getY(n6);
        MotionEvent motionEvent10 = motionEvent;
        int n7 = 1;
        float f18 = motionEvent10.getX(n7);
        MotionEvent motionEvent11 = motionEvent;
        int n8 = 1;
        float f19 = motionEvent11.getY(n8);
        float f20 = f14 - f12;
        float f21 = f15 - f13;
        float f22 = f18 - f16;
        float f23 = f19 - f17;
        this.mPrevFingerDiffX = f8 = f20;
        this.mPrevFingerDiffY = f7 = f21;
        this.mCurrFingerDiffX = f6 = f22;
        this.mCurrFingerDiffY = f5 = f23;
        this.mFocusX = f4 = 0.5f * f22 + f16;
        this.mFocusY = f3 = 0.5f * f23 + f17;
        long l2 = motionEvent.getEventTime();
        long l3 = motionEvent2.getEventTime();
        this.mTimeDelta = l = l2 - l3;
        MotionEvent motionEvent12 = motionEvent;
        int n9 = 0;
        float f24 = motionEvent12.getPressure(n9);
        MotionEvent motionEvent13 = motionEvent;
        int n10 = 1;
        float f25 = motionEvent13.getPressure(n10);
        this.mCurrPressure = f2 = f24 + f25;
        MotionEvent motionEvent14 = motionEvent2;
        int n11 = 0;
        float f26 = motionEvent14.getPressure(n11);
        MotionEvent motionEvent15 = motionEvent2;
        int n12 = 1;
        float f27 = motionEvent15.getPressure(n12);
        this.mPrevPressure = f = f26 + f27;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float f;
            float f2 = this.mCurrFingerDiffX;
            float f3 = this.mCurrFingerDiffY;
            float f4 = f2 * f2;
            float f5 = f3 * f3;
            this.mCurrLen = f = FloatMath.sqrt(f4 + f5);
        }
        return this.mCurrLen;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float f;
            float f2 = this.mPrevFingerDiffX;
            float f3 = this.mPrevFingerDiffY;
            float f4 = f2 * f2;
            float f5 = f3 * f3;
            this.mPrevLen = f = FloatMath.sqrt(f4 + f5);
        }
        return this.mPrevLen;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            float f;
            float f2 = this.getCurrentSpan();
            float f3 = this.getPreviousSpan();
            this.mScaleFactor = f = f2 / f3;
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (!this.mGestureInProgress) {
            switch (n & 0xFF) {
                case 5: {
                    boolean bl;
                    long l;
                    MotionEvent motionEvent2;
                    float f;
                    float f2;
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    float f3 = displayMetrics.widthPixels;
                    float f4 = this.mEdgeSlop;
                    this.mRightSlopEdge = f2 = f3 - f4;
                    float f5 = displayMetrics.heightPixels;
                    float f6 = this.mEdgeSlop;
                    this.mBottomSlopEdge = f = f5 - f6;
                    this.reset();
                    this.mPrevEvent = motionEvent2 = MotionEvent.obtain(motionEvent);
                    this.mTimeDelta = l = 0L;
                    this.setContext(motionEvent);
                    float f7 = this.mEdgeSlop;
                    float f8 = this.mRightSlopEdge;
                    float f9 = this.mBottomSlopEdge;
                    float f10 = motionEvent.getRawX();
                    float f11 = motionEvent.getRawY();
                    MotionEvent motionEvent3 = motionEvent;
                    int n2 = 1;
                    float f12 = ScaleGestureDetector.getRawX(motionEvent3, n2);
                    MotionEvent motionEvent4 = motionEvent;
                    int n3 = 1;
                    float f13 = ScaleGestureDetector.getRawY(motionEvent4, n3);
                    int n4 = f10 < f7 || f11 < f7 || f10 > f8 || f11 > f9 ? 1 : 0;
                    boolean bl2 = f12 < f7 || n4 < f7 || f12 > f8 || n4 > f9;
                    if (n4 != 0 && bl2) {
                        boolean bl3;
                        float f14;
                        float f15;
                        this.mFocusX = f15 = -1.0f;
                        this.mFocusY = f14 = -1.0f;
                        this.mSloppyGesture = bl3 = true;
                        return true;
                    }
                    if (n4 != 0) {
                        boolean bl4;
                        float f16;
                        float f17;
                        MotionEvent motionEvent5 = motionEvent;
                        int n5 = 1;
                        this.mFocusX = f17 = motionEvent5.getX(n5);
                        MotionEvent motionEvent6 = motionEvent;
                        int n6 = 1;
                        this.mFocusY = f16 = motionEvent6.getY(n6);
                        this.mSloppyGesture = bl4 = true;
                        return true;
                    }
                    if (bl2) {
                        boolean bl5;
                        float f18;
                        float f19;
                        MotionEvent motionEvent7 = motionEvent;
                        int n7 = 0;
                        this.mFocusX = f19 = motionEvent7.getX(n7);
                        MotionEvent motionEvent8 = motionEvent;
                        int n8 = 0;
                        this.mFocusY = f18 = motionEvent8.getY(n8);
                        this.mSloppyGesture = bl5 = true;
                        return true;
                    }
                    OnScaleGestureListener onScaleGestureListener = this.mListener;
                    ScaleGestureDetector scaleGestureDetector = this;
                    this.mGestureInProgress = bl = onScaleGestureListener.onScaleBegin(scaleGestureDetector);
                    return true;
                }
                case 2: {
                    boolean bl;
                    boolean bl6;
                    if (!this.mSloppyGesture) return true;
                    float f = this.mEdgeSlop;
                    float f20 = this.mRightSlopEdge;
                    float f21 = this.mBottomSlopEdge;
                    float f22 = motionEvent.getRawX();
                    float f23 = motionEvent.getRawY();
                    MotionEvent motionEvent9 = motionEvent;
                    int n9 = 1;
                    float f24 = ScaleGestureDetector.getRawX(motionEvent9, n9);
                    MotionEvent motionEvent10 = motionEvent;
                    int n10 = 1;
                    float f25 = ScaleGestureDetector.getRawY(motionEvent10, n10);
                    int n11 = f22 < f || f23 < f || f22 > f20 || f23 > f21 ? 1 : 0;
                    boolean bl7 = f24 < f || n11 < f || f24 > f20 || n11 > f21;
                    if (n11 != 0 && bl7) {
                        float f26;
                        float f27;
                        this.mFocusX = f27 = -1.0f;
                        this.mFocusY = f26 = -1.0f;
                        return true;
                    }
                    if (n11 != 0) {
                        float f28;
                        float f29;
                        MotionEvent motionEvent11 = motionEvent;
                        int n12 = 1;
                        this.mFocusX = f29 = motionEvent11.getX(n12);
                        MotionEvent motionEvent12 = motionEvent;
                        int n13 = 1;
                        this.mFocusY = f28 = motionEvent12.getY(n13);
                        return true;
                    }
                    if (bl7) {
                        float f30;
                        float f31;
                        MotionEvent motionEvent13 = motionEvent;
                        int n14 = 0;
                        this.mFocusX = f31 = motionEvent13.getX(n14);
                        MotionEvent motionEvent14 = motionEvent;
                        int n15 = 0;
                        this.mFocusY = f30 = motionEvent14.getY(n15);
                        return true;
                    }
                    this.mSloppyGesture = bl6 = false;
                    OnScaleGestureListener onScaleGestureListener = this.mListener;
                    ScaleGestureDetector scaleGestureDetector = this;
                    this.mGestureInProgress = bl = onScaleGestureListener.onScaleBegin(scaleGestureDetector);
                    return true;
                }
                case 6: {
                    float f;
                    float f32;
                    if (!this.mSloppyGesture) return true;
                    int n16 = (0xFF00 & n) >> 8 == 0 ? 1 : 0;
                    MotionEvent motionEvent15 = motionEvent;
                    int n17 = n16;
                    this.mFocusX = f32 = motionEvent15.getX(n17);
                    MotionEvent motionEvent16 = motionEvent;
                    int n18 = n16;
                    this.mFocusY = f = motionEvent16.getY(n18);
                    return true;
                }
            }
            return true;
        }
        switch (n & 0xFF) {
            default: {
                return true;
            }
            case 2: {
                MotionEvent motionEvent17;
                this.setContext(motionEvent);
                float f = this.mCurrPressure;
                float f33 = this.mPrevPressure;
                if (!(f / f33 > 0.67f)) return true;
                OnScaleGestureListener onScaleGestureListener = this.mListener;
                ScaleGestureDetector scaleGestureDetector = this;
                if (!onScaleGestureListener.onScale(scaleGestureDetector)) return true;
                this.mPrevEvent.recycle();
                this.mPrevEvent = motionEvent17 = MotionEvent.obtain(motionEvent);
                return true;
            }
            case 6: {
                float f;
                float f34;
                this.setContext(motionEvent);
                int n19 = (0xFF00 & n) >> 8 == 0 ? 1 : 0;
                MotionEvent motionEvent18 = motionEvent;
                int n20 = n19;
                this.mFocusX = f34 = motionEvent18.getX(n20);
                MotionEvent motionEvent19 = motionEvent;
                int n21 = n19;
                this.mFocusY = f = motionEvent19.getY(n21);
                if (!this.mSloppyGesture) {
                    OnScaleGestureListener onScaleGestureListener = this.mListener;
                    ScaleGestureDetector scaleGestureDetector = this;
                    onScaleGestureListener.onScaleEnd(scaleGestureDetector);
                }
                this.reset();
                return true;
            }
            case 3: 
        }
        if (!this.mSloppyGesture) {
            OnScaleGestureListener onScaleGestureListener = this.mListener;
            ScaleGestureDetector scaleGestureDetector = this;
            onScaleGestureListener.onScaleEnd(scaleGestureDetector);
        }
        this.reset();
        return true;
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        @Override
        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            return false;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            return true;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

