/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.SurfaceSession;

public class Surface
implements Parcelable {
    public static final Parcelable.Creator<Surface> CREATOR;
    private static final boolean DEBUG_RELEASE = false;
    public static final int FLAGS_ORIENTATION_ANIMATION_DISABLE = 1;
    public static final int FX_SURFACE_BLUR = 65536;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_MASK = 983040;
    public static final int FX_SURFACE_NORMAL = 0;
    @Deprecated
    public static final int GPU = 40;
    @Deprecated
    public static final int HARDWARE = 16;
    public static final int HIDDEN = 4;
    private static final String LOG_TAG = "Surface";
    public static final int NON_PREMULTIPLIED = 256;
    public static final int PUSH_BUFFERS = 512;
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int ROTATION_90 = 1;
    public static final int SECURE = 128;
    @Deprecated
    public static final int SURACE_FROZEN = 2;
    public static final int SURFACE_BLUR_FREEZE = 16;
    public static final int SURFACE_DITHER = 4;
    public static final int SURFACE_FROZEN = 2;
    public static final int SURFACE_HIDDEN = 1;
    private Canvas mCanvas;
    private DisplayMetrics mCompatibleDisplayMetrics;
    private Matrix mCompatibleMatrix;
    private Exception mCreationStack;
    private String mName;
    private int mNativeSurface;
    private int mSaveCount;
    private int mSurfaceControl;

    static {
        Surface.nativeClassInit();
        CREATOR = new Parcelable.Creator<Surface>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Surface createFromParcel(Parcel parcel) {
                try {
                    return new Surface(parcel);
                }
                catch (Exception exception) {
                    int n = Log.e(Surface.LOG_TAG, "Exception creating surface from parcel", exception);
                    return null;
                }
            }

            public Surface[] newArray(int n) {
                return new Surface[n];
            }
        };
    }

    public Surface() {
        CompatibleCanvas compatibleCanvas = new CompatibleCanvas();
        this.mCanvas = compatibleCanvas;
    }

    private Surface(Parcel parcel) throws OutOfResourcesException {
        this.init(parcel);
    }

    public Surface(SurfaceSession surfaceSession, int n, int n2, int n3, int n4, int n5, int n6) throws OutOfResourcesException {
        CompatibleCanvas compatibleCanvas = new CompatibleCanvas();
        this.mCanvas = compatibleCanvas;
        Surface surface = this;
        SurfaceSession surfaceSession2 = surfaceSession;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        surface.init(surfaceSession2, n7, null, n8, n9, n10, n11, n12);
    }

    public Surface(SurfaceSession surfaceSession, int n, String string2, int n2, int n3, int n4, int n5, int n6) throws OutOfResourcesException {
        CompatibleCanvas compatibleCanvas = new CompatibleCanvas();
        this.mCanvas = compatibleCanvas;
        this.init(surfaceSession, n, string2, n2, n3, n4, n5, n6);
        this.mName = string2;
    }

    public static native void closeTransaction();

    public static native void freezeDisplay(int var0);

    private native int getIdentity();

    private native void init(Parcel var1);

    private native void init(SurfaceSession var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8) throws OutOfResourcesException;

    private native Canvas lockCanvasNative(Rect var1);

    private static native void nativeClassInit();

    public static native void openTransaction();

    public static void setOrientation(int n, int n2) {
        Surface.setOrientation(n, n2, 0);
    }

    public static native void setOrientation(int var0, int var1, int var2);

    public static native void unfreezeDisplay(int var0);

    public native void copyFrom(Surface var1);

    @Override
    public int describeContents() {
        return 0;
    }

    public native void destroy();

    protected void finalize() throws Throwable {
        if (this.mNativeSurface != 0 || this.mSurfaceControl != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Surface.finalize() has work. You should have called release() (");
            int n = this.mNativeSurface;
            StringBuilder stringBuilder2 = stringBuilder.append(n).append(", ");
            int n2 = this.mSurfaceControl;
            String string2 = stringBuilder2.append(n2).append(")").toString();
            int n3 = Log.w(LOG_TAG, string2);
        }
        this.release();
    }

    public native void freeze();

    public native void hide();

    public native boolean isValid();

    public Canvas lockCanvas(Rect rect) throws OutOfResourcesException, IllegalArgumentException {
        return this.lockCanvasNative(rect);
    }

    public native void readFromParcel(Parcel var1);

    public native void release();

    public native void setAlpha(float var1);

    void setCompatibleDisplayMetrics(DisplayMetrics displayMetrics, CompatibilityInfo.Translator translator) {
        Matrix matrix;
        this.mCompatibleDisplayMetrics = displayMetrics;
        if (translator == null) {
            return;
        }
        float f = translator.applicationScale;
        this.mCompatibleMatrix = matrix = new Matrix();
        this.mCompatibleMatrix.setScale(f, f);
    }

    public native void setFlags(int var1, int var2);

    public native void setFreezeTint(int var1);

    public native void setLayer(int var1);

    public native void setMatrix(float var1, float var2, float var3, float var4);

    public native void setPosition(int var1, int var2);

    public native void setSize(int var1, int var2);

    public native void setTransparentRegionHint(Region var1);

    public native void show();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Surface(name=");
        String string2 = this.mName;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", identity=");
        int n = this.getIdentity();
        return stringBuilder2.append(n).append(")").toString();
    }

    public native void unfreeze();

    public native void unlockCanvas(Canvas var1);

    public native void unlockCanvasAndPost(Canvas var1);

    @Override
    public native void writeToParcel(Parcel var1, int var2);

    private class CompatibleCanvas
    extends Canvas {
        private Matrix mOrigMatrix = null;

        private CompatibleCanvas() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getHeight() {
            if (Surface.this.mCompatibleDisplayMetrics != null) return ((Surface)Surface.this).mCompatibleDisplayMetrics.heightPixels;
            return super.getHeight();
        }

        @Override
        public void getMatrix(Matrix matrix) {
            super.getMatrix(matrix);
            if (this.mOrigMatrix == null) {
                Matrix matrix2;
                this.mOrigMatrix = matrix2 = new Matrix();
            }
            this.mOrigMatrix.set(matrix);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getWidth() {
            if (Surface.this.mCompatibleDisplayMetrics != null) return ((Surface)Surface.this).mCompatibleDisplayMetrics.widthPixels;
            return super.getWidth();
        }

        @Override
        public void setMatrix(Matrix matrix) {
            if (Surface.this.mCompatibleMatrix == null || this.mOrigMatrix == null || this.mOrigMatrix.equals(matrix)) {
                super.setMatrix(matrix);
                return;
            }
            Matrix matrix2 = Surface.this.mCompatibleMatrix;
            Matrix matrix3 = new Matrix(matrix2);
            boolean bl = matrix3.preConcat(matrix);
            super.setMatrix(matrix3);
        }
    }

    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String string2) {
            super(string2);
        }
    }
}

