/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.IWindowSession;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewRoot;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.android.internal.view.BaseIWindow;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class SurfaceView
extends View {
    private static final boolean DEBUG = false;
    static final int GET_NEW_SURFACE_MSG = 2;
    static final int KEEP_SCREEN_ON_MSG = 1;
    private static final String TAG = "SurfaceView";
    static final int UPDATE_WINDOW_MSG = 3;
    private static final boolean localLOGV;
    final ArrayList<SurfaceHolder.Callback> mCallbacks;
    final Configuration mConfiguration;
    final Rect mContentInsets;
    boolean mDestroyReportNeeded;
    boolean mDrawingStopped;
    int mFormat;
    final Handler mHandler;
    boolean mHaveFrame;
    int mHeight;
    boolean mIsCreating;
    long mLastLockTime;
    int mLastSurfaceHeight;
    int mLastSurfaceWidth;
    final WindowManager.LayoutParams mLayout;
    int mLeft;
    final int[] mLocation;
    boolean mNewSurfaceNeeded;
    boolean mReportDrawNeeded;
    int mRequestedFormat;
    int mRequestedHeight;
    int mRequestedType;
    boolean mRequestedVisible;
    int mRequestedWidth;
    final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener;
    IWindowSession mSession;
    final Surface mSurface;
    final Rect mSurfaceFrame;
    private SurfaceHolder mSurfaceHolder;
    final ReentrantLock mSurfaceLock;
    int mTop;
    private CompatibilityInfo.Translator mTranslator;
    int mType;
    boolean mUpdateWindowNeeded;
    boolean mViewVisibility;
    boolean mVisible;
    final Rect mVisibleInsets;
    int mWidth;
    final Rect mWinFrame;
    MyWindow mWindow;
    int mWindowType;
    boolean mWindowVisibility;

    public SurfaceView(Context context) {
        super(context);
        SurfaceHolder surfaceHolder;
        Rect rect;
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
        Handler handler;
        Configuration configuration;
        Rect rect2;
        Rect rect3;
        Rect rect4;
        WindowManager.LayoutParams layoutParams;
        Surface surface;
        ReentrantLock reentrantLock;
        ArrayList arrayList = new ArrayList();
        this.mCallbacks = arrayList;
        int[] nArray = new int[2];
        this.mLocation = nArray;
        this.mSurfaceLock = reentrantLock = new ReentrantLock();
        this.mSurface = surface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = layoutParams = new WindowManager.LayoutParams();
        this.mVisibleInsets = rect4 = new Rect();
        this.mWinFrame = rect3 = new Rect();
        this.mContentInsets = rect2 = new Rect();
        this.mConfiguration = configuration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        SurfaceView surfaceView = SurfaceView.this;
                        boolean bl = message.arg1 != 0;
                        surfaceView.setKeepScreenOn(bl);
                        return;
                    }
                    case 2: {
                        SurfaceView.this.handleGetNewSurface();
                        return;
                    }
                    case 3: 
                }
                SurfaceView.this.updateWindow(false, false);
            }
        };
        this.mScrollChangedListener = onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            @Override
            public void onScrollChanged() {
                SurfaceView.this.updateWindow(false, false);
            }
        };
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mRequestedType = -1;
        this.mHaveFrame = false;
        this.mDestroyReportNeeded = false;
        this.mNewSurfaceNeeded = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mLeft = -1;
        this.mTop = -1;
        this.mWidth = -1;
        this.mHeight = -1;
        this.mFormat = -1;
        this.mType = -1;
        this.mSurfaceFrame = rect = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mSurfaceHolder = surfaceHolder = new SurfaceHolder(){
            private static final String LOG_TAG = "SurfaceHolder";

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final Canvas internalLockCanvas(Rect rect) {
                if (SurfaceView.this.mType == 3) {
                    throw new SurfaceHolder.BadSurfaceTypeException("Surface type is SURFACE_TYPE_PUSH_BUFFERS");
                }
                SurfaceView.this.mSurfaceLock.lock();
                Canvas canvas = null;
                if (!SurfaceView.this.mDrawingStopped && SurfaceView.this.mWindow != null) {
                    Rect rect2 = rect != null ? rect : SurfaceView.this.mSurfaceFrame;
                    try {
                        Canvas canvas2;
                        canvas = canvas2 = SurfaceView.this.mSurface.lockCanvas(rect2);
                    }
                    catch (Exception exception) {
                        int n = Log.e(LOG_TAG, "Exception locking surface", exception);
                    }
                }
                if (canvas != null) {
                    long l;
                    SurfaceView surfaceView = SurfaceView.this;
                    surfaceView.mLastLockTime = l = SystemClock.uptimeMillis();
                    return canvas;
                }
                long l = SurfaceView.this.mLastLockTime + 100L;
                long l2 = SystemClock.uptimeMillis();
                if (l > l2) {
                    long l3 = l - l2;
                    try {
                        Thread.sleep(l3);
                    }
                    catch (InterruptedException interruptedException) {}
                    l2 = SystemClock.uptimeMillis();
                }
                SurfaceView.this.mLastLockTime = l2;
                SurfaceView.this.mSurfaceLock.unlock();
                return null;
            }

            @Override
            public void addCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = SurfaceView.this.mCallbacks;
                synchronized (arrayList) {
                    if (!SurfaceView.this.mCallbacks.contains(callback)) {
                        boolean bl = SurfaceView.this.mCallbacks.add(callback);
                    }
                    return;
                }
            }

            @Override
            public Surface getSurface() {
                return SurfaceView.this.mSurface;
            }

            @Override
            public Rect getSurfaceFrame() {
                return SurfaceView.this.mSurfaceFrame;
            }

            @Override
            public boolean isCreating() {
                return SurfaceView.this.mIsCreating;
            }

            @Override
            public Canvas lockCanvas() {
                return this.internalLockCanvas(null);
            }

            @Override
            public Canvas lockCanvas(Rect rect) {
                return this.internalLockCanvas(rect);
            }

            @Override
            public void removeCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = SurfaceView.this.mCallbacks;
                synchronized (arrayList) {
                    boolean bl = SurfaceView.this.mCallbacks.remove(callback);
                    return;
                }
            }

            @Override
            public void setFixedSize(int n, int n2) {
                if (SurfaceView.this.mRequestedWidth != n && SurfaceView.this.mRequestedHeight != n2) {
                    return;
                }
                SurfaceView.this.mRequestedWidth = n;
                SurfaceView.this.mRequestedHeight = n2;
                SurfaceView.this.requestLayout();
            }

            @Override
            public void setFormat(int n) {
                if (n == -1) {
                    n = 4;
                }
                SurfaceView.this.mRequestedFormat = n;
                if (SurfaceView.this.mWindow == null) {
                    return;
                }
                SurfaceView.this.updateWindow(false, false);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void setKeepScreenOn(boolean bl) {
                Message message = SurfaceView.this.mHandler.obtainMessage(1);
                int n = bl ? 1 : 0;
                message.arg1 = n;
                boolean bl2 = SurfaceView.this.mHandler.sendMessage(message);
            }

            @Override
            public void setSizeFromLayout() {
                if (SurfaceView.this.mRequestedWidth == -1 && SurfaceView.this.mRequestedHeight == -1) {
                    return;
                }
                SurfaceView surfaceView = SurfaceView.this;
                SurfaceView.this.mRequestedHeight = -1;
                surfaceView.mRequestedWidth = -1;
                SurfaceView.this.requestLayout();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void setType(int n) {
                switch (n) {
                    case 1: 
                    case 2: {
                        n = 0;
                        break;
                    }
                }
                switch (n) {
                    default: {
                        return;
                    }
                    case 0: 
                    case 3: 
                }
                SurfaceView.this.mRequestedType = n;
                if (SurfaceView.this.mWindow == null) {
                    return;
                }
                SurfaceView.this.updateWindow(false, false);
            }

            @Override
            public void unlockCanvasAndPost(Canvas canvas) {
                SurfaceView.this.mSurface.unlockCanvasAndPost(canvas);
                SurfaceView.this.mSurfaceLock.unlock();
            }
        };
        this.init();
    }

    public SurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        SurfaceHolder surfaceHolder;
        Rect rect;
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
        Handler handler;
        Configuration configuration;
        Rect rect2;
        Rect rect3;
        Rect rect4;
        WindowManager.LayoutParams layoutParams;
        Surface surface;
        ReentrantLock reentrantLock;
        ArrayList arrayList = new ArrayList();
        this.mCallbacks = arrayList;
        int[] nArray = new int[2];
        this.mLocation = nArray;
        this.mSurfaceLock = reentrantLock = new ReentrantLock();
        this.mSurface = surface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = layoutParams = new WindowManager.LayoutParams();
        this.mVisibleInsets = rect4 = new Rect();
        this.mWinFrame = rect3 = new Rect();
        this.mContentInsets = rect2 = new Rect();
        this.mConfiguration = configuration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mHandler = handler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = onScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mRequestedType = -1;
        this.mHaveFrame = false;
        this.mDestroyReportNeeded = false;
        this.mNewSurfaceNeeded = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mLeft = -1;
        this.mTop = -1;
        this.mWidth = -1;
        this.mHeight = -1;
        this.mFormat = -1;
        this.mType = -1;
        this.mSurfaceFrame = rect = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mSurfaceHolder = surfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        SurfaceHolder surfaceHolder;
        Rect rect;
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
        Handler handler;
        Configuration configuration;
        Rect rect2;
        Rect rect3;
        Rect rect4;
        WindowManager.LayoutParams layoutParams;
        Surface surface;
        ReentrantLock reentrantLock;
        ArrayList arrayList = new ArrayList();
        this.mCallbacks = arrayList;
        int[] nArray = new int[2];
        this.mLocation = nArray;
        this.mSurfaceLock = reentrantLock = new ReentrantLock();
        this.mSurface = surface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = layoutParams = new WindowManager.LayoutParams();
        this.mVisibleInsets = rect4 = new Rect();
        this.mWinFrame = rect3 = new Rect();
        this.mContentInsets = rect2 = new Rect();
        this.mConfiguration = configuration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mHandler = handler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = onScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mRequestedType = -1;
        this.mHaveFrame = false;
        this.mDestroyReportNeeded = false;
        this.mNewSurfaceNeeded = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mLeft = -1;
        this.mTop = -1;
        this.mWidth = -1;
        this.mHeight = -1;
        this.mFormat = -1;
        this.mType = -1;
        this.mSurfaceFrame = rect = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mSurfaceHolder = surfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    private void init() {
        this.setWillNotDraw(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reportSurfaceDestroyed() {
        if (this.mDestroyReportNeeded) {
            SurfaceHolder.Callback[] callbackArray;
            this.mDestroyReportNeeded = false;
            ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
            synchronized (arrayList) {
                callbackArray = new SurfaceHolder.Callback[this.mCallbacks.size()];
                SurfaceHolder.Callback[] callbackArray2 = this.mCallbacks.toArray(callbackArray);
            }
            for (SurfaceHolder.Callback callback : callbackArray) {
                SurfaceHolder surfaceHolder = this.mSurfaceHolder;
                callback.surfaceDestroyed(surfaceHolder);
            }
        }
        super.onDetachedFromWindow();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateWindow(boolean var1_1, boolean var2_2) {
        if (!this.mHaveFrame) {
            return;
        }
        var3_3 = (ViewRoot)this.getRootView().getParent();
        if (var3_3 != null) {
            this.mTranslator = var4_4 = var3_3.mTranslator;
        }
        var5_5 = this.getContext().getResources();
        if (this.mTranslator != null || !var5_5.getCompatibilityInfo().supportsScreen()) {
            var6_6 = this.mSurface;
            var7_7 = var5_5.getDisplayMetrics();
            var8_8 = this.mTranslator;
            var6_6.setCompatibleDisplayMetrics(var7_7, var8_8);
        }
        if ((var9_9 = this.mRequestedWidth) <= 0) {
            var9_9 = this.getWidth();
        }
        if ((var10_10 = this.mRequestedHeight) <= 0) {
            var10_10 = this.getHeight();
        }
        var11_11 = this.mLocation;
        var12_12 = this;
        var13_13 = var11_11;
        var12_12.getLocationInWindow(var13_13);
        var14_14 = this.mWindow == null;
        var15_15 = this.mFormat;
        var16_16 = this.mRequestedFormat;
        var17_17 = var15_15 != var16_16;
        var18_18 = this.mWidth;
        var19_19 = var9_9;
        var22_22 = var18_18 == var19_19 || (var20_20 = this.mHeight) != (var21_21 = var10_10);
        var23_23 = this.mVisible;
        var24_24 = this.mRequestedVisible;
        var25_25 = var23_23 == var24_24 || this.mNewSurfaceNeeded != false;
        var26_26 = this.mType;
        var27_27 = this.mRequestedType;
        var28_28 = var26_26 != var27_27;
        if (!(var1_1 || var14_14 || var17_17 || var22_22 || var25_25 || var28_28 || (var29_29 = this.mLeft) == (var30_30 = this.mLocation[0]) || (var31_31 = this.mTop) == (var32_32 = this.mLocation[1]) || this.mUpdateWindowNeeded || this.mReportDrawNeeded || var2_2)) {
            return;
        }
        this.mVisible = var34_34 = (var33_33 = this.mRequestedVisible);
        this.mLeft = var35_35 = this.mLocation[0];
        this.mTop = var36_36 = this.mLocation[1];
        this.mWidth = var37_37 = var9_9;
        this.mHeight = var38_38 = var10_10;
        this.mFormat = var39_39 = this.mRequestedFormat;
        this.mType = var40_40 = this.mRequestedType;
        var41_41 = this.mLayout;
        var41_41.x = var42_42 = this.mLeft;
        var43_43 = this.mLayout;
        var43_43.y = var44_44 = this.mTop;
        var45_45 = this.mLayout;
        var45_45.width = var46_46 = this.getWidth();
        var47_47 = this.mLayout;
        var47_47.height = var48_48 = this.getHeight();
        if (this.mTranslator != null) {
            var49_49 = this.mTranslator;
            var50_50 = this.mLayout;
            var49_49.translateLayoutParamsInAppWindowToScreen(var50_50);
        }
        var51_51 = this.mLayout;
        var51_51.format = var52_52 = this.mRequestedFormat;
        var53_53 = this.mLayout;
        var53_53.flags = var54_54 = var53_53.flags | 16920;
        if (!this.getContext().getResources().getCompatibilityInfo().supportsScreen()) {
            var55_55 = this.mLayout;
            var55_55.flags = var56_56 = var55_55.flags | 0x20000000;
        }
        var57_57 = this.mLayout;
        var57_57.memoryType = var58_58 = this.mRequestedType;
        if (this.mWindow == null) {
            var60_60 = var59_59;
            var61_61 = this;
            var60_60(var61_61);
            this.mWindow = var62_62 = var59_59;
            var63_63 = this.mLayout;
            var63_63.type = var64_64 = this.mWindowType;
            this.mLayout.gravity = 51;
            var65_65 = this.mSession;
            var66_68 = this.mWindow;
            var67_69 = this.mLayout;
            var68_70 = this.mVisible != false ? 0 : 8;
            var69_71 = this.mContentInsets;
            var70_72 = var65_65.addWithoutInputChannel(var66_68, var67_69, var68_70, var69_71);
        }
        if (var25_25 && (!var33_33 || this.mNewSurfaceNeeded)) {
            this.reportSurfaceDestroyed();
        }
        this.mNewSurfaceNeeded = var71_73 = false;
        this.mSurfaceLock.lock();
        var72_74 = null;
        var73_77 = var72_74;
        this.mUpdateWindowNeeded = var73_77;
        var74_78 = this.mReportDrawNeeded;
        this.mReportDrawNeeded = var75_79 = false;
        var72_75 = var33_33 == false;
        this.mDrawingStopped = var76_80 = var72_75;
        var72_76 = this.mSession;
        var66_68 = this.mWindow;
        var67_69 = this.mLayout;
        var68_70 = this.mWidth;
        var77_81 = this.mHeight;
        var78_82 = var33_33 != false ? 0 : 8;
        var79_83 = this.mWinFrame;
        var80_84 = this.mContentInsets;
        var81_85 = this.mVisibleInsets;
        var82_86 = this.mConfiguration;
        var83_87 = this.mSurface;
        if ((var72_76.relayout(var66_68, var67_69, var68_70, var77_81, var78_82, false, var79_83, var80_84, var81_85, var82_86, var83_87) & 2) != 0) {
            this.mReportDrawNeeded = var84_88 = true;
        }
        this.mSurfaceFrame.left = 0;
        this.mSurfaceFrame.top = 0;
        if (this.mTranslator == null) {
            var85_89 = this.mSurfaceFrame;
            var85_89.right = var86_90 = this.mWinFrame.width();
            var87_91 = this.mSurfaceFrame;
            var87_91.bottom = var88_92 = this.mWinFrame.height();
        } else {
            var115_93 = this.mTranslator.applicationInvertedScale;
            var116_94 = this.mSurfaceFrame;
            var116_94.right = var117_95 = (int)((float)this.mWinFrame.width() * var115_93 + 0.5f);
            var118_96 = this.mSurfaceFrame;
            var118_96.bottom = var119_97 = (int)((float)this.mWinFrame.height() * var115_93 + 0.5f);
        }
        var89_98 = this.mSurfaceFrame.right;
        var90_99 = this.mSurfaceFrame.bottom;
        var91_100 = this.mLastSurfaceWidth;
        var92_101 = var89_98;
        var95_104 = var91_100 == var92_101 || (var93_102 = this.mLastSurfaceHeight) != (var94_103 = var90_99);
        this.mLastSurfaceWidth = var96_105 = var89_98;
        this.mLastSurfaceHeight = var97_106 = var90_99;
        this.mSurfaceLock.unlock();
        var98_107 = var14_14 | var74_78;
        var2_2 |= var98_107;
        if (!var33_33) ** GOTO lbl199
        var99_108 = null;
        var100_109 = var99_108;
        this.mDestroyReportNeeded = var100_109;
        var99_108 = this.mCallbacks;
        ** synchronized (var99_108)
lbl-1000:
        // 1 sources

        {
            var101_110 = new SurfaceHolder.Callback[this.mCallbacks.size()];
            var102_111 = this.mCallbacks;
            var103_112 = var101_110;
            var104_113 = var102_111.toArray(var103_112);
            if (!var25_25) ** GOTO lbl158
        }
        var99_108 = null;
        var105_114 = var99_108;
        this.mIsCreating = var105_114;
        var106_115 = var101_110;
        var107_116 = var106_115.length;
        var108_117 = 0;
        while ((var109_118 = ++var108_117) < (var110_119 = var107_116)) {
            var111_120 = var106_115[var108_117];
            var112_121 = this.mSurfaceHolder;
            var113_122 = var111_120;
            var114_123 = var112_121;
            var113_122.surfaceCreated(var114_123);
        }
        ** GOTO lbl158
        catch (Throwable var65_66) {
            this.mSurfaceLock.unlock();
            throw var65_66;
lbl158:
            // 2 sources

            if (!var14_14 && !var17_17 && !var22_22 && !var25_25 && !var95_104) ** GOTO lbl185
            var106_115 = var101_110;
            try {
                var107_116 = var106_115.length;
                var108_117 = 0;
                while ((var124_128 = ++var108_117) < (var125_129 = var107_116)) {
                    var126_130 = var106_115[var108_117];
                    var127_131 = this.mSurfaceHolder;
                    var128_132 = this.mFormat;
                    var129_133 = var126_130;
                    var130_134 = var127_131;
                    var131_135 = var128_132;
                    var132_136 = var9_9;
                    var133_137 = var10_10;
                    var129_133.surfaceChanged(var130_134, var131_135, var132_136, var133_137);
                }
                ** GOTO lbl185
            }
            catch (Throwable var65_67) {
                block36: {
                    var66_68 = null;
                    var121_125 = var66_68;
                    this.mIsCreating = var121_125;
                    if (var2_2) {
                        var122_126 = this.mSession;
                        var123_127 = this.mWindow;
                        var122_126.finishDrawing(var123_127);
                    }
                    throw var65_67;
lbl185:
                    // 2 sources

                    if (var2_2) {
                        var106_115 = var101_110;
                        var107_116 = var106_115.length;
                        var108_117 = 0;
                        while ((var134_138 = ++var108_117) < (var135_139 = var107_116)) {
                            var136_140 = var106_115[var108_117];
                            if (!(var136_140 instanceof SurfaceHolder.Callback2)) continue;
                            var137_141 = (SurfaceHolder.Callback2)var136_140;
                            var138_142 = this.mSurfaceHolder;
                            var139_143 = var137_141;
                            var140_144 = var138_142;
                            var139_143.surfaceRedrawNeeded(var140_144);
                        }
                    }
                    break block36;
lbl199:
                    // 1 sources

                    this.mSurface.release();
                }
                var65_65 = null;
                try {
                    var141_145 = var65_65;
                    this.mIsCreating = var141_145;
                    if (!var2_2) {
                        return;
                    }
                }
                catch (RemoteException var120_124) {
                    return;
                }
            }
        }
        var142_146 = this.mSession;
        var143_147 = this.mWindow;
        var142_146.finishDrawing(var143_147);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mWindowType != 1000 && (this.mPrivateFlags & 0x80) == 128) {
            PorterDuff.Mode mode = PorterDuff.Mode.CLEAR;
            canvas.drawColor(0, mode);
        }
        this.mHaveFrame = true;
        this.updateWindow(false, false);
        super.dispatchDraw(canvas);
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mWindowType != 1000 && (this.mPrivateFlags & 0x80) == 0) {
            PorterDuff.Mode mode = PorterDuff.Mode.CLEAR;
            canvas.drawColor(0, mode);
        }
        super.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean gatherTransparentRegion(Region region) {
        if (this.mWindowType == 1000) {
            return super.gatherTransparentRegion(region);
        }
        boolean bl = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            bl = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n > 0 && n2 > 0) {
                int[] nArray = this.mLocation;
                this.getLocationInWindow(nArray);
                int n3 = this.mLocation[0];
                int n4 = this.mLocation[1];
                int n5 = n3 + n;
                int n6 = n4 + n2;
                Region.Op op = Region.Op.UNION;
                boolean bl2 = region.op(n3, n4, n5, n6, op);
            }
        }
        if (!PixelFormat.formatHasAlpha(this.mRequestedFormat)) return bl;
        return false;
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.updateWindow(false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void hideSurface() {
        ReentrantLock reentrantLock;
        if (this.mSession == null) {
            return;
        }
        if (this.mWindow == null) {
            return;
        }
        this.mSurfaceLock.lock();
        try {
            int n;
            DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
            WindowManager.LayoutParams layoutParams = this.mLayout;
            layoutParams.x = n = displayMetrics.widthPixels * 3;
            IWindowSession iWindowSession = this.mSession;
            MyWindow myWindow = this.mWindow;
            WindowManager.LayoutParams layoutParams2 = this.mLayout;
            int n2 = this.mWidth;
            int n3 = this.mHeight;
            Rect rect = this.mWinFrame;
            Rect rect2 = this.mContentInsets;
            Rect rect3 = this.mVisibleInsets;
            Configuration configuration = this.mConfiguration;
            Surface surface = this.mSurface;
            int n4 = iWindowSession.relayout(myWindow, layoutParams2, n2, n3, 0, false, rect, rect2, rect3, configuration, surface);
            reentrantLock = this.mSurfaceLock;
        }
        catch (Throwable throwable) {
            this.mSurfaceLock.unlock();
            throw throwable;
        }
        catch (RemoteException remoteException) {
            reentrantLock = this.mSurfaceLock;
        }
        reentrantLock.unlock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFixedSize() {
        if (this.mRequestedWidth != -1) return true;
        if (this.mRequestedHeight == -1) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onAttachedToWindow() {
        IBinder iBinder;
        IWindowSession iWindowSession;
        super.onAttachedToWindow();
        this.mParent.requestTransparentRegion(this);
        this.mSession = iWindowSession = this.getWindowSession();
        WindowManager.LayoutParams layoutParams = this.mLayout;
        layoutParams.token = iBinder = this.getWindowToken();
        this.mLayout.setTitle(TAG);
        boolean bl = this.getVisibility() == 0;
        this.mViewVisibility = bl;
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = this.mScrollChangedListener;
        viewTreeObserver.addOnScrollChangedListener(onScrollChangedListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = this.mScrollChangedListener;
        viewTreeObserver.removeOnScrollChangedListener(onScrollChangedListener);
        this.mRequestedVisible = false;
        this.updateWindow(false, false);
        this.mHaveFrame = false;
        if (this.mWindow != null) {
            try {
                IWindowSession iWindowSession = this.mSession;
                MyWindow myWindow = this.mWindow;
                iWindowSession.remove(myWindow);
            }
            catch (RemoteException remoteException) {}
            this.mWindow = null;
        }
        this.mSession = null;
        this.mLayout.token = null;
        super.onDetachedFromWindow();
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = SurfaceView.getDefaultSize(this.mRequestedWidth, n);
        int n4 = SurfaceView.getDefaultSize(this.mRequestedHeight, n2);
        this.setMeasuredDimension(n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        boolean bl = n == 0;
        this.mWindowVisibility = bl;
        boolean bl2 = this.mWindowVisibility && this.mViewVisibility;
        this.mRequestedVisible = bl2;
        this.updateWindow(false, false);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        this.updateWindow(false, false);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        boolean bl = n == 0;
        this.mViewVisibility = bl;
        boolean bl2 = this.mWindowVisibility && this.mViewVisibility;
        this.mRequestedVisible = bl2;
        this.updateWindow(false, false);
    }

    public void setWindowType(int n) {
        this.mWindowType = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setZOrderMediaOverlay(boolean bl) {
        int n = bl ? 1004 : 1001;
        this.mWindowType = n;
    }

    public void setZOrderOnTop(boolean bl) {
        int n;
        if (bl) {
            int n2;
            this.mWindowType = 1000;
            WindowManager.LayoutParams layoutParams = this.mLayout;
            layoutParams.flags = n2 = layoutParams.flags | 0x20000;
            return;
        }
        this.mWindowType = 1001;
        WindowManager.LayoutParams layoutParams = this.mLayout;
        layoutParams.flags = n = layoutParams.flags & 0xFFFDFFFF;
    }

    protected void showSurface() {
        if (this.mSession == null) {
            return;
        }
        this.updateWindow(true, false);
    }

    private static class MyWindow
    extends BaseIWindow {
        int mCurHeight = -1;
        int mCurWidth = -1;
        private final WeakReference<SurfaceView> mSurfaceView;

        public MyWindow(SurfaceView surfaceView) {
            WeakReference<SurfaceView> weakReference = new WeakReference<SurfaceView>(surfaceView);
            this.mSurfaceView = weakReference;
        }

        @Override
        public void dispatchAppVisibility(boolean bl) {
        }

        @Override
        public void dispatchGetNewSurface() {
            SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
            if (surfaceView == null) {
                return;
            }
            Message message = surfaceView.mHandler.obtainMessage(2);
            boolean bl = surfaceView.mHandler.sendMessage(message);
        }

        @Override
        public void executeCommand(String string2, String string3, ParcelFileDescriptor parcelFileDescriptor) {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void resized(int var1_1, int var2_2, Rect var3_3, Rect var4_4, boolean var5_5, Configuration var6_6) {
            var7_7 = (SurfaceView)this.mSurfaceView.get();
            if (var7_7 == null) {
                return;
            }
            var7_7.mSurfaceLock.lock();
            if (var5_5) {
                var8_8 = true;
                var7_7.mUpdateWindowNeeded = var8_8;
                var7_7.mReportDrawNeeded = true;
                var9_9 = var7_7.mHandler.sendEmptyMessage(3);
lbl11:
                // 3 sources

                return;
            }
            try {
                if (var7_7.mWinFrame.width() != var1_1 && var7_7.mWinFrame.height() == var2_2) ** GOTO lbl11
                var7_7.mUpdateWindowNeeded = true;
                var10_10 = var7_7.mHandler.sendEmptyMessage(3);
                ** continue;
            }
            catch (Throwable var11_11) {
                throw var11_11;
            }
            finally {
                var7_7.mSurfaceLock.unlock();
            }
        }

        @Override
        public void windowFocusChanged(boolean bl, boolean bl2) {
            String string2 = "Unexpected focus in surface: focus=" + bl + ", touchEnabled=" + bl2;
            int n = Log.w(SurfaceView.TAG, string2);
        }
    }
}

