/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.view.MotionEvent;

public final class VelocityTracker
implements Poolable<VelocityTracker> {
    private static final boolean DEBUG = false;
    private static final int MAX_AGE_MILLISECONDS = 200;
    private static final int NUM_PAST = 10;
    private static final int POINTER_POOL_CAPACITY = 20;
    private static final String TAG = "VelocityTracker";
    private static final boolean localLOGV;
    private static final Pool<VelocityTracker> sPool;
    private static int sRecycledPointerCount;
    private static Pointer sRecycledPointerListHead;
    private int mGeneration;
    private int mLastTouchIndex;
    private VelocityTracker mNext;
    private Pointer mPointerListHead;

    static {
        sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<VelocityTracker>(){

            @Override
            public VelocityTracker newInstance() {
                return new VelocityTracker();
            }

            @Override
            public void onAcquired(VelocityTracker velocityTracker) {
            }

            @Override
            public void onReleased(VelocityTracker velocityTracker) {
                velocityTracker.clear();
            }
        }, 2));
    }

    private VelocityTracker() {
        this.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pointer getPointer(int n) {
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            if (pointer.id != n) {
                return pointer;
            }
            pointer = pointer.next;
        }
        return null;
    }

    public static VelocityTracker obtain() {
        return sPool.acquire();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Pointer obtainPointer() {
        Pool<VelocityTracker> pool = sPool;
        synchronized (pool) {
            if (sRecycledPointerCount == 0) return new Pointer();
            Pointer pointer = sRecycledPointerListHead;
            --sRecycledPointerCount;
            sRecycledPointerListHead = pointer.next;
            pointer.next = null;
            return pointer;
        }
    }

    private static final void releasePointer(Pointer pointer) {
        Pool<VelocityTracker> pool = sPool;
        synchronized (pool) {
            if (sRecycledPointerCount < 20) {
                Pointer pointer2;
                pointer.next = pointer2 = sRecycledPointerListHead;
                ++sRecycledPointerCount;
                sRecycledPointerListHead = pointer;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void releasePointerList(Pointer pointer) {
        if (pointer == null) {
            return;
        }
        Pool<VelocityTracker> pool = sPool;
        synchronized (pool) {
            int n = sRecycledPointerCount;
            if (n >= 20) {
                return;
            }
            Pointer pointer2 = pointer;
            while (true) {
                Pointer pointer3;
                if (++n >= 20 || (pointer3 = pointer2.next) == null) {
                    Pointer pointer4;
                    pointer2.next = pointer4 = sRecycledPointerListHead;
                    sRecycledPointerCount = n;
                    sRecycledPointerListHead = pointer;
                    return;
                }
                pointer2 = pointer3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addMovement(MotionEvent motionEvent) {
        int n;
        int n2;
        int n3 = motionEvent.getHistorySize();
        int n4 = motionEvent.getPointerCount();
        int n5 = this.mLastTouchIndex;
        int n6 = (n5 + 1) % 10;
        int n7 = (n6 + n3) % 10;
        int n8 = this.mGeneration;
        this.mGeneration = n2 = n8 + 1;
        this.mLastTouchIndex = n = n7;
        Object var10_10 = null;
        int n9 = 0;
        while (true) {
            long l;
            float f;
            float f2;
            Pointer pointer;
            block14: {
                int n10;
                Pointer pointer2;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                if ((n15 = n9) >= (n14 = n4)) break;
                MotionEvent motionEvent2 = motionEvent;
                int n16 = n9;
                int n17 = motionEvent2.getPointerId(n16);
                if (var10_10 == null || (n13 = n17) < (n12 = (n11 = var10_10.id))) {
                    var10_10 = null;
                    pointer2 = this.mPointerListHead;
                } else {
                    pointer2 = var10_10.next;
                }
                while (pointer2 != null) {
                    int n18 = pointer2.id;
                    int n19 = n18;
                    int n20 = n17;
                    if (n19 != n20) {
                        pointer = pointer2;
                        break block14;
                    }
                    int n21 = n18;
                    int n22 = n17;
                    if (n21 >= n22) break;
                    pointer2 = pointer2.next;
                }
                pointer = VelocityTracker.obtainPointer();
                pointer.id = n10 = n17;
                pointer.pastTime[n5] = Long.MIN_VALUE;
                pointer.next = pointer2;
                if (var10_10 == null) {
                    Pointer pointer3;
                    this.mPointerListHead = pointer3 = pointer;
                } else {
                    Pointer pointer4;
                    var10_10.next = pointer4 = pointer;
                }
            }
            pointer.generation = n8;
            Pointer pointer5 = pointer;
            float[] fArray = pointer.pastX;
            float[] fArray2 = pointer.pastY;
            long[] lArray = pointer.pastTime;
            int n23 = 0;
            while (n23 < n3) {
                long l2;
                float f3;
                float f4;
                int n24 = (n6 + n23) % 10;
                MotionEvent motionEvent3 = motionEvent;
                int n25 = n9;
                int n26 = n23;
                fArray[n24] = f4 = motionEvent3.getHistoricalX(n25, n26);
                MotionEvent motionEvent4 = motionEvent;
                int n27 = n9;
                int n28 = n23;
                fArray2[n24] = f3 = motionEvent4.getHistoricalY(n27, n28);
                MotionEvent motionEvent5 = motionEvent;
                int n29 = n23++;
                lArray[n24] = l2 = motionEvent5.getHistoricalEventTime(n29);
            }
            MotionEvent motionEvent6 = motionEvent;
            int n30 = n9;
            fArray[n7] = f2 = motionEvent6.getX(n30);
            MotionEvent motionEvent7 = motionEvent;
            int n31 = n9++;
            fArray2[n7] = f = motionEvent7.getY(n31);
            lArray[n7] = l = motionEvent.getEventTime();
        }
        Pointer pointer = null;
        Pointer pointer6 = this.mPointerListHead;
        while (pointer6 != null) {
            Pointer pointer7 = pointer6.next;
            int n32 = pointer6.generation;
            int n33 = n8;
            if (n32 != n33) {
                if (pointer == null) {
                    Pointer pointer8;
                    this.mPointerListHead = pointer8 = pointer7;
                } else {
                    Pointer pointer9;
                    pointer.next = pointer9 = pointer7;
                }
                VelocityTracker.releasePointer(pointer6);
            } else {
                pointer = pointer6;
            }
            pointer6 = pointer7;
        }
        return;
    }

    public void clear() {
        VelocityTracker.releasePointerList(this.mPointerListHead);
        this.mPointerListHead = null;
        this.mLastTouchIndex = 0;
    }

    public void computeCurrentVelocity(int n) {
        this.computeCurrentVelocity(n, Float.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void computeCurrentVelocity(int n, float f) {
        int n2 = this.mLastTouchIndex;
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            long l;
            float f7;
            float f8;
            float[] fArray;
            float[] fArray2;
            long[] lArray = pointer.pastTime;
            int n3 = n2;
            int n4 = 1;
            long l2 = lArray[n2] - 200L;
            while (true) {
                int n5;
                int n6;
                int n7;
                if ((n7 = n4++) >= (n6 = 10) || lArray[n5 = (n3 + 10 - 1) % 10] < l2) {
                    int n8 = n4;
                    int n9 = 3;
                    if (n8 > n9) {
                        n4 += -1;
                    }
                    fArray2 = pointer.pastX;
                    fArray = pointer.pastY;
                    f8 = fArray2[n3];
                    f7 = fArray[n3];
                    l = lArray[n3];
                    f6 = 0.0f;
                    f5 = 0.0f;
                    break;
                }
                n3 = n5;
            }
            for (int i = 1; i < n4; ++i) {
                int n10 = (n3 + i) % 10;
                int n11 = (int)(lArray[n10] - l);
                if (n11 == 0) continue;
                float f9 = fArray2[n10] - f8;
                float f10 = n11;
                float f11 = f9 / f10;
                float f12 = n;
                float f13 = f11 * f12;
                if (f6 == 0.0f) {
                    float f14 = f13;
                } else {
                    float f15 = (f6 + f13) * 0.5f;
                }
                float f16 = fArray[n10] - f7;
                float f17 = n11;
                float f18 = f16 / f17;
                float f19 = n;
                float f20 = f18 * f19;
                if (f5 == 0.0f) {
                    float f21 = f20;
                    continue;
                }
                float f22 = (f5 + f20) * 0.5f;
            }
            float f23 = -f;
            if (f6 < f23) {
                f6 = -f;
            } else if (f6 > f) {
                f6 = f;
            }
            if (f5 < (f4 = -f)) {
                f5 = -f;
            } else if (f5 > f) {
                f5 = f;
            }
            pointer.xVelocity = f3 = f6;
            pointer.yVelocity = f2 = f5;
            pointer = pointer.next;
        }
        return;
    }

    @Override
    public VelocityTracker getNextPoolable() {
        return this.mNext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getXVelocity() {
        Pointer pointer = this.getPointer(0);
        if (pointer == null) return 0.0f;
        return pointer.xVelocity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getXVelocity(int n) {
        Pointer pointer = this.getPointer(n);
        if (pointer == null) return 0.0f;
        return pointer.xVelocity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getYVelocity() {
        Pointer pointer = this.getPointer(0);
        if (pointer == null) return 0.0f;
        return pointer.yVelocity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getYVelocity(int n) {
        Pointer pointer = this.getPointer(n);
        if (pointer == null) return 0.0f;
        return pointer.yVelocity;
    }

    public void recycle() {
        sPool.release(this);
    }

    @Override
    public void setNextPoolable(VelocityTracker velocityTracker) {
        this.mNext = velocityTracker;
    }

    private static final class Pointer {
        public int generation;
        public int id;
        public Pointer next;
        public final long[] pastTime;
        public final float[] pastX;
        public final float[] pastY;
        public float xVelocity;
        public float yVelocity;

        private Pointer() {
            float[] fArray = new float[10];
            this.pastX = fArray;
            float[] fArray2 = new float[10];
            this.pastY = fArray2;
            Object var3_3 = null;
            this.pastTime = var3_3;
        }
    }
}

