/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.SparseArray;

public class ViewConfiguration {
    private static final int DOUBLE_TAP_SLOP = 100;
    private static final int DOUBLE_TAP_TIMEOUT = 300;
    private static final int EDGE_SLOP = 12;
    private static final int FADING_EDGE_LENGTH = 12;
    private static final int GLOBAL_ACTIONS_KEY_TIMEOUT = 500;
    private static final int JUMP_TAP_TIMEOUT = 500;
    private static final int LONG_PRESS_TIMEOUT = 500;
    @Deprecated
    private static final int MAXIMUM_DRAWING_CACHE_SIZE = 614400;
    private static final int MAXIMUM_FLING_VELOCITY = 4000;
    private static final int MINIMUM_FLING_VELOCITY = 50;
    private static final int OVERFLING_DISTANCE = 4;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int PAGING_TOUCH_SLOP = 32;
    private static final int PRESSED_STATE_DURATION = 125;
    private static final int SCROLL_BAR_DEFAULT_DELAY = 300;
    private static final int SCROLL_BAR_FADE_DURATION = 250;
    private static final int SCROLL_BAR_SIZE = 10;
    private static float SCROLL_FRICTION = 0.0f;
    private static final int TAP_TIMEOUT = 115;
    private static final int TOUCH_SLOP = 16;
    private static final int WINDOW_TOUCH_SLOP = 16;
    private static final int ZOOM_CONTROLS_TIMEOUT = 3000;
    private static final SparseArray<ViewConfiguration> sConfigurations;
    private final int mDoubleTapSlop;
    private final int mEdgeSlop;
    private final int mFadingEdgeLength;
    private final int mMaximumDrawingCacheSize;
    private final int mMaximumFlingVelocity;
    private final int mMinimumFlingVelocity;
    private final int mOverflingDistance;
    private final int mOverscrollDistance;
    private final int mPagingTouchSlop;
    private final int mScrollbarSize;
    private final int mTouchSlop;
    private final int mWindowTouchSlop;

    static {
        SCROLL_FRICTION = 0.015f;
        sConfigurations = new SparseArray(2);
    }

    @Deprecated
    public ViewConfiguration() {
        this.mEdgeSlop = 12;
        this.mFadingEdgeLength = 12;
        this.mMinimumFlingVelocity = 50;
        this.mMaximumFlingVelocity = 4000;
        this.mScrollbarSize = 10;
        this.mTouchSlop = 16;
        this.mPagingTouchSlop = 32;
        this.mDoubleTapSlop = 100;
        this.mWindowTouchSlop = 16;
        this.mMaximumDrawingCacheSize = 614400;
        this.mOverscrollDistance = 0;
        this.mOverflingDistance = 4;
    }

    private ViewConfiguration(Context context) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        float f = displayMetrics.density;
        this.mEdgeSlop = n12 = (int)(f * 12.0f + 0.5f);
        this.mFadingEdgeLength = n11 = (int)(f * 12.0f + 0.5f);
        this.mMinimumFlingVelocity = n10 = (int)(50.0f * f + 0.5f);
        this.mMaximumFlingVelocity = n9 = (int)(4000.0f * f + 0.5f);
        this.mScrollbarSize = n8 = (int)(10.0f * f + 0.5f);
        this.mTouchSlop = n7 = (int)(f * 16.0f + 0.5f);
        this.mPagingTouchSlop = n6 = (int)(32.0f * f + 0.5f);
        this.mDoubleTapSlop = n5 = (int)(100.0f * f + 0.5f);
        this.mWindowTouchSlop = n4 = (int)(f * 16.0f + 0.5f);
        int n13 = displayMetrics.widthPixels * 4;
        int n14 = displayMetrics.heightPixels;
        this.mMaximumDrawingCacheSize = n3 = n13 * n14;
        this.mOverscrollDistance = n2 = (int)(0.0f * f + 0.5f);
        this.mOverflingDistance = n = (int)(4.0f * f + 0.5f);
    }

    public static ViewConfiguration get(Context context) {
        float f = context.getResources().getDisplayMetrics().density;
        int n = (int)(100.0f * f);
        ViewConfiguration viewConfiguration = sConfigurations.get(n);
        if (viewConfiguration == null) {
            viewConfiguration = new ViewConfiguration(context);
            sConfigurations.put(n, viewConfiguration);
        }
        return viewConfiguration;
    }

    @Deprecated
    public static int getDoubleTapSlop() {
        return 100;
    }

    public static int getDoubleTapTimeout() {
        return 300;
    }

    @Deprecated
    public static int getEdgeSlop() {
        return 12;
    }

    @Deprecated
    public static int getFadingEdgeLength() {
        return 12;
    }

    public static long getGlobalActionKeyTimeout() {
        return 500L;
    }

    public static int getJumpTapTimeout() {
        return 500;
    }

    public static int getLongPressTimeout() {
        return 500;
    }

    @Deprecated
    public static int getMaximumDrawingCacheSize() {
        return 614400;
    }

    @Deprecated
    public static int getMaximumFlingVelocity() {
        return 4000;
    }

    @Deprecated
    public static int getMinimumFlingVelocity() {
        return 50;
    }

    public static int getPressedStateDuration() {
        return 125;
    }

    public static int getScrollBarFadeDuration() {
        return 250;
    }

    @Deprecated
    public static int getScrollBarSize() {
        return 10;
    }

    public static int getScrollDefaultDelay() {
        return 300;
    }

    public static float getScrollFriction() {
        return SCROLL_FRICTION;
    }

    public static int getTapTimeout() {
        return 115;
    }

    @Deprecated
    public static int getTouchSlop() {
        return 16;
    }

    @Deprecated
    public static int getWindowTouchSlop() {
        return 16;
    }

    public static long getZoomControlsTimeout() {
        return 3000L;
    }

    public int getScaledDoubleTapSlop() {
        return this.mDoubleTapSlop;
    }

    public int getScaledEdgeSlop() {
        return this.mEdgeSlop;
    }

    public int getScaledFadingEdgeLength() {
        return this.mFadingEdgeLength;
    }

    public int getScaledMaximumDrawingCacheSize() {
        return this.mMaximumDrawingCacheSize;
    }

    public int getScaledMaximumFlingVelocity() {
        return this.mMaximumFlingVelocity;
    }

    public int getScaledMinimumFlingVelocity() {
        return this.mMinimumFlingVelocity;
    }

    public int getScaledOverflingDistance() {
        return this.mOverflingDistance;
    }

    public int getScaledOverscrollDistance() {
        return this.mOverscrollDistance;
    }

    public int getScaledPagingTouchSlop() {
        return this.mPagingTouchSlop;
    }

    public int getScaledScrollBarSize() {
        return this.mScrollbarSize;
    }

    public int getScaledTouchSlop() {
        return this.mTouchSlop;
    }

    public int getScaledWindowTouchSlop() {
        return this.mWindowTouchSlop;
    }
}

