/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Debug;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRoot;
import dalvik.annotation.AnnotationDefault;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ViewDebug {
    private static final int CAPTURE_TIMEOUT = 4000;
    public static final int CONSISTENCY_DRAWING = 2;
    public static final int CONSISTENCY_LAYOUT = 1;
    public static final String CONSISTENCY_LOG_TAG = "ViewConsistency";
    private static final String REMOTE_COMMAND_CAPTURE = "CAPTURE";
    private static final String REMOTE_COMMAND_CAPTURE_LAYERS = "CAPTURE_LAYERS";
    private static final String REMOTE_COMMAND_DUMP = "DUMP";
    private static final String REMOTE_COMMAND_INVALIDATE = "INVALIDATE";
    private static final String REMOTE_COMMAND_REQUEST_LAYOUT = "REQUEST_LAYOUT";
    private static final String REMOTE_PROFILE = "PROFILE";
    static final String SYSTEM_PROPERTY_CAPTURE_EVENT = "debug.captureevent";
    static final String SYSTEM_PROPERTY_CAPTURE_VIEW = "debug.captureview";
    public static final boolean TRACE_HIERARCHY;
    public static final boolean TRACE_MOTION_EVENTS;
    public static final boolean TRACE_RECYCLER;
    @Debug.DebugProperty
    public static boolean consistencyCheckEnabled;
    private static HashMap<Class<?>, Field[]> mCapturedViewFieldsForClasses;
    private static HashMap<Class<?>, Method[]> mCapturedViewMethodsForClasses;
    @Debug.DebugProperty
    public static boolean profileDrawing;
    @Debug.DebugProperty
    public static boolean profileLayout;
    private static HashMap<AccessibleObject, ExportedProperty> sAnnotations;
    private static HashMap<Class<?>, Field[]> sFieldsForClasses;
    private static String sHierarchyTracePrefix;
    private static BufferedWriter sHierarchyTraces;
    private static ViewRoot sHierarhcyRoot;
    private static HashMap<Class<?>, Method[]> sMethodsForClasses;
    private static ViewRoot sMotionEventRoot;
    private static String sMotionEventTracePrefix;
    private static BufferedWriter sMotionEventTraces;
    private static View sRecyclerOwnerView;
    private static String sRecyclerTracePrefix;
    private static List<RecyclerTrace> sRecyclerTraces;
    private static List<View> sRecyclerViews;
    @Debug.DebugProperty
    public static boolean showFps;

    static {
        profileDrawing = false;
        profileLayout = false;
        showFps = false;
        consistencyCheckEnabled = false;
        mCapturedViewMethodsForClasses = null;
        mCapturedViewFieldsForClasses = null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void capture(View view, OutputStream outputStream, String string2) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        Bitmap bitmap;
        block6: {
            BufferedOutputStream bufferedOutputStream2;
            bitmap = ViewDebug.performViewCapture(ViewDebug.findView(view, string2), false);
            if (bitmap == null) {
                int n = Log.w("View", "Failed to create capture bitmap!");
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
                bitmap = Bitmap.createBitmap(1, 1, config);
            }
            bufferedOutputStream = null;
            try {
                bufferedOutputStream2 = new BufferedOutputStream(outputStream, 32768);
            }
            catch (Throwable throwable) {}
            try {
                Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                boolean bl = bitmap.compress(compressFormat, 100, bufferedOutputStream2);
                bufferedOutputStream2.flush();
                if (bufferedOutputStream2 == null) break block6;
            }
            catch (Throwable throwable) {
                bufferedOutputStream = bufferedOutputStream2;
            }
            bufferedOutputStream2.close();
        }
        bitmap.recycle();
        return;
        {
            void var10_11;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
            bitmap.recycle();
            throw var10_11;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void captureLayers(View view, DataOutputStream dataOutputStream) throws IOException {
        try {
            Rect rect = new Rect();
            try {
                IWindowSession iWindowSession = view.mAttachInfo.mSession;
                IWindow iWindow = view.mAttachInfo.mWindow;
                iWindowSession.getDisplayFrame(iWindow, rect);
            }
            catch (RemoteException remoteException) {}
            int n = rect.width();
            dataOutputStream.writeInt(n);
            int n2 = rect.height();
            dataOutputStream.writeInt(n2);
            ViewDebug.captureViewLayer(view, dataOutputStream, true);
            dataOutputStream.write(2);
            return;
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void captureViewLayer(View view, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        boolean bl2 = view.getVisibility() == 0 && bl;
        if ((view.mPrivateFlags & 0x80) != 128) {
            int n = view.getId();
            String string2 = view.getClass().getSimpleName();
            if (n != -1) {
                string2 = ViewDebug.resolveId(view.getContext(), n).toString();
            }
            dataOutputStream.write(1);
            dataOutputStream.writeUTF(string2);
            int n2 = bl2 ? 1 : 0;
            dataOutputStream.writeByte(n2);
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n3 = nArray[0];
            dataOutputStream.writeInt(n3);
            int n4 = nArray[1];
            dataOutputStream.writeInt(n4);
            dataOutputStream.flush();
            Bitmap bitmap = ViewDebug.performViewCapture(view, true);
            if (bitmap != null) {
                int n5 = bitmap.getWidth();
                int n6 = bitmap.getHeight();
                int n7 = n5 * n6 * 2;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n7);
                Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                boolean bl3 = bitmap.compress(compressFormat, 100, byteArrayOutputStream);
                int n8 = byteArrayOutputStream.size();
                dataOutputStream.writeInt(n8);
                byteArrayOutputStream.writeTo(dataOutputStream);
            }
            dataOutputStream.flush();
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        int n9 = 0;
        while (n9 < n) {
            ViewDebug.captureViewLayer(viewGroup.getChildAt(n9), dataOutputStream, bl2);
            ++n9;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String capturedViewExportFields(Object object, Class<?> clazz, String string2) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = ViewDebug.capturedViewGetPropertyFields(clazz);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Object object2 = field.get(object);
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                String string3 = field.getName();
                StringBuilder stringBuilder3 = stringBuilder.append(string3);
                StringBuilder stringBuilder4 = stringBuilder.append("=");
                if (object2 != null) {
                    String string4 = object2.toString().replace("\n", "\\n");
                    StringBuilder stringBuilder5 = stringBuilder.append(string4);
                } else {
                    StringBuilder stringBuilder6 = stringBuilder.append("null");
                }
                StringBuilder stringBuilder7 = stringBuilder.append(' ');
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String capturedViewExportMethods(Object object, Class<?> clazz, String string2) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Method[] methodArray = ViewDebug.capturedViewGetPropertyMethods(clazz);
        int n = methodArray.length;
        int n2 = 0;
        while (true) {
            block8: {
                if (n2 >= n) {
                    return stringBuilder.toString();
                }
                Method method = methodArray[n2];
                Object var9_9 = null;
                try {
                    block10: {
                        block9: {
                            try {
                                Object[] objectArray = var9_9;
                                Object object2 = method.invoke(object, objectArray);
                                Class<?> clazz2 = method.getReturnType();
                                if (method.getAnnotation(CapturedViewProperty.class).retrieveReturn()) {
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    String string3 = method.getName();
                                    String string4 = stringBuilder2.append(string3).append("#").toString();
                                    String string5 = ViewDebug.capturedViewExportMethods(object2, clazz2, string4);
                                    StringBuilder stringBuilder3 = stringBuilder.append(string5);
                                    break block8;
                                }
                                StringBuilder stringBuilder4 = stringBuilder.append(string2);
                                String string6 = method.getName();
                                StringBuilder stringBuilder5 = stringBuilder.append(string6);
                                StringBuilder stringBuilder6 = stringBuilder.append("()=");
                                if (object2 == null) break block9;
                                String string7 = object2.toString().replace("\n", "\\n");
                                StringBuilder stringBuilder7 = stringBuilder.append(string7);
                                break block10;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                        }
                        StringBuilder stringBuilder8 = stringBuilder.append("null");
                    }
                    StringBuilder stringBuilder9 = stringBuilder.append("; ");
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field[] capturedViewGetPropertyFields(Class<?> clazz) {
        HashMap<Class<?>, Field[]> hashMap;
        Field[] fieldArray;
        if (mCapturedViewFieldsForClasses == null) {
            mCapturedViewFieldsForClasses = new HashMap();
        }
        if ((fieldArray = (hashMap = mCapturedViewFieldsForClasses).get(clazz)) != null) {
            return fieldArray;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : clazz.getFields()) {
            if (!field.isAnnotationPresent(CapturedViewProperty.class)) continue;
            field.setAccessible(true);
            boolean bl = arrayList.add(field);
        }
        Field[] fieldArray2 = new Field[arrayList.size()];
        Field[] fieldArray3 = arrayList.toArray(fieldArray2);
        Field[] fieldArray4 = hashMap.put(clazz, fieldArray3);
        return fieldArray3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Method[] capturedViewGetPropertyMethods(Class<?> clazz) {
        HashMap<Class<?>, Method[]> hashMap;
        Method[] methodArray;
        if (mCapturedViewMethodsForClasses == null) {
            mCapturedViewMethodsForClasses = new HashMap();
        }
        if ((methodArray = (hashMap = mCapturedViewMethodsForClasses).get(clazz)) != null) {
            return methodArray;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(CapturedViewProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            boolean bl = arrayList.add(method);
        }
        Method[] methodArray2 = new Method[arrayList.size()];
        Method[] methodArray3 = arrayList.toArray(methodArray2);
        Method[] methodArray4 = hashMap.put(clazz, methodArray3);
        return methodArray3;
    }

    static void dispatchCommand(View view, String string2, String string3, OutputStream outputStream) throws IOException {
        View view2 = view.getRootView();
        if (REMOTE_COMMAND_DUMP.equalsIgnoreCase(string2)) {
            ViewDebug.dump(view2, outputStream);
            return;
        }
        if (REMOTE_COMMAND_CAPTURE_LAYERS.equalsIgnoreCase(string2)) {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            ViewDebug.captureLayers(view2, dataOutputStream);
            return;
        }
        String[] stringArray = string3.split(" ");
        if (REMOTE_COMMAND_CAPTURE.equalsIgnoreCase(string2)) {
            String string4 = stringArray[0];
            ViewDebug.capture(view2, outputStream, string4);
            return;
        }
        if (REMOTE_COMMAND_INVALIDATE.equalsIgnoreCase(string2)) {
            String string5 = stringArray[0];
            ViewDebug.invalidate(view2, string5);
            return;
        }
        if (REMOTE_COMMAND_REQUEST_LAYOUT.equalsIgnoreCase(string2)) {
            String string6 = stringArray[0];
            ViewDebug.requestLayout(view2, string6);
            return;
        }
        if (!REMOTE_PROFILE.equalsIgnoreCase(string2)) {
            return;
        }
        String string7 = stringArray[0];
        ViewDebug.profile(view2, outputStream, string7);
    }

    /*
     * Unable to fully structure code
     */
    private static void dump(View var0, OutputStream var1_1) throws IOException {
        var2_2 = null;
        var3_3 = new OutputStreamWriter(var1_1, "utf-8");
        var4_4 = new BufferedWriter(var3_3, 32768);
        try {
            var5_5 = var0.getRootView();
            if (var5_5 instanceof ViewGroup) {
                var6_6 = (ViewGroup)var5_5;
                ViewDebug.dumpViewHierarchyWithProperties(var6_6.getContext(), var6_6, var4_4, 0);
            }
            var4_4.write("DONE.");
            var4_4.newLine();
            ** if (var4_4 == null) goto lbl-1000
        }
        catch (Throwable var10_14) {
            var11_15 = var4_4;
            ** continue;
        }
        catch (Exception var8_10) {
            var2_2 = var4_4;
            ** continue;
        }
lbl-1000:
        // 1 sources

        {
            var4_4.close();
            var7_7 = var4_4;
            return;
        }
lbl-1000:
        // 1 sources

        {
        }
        catch (Exception var8_8) lbl-1000:
        // 2 sources

        {
            while (true) {
                block12: {
                    try {
                        var9_11 = Log.w("View", "Problem dumping the view:", (Throwable)var8_9);
                        if (var2_2 != null) break block12;
                        return;
                    }
                    catch (Throwable var10_12) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var2_2 != null) {
                                var2_2.close();
                            }
                            throw var10_13;
                        }
                    }
                }
                var2_2.close();
                return;
            }
        }
        var12_16 = var4_4;
    }

    public static void dumpCapturedView(String string2, Object object) {
        Class<? extends Object> clazz = object.getClass();
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = clazz.getName();
        String string4 = stringBuilder.append(string3).append(": ").toString();
        StringBuilder stringBuilder2 = new StringBuilder(string4);
        String string5 = ViewDebug.capturedViewExportFields(object, clazz, "");
        StringBuilder stringBuilder3 = stringBuilder2.append(string5);
        String string6 = ViewDebug.capturedViewExportMethods(object, clazz, "");
        StringBuilder stringBuilder4 = stringBuilder2.append(string6);
        String string7 = stringBuilder2.toString();
        int n = Log.d(string2, string7);
    }

    /*
     * Exception decompiling
     */
    private static boolean dumpView(Object var0, BufferedWriter var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[FORLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void dumpViewHierarchy(ViewGroup viewGroup, BufferedWriter bufferedWriter, int n) {
        if (!ViewDebug.dumpView(viewGroup, bufferedWriter, n)) {
            return;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = viewGroup.getChildAt(n3);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup2 = (ViewGroup)view;
                int n4 = n + 1;
                ViewDebug.dumpViewHierarchy(viewGroup2, bufferedWriter, n4);
            } else {
                int n5 = n + 1;
                boolean bl = ViewDebug.dumpView(view, bufferedWriter, n5);
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void dumpViewHierarchyWithProperties(Context context, ViewGroup viewGroup, BufferedWriter bufferedWriter, int n) {
        if (!ViewDebug.dumpViewWithProperties(context, viewGroup, bufferedWriter, n)) {
            return;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = viewGroup.getChildAt(n3);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup2 = (ViewGroup)view;
                int n4 = n + 1;
                ViewDebug.dumpViewHierarchyWithProperties(context, viewGroup2, bufferedWriter, n4);
            } else {
                int n5 = n + 1;
                boolean bl = ViewDebug.dumpViewWithProperties(context, view, bufferedWriter, n5);
            }
            ++n3;
        }
        return;
    }

    private static void dumpViewProperties(Context context, Object object, BufferedWriter bufferedWriter) throws IOException {
        ViewDebug.dumpViewProperties(context, object, bufferedWriter, "");
    }

    private static void dumpViewProperties(Context context, Object object, BufferedWriter bufferedWriter, String string2) throws IOException {
        Class<? extends Object> clazz = object.getClass();
        do {
            ViewDebug.exportFields(context, object, bufferedWriter, clazz, string2);
            ViewDebug.exportMethods(context, object, bufferedWriter, clazz, string2);
        } while ((clazz = clazz.getSuperclass()) != Object.class);
    }

    /*
     * Exception decompiling
     */
    private static boolean dumpViewWithProperties(Context var0, View var1_1, BufferedWriter var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[FORLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void exportFields(Context var0, Object var1_1, BufferedWriter var2_2, Class<?> var3_3, String var4_4) throws IOException {
        var5_5 = ViewDebug.getExportedPropertyFields(var3_3);
        var6_6 = var5_5.length;
        var7_7 = 0;
        while (true) {
            if (var7_7 >= var6_6) {
                return;
            }
            var8_8 = var5_5[var7_7];
            var9_9 = null;
            try {
                var10_10 = var8_8.getType();
                var11_13 = ViewDebug.sAnnotations;
                var12_14 = var8_8;
                var13_15 = var11_13.get(var12_14);
                if (var13_15.category().length() != 0) {
                    var14_16 = new StringBuilder();
                    var15_17 = var13_15.category();
                    var16_18 = var14_16;
                    var17_19 = var15_17;
                    var18_20 = var16_18.append(var17_19);
                    var19_21 = ":";
                    var20_22 = var18_20.append(var19_21).toString();
                } else {
                    var20_22 = "";
                }
                if (var10_10 == (var21_23 = Integer.TYPE)) {
                    if (var13_15.resolveId() && var0 != null) {
                        var22_24 = var8_8;
                        var23_25 = var1_1;
                        var24_26 = var22_24.getInt(var23_25);
                        var25_27 = var0;
                        var26_28 = var24_26;
                        var9_9 = ViewDebug.resolveId(var25_27, var26_28);
                    } else {
                        var10_11 = var13_15.flagMapping();
                        if (var10_11.length > 0) {
                            var38_40 = var8_8;
                            var39_41 = var1_1;
                            var40_42 = var38_40.getInt(var39_41);
                            var41_43 = new StringBuilder();
                            var42_44 = var20_22;
                            var43_45 = var41_43.append(var42_44);
                            var44_46 = var4_4;
                            var45_47 = var43_45.append(var44_46);
                            var46_48 = var8_8.getName();
                            var47_49 = var45_47.append(var46_48).append('_').toString();
                            var48_50 = var2_2;
                            var49_51 = var10_11;
                            var50_52 = var40_42;
                            var51_53 = var47_49;
                            ViewDebug.exportUnrolledFlags(var48_50, var49_51, var50_52, var51_53);
                        }
                        if ((var52_54 = var13_15.mapping()).length > 0) {
                            var53_55 = var8_8;
                            var54_56 = var1_1;
                            var13_15 = var53_55.getInt(var54_56);
                            var55_57 = var52_54.length;
                            var10_12 = 0;
                            break;
                        }
                    }
                } else {
                    if (var10_10 == int[].class) {
                        var57_72 = var8_8;
                        var58_73 = var1_1;
                        var59_74 = (int[])var57_72.get(var58_73);
                        var60_75 = new StringBuilder();
                        var61_76 = var20_22;
                        var62_77 = var60_75.append(var61_76).append(var4_4);
                        var63_78 = var8_8.getName();
                        var64_79 = var62_77;
                        var65_80 = var63_78;
                        var66_81 = var64_79.append(var65_80);
                        var67_82 = '_';
                        var68_83 = var66_81.append(var67_82).toString();
                        var69_84 = var0;
                        var70_85 = var2_2;
                        ViewDebug.exportUnrolledArray(var69_84, var70_85, (ExportedProperty)var13_15, var59_74, var68_83, "");
                        return;
                    }
                    if (!var10_10.isPrimitive() && var13_15.deepExport()) {
                        var71_59 = var8_8;
                        var72_60 = var1_1;
                        var73_61 = var71_59.get(var72_60);
                        var74_62 = new StringBuilder();
                        var75_63 = var4_4;
                        var76_64 = var74_62.append(var75_63);
                        var77_65 = var13_15.prefix();
                        var78_66 = var76_64.append(var77_65).toString();
                        var79_67 = var0;
                        var80_68 = var73_61;
                        var81_69 = var2_2;
                        var82_70 = var78_66;
                        ViewDebug.dumpViewProperties(var79_67, var80_68, var81_69, var82_70);
                    }
                }
lbl91:
                // 3 sources

                while (true) {
                    if (var9_9 == null) {
                        var27_29 = var8_8;
                        var28_30 = var1_1;
                        var9_9 = var27_29.get(var28_30);
                    }
                    var29_31 = new StringBuilder();
                    var30_32 = var20_22;
                    var31_33 = var29_31.append(var30_32).append(var4_4).toString();
                    var32_34 = var8_8.getName();
                    var33_35 = var2_2;
                    var34_36 = var31_33;
                    var35_37 = var32_34;
                    var36_38 = "";
                    var37_39 = var9_9;
                    ViewDebug.writeEntry(var33_35, var34_36, var35_37, var36_38, var37_39);
                    break;
                }
            }
            catch (IllegalAccessException var83_71) {}
            ++var7_7;
        }
        while (true) {
            block19: {
                block18: {
                    if (var10_12 >= var55_57) break block18;
                    var56_58 = var52_54[var10_12];
                    if (var56_58.from() == var13_15) break block19;
                    var9_9 = var56_58.to();
                }
                if (var9_9 != null) ** GOTO lbl91
                var9_9 = (int)var13_15;
                ** continue;
            }
            ++var10_12;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void exportMethods(Context var0, Object var1_1, BufferedWriter var2_2, Class<?> var3_3, String var4_4) throws IOException {
        block18: {
            block17: {
                var5_5 = ViewDebug.getExportedPropertyMethods(var3_3);
                var6_6 = var5_5.length;
                var7_7 = 0;
                block3: while (true) {
                    block15: {
                        block16: {
                            if (var7_7 >= var6_6) {
                                return;
                            }
                            var8_8 = var5_5[var7_7];
                            var9_9 = null;
                            try {
                                var10_10 = (Object[])var9_9;
                                var11_11 = var8_8;
                                var12_12 = var1_1;
                                var13_13 = var10_10;
                                var14_14 = var11_11.invoke(var12_12, var13_13);
                                var15_15 = var8_8.getReturnType();
                                var16_19 = ViewDebug.sAnnotations;
                                var17_20 = var8_8;
                                var18_21 = var16_19.get(var17_20);
                                if (var18_21.category().length() != 0) {
                                    var19_22 = new StringBuilder();
                                    var20_23 = var18_21.category();
                                    var21_24 = var19_22;
                                    var22_25 = var20_23;
                                    var23_26 = var21_24.append(var22_25);
                                    var24_27 = ":";
                                    var9_9 = var23_26.append(var24_27).toString();
                                } else {
                                    var9_9 = "";
                                }
                                if (var15_15 == (var25_28 = Integer.TYPE)) {
                                    if (var18_21.resolveId() && var0 != null) {
                                        var26_29 = (Integer)var14_14;
                                        var27_30 = var0;
                                        var28_31 = var26_29;
                                        var15_15 = ViewDebug.resolveId(var27_30, var28_31);
                                        break block15;
                                    }
                                    var15_15 = var18_21.flagMapping();
                                    if (var15_15.length > 0) {
                                        var38_41 = (Integer)var14_14;
                                        var39_42 = new StringBuilder();
                                        var40_43 = var9_9;
                                        var41_44 = var39_42.append(var40_43);
                                        var42_45 = var4_4;
                                        var43_46 = var41_44.append(var42_45);
                                        var44_47 = var8_8.getName();
                                        var45_48 = var43_46.append(var44_47).append('_').toString();
                                        var46_49 = var2_2;
                                        var47_50 = var15_15;
                                        var48_51 = var38_41;
                                        var49_52 = var45_48;
                                        ViewDebug.exportUnrolledFlags(var46_49, var47_50, var48_51, var49_52);
                                    }
                                    if ((var50_53 = var18_21.mapping()).length > 0) {
                                        var15_15 = (FlagToString[])((Integer)var14_14);
                                        var18_21 = null;
                                        var51_54 = var50_53.length;
                                        break;
                                    }
                                    break block16;
                                }
                                if (var15_15 == int[].class) {
                                    var56_71 = (int[])var14_14;
                                    var57_72 = new StringBuilder();
                                    var58_73 = var9_9;
                                    var59_74 = var57_72.append(var58_73).append(var4_4);
                                    var60_75 = var8_8.getName();
                                    var61_76 = var59_74;
                                    var62_77 = var60_75;
                                    var63_78 = var61_76.append(var62_77);
                                    var64_79 = '_';
                                    var65_80 = var63_78.append(var64_79).toString();
                                    var66_81 = var0;
                                    var67_82 = var2_2;
                                    ViewDebug.exportUnrolledArray(var66_81, var67_82, (ExportedProperty)var18_21, var56_71, var65_80, "()");
                                    return;
                                }
                                if (!var15_15.isPrimitive() && var18_21.deepExport()) {
                                    var68_60 = new StringBuilder().append(var4_4);
                                    var69_61 = var18_21.prefix();
                                    var70_62 = var68_60;
                                    var71_63 = var69_61;
                                    var72_64 = var70_62.append(var71_63).toString();
                                    var73_65 = var0;
                                    var74_66 = var14_14;
                                    var75_67 = var2_2;
                                    var76_68 = var72_64;
                                    ViewDebug.dumpViewProperties(var73_65, var74_66, var75_67, var76_68);
                                }
                                break block16;
                            }
                            catch (IllegalAccessException var77_69) {
                            }
                            catch (InvocationTargetException var78_70) {}
                            ** GOTO lbl103
                        }
                        var15_17 = var14_14;
                    }
lbl92:
                    // 3 sources

                    while (true) {
                        var29_32 = new StringBuilder();
                        var30_33 = var9_9;
                        var31_34 = var29_32.append(var30_33).append(var4_4).toString();
                        var32_35 = var8_8.getName();
                        var33_36 = var2_2;
                        var34_37 = var31_34;
                        var35_38 = var32_35;
                        var36_39 = "()";
                        var37_40 = var15_15;
                        ViewDebug.writeEntry(var33_36, var34_37, var35_38, var36_39, var37_40);
lbl103:
                        // 4 sources

                        ++var7_7;
                        continue block3;
                        break;
                    }
                    break;
                }
                for (var52_56 = 0; var52_56 < var51_54; ++var52_56) {
                    var53_57 = var50_53[var52_56];
                    var54_58 = var53_57.from();
                    if (var54_58 == (var55_59 = var15_15)) continue;
                    var18_21 = var53_57.to();
                    var52_55 = null;
                    break block17;
                }
                var52_55 = var18_21;
                var18_21 = var14_14;
            }
            if (var52_55 != null) break block18;
            var15_16 = (int)var15_15;
            ** GOTO lbl92
        }
        var15_18 = var18_21;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void exportUnrolledArray(Context context, BufferedWriter bufferedWriter, ExportedProperty exportedProperty, int[] nArray, String string2, String string3) throws IOException {
        IntToString[] intToStringArray = exportedProperty.indexMapping();
        boolean bl = intToStringArray.length > 0;
        IntToString[] intToStringArray2 = exportedProperty.mapping();
        boolean bl2 = intToStringArray2.length > 0;
        boolean bl3 = exportedProperty.resolveId() && context != null;
        int n = nArray.length;
        int n2 = 0;
        int n3;
        int n4;
        while ((n4 = ++n2) < (n3 = n)) {
            String string4;
            String string5;
            String string6 = null;
            int n5 = nArray[n2];
            String string7 = String.valueOf(n2);
            if (bl) {
                for (IntToString intToString : intToStringArray) {
                    int n6;
                    int n7 = intToString.from();
                    if (n7 == (n6 = n2)) continue;
                    string7 = intToString.to();
                    break;
                }
            }
            if (bl2) {
                for (IntToString intToString : intToStringArray2) {
                    int n8;
                    int n9 = intToString.from();
                    if (n9 == (n8 = n5)) continue;
                    string5 = intToString.to();
                    break;
                }
            } else {
                string5 = string6;
            }
            if (bl3) {
                if (string5 == null) {
                    Context context2 = context;
                    int n10 = n5;
                    string4 = (String)ViewDebug.resolveId(context2, n10);
                } else {
                    string4 = string5;
                }
            } else {
                string4 = String.valueOf(n5);
            }
            BufferedWriter bufferedWriter2 = bufferedWriter;
            String string8 = string2;
            String string9 = string7;
            String string10 = string3;
            String string11 = string4;
            ViewDebug.writeEntry(bufferedWriter2, string8, string9, string10, string11);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void exportUnrolledFlags(BufferedWriter bufferedWriter, FlagToString[] flagToStringArray, int n, String string2) throws IOException {
        int n2 = flagToStringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            FlagToString flagToString = flagToStringArray[n3];
            boolean bl = flagToString.outputIf();
            int n5 = flagToString.mask();
            int n6 = n & n5;
            boolean bl2 = n6 != (n4 = flagToString.equals());
            if (bl2 && bl || !bl2 && !bl) {
                String string3 = flagToString.name();
                StringBuilder stringBuilder = new StringBuilder().append("0x");
                String string4 = Integer.toHexString(n6);
                String string5 = stringBuilder.append(string4).toString();
                ViewDebug.writeEntry(bufferedWriter, string2, string3, "", string5);
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static View findView(View view, String string2) {
        if (string2.indexOf(64) != -1) {
            String[] stringArray = string2.split("@");
            String string3 = stringArray[0];
            int n = (int)Long.parseLong(stringArray[1], 16);
            View view2 = view.getRootView();
            if (!(view2 instanceof ViewGroup)) return null;
            return ViewDebug.findView((ViewGroup)view2, string3, n);
        }
        int n = view.getResources().getIdentifier(string2, null, null);
        return view.getRootView().findViewById(n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static View findView(ViewGroup viewGroup, String string2, int n) {
        void var3_4;
        if (ViewDebug.isRequestedView(viewGroup, string2, n)) {
            ViewGroup viewGroup2 = viewGroup;
            return var3_4;
        }
        int n2 = viewGroup.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                View view2 = ViewDebug.findView((ViewGroup)view, string2, n);
                if (view2 == null) continue;
                View view3 = view2;
                return var3_4;
            }
            if (!ViewDebug.isRequestedView(view, string2, n)) continue;
            View view4 = view;
            return var3_4;
        }
        return var3_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field[] getExportedPropertyFields(Class<?> clazz) {
        if (sFieldsForClasses == null) {
            sFieldsForClasses = new HashMap();
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        HashMap<Class<?>, Field[]> hashMap = sFieldsForClasses;
        HashMap<AccessibleObject, ExportedProperty> hashMap2 = sAnnotations;
        Field[] fieldArray = hashMap.get(clazz);
        if (fieldArray != null) {
            return fieldArray;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExportedProperty.class)) continue;
            field.setAccessible(true);
            boolean bl = arrayList.add(field);
            ExportedProperty exportedProperty = field.getAnnotation(ExportedProperty.class);
            ExportedProperty exportedProperty2 = hashMap2.put(field, exportedProperty);
        }
        Field[] fieldArray2 = new Field[arrayList.size()];
        Field[] fieldArray3 = arrayList.toArray(fieldArray2);
        Field[] fieldArray4 = hashMap.put(clazz, fieldArray3);
        return fieldArray3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Method[] getExportedPropertyMethods(Class<?> clazz) {
        if (sMethodsForClasses == null) {
            sMethodsForClasses = new HashMap(100);
        }
        if (sAnnotations == null) {
            sAnnotations = new HashMap(512);
        }
        HashMap<Class<?>, Method[]> hashMap = sMethodsForClasses;
        HashMap<AccessibleObject, ExportedProperty> hashMap2 = sAnnotations;
        Method[] methodArray = hashMap.get(clazz);
        if (methodArray != null) {
            return methodArray;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(ExportedProperty.class) || method.getReturnType() == Void.class) continue;
            method.setAccessible(true);
            boolean bl = arrayList.add(method);
            ExportedProperty exportedProperty = method.getAnnotation(ExportedProperty.class);
            ExportedProperty exportedProperty2 = hashMap2.put(method, exportedProperty);
        }
        Method[] methodArray2 = new Method[arrayList.size()];
        Method[] methodArray3 = arrayList.toArray(methodArray2);
        Method[] methodArray4 = hashMap.put(clazz, methodArray3);
        return methodArray3;
    }

    public static long getViewInstanceCount() {
        return View.sInstanceCount;
    }

    public static long getViewRootInstanceCount() {
        return ViewRoot.getInstanceCount();
    }

    private static void invalidate(View view, String string2) {
        View view2 = ViewDebug.findView(view, string2);
        if (view2 == null) {
            return;
        }
        view2.postInvalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRequestedView(View view, String string2, int n) {
        if (!view.getClass().getName().equals(string2)) return false;
        if (view.hashCode() == n) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bitmap performViewCapture(final View view, final boolean bl) {
        if (view == null) return null;
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Bitmap[] bitmapArray = new Bitmap[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Bitmap bitmap;
                    Bitmap[] bitmapArray2 = bitmapArray;
                    View view2 = view;
                    Bitmap.Config config = Bitmap.Config.ARGB_8888;
                    boolean bl2 = bl;
                    bitmapArray2[0] = bitmap = view2.createSnapshot(config, 0, bl2);
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Bitmap bitmap;
                    Bitmap[] bitmapArray3 = bitmapArray;
                    View view3 = view;
                    Bitmap.Config config = Bitmap.Config.ARGB_4444;
                    boolean bl3 = bl;
                    bitmapArray3[0] = bitmap = view3.createSnapshot(config, 0, bl3);
                    return;
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        };
        boolean bl2 = view.post(runnable);
        Bitmap bitmap = null;
        try {
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            boolean bl3 = countDownLatch.await((long)bitmap, timeUnit);
            return bitmapArray[0];
        }
        catch (InterruptedException interruptedException) {
            String string2 = "Could not complete the capture of the view " + view;
            int n = Log.w("View", string2);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void profile(View var0, OutputStream var1_1, String var2_2) throws IOException {
        var3_3 = ViewDebug.findView(var0, var2_2);
        var4_4 = null;
        var5_5 = new OutputStreamWriter(var1_1);
        var6_6 = new BufferedWriter(var5_5, 32768);
        if (var3_3 == null) ** GOTO lbl10
        try {
            block12: {
                ViewDebug.profileViewAndChildren(var3_3, var6_6);
                break block12;
lbl10:
                // 1 sources

                var6_6.write("-1 -1 -1");
                var6_6.newLine();
            }
            var6_6.write("DONE.");
            var6_6.newLine();
            ** if (var6_6 == null) goto lbl19
        }
        catch (Exception var8_8) {
            block13: {
                var4_4 = var6_6;
                break block13;
                catch (Throwable var10_14) {
                    var11_15 = var6_6;
                    ** GOTO lbl-1000
                }
lbl26:
                // 1 sources

                var12_16 = var6_6;
                return;
            }
lbl29:
            // 2 sources

            while (true) {
                block11: {
                    try {
                        var9_11 = Log.w("View", "Problem profiling the view:", (Throwable)var8_9);
                        if (var4_4 != null) break block11;
                        return;
                    }
                    catch (Throwable var10_12) lbl-1000:
                    // 2 sources

                    {
                        if (var11_15 != null) {
                            var11_15.close();
                        }
                        throw var10_13;
                    }
                }
                var4_4.close();
                return;
            }
        }
lbl-1000:
        // 1 sources

        {
            var6_6.close();
            var7_7 = var6_6;
            return;
        }
lbl19:
        // 1 sources

        ** GOTO lbl26
        catch (Exception var8_10) {
            ** continue;
        }
    }

    private static void profileViewAndChildren(View view, BufferedWriter bufferedWriter) throws IOException {
        ViewDebug.profileViewAndChildren(view, bufferedWriter, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void profileViewAndChildren(final View view, BufferedWriter bufferedWriter, boolean bl) throws IOException {
        long l;
        long l2;
        long l3;
        if (bl || (view.mPrivateFlags & 0x800) != 0) {
            ViewOperation<Void> viewOperation = new ViewOperation<Void>(){

                private void forceLayout(View view3) {
                    view3.forceLayout();
                    if (!(view3 instanceof ViewGroup)) {
                        return;
                    }
                    ViewGroup viewGroup = (ViewGroup)view3;
                    int n = viewGroup.getChildCount();
                    int n2 = 0;
                    while (n2 < n) {
                        View view2 = viewGroup.getChildAt(n2);
                        this.forceLayout(view2);
                        ++n2;
                    }
                    return;
                }

                public void post(Void ... voidArray) {
                }

                public Void[] pre() {
                    View view2 = view;
                    this.forceLayout(view2);
                    return null;
                }

                public void run(Void ... voidArray) {
                    View view2 = view;
                    int n = view.mOldWidthMeasureSpec;
                    int n2 = view.mOldHeightMeasureSpec;
                    view2.measure(n, n2);
                }
            };
            l3 = ViewDebug.profileViewOperation(view, viewOperation);
        } else {
            l3 = 0L;
        }
        if (bl || (view.mPrivateFlags & 0x2000) != 0) {
            ViewOperation<Void> viewOperation = new ViewOperation<Void>(){

                public void post(Void ... voidArray) {
                }

                public Void[] pre() {
                    return null;
                }

                public void run(Void ... voidArray) {
                    View view2 = view;
                    int n = view.mLeft;
                    int n2 = view.mTop;
                    int n3 = view.mRight;
                    int n4 = view.mBottom;
                    view2.layout(n, n2, n3, n4);
                }
            };
            l2 = ViewDebug.profileViewOperation(view, viewOperation);
        } else {
            l2 = 0L;
        }
        if (bl || !view.willNotDraw() || (view.mPrivateFlags & 0x20) != 0) {
            ViewOperation<Object> viewOperation = new ViewOperation<Object>(){

                @Override
                public void post(Object ... objectArray) {
                    ((Bitmap)objectArray[0]).recycle();
                }

                @Override
                public Object[] pre() {
                    DisplayMetrics displayMetrics = view.getResources().getDisplayMetrics();
                    int n = displayMetrics.widthPixels;
                    int n2 = displayMetrics.heightPixels;
                    Bitmap.Config config = Bitmap.Config.RGB_565;
                    Bitmap bitmap = Bitmap.createBitmap(n, n2, config);
                    Canvas canvas = new Canvas(bitmap);
                    Object[] objectArray = new Object[]{bitmap, canvas};
                    return objectArray;
                }

                @Override
                public void run(Object ... objectArray) {
                    View view2 = view;
                    Canvas canvas = (Canvas)objectArray[1];
                    view2.draw(canvas);
                }
            };
            l = ViewDebug.profileViewOperation(view, viewOperation);
        } else {
            l = 0L;
        }
        String string2 = String.valueOf(l3);
        bufferedWriter.write(string2);
        bufferedWriter.write(32);
        String string3 = String.valueOf(l2);
        bufferedWriter.write(string3);
        bufferedWriter.write(32);
        String string4 = String.valueOf(l);
        bufferedWriter.write(string4);
        bufferedWriter.newLine();
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ViewDebug.profileViewAndChildren(viewGroup.getChildAt(n2), bufferedWriter, false);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> long profileViewOperation(View view, final ViewOperation<T> viewOperation) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(null, countDownLatch){
            final /* synthetic */ long[] val$duration;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$duration = lArray;
                this.val$latch = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    long l;
                    T[] TArray = viewOperation.pre();
                    long l2 = Debug.threadCpuTimeNanos();
                    viewOperation.run(TArray);
                    long[] lArray = this.val$duration;
                    lArray[0] = l = Debug.threadCpuTimeNanos() - l2;
                    viewOperation.post(TArray);
                    return;
                }
                finally {
                    this.val$latch.countDown();
                }
            }
        };
        boolean bl = view.post(runnable);
        try {
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            if (countDownLatch.await(4000L, timeUnit)) return (long)null[0];
            String string2 = "Could not complete the profiling of the view " + view;
            int n = Log.w("View", string2);
            return 65535L;
        }
        catch (InterruptedException interruptedException) {
            String string3 = "Could not complete the profiling of the view " + view;
            int n = Log.w("View", string3);
            Thread.currentThread().interrupt();
            return 65535L;
        }
    }

    private static void requestLayout(View view, String string2) {
        final View view2 = ViewDebug.findView(view, string2);
        if (view2 == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                view2.requestLayout();
            }
        };
        boolean bl = view.post(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object resolveId(Context context, int n) {
        Resources resources = context.getResources();
        if (n < 0) return "NO_ID";
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = resources.getResourceTypeName(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append('/');
            String string3 = resources.getResourceEntryName(n);
            String string4 = stringBuilder2.append(string3).toString();
            return string4;
        }
        catch (Resources.NotFoundException notFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("id/0x");
            String string5 = Integer.toHexString(n);
            return stringBuilder.append(string5).toString();
        }
    }

    public static void startHierarchyTracing(String string2, View view) {
    }

    public static void startMotionEventTracing(String string2, View view) {
    }

    public static void startRecyclerTracing(String string2, View view) {
    }

    public static void stopHierarchyTracing() {
    }

    public static void stopMotionEventTracing() {
    }

    public static void stopRecyclerTracing() {
    }

    public static void trace(View view, MotionEvent motionEvent, MotionEventTraceType motionEventTraceType) {
        if (sMotionEventTraces == null) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = sMotionEventTraces;
            String string2 = motionEventTraceType.name();
            bufferedWriter.write(string2);
            sMotionEventTraces.write(32);
            BufferedWriter bufferedWriter2 = sMotionEventTraces;
            int n = motionEvent.getAction();
            bufferedWriter2.write(n);
            sMotionEventTraces.write(32);
            BufferedWriter bufferedWriter3 = sMotionEventTraces;
            String string3 = view.getClass().getName();
            bufferedWriter3.write(string3);
            sMotionEventTraces.write(64);
            BufferedWriter bufferedWriter4 = sMotionEventTraces;
            String string4 = Integer.toHexString(view.hashCode());
            bufferedWriter4.write(string4);
            sHierarchyTraces.newLine();
            return;
        }
        catch (IOException iOException) {
            String string5 = "Error while dumping trace of event " + motionEvent + " for view " + view;
            int n = Log.w("View", string5);
            return;
        }
    }

    public static void trace(View view, HierarchyTraceType hierarchyTraceType) {
        if (sHierarchyTraces == null) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = sHierarchyTraces;
            String string2 = hierarchyTraceType.name();
            bufferedWriter.write(string2);
            sHierarchyTraces.write(32);
            BufferedWriter bufferedWriter2 = sHierarchyTraces;
            String string3 = view.getClass().getName();
            bufferedWriter2.write(string3);
            sHierarchyTraces.write(64);
            BufferedWriter bufferedWriter3 = sHierarchyTraces;
            String string4 = Integer.toHexString(view.hashCode());
            bufferedWriter3.write(string4);
            sHierarchyTraces.newLine();
            return;
        }
        catch (IOException iOException) {
            String string5 = "Error while dumping trace of type " + (Object)((Object)hierarchyTraceType) + " for view " + view;
            int n = Log.w("View", string5);
            return;
        }
    }

    public static void trace(View view, RecyclerTraceType recyclerTraceType, int ... nArray) {
        int n;
        int n2;
        if (sRecyclerOwnerView == null) {
            return;
        }
        if (sRecyclerViews == null) {
            return;
        }
        if (!sRecyclerViews.contains(view)) {
            boolean bl = sRecyclerViews.add(view);
        }
        int n3 = sRecyclerViews.indexOf(view);
        RecyclerTrace recyclerTrace = new RecyclerTrace();
        recyclerTrace.view = n3;
        recyclerTrace.type = recyclerTraceType;
        recyclerTrace.position = n2 = nArray[0];
        recyclerTrace.indexOnScreen = n = nArray[1];
        boolean bl = sRecyclerTraces.add(recyclerTrace);
    }

    private static void writeEntry(BufferedWriter bufferedWriter, String string2, String string3, String string4, Object object) throws IOException {
        bufferedWriter.write(string2);
        bufferedWriter.write(string3);
        bufferedWriter.write(string4);
        bufferedWriter.write("=");
        ViewDebug.writeValue(bufferedWriter, object);
        bufferedWriter.write(32);
    }

    private static void writeValue(BufferedWriter bufferedWriter, Object object) throws IOException {
        if (object != null) {
            String string2 = object.toString().replace("\n", "\\n");
            String string3 = String.valueOf(string2.length());
            bufferedWriter.write(string3);
            bufferedWriter.write(",");
            bufferedWriter.write(string2);
            return;
        }
        bufferedWriter.write("4,null");
    }

    static interface ViewOperation<T> {
        public void post(T ... var1);

        public T[] pre();

        public void run(T ... var1);
    }

    public static final class MotionEventTraceType
    extends Enum<MotionEventTraceType> {
        private static final /* synthetic */ MotionEventTraceType[] $VALUES;
        public static final /* enum */ MotionEventTraceType DISPATCH = new MotionEventTraceType();
        public static final /* enum */ MotionEventTraceType ON_INTERCEPT = new MotionEventTraceType();
        public static final /* enum */ MotionEventTraceType ON_TOUCH = new MotionEventTraceType();

        static {
            MotionEventTraceType motionEventTraceType = DISPATCH;
            MotionEventTraceType motionEventTraceType2 = ON_INTERCEPT;
            MotionEventTraceType motionEventTraceType3 = ON_TOUCH;
            MotionEventTraceType[] motionEventTraceTypeArray = new MotionEventTraceType[]{motionEventTraceType, motionEventTraceType2, motionEventTraceType3};
            $VALUES = motionEventTraceTypeArray;
        }

        public static MotionEventTraceType valueOf(String string2) {
            return Enum.valueOf(MotionEventTraceType.class, string2);
        }

        public static MotionEventTraceType[] values() {
            return (MotionEventTraceType[])$VALUES.clone();
        }
    }

    private static class RecyclerTrace {
        public int indexOnScreen;
        public int position;
        public RecyclerTraceType type;
        public int view;

        private RecyclerTrace() {
        }
    }

    public static final class RecyclerTraceType
    extends Enum<RecyclerTraceType> {
        private static final /* synthetic */ RecyclerTraceType[] $VALUES;
        public static final /* enum */ RecyclerTraceType BIND_VIEW;
        public static final /* enum */ RecyclerTraceType MOVE_FROM_ACTIVE_TO_SCRAP_HEAP;
        public static final /* enum */ RecyclerTraceType MOVE_TO_SCRAP_HEAP;
        public static final /* enum */ RecyclerTraceType NEW_VIEW;
        public static final /* enum */ RecyclerTraceType RECYCLE_FROM_ACTIVE_HEAP;
        public static final /* enum */ RecyclerTraceType RECYCLE_FROM_SCRAP_HEAP;

        static {
            NEW_VIEW = new RecyclerTraceType();
            BIND_VIEW = new RecyclerTraceType();
            RECYCLE_FROM_ACTIVE_HEAP = new RecyclerTraceType();
            RECYCLE_FROM_SCRAP_HEAP = new RecyclerTraceType();
            MOVE_TO_SCRAP_HEAP = new RecyclerTraceType();
            MOVE_FROM_ACTIVE_TO_SCRAP_HEAP = new RecyclerTraceType();
            RecyclerTraceType recyclerTraceType = NEW_VIEW;
            RecyclerTraceType recyclerTraceType2 = BIND_VIEW;
            RecyclerTraceType recyclerTraceType3 = RECYCLE_FROM_ACTIVE_HEAP;
            RecyclerTraceType recyclerTraceType4 = RECYCLE_FROM_SCRAP_HEAP;
            RecyclerTraceType recyclerTraceType5 = MOVE_TO_SCRAP_HEAP;
            RecyclerTraceType recyclerTraceType6 = MOVE_FROM_ACTIVE_TO_SCRAP_HEAP;
            RecyclerTraceType[] recyclerTraceTypeArray = new RecyclerTraceType[]{recyclerTraceType, recyclerTraceType2, recyclerTraceType3, recyclerTraceType4, recyclerTraceType5, recyclerTraceType6};
            $VALUES = recyclerTraceTypeArray;
        }

        public static RecyclerTraceType valueOf(String string2) {
            return Enum.valueOf(RecyclerTraceType.class, string2);
        }

        public static RecyclerTraceType[] values() {
            return (RecyclerTraceType[])$VALUES.clone();
        }
    }

    public static final class HierarchyTraceType
    extends Enum<HierarchyTraceType> {
        private static final /* synthetic */ HierarchyTraceType[] $VALUES;
        public static final /* enum */ HierarchyTraceType BUILD_CACHE;
        public static final /* enum */ HierarchyTraceType DRAW;
        public static final /* enum */ HierarchyTraceType INVALIDATE;
        public static final /* enum */ HierarchyTraceType INVALIDATE_CHILD;
        public static final /* enum */ HierarchyTraceType INVALIDATE_CHILD_IN_PARENT;
        public static final /* enum */ HierarchyTraceType ON_LAYOUT;
        public static final /* enum */ HierarchyTraceType ON_MEASURE;
        public static final /* enum */ HierarchyTraceType REQUEST_LAYOUT;

        static {
            INVALIDATE = new HierarchyTraceType();
            INVALIDATE_CHILD = new HierarchyTraceType();
            INVALIDATE_CHILD_IN_PARENT = new HierarchyTraceType();
            REQUEST_LAYOUT = new HierarchyTraceType();
            ON_LAYOUT = new HierarchyTraceType();
            ON_MEASURE = new HierarchyTraceType();
            DRAW = new HierarchyTraceType();
            BUILD_CACHE = new HierarchyTraceType();
            HierarchyTraceType hierarchyTraceType = INVALIDATE;
            HierarchyTraceType hierarchyTraceType2 = INVALIDATE_CHILD;
            HierarchyTraceType hierarchyTraceType3 = INVALIDATE_CHILD_IN_PARENT;
            HierarchyTraceType hierarchyTraceType4 = REQUEST_LAYOUT;
            HierarchyTraceType hierarchyTraceType5 = ON_LAYOUT;
            HierarchyTraceType hierarchyTraceType6 = ON_MEASURE;
            HierarchyTraceType hierarchyTraceType7 = DRAW;
            HierarchyTraceType hierarchyTraceType8 = BUILD_CACHE;
            HierarchyTraceType[] hierarchyTraceTypeArray = new HierarchyTraceType[]{hierarchyTraceType, hierarchyTraceType2, hierarchyTraceType3, hierarchyTraceType4, hierarchyTraceType5, hierarchyTraceType6, hierarchyTraceType7, hierarchyTraceType8};
            $VALUES = hierarchyTraceTypeArray;
        }

        public static HierarchyTraceType valueOf(String string2) {
            return Enum.valueOf(HierarchyTraceType.class, string2);
        }

        public static HierarchyTraceType[] values() {
            return (HierarchyTraceType[])$VALUES.clone();
        }
    }

    @AnnotationDefault(value=@CapturedViewProperty(retrieveReturn=false))
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface CapturedViewProperty {
        public boolean retrieveReturn();
    }

    @AnnotationDefault(value=@FlagToString(outputIf=true))
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FlagToString {
        public int equals();

        public int mask();

        public String name();

        public boolean outputIf();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface IntToString {
        public int from();

        public String to();
    }

    @AnnotationDefault(value=@ExportedProperty(category="", deepExport=false, flagMapping={}, indexMapping={}, mapping={}, prefix="", resolveId=false))
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface ExportedProperty {
        public String category();

        public boolean deepExport();

        public FlagToString[] flagMapping();

        public IntToString[] indexMapping();

        public IntToString[] mapping();

        public String prefix();

        public boolean resolveId();
    }
}

