/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewManager;
import android.view.ViewParent;
import android.view.ViewRoot;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Transformation;
import com.android.internal.R;
import java.util.ArrayList;

public abstract class ViewGroup
extends View
implements ViewParent,
ViewManager {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private static final int ARRAY_INITIAL_CAPACITY = 12;
    private static final int CHILD_LEFT_INDEX = 0;
    private static final int CHILD_TOP_INDEX = 1;
    protected static final int CLIP_TO_PADDING_MASK = 34;
    private static final boolean DBG = false;
    private static final int[] DESCENDANT_FOCUSABILITY_FLAGS = new int[]{131072, 262144, 393216};
    private static final int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    private static final int FLAG_ALPHA_LOWER_THAN_ONE = 4096;
    private static final int FLAG_ALWAYS_DRAWN_WITH_CACHE = 16384;
    private static final int FLAG_ANIMATION_CACHE = 64;
    private static final int FLAG_ANIMATION_DONE = 16;
    private static final int FLAG_CHILDREN_DRAWN_WITH_CACHE = 32768;
    private static final int FLAG_CLEAR_TRANSFORMATION = 256;
    private static final int FLAG_CLIP_CHILDREN = 1;
    private static final int FLAG_CLIP_TO_PADDING = 2;
    protected static final int FLAG_DISALLOW_INTERCEPT = 524288;
    private static final int FLAG_INVALIDATE_REQUIRED = 4;
    private static final int FLAG_MASK_FOCUSABILITY = 393216;
    private static final int FLAG_NOTIFY_ANIMATION_LISTENER = 512;
    private static final int FLAG_NOTIFY_CHILDREN_ON_DRAWABLE_STATE_CHANGE = 65536;
    private static final int FLAG_OPTIMIZE_INVALIDATE = 128;
    private static final int FLAG_PADDING_NOT_NULL = 32;
    private static final int FLAG_RUN_ANIMATION = 8;
    protected static final int FLAG_SUPPORT_STATIC_TRANSFORMATIONS = 2048;
    protected static final int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    public static final int FOCUS_AFTER_DESCENDANTS = 262144;
    public static final int FOCUS_BEFORE_DESCENDANTS = 131072;
    public static final int FOCUS_BLOCK_DESCENDANTS = 393216;
    public static final int PERSISTENT_ALL_CACHES = 3;
    public static final int PERSISTENT_ANIMATION_CACHE = 1;
    public static final int PERSISTENT_NO_CACHE = 0;
    public static final int PERSISTENT_SCROLLING_CACHE = 2;
    private Animation.AnimationListener mAnimationListener;
    private final Paint mCachePaint;
    private Transformation mChildTransformation;
    private View[] mChildren;
    private int mChildrenCount;
    protected ArrayList<View> mDisappearingChildren;
    private View mFocused;
    protected int mGroupFlags;
    private RectF mInvalidateRegion;
    private LayoutAnimationController mLayoutAnimationController;
    private View mMotionTarget;
    protected OnHierarchyChangeListener mOnHierarchyChangeListener;
    protected int mPersistentDrawingCache;
    private final Rect mTempRect;

    public ViewGroup(Context context) {
        super(context);
        Paint paint;
        Rect rect;
        this.mTempRect = rect = new Rect();
        this.mCachePaint = paint = new Paint();
        this.initViewGroup();
    }

    public ViewGroup(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Paint paint;
        Rect rect;
        this.mTempRect = rect = new Rect();
        this.mCachePaint = paint = new Paint();
        this.initViewGroup();
        this.initFromAttributes(context, attributeSet);
    }

    public ViewGroup(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Paint paint;
        Rect rect;
        this.mTempRect = rect = new Rect();
        this.mCachePaint = paint = new Paint();
        this.initViewGroup();
        this.initFromAttributes(context, attributeSet);
    }

    private void addDisappearingView(View view) {
        ArrayList<View> arrayList = this.mDisappearingChildren;
        if (arrayList == null) {
            this.mDisappearingChildren = arrayList = new ArrayList();
        }
        boolean bl = arrayList.add(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addInArray(View view, int n) {
        int n2;
        View[] viewArray = this.mChildren;
        int n3 = this.mChildrenCount;
        int n4 = viewArray.length;
        if (n != n3) {
            int n5;
            if (n4 != n3) {
                View[] viewArray2 = new View[n4 + 12];
                View[] viewArray3 = this.mChildren = viewArray2;
                System.arraycopy(viewArray, 0, viewArray3, 0, n4);
                viewArray = this.mChildren;
            }
            int n6 = this.mChildrenCount;
            this.mChildrenCount = n5 = n6 + 1;
            viewArray[n6] = view;
            return;
        }
        if (n >= n3) {
            String string2 = "index=" + n + " count=" + n3;
            throw new IndexOutOfBoundsException(string2);
        }
        if (n4 != n3) {
            View[] viewArray4 = new View[n4 + 12];
            View[] viewArray5 = this.mChildren = viewArray4;
            System.arraycopy(viewArray, 0, viewArray5, 0, n);
            View[] viewArray6 = this.mChildren;
            int n7 = n + 1;
            int n8 = n3 - n;
            System.arraycopy(viewArray, n, viewArray6, n7, n8);
            viewArray = this.mChildren;
        } else {
            int n9 = n + 1;
            int n10 = n3 - n;
            System.arraycopy(viewArray, n, viewArray, n9, n10);
        }
        viewArray[n] = view;
        this.mChildrenCount = n2 = this.mChildrenCount + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addViewInner(View view, int n, LayoutParams layoutParams, boolean bl) {
        int n2;
        View.AttachInfo attachInfo;
        if (view.getParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        if (bl) {
            view.mLayoutParams = layoutParams;
        } else {
            view.setLayoutParams(layoutParams);
        }
        if (n < 0) {
            n = this.mChildrenCount;
        }
        this.addInArray(view, n);
        if (bl) {
            view.assignParent(this);
        } else {
            view.mParent = this;
        }
        if (view.hasFocus()) {
            View view2 = view.findFocus();
            this.requestChildFocus(view, view2);
        }
        if ((attachInfo = this.mAttachInfo) != null) {
            boolean bl2 = attachInfo.mKeepScreenOn;
            attachInfo.mKeepScreenOn = false;
            View.AttachInfo attachInfo2 = this.mAttachInfo;
            int n3 = this.mViewFlags & 0xC;
            view.dispatchAttachedToWindow(attachInfo2, n3);
            if (attachInfo.mKeepScreenOn) {
                this.needGlobalAttributesUpdate(true);
            }
            attachInfo.mKeepScreenOn = bl2;
        }
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewAdded(this, view);
        }
        if ((view.mViewFlags & 0x400000) != 0x400000) {
            return;
        }
        this.mGroupFlags = n2 = this.mGroupFlags | 0x10000;
    }

    private void bindLayoutAnimation(View view) {
        Animation animation = this.mLayoutAnimationController.getAnimationForView(view);
        view.setAnimation(animation);
    }

    private void finishAnimatingView(View view, Animation animation) {
        int n;
        int n2;
        ArrayList<View> arrayList = this.mDisappearingChildren;
        if (arrayList != null && arrayList.contains(view)) {
            int n3;
            boolean bl = arrayList.remove(view);
            if (view.mAttachInfo != null) {
                view.dispatchDetachedFromWindow();
            }
            view.clearAnimation();
            this.mGroupFlags = n3 = this.mGroupFlags | 4;
        }
        if (animation != null && !animation.getFillAfter()) {
            view.clearAnimation();
        }
        if ((view.mPrivateFlags & 0x10000) != 65536) {
            return;
        }
        view.onAnimationEnd();
        view.mPrivateFlags = n2 = view.mPrivateFlags & 0xFFFEFFFF;
        this.mGroupFlags = n = this.mGroupFlags | 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getChildMeasureSpec(int n, int n2, int n3) {
        int n4 = View.MeasureSpec.getMode(n);
        int n5 = View.MeasureSpec.getSize(n) - n2;
        int n6 = Math.max(0, n5);
        int n7 = 0;
        int n8 = 0;
        switch (n4) {
            case 0x40000000: {
                if (n3 >= 0) {
                    n7 = n3;
                    n8 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n8);
                }
                if (n3 == -1) {
                    n7 = n6;
                    n8 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n8);
                }
                if (n3 != -1) return View.MeasureSpec.makeMeasureSpec(n7, n8);
                n7 = n6;
                n8 = Integer.MIN_VALUE;
                return View.MeasureSpec.makeMeasureSpec(n7, n8);
            }
            case -2147483648: {
                if (n3 >= 0) {
                    n7 = n3;
                    n8 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n8);
                }
                if (n3 == -1) {
                    n7 = n6;
                    n8 = Integer.MIN_VALUE;
                    return View.MeasureSpec.makeMeasureSpec(n7, n8);
                }
                if (n3 != -1) return View.MeasureSpec.makeMeasureSpec(n7, n8);
                n7 = n6;
                n8 = Integer.MIN_VALUE;
                return View.MeasureSpec.makeMeasureSpec(n7, n8);
            }
            case 0: {
                if (n3 >= 0) {
                    n7 = n3;
                    n8 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n8);
                }
                if (n3 == -1) {
                    n7 = 0;
                    n8 = 0;
                    return View.MeasureSpec.makeMeasureSpec(n7, n8);
                }
                if (n3 != -1) return View.MeasureSpec.makeMeasureSpec(n7, n8);
                n7 = 0;
                n8 = 0;
                return View.MeasureSpec.makeMeasureSpec(n7, n8);
            }
        }
        return View.MeasureSpec.makeMeasureSpec(n7, n8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initFromAttributes(Context context, AttributeSet attributeSet) {
        int[] nArray = R.styleable.ViewGroup;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        int n = typedArray.getIndexCount();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                typedArray.recycle();
                return;
            }
            int n3 = typedArray.getIndex(n2);
            switch (n3) {
                case 0: {
                    boolean bl = typedArray.getBoolean(n3, true);
                    this.setClipChildren(bl);
                    break;
                }
                case 1: {
                    boolean bl = typedArray.getBoolean(n3, true);
                    this.setClipToPadding(bl);
                    break;
                }
                case 3: {
                    boolean bl = typedArray.getBoolean(n3, true);
                    this.setAnimationCacheEnabled(bl);
                    break;
                }
                case 4: {
                    int n4 = typedArray.getInt(n3, 2);
                    this.setPersistentDrawingCache(n4);
                    break;
                }
                case 6: {
                    boolean bl = typedArray.getBoolean(n3, false);
                    this.setAddStatesFromChildren(bl);
                    break;
                }
                case 5: {
                    boolean bl = typedArray.getBoolean(n3, true);
                    this.setAlwaysDrawnWithCacheEnabled(bl);
                    break;
                }
                case 2: {
                    int n5 = typedArray.getResourceId(n3, -1);
                    if (n5 <= 0) break;
                    LayoutAnimationController layoutAnimationController = AnimationUtils.loadLayoutAnimation(this.mContext, n5);
                    this.setLayoutAnimation(layoutAnimationController);
                    break;
                }
                case 7: {
                    int[] nArray2 = DESCENDANT_FOCUSABILITY_FLAGS;
                    int n6 = typedArray.getInt(n3, 0);
                    int n7 = nArray2[n6];
                    this.setDescendantFocusability(n7);
                    break;
                }
            }
            ++n2;
        }
    }

    private void initViewGroup() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.setFlags(128, 128);
        this.mGroupFlags = n5 = this.mGroupFlags | 1;
        this.mGroupFlags = n4 = this.mGroupFlags | 2;
        this.mGroupFlags = n3 = this.mGroupFlags | 0x10;
        this.mGroupFlags = n2 = this.mGroupFlags | 0x40;
        this.mGroupFlags = n = this.mGroupFlags | 0x4000;
        this.setDescendantFocusability(131072);
        View[] viewArray = new View[12];
        this.mChildren = viewArray;
        this.mChildrenCount = 0;
        this.mCachePaint.setDither(false);
        this.mPersistentDrawingCache = 2;
    }

    private void notifyAnimationListener() {
        int n;
        int n2;
        this.mGroupFlags = n2 = this.mGroupFlags & 0xFFFFFDFF;
        this.mGroupFlags = n = this.mGroupFlags | 0x10;
        if (this.mAnimationListener != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Animation.AnimationListener animationListener = ViewGroup.this.mAnimationListener;
                    Animation animation = ViewGroup.this.mLayoutAnimationController.getAnimation();
                    animationListener.onAnimationEnd(animation);
                }
            };
            boolean bl = this.post(runnable);
        }
        if ((this.mGroupFlags & 0x40) == 64) {
            int n3;
            this.mGroupFlags = n3 = this.mGroupFlags & 0xFFFF7FFF;
            if ((this.mPersistentDrawingCache & 1) == 0) {
                this.setChildrenDrawingCacheEnabled(false);
            }
        }
        this.invalidate();
    }

    private void removeFromArray(int n) {
        View[] viewArray = this.mChildren;
        viewArray[n].mParent = null;
        int n2 = this.mChildrenCount;
        int n3 = n2 - 1;
        if (n != n3) {
            int n4;
            this.mChildrenCount = n4 = this.mChildrenCount - 1;
            viewArray[n4] = null;
            return;
        }
        if (n >= 0 && n < n2) {
            int n5;
            int n6 = n + 1;
            int n7 = n2 - n - 1;
            System.arraycopy(viewArray, n6, viewArray, n, n7);
            this.mChildrenCount = n5 = this.mChildrenCount - 1;
            viewArray[n5] = null;
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    private void removeFromArray(int n, int n2) {
        int n3;
        int n4;
        int n5;
        View[] viewArray = this.mChildren;
        int n6 = this.mChildrenCount;
        int n7 = Math.max(0, n);
        if (n7 != (n5 = Math.min(n6, n4 = n7 + n2))) {
            return;
        }
        if (n5 != n6) {
            for (int i = n7; i < n5; ++i) {
                viewArray[i].mParent = null;
                viewArray[i] = null;
            }
        } else {
            for (int i = n7; i < n5; ++i) {
                viewArray[i].mParent = null;
            }
            int n8 = n6 - n5;
            System.arraycopy(viewArray, n5, viewArray, n7, n8);
            int n9 = n5 - n7;
            for (int i = n6 - n9; i < n6; ++i) {
                viewArray[i] = null;
            }
        }
        int n10 = this.mChildrenCount;
        int n11 = n5 - n7;
        this.mChildrenCount = n3 = n10 - n11;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeViewInternal(int n, View view) {
        boolean bl = false;
        View view2 = this.mFocused;
        if (view == view2) {
            view.clearFocusForRemoval();
            bl = true;
        }
        if (view.getAnimation() != null) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewRemoved(this, view);
        }
        this.needGlobalAttributesUpdate(false);
        this.removeFromArray(n);
        if (!bl) {
            return;
        }
        this.clearChildFocus(view);
    }

    private void removeViewInternal(View view) {
        int n = this.indexOfChild(view);
        if (n < 0) {
            return;
        }
        this.removeViewInternal(n, view);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeViewsInternal(int n, int n2) {
        OnHierarchyChangeListener onHierarchyChangeListener = this.mOnHierarchyChangeListener;
        boolean bl = onHierarchyChangeListener != null;
        View view = this.mFocused;
        boolean bl2 = this.mAttachInfo != null;
        View view2 = null;
        View[] viewArray = this.mChildren;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            View view3 = viewArray[i];
            if (view3 == view) {
                view3.clearFocusForRemoval();
                view2 = view3;
            }
            if (view3.getAnimation() != null) {
                this.addDisappearingView(view3);
            } else if (bl2) {
                view3.dispatchDetachedFromWindow();
            }
            this.needGlobalAttributesUpdate(false);
            if (!bl) continue;
            onHierarchyChangeListener.onChildViewRemoved(this, view3);
        }
        this.removeFromArray(n, n2);
        if (view2 == null) {
            return;
        }
        this.clearChildFocus(view2);
    }

    private void setBooleanFlag(int n, boolean bl) {
        int n2;
        if (bl) {
            int n3;
            this.mGroupFlags = n3 = this.mGroupFlags | n;
            return;
        }
        int n4 = this.mGroupFlags;
        int n5 = ~n;
        this.mGroupFlags = n2 = n4 & n5;
    }

    @Override
    public void addFocusables(ArrayList<View> arrayList, int n) {
        this.addFocusables(arrayList, n, 1);
    }

    @Override
    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        int n3;
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            int n6 = this.mChildrenCount;
            View[] viewArray = this.mChildren;
            for (int i = 0; i < n6; ++i) {
                View view = viewArray[i];
                if ((view.mViewFlags & 0xC) != 0) continue;
                view.addFocusables(arrayList, n, n2);
            }
        }
        if (n5 == 262144 && n4 != (n3 = arrayList.size())) {
            return;
        }
        super.addFocusables(arrayList, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addStatesFromChildren() {
        if ((this.mGroupFlags & 0x2000) == 0) return false;
        return true;
    }

    @Override
    public void addTouchables(ArrayList<View> arrayList) {
        super.addTouchables(arrayList);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            View view = viewArray[n2];
            if ((view.mViewFlags & 0xC) == 0) {
                view.addTouchables(arrayList);
            }
            ++n2;
        }
        return;
    }

    public void addView(View view) {
        this.addView(view, -1);
    }

    public void addView(View view, int n) {
        LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null && (layoutParams = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addView(view, n, layoutParams);
    }

    public void addView(View view, int n, int n2) {
        LayoutParams layoutParams = this.generateDefaultLayoutParams();
        layoutParams.width = n;
        layoutParams.height = n2;
        this.addView(view, -1, layoutParams);
    }

    public void addView(View view, int n, LayoutParams layoutParams) {
        this.requestLayout();
        this.invalidate();
        this.addViewInner(view, n, layoutParams, false);
    }

    @Override
    public void addView(View view, LayoutParams layoutParams) {
        this.addView(view, -1, layoutParams);
    }

    protected boolean addViewInLayout(View view, int n, LayoutParams layoutParams) {
        return this.addViewInLayout(view, n, layoutParams, false);
    }

    protected boolean addViewInLayout(View view, int n, LayoutParams layoutParams, boolean bl) {
        int n2;
        view.mParent = null;
        this.addViewInner(view, n, layoutParams, bl);
        view.mPrivateFlags = n2 = view.mPrivateFlags & 0xFF9FFFFF | 0x20;
        return true;
    }

    protected void attachLayoutAnimationParameters(View view, LayoutParams layoutParams, int n, int n2) {
        LayoutAnimationController.AnimationParameters animationParameters = layoutParams.layoutAnimationParameters;
        if (animationParameters == null) {
            layoutParams.layoutAnimationParameters = animationParameters = new LayoutAnimationController.AnimationParameters();
        }
        animationParameters.count = n2;
        animationParameters.index = n;
    }

    protected void attachViewToParent(View view, int n, LayoutParams layoutParams) {
        int n2;
        view.mLayoutParams = layoutParams;
        if (n < 0) {
            n = this.mChildrenCount;
        }
        this.addInArray(view, n);
        view.mParent = this;
        view.mPrivateFlags = n2 = view.mPrivateFlags & 0xFF9FFFFF & 0xFFFF7FFF | 0x20;
        if (!view.hasFocus()) {
            return;
        }
        View view2 = view.findFocus();
        this.requestChildFocus(view, view2);
    }

    @Override
    public void bringChildToFront(View view) {
        int n = this.indexOfChild(view);
        if (n < 0) {
            return;
        }
        this.removeFromArray(n);
        int n2 = this.mChildrenCount;
        this.addInArray(view, n2);
        view.mParent = this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canAnimate() {
        if (this.mLayoutAnimationController == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(LayoutParams layoutParams) {
        if (layoutParams == null) return false;
        return true;
    }

    @Override
    public void childDrawableStateChanged(View view) {
        if ((this.mGroupFlags & 0x2000) == 0) {
            return;
        }
        this.refreshDrawableState();
    }

    protected void cleanupLayoutState(View view) {
        int n;
        view.mPrivateFlags = n = view.mPrivateFlags & 0xFFFFEFFF;
    }

    @Override
    public void clearChildFocus(View view) {
        this.mFocused = null;
        if (this.mParent == null) {
            return;
        }
        this.mParent.clearChildFocus(this);
    }

    public void clearDisappearingChildren() {
        if (this.mDisappearingChildren == null) {
            return;
        }
        this.mDisappearingChildren.clear();
    }

    @Override
    public void clearFocus() {
        super.clearFocus();
        if (this.mFocused == null) {
            return;
        }
        this.mFocused.clearFocus();
    }

    @Override
    Bitmap createSnapshot(Bitmap.Config config, int n, boolean bl) {
        int n2;
        int n3 = this.mChildrenCount;
        int[] nArray = null;
        if (bl) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                View view = this.getChildAt(n2);
                nArray[n2] = n4 = view.getVisibility();
                if (nArray[n2] != 0) continue;
                view.setVisibility(4);
            }
        }
        Bitmap bitmap = super.createSnapshot(config, n, bl);
        if (bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                View view = this.getChildAt(n2);
                int n5 = nArray[n2];
                view.setVisibility(n5);
            }
        }
        return bitmap;
    }

    @Override
    protected void debug(int n) {
        super.debug(n);
        if (this.mFocused != null) {
            String string2 = ViewGroup.debugIndent(n);
            String string3 = string2 + "mFocused";
            int n2 = Log.d("View", string3);
        }
        if (this.mChildrenCount != 0) {
            String string4 = ViewGroup.debugIndent(n);
            String string5 = string4 + "{";
            int n3 = Log.d("View", string5);
        }
        int n4 = this.mChildrenCount;
        for (int i = 0; i < n4; ++i) {
            View view = this.mChildren[i];
            int n5 = n + 1;
            view.debug(n5);
        }
        if (this.mChildrenCount == 0) {
            return;
        }
        String string6 = ViewGroup.debugIndent(n);
        String string7 = string6 + "}";
        int n6 = Log.d("View", string7);
    }

    protected void detachAllViewsFromParent() {
        int n = this.mChildrenCount;
        if (n <= 0) {
            return;
        }
        View[] viewArray = this.mChildren;
        this.mChildrenCount = 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            viewArray[n2].mParent = null;
            viewArray[n2] = null;
            n2 += -1;
        }
        return;
    }

    protected void detachViewFromParent(int n) {
        this.removeFromArray(n);
    }

    protected void detachViewFromParent(View view) {
        int n = this.indexOfChild(view);
        this.removeFromArray(n);
    }

    protected void detachViewsFromParent(int n, int n2) {
        this.removeFromArray(n, n2);
    }

    @Override
    void dispatchAttachedToWindow(View.AttachInfo attachInfo, int n) {
        super.dispatchAttachedToWindow(attachInfo, n);
        int n2 = this.mViewFlags & 0xC;
        int n3 = n | n2;
        int n4 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n5 = 0;
        while (n5 < n4) {
            viewArray[n5].dispatchAttachedToWindow(attachInfo, n3);
            ++n5;
        }
        return;
    }

    @Override
    void dispatchCollectViewAttributes(int n) {
        int n2 = this.mViewFlags & 0xC;
        int n3 = n | n2;
        super.dispatchCollectViewAttributes(n3);
        int n4 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n5 = 0;
        while (n5 < n4) {
            viewArray[n5].dispatchCollectViewAttributes(n3);
            ++n5;
        }
        return;
    }

    @Override
    public void dispatchConfigurationChanged(Configuration configuration) {
        super.dispatchConfigurationChanged(configuration);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].dispatchConfigurationChanged(configuration);
            ++n2;
        }
        return;
    }

    @Override
    protected boolean dispatchConsistencyCheck(int n) {
        boolean bl = super.dispatchConsistencyCheck(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            if (viewArray[i].dispatchConsistencyCheck(n)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    void dispatchDetachedFromWindow() {
        if (this.mMotionTarget != null) {
            long l;
            long l2 = l = SystemClock.uptimeMillis();
            float f = 0.0f;
            MotionEvent motionEvent = MotionEvent.obtain(l, l2, 3, 0.0f, f, 0);
            boolean bl = this.mMotionTarget.dispatchTouchEvent(motionEvent);
            motionEvent.recycle();
            this.mMotionTarget = null;
        }
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchDetachedFromWindow();
        }
        super.dispatchDetachedFromWindow();
    }

    @Override
    public void dispatchDisplayHint(int n) {
        super.dispatchDisplayHint(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n3 = 0;
        while (n3 < n2) {
            viewArray[n3].dispatchDisplayHint(n);
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        1 var105_101;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n9 = this.mGroupFlags;
        if ((n9 & 8) != 0 && this.canAnimate()) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14 = this.mGroupFlags & 0x40;
            int n15 = 64;
            boolean bl = n14 == n15;
            int n16 = 0;
            while ((n13 = ++n16) < (n12 = n8)) {
                View view = viewArray[n16];
                if ((view.mViewFlags & 0xC) != 0) continue;
                LayoutParams layoutParams = view.getLayoutParams();
                ViewGroup viewGroup = this;
                View view2 = view;
                LayoutParams layoutParams2 = layoutParams;
                int n17 = n16;
                int n18 = n8;
                viewGroup.attachLayoutAnimationParameters(view2, layoutParams2, n17, n18);
                ViewGroup viewGroup2 = this;
                View view3 = view;
                viewGroup2.bindLayoutAnimation(view3);
                if (!bl) continue;
                View view4 = view;
                boolean bl2 = true;
                view4.setDrawingCacheEnabled(bl2);
                View view5 = view;
                boolean bl3 = true;
                view5.buildDrawingCache(bl3);
            }
            LayoutAnimationController layoutAnimationController = this.mLayoutAnimationController;
            if (layoutAnimationController.willOverlap()) {
                int n19;
                this.mGroupFlags = n19 = this.mGroupFlags | 0x80;
            }
            layoutAnimationController.start();
            this.mGroupFlags = n11 = this.mGroupFlags & 0xFFFFFFF7;
            this.mGroupFlags = n10 = this.mGroupFlags & 0xFFFFFFEF;
            if (bl) {
                int n20;
                this.mGroupFlags = n20 = this.mGroupFlags | 0x8000;
            }
            if (this.mAnimationListener != null) {
                Animation.AnimationListener animationListener = this.mAnimationListener;
                Animation animation = layoutAnimationController.getAnimation();
                animationListener.onAnimationStart(animation);
            }
        }
        int n21 = 0;
        int n22 = n9 & 0x22;
        int n23 = 34;
        boolean bl = n22 == n23;
        if (bl) {
            n21 = canvas.save();
            int n24 = this.mScrollX;
            int n25 = this.mPaddingLeft;
            int n26 = n24 + n25;
            int n27 = this.mScrollY;
            int n28 = this.mPaddingTop;
            int n29 = n27 + n28;
            int n30 = this.mScrollX;
            int n31 = this.mRight;
            int n32 = n30 + n31;
            int n33 = this.mLeft;
            int n34 = n32 - n33;
            int n35 = this.mPaddingRight;
            int n36 = n34 - n35;
            int n37 = this.mScrollY;
            int n38 = this.mBottom;
            int n39 = n37 + n38;
            int n40 = this.mTop;
            int n41 = n39 - n40;
            int n42 = this.mPaddingBottom;
            int n43 = n41 - n42;
            Canvas canvas2 = canvas;
            int n44 = n26;
            int n45 = n29;
            int n46 = n36;
            int n47 = n43;
            boolean bl4 = canvas2.clipRect(n44, n45, n46, n47);
        }
        this.mPrivateFlags = n7 = this.mPrivateFlags & 0xFFFFFFBF;
        this.mGroupFlags = n6 = this.mGroupFlags & 0xFFFFFFFB;
        boolean bl5 = false;
        long l = this.getDrawingTime();
        if ((n9 & 0x400) == 0) {
            int n48;
            int n49;
            n5 = 0;
            while ((n49 = ++n5) < (n48 = n8)) {
                View view = viewArray[n5];
                if ((view.mViewFlags & 0xC) != 0 && view.getAnimation() == null) continue;
                ViewGroup viewGroup = this;
                Canvas canvas3 = canvas;
                View view6 = view;
                long l2 = l;
                boolean bl6 = viewGroup.drawChild(canvas3, view6, l2);
                bl5 |= bl6;
            }
        } else {
            int n50;
            int n51;
            n5 = 0;
            while ((n51 = ++n5) < (n50 = n8)) {
                ViewGroup viewGroup = this;
                int n52 = n8;
                int n53 = n5;
                int n54 = viewGroup.getChildDrawingOrder(n52, n53);
                View view = viewArray[n54];
                if ((view.mViewFlags & 0xC) != 0 && view.getAnimation() == null) continue;
                ViewGroup viewGroup3 = this;
                Canvas canvas4 = canvas;
                View view7 = view;
                long l3 = l;
                boolean bl7 = viewGroup3.drawChild(canvas4, view7, l3);
                bl5 |= bl7;
            }
        }
        if (this.mDisappearingChildren != null) {
            boolean bl8;
            ArrayList<View> arrayList = this.mDisappearingChildren;
            for (n5 = arrayList.size() - 1; n5 >= 0; bl5 |= bl8, n5 += -1) {
                ArrayList<View> arrayList2 = arrayList;
                int n55 = n5;
                View view = arrayList2.get(n55);
                ViewGroup viewGroup = this;
                Canvas canvas5 = canvas;
                View view8 = view;
                long l4 = l;
                bl8 = viewGroup.drawChild(canvas5, view8, l4);
            }
        }
        if (bl) {
            Canvas canvas6 = canvas;
            int n56 = n21;
            canvas6.restoreToCount(n56);
        }
        if ((n4 = (n3 = this.mGroupFlags) & 4) == (n2 = 4)) {
            this.invalidate();
        }
        if ((n3 & 0x10) != 0) {
            return;
        }
        if ((n3 & 0x200) != 0) {
            return;
        }
        if (!this.mLayoutAnimationController.isDone()) {
            return;
        }
        if (bl5) {
            return;
        }
        this.mGroupFlags = n = this.mGroupFlags | 0x200;
        1 var106_102 = var105_101;
        ViewGroup viewGroup = this;
        var106_102();
        ViewGroup viewGroup4 = this;
        1 var109_105 = var105_101;
        boolean bl9 = viewGroup4.post(var109_105);
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        super.dispatchFinishTemporaryDetach();
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].dispatchFinishTemporaryDetach();
            ++n2;
        }
        return;
    }

    protected void dispatchFreezeSelfOnly(SparseArray<Parcelable> sparseArray) {
        super.dispatchSaveInstanceState(sparseArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyEvent(keyEvent);
        }
        if (this.mFocused == null) return false;
        if ((this.mFocused.mPrivateFlags & 0x10) != 16) return false;
        return this.mFocused.dispatchKeyEvent(keyEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyEventPreIme(KeyEvent keyEvent) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyEventPreIme(keyEvent);
        }
        if (this.mFocused == null) return false;
        if ((this.mFocused.mPrivateFlags & 0x10) != 16) return false;
        return this.mFocused.dispatchKeyEventPreIme(keyEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyShortcutEvent(keyEvent);
        }
        if (this.mFocused == null) return false;
        if ((this.mFocused.mPrivateFlags & 0x10) != 16) return false;
        return this.mFocused.dispatchKeyShortcutEvent(keyEvent);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        boolean bl = false;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            boolean bl2 = this.getChildAt(i).dispatchPopulateAccessibilityEvent(accessibilityEvent);
            bl |= bl2;
        }
        return bl;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        super.dispatchRestoreInstanceState(sparseArray);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].dispatchRestoreInstanceState(sparseArray);
            ++n2;
        }
        return;
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        super.dispatchSaveInstanceState(sparseArray);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].dispatchSaveInstanceState(sparseArray);
            ++n2;
        }
        return;
    }

    @Override
    protected void dispatchSetPressed(boolean bl) {
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].setPressed(bl);
            ++n2;
        }
        return;
    }

    @Override
    public void dispatchSetSelected(boolean bl) {
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].setSelected(bl);
            ++n2;
        }
        return;
    }

    @Override
    public void dispatchStartTemporaryDetach() {
        super.dispatchStartTemporaryDetach();
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].dispatchStartTemporaryDetach();
            ++n2;
        }
        return;
    }

    protected void dispatchThawSelfOnly(SparseArray<Parcelable> sparseArray) {
        super.dispatchRestoreInstanceState(sparseArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        View view;
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        if (!this.onFilterTouchEventForSecurity(motionEvent)) {
            return false;
        }
        int n5 = motionEvent.getAction();
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        float f3 = this.mScrollX;
        float f4 = f + f3;
        float f5 = this.mScrollY;
        float f6 = f2 + f5;
        Rect rect = this.mTempRect;
        boolean bl2 = (this.mGroupFlags & 0x80000) != 0;
        if (n5 == 0) {
            if (this.mMotionTarget != null) {
                Object var12_12 = null;
                this.mMotionTarget = var12_12;
            }
            if (bl2 || !this.onInterceptTouchEvent(motionEvent)) {
                MotionEvent motionEvent2 = motionEvent;
                int n6 = 0;
                motionEvent2.setAction(n6);
                int n7 = (int)f4;
                int n8 = (int)f6;
                View[] viewArray = this.mChildren;
                for (int i = this.mChildrenCount - 1; i >= 0; i += -1) {
                    View view2;
                    int n9;
                    View view3 = viewArray[i];
                    if ((view3.mViewFlags & 0xC) != 0 && view3.getAnimation() == null) continue;
                    view3.getHitRect(rect);
                    if (!rect.contains(n7, n8)) continue;
                    float f7 = view3.mLeft;
                    float f8 = f4 - f7;
                    float f9 = view3.mTop;
                    float f10 = f6 - f9;
                    MotionEvent motionEvent3 = motionEvent;
                    float f11 = f8;
                    float f12 = f10;
                    motionEvent3.setLocation(f11, f12);
                    view3.mPrivateFlags = n9 = view3.mPrivateFlags & 0xFBFFFFFF;
                    View view4 = view3;
                    MotionEvent motionEvent4 = motionEvent;
                    if (!view4.dispatchTouchEvent(motionEvent4)) continue;
                    this.mMotionTarget = view2 = view3;
                    return true;
                }
            }
        }
        if (bl = (n4 = n5) == (n3 = 1) || (n2 = n5) == (n = 3)) {
            int n10;
            this.mGroupFlags = n10 = this.mGroupFlags & 0xFFF7FFFF;
        }
        if ((view = this.mMotionTarget) == null) {
            int n11;
            MotionEvent motionEvent5 = motionEvent;
            float f13 = f;
            float f14 = f2;
            motionEvent5.setLocation(f13, f14);
            if ((this.mPrivateFlags & 0x4000000) == 0) return super.dispatchTouchEvent(motionEvent);
            MotionEvent motionEvent6 = motionEvent;
            int n12 = 3;
            motionEvent6.setAction(n12);
            this.mPrivateFlags = n11 = this.mPrivateFlags & 0xFBFFFFFF;
            return super.dispatchTouchEvent(motionEvent);
        }
        if (!bl2 && this.onInterceptTouchEvent(motionEvent)) {
            int n13;
            float f15 = view.mLeft;
            float f16 = f4 - f15;
            float f17 = view.mTop;
            float f18 = f6 - f17;
            this.mPrivateFlags = n13 = this.mPrivateFlags & 0xFBFFFFFF;
            MotionEvent motionEvent7 = motionEvent;
            int n14 = 3;
            motionEvent7.setAction(n14);
            MotionEvent motionEvent8 = motionEvent;
            float f19 = f16;
            float f20 = f18;
            motionEvent8.setLocation(f19, f20);
            View view5 = view;
            MotionEvent motionEvent9 = motionEvent;
            if (!view5.dispatchTouchEvent(motionEvent9)) {
                // empty if block
            }
            Object var56_56 = null;
            this.mMotionTarget = var56_56;
            return true;
        }
        if (bl) {
            Object var57_57 = null;
            this.mMotionTarget = var57_57;
        }
        float f21 = view.mLeft;
        float f22 = f4 - f21;
        float f23 = view.mTop;
        float f24 = f6 - f23;
        MotionEvent motionEvent10 = motionEvent;
        float f25 = f22;
        float f26 = f24;
        motionEvent10.setLocation(f25, f26);
        if ((view.mPrivateFlags & 0x4000000) != 0) {
            int n15;
            MotionEvent motionEvent11 = motionEvent;
            int n16 = 3;
            motionEvent11.setAction(n16);
            view.mPrivateFlags = n15 = view.mPrivateFlags & 0xFBFFFFFF;
            Object var68_68 = null;
            this.mMotionTarget = var68_68;
        }
        View view6 = view;
        MotionEvent motionEvent12 = motionEvent;
        return view6.dispatchTouchEvent(motionEvent12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchTrackballEvent(motionEvent);
        }
        if (this.mFocused == null) return false;
        if ((this.mFocused.mPrivateFlags & 0x10) != 16) return false;
        return this.mFocused.dispatchTrackballEvent(motionEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchUnhandledMove(View view, int n) {
        if (this.mFocused == null) return false;
        if (!this.mFocused.dispatchUnhandledMove(view, n)) return false;
        return true;
    }

    @Override
    protected void dispatchVisibilityChanged(View view, int n) {
        super.dispatchVisibilityChanged(view, n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n3 = 0;
        while (n3 < n2) {
            viewArray[n3].dispatchVisibilityChanged(view, n);
            ++n3;
        }
        return;
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        super.dispatchWindowFocusChanged(bl);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].dispatchWindowFocusChanged(bl);
            ++n2;
        }
        return;
    }

    @Override
    public void dispatchWindowVisibilityChanged(int n) {
        super.dispatchWindowVisibilityChanged(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n3 = 0;
        while (n3 < n2) {
            viewArray[n3].dispatchWindowVisibilityChanged(n);
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l) {
        Canvas.EdgeType edgeType;
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        boolean bl;
        Animation animation;
        Transformation transformation;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl2;
        block41: {
            block40: {
                int n7;
                RectF rectF;
                block42: {
                    bl2 = false;
                    n6 = view.mLeft;
                    n5 = view.mTop;
                    n4 = view.mRight;
                    n3 = view.mBottom;
                    n2 = this.mGroupFlags;
                    if ((n2 & 0x100) == 256) {
                        int n8;
                        if (this.mChildTransformation != null) {
                            this.mChildTransformation.clear();
                        }
                        this.mGroupFlags = n8 = this.mGroupFlags & 0xFFFFFEFF;
                    }
                    transformation = null;
                    animation = view.getAnimation();
                    bl = false;
                    if (animation == null) break block40;
                    if (this.mInvalidateRegion == null) {
                        RectF rectF2;
                        this.mInvalidateRegion = rectF2 = new RectF();
                    }
                    rectF = this.mInvalidateRegion;
                    if (!animation.isInitialized()) {
                        int n9 = n4 - n6;
                        int n10 = n3 - n5;
                        int n11 = this.getWidth();
                        int n12 = this.getHeight();
                        animation.initialize(n9, n10, n11, n12);
                        int n13 = n4 - n6;
                        int n14 = n3 - n5;
                        animation.initializeInvalidateRegion(0, 0, n13, n14);
                        view.onAnimationStart();
                    }
                    if (this.mChildTransformation == null) {
                        Transformation transformation2;
                        this.mChildTransformation = transformation2 = new Transformation();
                    }
                    Transformation transformation3 = this.mChildTransformation;
                    Animation animation2 = animation;
                    long l2 = l;
                    Transformation transformation4 = transformation3;
                    bl2 = animation2.getTransformation(l2, transformation4);
                    transformation = this.mChildTransformation;
                    bl = animation.willChangeTransformationMatrix();
                    if (!bl2) break block41;
                    if (animation.willChangeBounds()) break block42;
                    if ((n2 & 0x90) == 128) {
                        int n15;
                        this.mGroupFlags = n15 = this.mGroupFlags | 4;
                        break block41;
                    } else if ((n2 & 4) == 0) {
                        int n16;
                        this.mPrivateFlags = n16 = this.mPrivateFlags | 0x40;
                        ViewGroup viewGroup = this;
                        int n17 = n6;
                        int n18 = n5;
                        int n19 = n4;
                        int n20 = n3;
                        viewGroup.invalidate(n17, n18, n19, n20);
                    }
                    break block41;
                }
                int n21 = n4 - n6;
                int n22 = n3 - n5;
                animation.getInvalidateRegion(0, 0, n21, n22, rectF, transformation);
                this.mPrivateFlags = n7 = this.mPrivateFlags | 0x40;
                int n23 = (int)rectF.left;
                int n24 = n6 + n23;
                int n25 = (int)rectF.top;
                int n26 = n5 + n25;
                int n27 = (int)rectF.width() + n24;
                int n28 = (int)rectF.height() + n26;
                ViewGroup viewGroup = this;
                int n29 = n24;
                int n30 = n26;
                int n31 = n27;
                int n32 = n28;
                viewGroup.invalidate(n29, n30, n31, n32);
                break block41;
            }
            if ((n2 & 0x800) == 2048) {
                Transformation transformation5;
                Transformation transformation6;
                View view2;
                ViewGroup viewGroup;
                if (this.mChildTransformation == null) {
                    Transformation transformation7;
                    this.mChildTransformation = transformation7 = new Transformation();
                }
                if ((viewGroup = this).getChildStaticTransformation(view2 = view, transformation6 = (transformation5 = this.mChildTransformation))) {
                    int n33;
                    int n34;
                    int n35 = this.mChildTransformation.getTransformationType();
                    int n36 = n35;
                    transformation = n36 != (n34 = (n33 = Transformation.TYPE_IDENTITY)) ? this.mChildTransformation : null;
                    bl = (Transformation.TYPE_MATRIX & n35) != 0;
                }
            }
        }
        view.mPrivateFlags = n = view.mPrivateFlags | 0x20;
        if (!bl && canvas.quickReject(f4 = (float)n6, f3 = (float)n5, f2 = (float)n4, f = (float)n3, edgeType = Canvas.EdgeType.BW) && (view.mPrivateFlags & 0x40) == 0) {
            return bl2;
        }
        view.computeScroll();
        int n37 = view.mScrollX;
        int n38 = view.mScrollY;
        boolean bl3 = false;
        Bitmap bitmap = null;
        if ((0x8000 & n2) == 32768 || (n2 & 0x4000) == 16384) {
            View view3 = view;
            boolean bl4 = true;
            bitmap = view3.getDrawingCache(bl4);
            if (this.mAttachInfo != null) {
                bl3 = this.mAttachInfo.mScalingRequired;
            }
        }
        boolean bl5 = bitmap == null;
        int n39 = canvas.save();
        if (bl5) {
            float f5 = n6 - n37;
            float f6 = n5 - n38;
            Canvas canvas2 = canvas;
            float f7 = f5;
            float f8 = f6;
            canvas2.translate(f7, f8);
        } else {
            float f9 = n6;
            float f10 = n5;
            Canvas canvas3 = canvas;
            float f11 = f9;
            float f12 = f10;
            canvas3.translate(f11, f12);
            if (bl3) {
                float f13 = this.mAttachInfo.mApplicationScale;
                float f14 = 1.0f / f13;
                Canvas canvas4 = canvas;
                float f15 = f14;
                float f16 = f14;
                canvas4.scale(f15, f16);
            }
        }
        float f17 = 1.0f;
        if (transformation != null) {
            if (bl) {
                int n40;
                int n41 = 0;
                int n42 = 0;
                if (bl5) {
                    n41 = -n37;
                    n42 = -n38;
                }
                float f18 = -n41;
                float f19 = -n42;
                Canvas canvas5 = canvas;
                float f20 = f18;
                float f21 = f19;
                canvas5.translate(f20, f21);
                Matrix matrix = transformation.getMatrix();
                Canvas canvas6 = canvas;
                Matrix matrix2 = matrix;
                canvas6.concat(matrix2);
                float f22 = n41;
                float f23 = n42;
                Canvas canvas7 = canvas;
                float f24 = f22;
                float f25 = f23;
                canvas7.translate(f24, f25);
                this.mGroupFlags = n40 = this.mGroupFlags | 0x100;
            }
            if ((f17 = transformation.getAlpha()) < 1.0f) {
                int n43;
                this.mGroupFlags = n43 = this.mGroupFlags | 0x100;
            }
            if (f17 < 1.0f && bl5) {
                View view4 = view;
                int n44 = (int)(255.0f * f17);
                int n45 = n44;
                if (!view4.onSetAlpha(n45)) {
                    float f26 = n37;
                    float f27 = n38;
                    float f28 = n37 + n4 - n6;
                    float f29 = n38 + n3 - n5;
                    int n46 = canvas.saveLayerAlpha(f26, f27, f28, f29, n44, 20);
                } else {
                    int n47;
                    view.mPrivateFlags = n47 = view.mPrivateFlags | 0x40000;
                }
            }
        } else if ((view.mPrivateFlags & 0x40000) == 262144) {
            View view5 = view;
            int n48 = 255;
            boolean bl6 = view5.onSetAlpha(n48);
        }
        if ((n2 & 1) == 1) {
            if (bl5) {
                int n49 = n4 - n6 + n37;
                int n50 = n3 - n5 + n38;
                Canvas canvas8 = canvas;
                int n51 = n37;
                int n52 = n38;
                int n53 = n49;
                int n54 = n50;
                boolean bl7 = canvas8.clipRect(n51, n52, n53, n54);
            } else if (!bl3) {
                int n55 = n4 - n6;
                int n56 = n3 - n5;
                Canvas canvas9 = canvas;
                int n57 = 0;
                int n58 = 0;
                int n59 = n55;
                int n60 = n56;
                boolean bl8 = canvas9.clipRect(n57, n58, n59, n60);
            } else {
                int n61 = bitmap.getWidth();
                int n62 = bitmap.getHeight();
                Canvas canvas10 = canvas;
                int n63 = 0;
                int n64 = 0;
                int n65 = n61;
                int n66 = n62;
                boolean bl9 = canvas10.clipRect(n63, n64, n65, n66);
            }
        }
        if (bl5) {
            if ((view.mPrivateFlags & 0x80) == 128) {
                int n67;
                view.mPrivateFlags = n67 = view.mPrivateFlags & 0xFF9FFFFF;
                View view6 = view;
                Canvas canvas11 = canvas;
                view6.dispatchDraw(canvas11);
            } else {
                View view7 = view;
                Canvas canvas12 = canvas;
                view7.draw(canvas12);
            }
        } else {
            Paint paint = this.mCachePaint;
            if (f17 < 1.0f) {
                int n68;
                int n69 = (int)(255.0f * f17);
                Paint paint2 = paint;
                int n70 = n69;
                paint2.setAlpha(n70);
                this.mGroupFlags = n68 = this.mGroupFlags | 0x1000;
            } else if ((n2 & 0x1000) == 4096) {
                int n71;
                Paint paint3 = paint;
                int n72 = 255;
                paint3.setAlpha(n72);
                this.mGroupFlags = n71 = this.mGroupFlags & 0xFFFFEFFF;
            }
            Canvas canvas13 = canvas;
            Bitmap bitmap2 = bitmap;
            float f30 = 0.0f;
            float f31 = 0.0f;
            Paint paint4 = paint;
            canvas13.drawBitmap(bitmap2, f30, f31, paint4);
        }
        Canvas canvas14 = canvas;
        int n73 = n39;
        canvas14.restoreToCount(n73);
        if (animation == null) return bl2;
        if (bl2) return bl2;
        View view8 = view;
        int n74 = 255;
        boolean bl10 = view8.onSetAlpha(n74);
        ViewGroup viewGroup = this;
        View view9 = view;
        Animation animation3 = animation;
        viewGroup.finishAnimatingView(view9, animation3);
        return bl2;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if ((this.mGroupFlags & 0x10000) == 0) {
            return;
        }
        if ((this.mGroupFlags & 0x2000) != 0) {
            throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
        }
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        int n2 = 0;
        while (n2 < n) {
            View view = viewArray[n2];
            if ((view.mViewFlags & 0x400000) != 0) {
                view.refreshDrawableState();
            }
            ++n2;
        }
        return;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View findFocus() {
        void var1_2;
        if (this.isFocused()) {
            ViewGroup viewGroup = this;
            return var1_2;
        }
        if (this.mFocused == null) return var1_2;
        View view = this.mFocused.findFocus();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected View findViewTraversal(int n) {
        void var3_4;
        int n2 = this.mID;
        if (n != n2) {
            ViewGroup viewGroup = this;
            return var3_4;
        }
        View[] viewArray = this.mChildren;
        int n3 = this.mChildrenCount;
        for (int i = 0; i < n3; ++i) {
            View view = viewArray[i];
            if ((view.mPrivateFlags & 8) != 0 || (view = view.findViewById(n)) == null) continue;
            View view2 = view;
            return var3_4;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected View findViewWithTagTraversal(Object object) {
        void var3_4;
        Object object2;
        if (object != null && object.equals(object2 = this.mTag)) {
            ViewGroup viewGroup = this;
            return var3_4;
        }
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((view.mPrivateFlags & 8) != 0 || (view = view.findViewWithTag(object)) == null) continue;
            View view2 = view;
            return var3_4;
        }
        return var3_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean fitSystemWindows(Rect rect) {
        boolean bl = super.fitSystemWindows(rect);
        if (bl) return bl;
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n && !(bl = viewArray[n2].fitSystemWindows(rect))) {
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View focusSearch(View view, int n) {
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextFocus(this, view, n);
        }
        if (this.mParent == null) return null;
        return this.mParent.focusSearch(view, n);
    }

    @Override
    public void focusableViewAvailable(View view) {
        if (this.mParent == null) {
            return;
        }
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        if (this.isFocused() && this.getDescendantFocusability() != 262144) {
            return;
        }
        this.mParent.focusableViewAvailable(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean bl = (this.mPrivateFlags & 0x200) == 0;
        if (bl && region == null) {
            return true;
        }
        boolean bl2 = super.gatherTransparentRegion(region);
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((view.mViewFlags & 0xC) != 0 && view.getAnimation() == null || view.gatherTransparentRegion(region)) continue;
            bl3 = false;
        }
        if (bl) return true;
        if (bl3) return true;
        return false;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = this.getContext();
        return new LayoutParams(context, attributeSet);
    }

    protected LayoutParams generateLayoutParams(LayoutParams layoutParams) {
        return layoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View getChildAt(int n) {
        try {
            return this.mChildren[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getChildCount() {
        return this.mChildrenCount;
    }

    protected int getChildDrawingOrder(int n, int n2) {
        return n2;
    }

    protected boolean getChildStaticTransformation(View view, Transformation transformation) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getChildVisibleRect(View view, Rect rect, Point point) {
        int n = view.mLeft;
        int n2 = this.mScrollX;
        int n3 = n - n2;
        int n4 = view.mTop;
        int n5 = this.mScrollY;
        int n6 = n4 - n5;
        if (point != null) {
            int n7;
            int n8;
            point.x = n8 = point.x + n3;
            point.y = n7 = point.y + n6;
        }
        rect.offset(n3, n6);
        int n9 = this.mRight;
        int n10 = this.mLeft;
        int n11 = n9 - n10;
        int n12 = this.mBottom;
        int n13 = this.mTop;
        int n14 = n12 - n13;
        if (!rect.intersect(0, 0, n11, n14)) return false;
        if (this.mParent == null) return true;
        if (!this.mParent.getChildVisibleRect(this, rect, point)) return false;
        return true;
    }

    @ViewDebug.ExportedProperty(category="focus", mapping={@ViewDebug.IntToString(from=131072, to="FOCUS_BEFORE_DESCENDANTS"), @ViewDebug.IntToString(from=262144, to="FOCUS_AFTER_DESCENDANTS"), @ViewDebug.IntToString(from=393216, to="FOCUS_BLOCK_DESCENDANTS")})
    public int getDescendantFocusability() {
        return this.mGroupFlags & 0x60000;
    }

    public View getFocusedChild() {
        return this.mFocused;
    }

    public LayoutAnimationController getLayoutAnimation() {
        return this.mLayoutAnimationController;
    }

    public Animation.AnimationListener getLayoutAnimationListener() {
        return this.mAnimationListener;
    }

    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=3, to="ANIMATION"), @ViewDebug.IntToString(from=2, to="SCROLLING"), @ViewDebug.IntToString(from=3, to="ALL")})
    public int getPersistentDrawingCache() {
        return this.mPersistentDrawingCache;
    }

    @Override
    void handleFocusGainInternal(int n, Rect rect) {
        if (this.mFocused != null) {
            this.mFocused.unFocus();
            this.mFocused = null;
        }
        super.handleFocusGainInternal(n, rect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasFocus() {
        if ((this.mPrivateFlags & 2) != 0) return true;
        if (this.mFocused == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasFocusable() {
        if ((this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if (this.isFocusable()) {
            return true;
        }
        if (this.getDescendantFocusability() == 393216) return false;
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            if (viewArray[n2].hasFocusable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfChild(View view) {
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = 0;
        while (n2 < n) {
            if (viewArray[n2] == view) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public final void invalidateChild(View view, Rect rect) {
        void var3_4;
        ViewParent viewParent;
        int n;
        int n2;
        ViewGroup viewGroup = this;
        View.AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo == null) {
            return;
        }
        int[] nArray = attachInfo.mInvalidateChildLocation;
        nArray[0] = n2 = view.mLeft;
        nArray[1] = n = view.mTop;
        boolean bl = (view.mPrivateFlags & 0x40) == 64;
        boolean bl2 = view.isOpaque() && !bl && view.getAnimation() != null;
        int n3 = bl2 ? 0x400000 : 0x200000;
        do {
            int n4;
            View view2 = null;
            if (var3_4 instanceof View) {
                view2 = (View)var3_4;
            }
            if (bl) {
                if (view2 != null) {
                    int n5;
                    view2.mPrivateFlags = n5 = view2.mPrivateFlags | 0x40;
                } else if (var3_4 instanceof ViewRoot) {
                    ((ViewRoot)var3_4).mIsAnimating = true;
                }
            }
            if (view2 == null || (view2.mPrivateFlags & 0x600000) == 0x200000) continue;
            view2.mPrivateFlags = n4 = view2.mPrivateFlags & 0xFF9FFFFF | n3;
        } while ((viewParent = var3_4.invalidateChildInParent(nArray, rect)) != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
        int n;
        int n2;
        int n3;
        if ((this.mPrivateFlags & 0x20) != 32) return null;
        if ((this.mGroupFlags & 0x90) != 128) {
            int n4;
            int n5 = nArray[0];
            int n6 = this.mScrollX;
            int n7 = n5 - n6;
            int n8 = nArray[1];
            int n9 = this.mScrollY;
            int n10 = n8 - n9;
            rect.offset(n7, n10);
            int n11 = this.mLeft;
            int n12 = this.mTop;
            int n13 = this.mRight - n11;
            int n14 = this.mBottom - n12;
            if (!rect.intersect(0, 0, n13, n14)) {
                if ((this.mPrivateFlags & 0x40) != 64) return null;
            }
            this.mPrivateFlags = n4 = this.mPrivateFlags & 0xFFFF7FFF;
            nArray[0] = n11;
            nArray[1] = n12;
            return this.mParent;
        }
        this.mPrivateFlags = n3 = this.mPrivateFlags & 0xFFFF7FDF;
        nArray[0] = n2 = this.mLeft;
        nArray[1] = n = this.mTop;
        int n15 = this.mRight;
        int n16 = nArray[0];
        int n17 = n15 - n16;
        int n18 = this.mBottom;
        int n19 = nArray[1];
        int n20 = n18 - n19;
        rect.set(0, 0, n17, n20);
        return this.mParent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isAlwaysDrawnWithCacheEnabled() {
        if ((this.mGroupFlags & 0x4000) != 16384) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty
    public boolean isAnimationCacheEnabled() {
        if ((this.mGroupFlags & 0x40) != 64) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawingOrderEnabled() {
        if ((this.mGroupFlags & 0x400) != 1024) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawnWithCacheEnabled() {
        if ((this.mGroupFlags & 0x8000) != 32768) return false;
        return true;
    }

    protected void measureChild(View view, int n, int n2) {
        LayoutParams layoutParams = view.getLayoutParams();
        int n3 = this.mPaddingLeft;
        int n4 = this.mPaddingRight;
        int n5 = n3 + n4;
        int n6 = layoutParams.width;
        int n7 = ViewGroup.getChildMeasureSpec(n, n5, n6);
        int n8 = this.mPaddingTop;
        int n9 = this.mPaddingBottom;
        int n10 = n8 + n9;
        int n11 = layoutParams.height;
        int n12 = ViewGroup.getChildMeasureSpec(n2, n10, n11);
        view.measure(n7, n12);
    }

    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        MarginLayoutParams marginLayoutParams = (MarginLayoutParams)view.getLayoutParams();
        int n5 = this.mPaddingLeft;
        int n6 = this.mPaddingRight;
        int n7 = n5 + n6;
        int n8 = marginLayoutParams.leftMargin;
        int n9 = n7 + n8;
        int n10 = marginLayoutParams.rightMargin;
        int n11 = n9 + n10 + n2;
        int n12 = marginLayoutParams.width;
        int n13 = ViewGroup.getChildMeasureSpec(n, n11, n12);
        int n14 = this.mPaddingTop;
        int n15 = this.mPaddingBottom;
        int n16 = n14 + n15;
        int n17 = marginLayoutParams.topMargin;
        int n18 = n16 + n17;
        int n19 = marginLayoutParams.bottomMargin;
        int n20 = n18 + n19 + n4;
        int n21 = marginLayoutParams.height;
        int n22 = ViewGroup.getChildMeasureSpec(n3, n20, n21);
        view.measure(n13, n22);
    }

    protected void measureChildren(int n, int n2) {
        int n3 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n4 = 0;
        while (n4 < n3) {
            View view = viewArray[n4];
            if ((view.mViewFlags & 0xC) != 8) {
                this.measureChild(view, n, n2);
            }
            ++n4;
        }
        return;
    }

    public void offsetChildrenTopAndBottom(int n) {
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            View view = viewArray[n3];
            view.mTop = n5 = view.mTop + n;
            view.mBottom = n4 = view.mBottom + n;
            ++n3;
        }
        return;
    }

    public final void offsetDescendantRectToMyCoords(View view, Rect rect) {
        this.offsetRectBetweenParentAndChild(view, rect, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void offsetRectBetweenParentAndChild(View view, Rect rect, boolean bl, boolean bl2) {
        if (view == this) {
            return;
        }
        ViewParent viewParent = view.mParent;
        while (viewParent != null && viewParent instanceof View && viewParent != this) {
            if (bl) {
                int n = view.mLeft;
                int n2 = view.mScrollX;
                int n3 = n - n2;
                int n4 = view.mTop;
                int n5 = view.mScrollY;
                int n6 = n4 - n5;
                rect.offset(n3, n6);
                if (bl2) {
                    View view2 = (View)((Object)viewParent);
                    int n7 = view2.mRight;
                    int n8 = view2.mLeft;
                    int n9 = n7 - n8;
                    int n10 = view2.mBottom;
                    int n11 = view2.mTop;
                    int n12 = n10 - n11;
                    boolean bl3 = rect.intersect(0, 0, n9, n12);
                }
            } else {
                if (bl2) {
                    View view3 = (View)((Object)viewParent);
                    int n = view3.mRight;
                    int n13 = view3.mLeft;
                    int n14 = n - n13;
                    int n15 = view3.mBottom;
                    int n16 = view3.mTop;
                    int n17 = n15 - n16;
                    boolean bl4 = rect.intersect(0, 0, n14, n17);
                }
                int n = view.mScrollX;
                int n18 = view.mLeft;
                int n19 = n - n18;
                int n20 = view.mScrollY;
                int n21 = view.mTop;
                int n22 = n20 - n21;
                rect.offset(n19, n22);
            }
            view = (View)((Object)viewParent);
            viewParent = view.mParent;
        }
        if (viewParent != this) {
            throw new IllegalArgumentException("parameter must be a descendant of this view");
        }
        if (bl) {
            int n = view.mLeft;
            int n23 = view.mScrollX;
            int n24 = n - n23;
            int n25 = view.mTop;
            int n26 = view.mScrollY;
            int n27 = n25 - n26;
            rect.offset(n24, n27);
            return;
        }
        int n = view.mScrollX;
        int n28 = view.mLeft;
        int n29 = n - n28;
        int n30 = view.mScrollY;
        int n31 = view.mTop;
        int n32 = n30 - n31;
        rect.offset(n29, n32);
    }

    public final void offsetRectIntoDescendantCoords(View view, Rect rect) {
        this.offsetRectBetweenParentAndChild(view, rect, false, false);
    }

    @Override
    protected void onAnimationEnd() {
        int n;
        super.onAnimationEnd();
        if ((this.mGroupFlags & 0x40) != 64) {
            return;
        }
        this.mGroupFlags = n = this.mGroupFlags & 0xFFFF7FFF;
        if ((this.mPersistentDrawingCache & 1) != 0) {
            return;
        }
        this.setChildrenDrawingCacheEnabled(false);
    }

    @Override
    protected void onAnimationStart() {
        int n;
        super.onAnimationStart();
        if ((this.mGroupFlags & 0x40) != 64) {
            return;
        }
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            View view = viewArray[i];
            if ((view.mViewFlags & 0xC) != 0) continue;
            view.setDrawingCacheEnabled(true);
            view.buildDrawingCache(true);
        }
        this.mGroupFlags = n = this.mGroupFlags | 0x8000;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onConsistencyCheck(int n) {
        ViewParent viewParent;
        boolean bl = super.onConsistencyCheck(n);
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        if (bl2) {
            int n2 = this.mChildrenCount;
            View[] viewArray = this.mChildren;
            for (int i = 0; i < n2; ++i) {
                if (viewArray[i].getParent() == this) continue;
                bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("View ");
                View view = viewArray[i];
                String string2 = stringBuilder.append(view).append(" has no parent/a parent that is not ").append(this).toString();
                int n3 = Log.d("ViewConsistency", string2);
            }
        }
        if (bl3 && (this.mPrivateFlags & 0x600000) != 0 && (viewParent = this.getParent()) != null && !(viewParent instanceof ViewRoot) && (((View)((Object)viewParent)).mPrivateFlags & 0x600000) == 0) {
            bl = false;
            String string3 = "ViewGroup " + this + " is dirty but its parent is not: " + this;
            int n4 = Log.d("ViewConsistency", string3);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int[] onCreateDrawableState(int n) {
        if ((this.mGroupFlags & 0x2000) == 0) {
            return super.onCreateDrawableState(n);
        }
        int n2 = 0;
        int n3 = this.getChildCount();
        for (int i = 0; i < n3; ++i) {
            int[] nArray = this.getChildAt(i).getDrawableState();
            if (nArray == null) continue;
            int n4 = nArray.length;
            n2 += n4;
        }
        int n5 = n + n2;
        int[] nArray = super.onCreateDrawableState(n5);
        int n6 = 0;
        while (n6 < n3) {
            int[] nArray2 = this.getChildAt(n6).getDrawableState();
            if (nArray2 != null) {
                nArray = ViewGroup.mergeDrawableStates(nArray, nArray2);
            }
            ++n6;
        }
        return nArray;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return false;
    }

    @Override
    protected abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        int n2;
        int n3;
        int n4;
        int n5 = this.mChildrenCount;
        if ((n & 2) != 0) {
            n4 = 0;
            n3 = 1;
            n2 = n5;
        } else {
            n4 = n5 - 1;
            n3 = -1;
            n2 = -1;
        }
        View[] viewArray = this.mChildren;
        int n6 = n4;
        while (n6 != n2) {
            View view = viewArray[n6];
            if ((view.mViewFlags & 0xC) == 0 && view.requestFocus(n, rect)) {
                return true;
            }
            n6 += n3;
        }
        return false;
    }

    @Override
    public void recomputeViewAttributes(View view) {
        ViewParent viewParent = this.mParent;
        if (viewParent == null) {
            return;
        }
        viewParent.recomputeViewAttributes(this);
    }

    public void removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeAllViewsInLayout() {
        int n = this.mChildrenCount;
        if (n <= 0) {
            return;
        }
        View[] viewArray = this.mChildren;
        this.mChildrenCount = 0;
        OnHierarchyChangeListener onHierarchyChangeListener = this.mOnHierarchyChangeListener;
        boolean bl = onHierarchyChangeListener != null;
        View view = this.mFocused;
        boolean bl2 = this.mAttachInfo != null;
        View view2 = null;
        this.needGlobalAttributesUpdate(false);
        for (int i = n - 1; i >= 0; i += -1) {
            View view3 = viewArray[i];
            if (view3 == view) {
                view3.clearFocusForRemoval();
                view2 = view3;
            }
            if (view3.getAnimation() != null) {
                this.addDisappearingView(view3);
            } else if (bl2) {
                view3.dispatchDetachedFromWindow();
            }
            if (bl) {
                onHierarchyChangeListener.onChildViewRemoved(this, view3);
            }
            view3.mParent = null;
            viewArray[i] = null;
        }
        if (view2 == null) {
            return;
        }
        this.clearChildFocus(view2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void removeDetachedView(View view, boolean bl) {
        View view2 = this.mFocused;
        if (view == view2) {
            view.clearFocus();
        }
        if (bl && view.getAnimation() != null) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (this.mOnHierarchyChangeListener == null) {
            return;
        }
        this.mOnHierarchyChangeListener.onChildViewRemoved(this, view);
    }

    @Override
    public void removeView(View view) {
        this.removeViewInternal(view);
        this.requestLayout();
        this.invalidate();
    }

    public void removeViewAt(int n) {
        View view = this.getChildAt(n);
        this.removeViewInternal(n, view);
        this.requestLayout();
        this.invalidate();
    }

    public void removeViewInLayout(View view) {
        this.removeViewInternal(view);
    }

    public void removeViews(int n, int n2) {
        this.removeViewsInternal(n, n2);
        this.requestLayout();
        this.invalidate();
    }

    public void removeViewsInLayout(int n, int n2) {
        this.removeViewsInternal(n, n2);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        super.unFocus();
        if (this.mFocused != view) {
            if (this.mFocused != null) {
                this.mFocused.unFocus();
            }
            this.mFocused = view;
        }
        if (this.mParent == null) {
            return;
        }
        this.mParent.requestChildFocus(this, view2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        int n;
        int n2;
        boolean bl2 = (this.mGroupFlags & 0x80000) != 0;
        if (bl == bl2) {
            return;
        }
        this.mGroupFlags = bl ? (n2 = this.mGroupFlags | 0x80000) : (n = this.mGroupFlags & 0xFFF7FFFF);
        if (this.mParent == null) {
            return;
        }
        this.mParent.requestDisallowInterceptTouchEvent(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requestFocus(int n, Rect rect) {
        int n2 = this.getDescendantFocusability();
        switch (n2) {
            default: {
                String string2 = "descendant focusability must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS but is " + n2;
                throw new IllegalStateException(string2);
            }
            case 393216: {
                return super.requestFocus(n, rect);
            }
            case 131072: {
                boolean bl = super.requestFocus(n, rect);
                if (!bl) return this.onRequestFocusInDescendants(n, rect);
                return bl;
            }
            case 262144: 
        }
        boolean bl = this.onRequestFocusInDescendants(n, rect);
        if (!bl) return super.requestFocus(n, rect);
        return bl;
    }

    @Override
    public void requestTransparentRegion(View view) {
        int n;
        if (view == null) {
            return;
        }
        view.mPrivateFlags = n = view.mPrivateFlags | 0x200;
        if (this.mParent == null) {
            return;
        }
        this.mParent.requestTransparentRegion(this);
    }

    public void scheduleLayoutAnimation() {
        int n;
        this.mGroupFlags = n = this.mGroupFlags | 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAddStatesFromChildren(boolean bl) {
        int n;
        int n2;
        this.mGroupFlags = bl ? (n2 = this.mGroupFlags | 0x2000) : (n = this.mGroupFlags & 0xFFFFDFFF);
        this.refreshDrawableState();
    }

    public void setAlwaysDrawnWithCacheEnabled(boolean bl) {
        this.setBooleanFlag(16384, bl);
    }

    public void setAnimationCacheEnabled(boolean bl) {
        this.setBooleanFlag(64, bl);
    }

    protected void setChildrenDrawingCacheEnabled(boolean bl) {
        if (!bl && (this.mPersistentDrawingCache & 3) == 3) {
            return;
        }
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        int n2 = 0;
        while (n2 < n) {
            viewArray[n2].setDrawingCacheEnabled(bl);
            ++n2;
        }
        return;
    }

    protected void setChildrenDrawingOrderEnabled(boolean bl) {
        this.setBooleanFlag(1024, bl);
    }

    protected void setChildrenDrawnWithCacheEnabled(boolean bl) {
        this.setBooleanFlag(32768, bl);
    }

    public void setClipChildren(boolean bl) {
        this.setBooleanFlag(1, bl);
    }

    public void setClipToPadding(boolean bl) {
        this.setBooleanFlag(2, bl);
    }

    public void setDescendantFocusability(int n) {
        int n2;
        int n3;
        switch (n) {
            default: {
                throw new IllegalArgumentException("must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS");
            }
            case 131072: 
            case 262144: 
            case 393216: 
        }
        int n4 = this.mGroupFlags = (n3 = this.mGroupFlags & 0xFFF9FFFF);
        int n5 = 0x60000 & n;
        this.mGroupFlags = n2 = n4 | n5;
    }

    public void setLayoutAnimation(LayoutAnimationController layoutAnimationController) {
        int n;
        this.mLayoutAnimationController = layoutAnimationController;
        if (this.mLayoutAnimationController == null) {
            return;
        }
        this.mGroupFlags = n = this.mGroupFlags | 8;
    }

    public void setLayoutAnimationListener(Animation.AnimationListener animationListener) {
        this.mAnimationListener = animationListener;
    }

    public void setOnHierarchyChangeListener(OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    @Override
    public void setPadding(int n, int n2, int n3, int n4) {
        int n5;
        super.setPadding(n, n2, n3, n4);
        int n6 = this.mPaddingLeft;
        int n7 = this.mPaddingTop;
        int n8 = n6 | n7;
        int n9 = this.mPaddingRight;
        int n10 = n8 | n9;
        int n11 = this.mPaddingRight;
        if ((n10 | n11) != 0) {
            int n12;
            this.mGroupFlags = n12 = this.mGroupFlags | 0x20;
            return;
        }
        this.mGroupFlags = n5 = this.mGroupFlags & 0xFFFFFFDF;
    }

    public void setPersistentDrawingCache(int n) {
        int n2;
        this.mPersistentDrawingCache = n2 = n & 3;
    }

    protected void setStaticTransformationsEnabled(boolean bl) {
        this.setBooleanFlag(2048, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean showContextMenuForChild(View view) {
        if (this.mParent == null) return false;
        if (!this.mParent.showContextMenuForChild(view)) return false;
        return true;
    }

    public void startLayoutAnimation() {
        int n;
        if (this.mLayoutAnimationController == null) {
            return;
        }
        this.mGroupFlags = n = this.mGroupFlags | 8;
        this.requestLayout();
    }

    @Override
    void unFocus() {
        super.unFocus();
        if (this.mFocused != null) {
            this.mFocused.unFocus();
        }
        this.mFocused = null;
    }

    @Override
    public void updateViewLayout(View view, LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            String string2 = "Invalid LayoutParams supplied to " + this;
            throw new IllegalArgumentException(string2);
        }
        if (view.mParent != this) {
            String string3 = "Given view not a child of " + this;
            throw new IllegalArgumentException(string3);
        }
        view.setLayoutParams(layoutParams);
    }

    public static class MarginLayoutParams
    extends LayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public int bottomMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int leftMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int rightMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int topMargin;

        public MarginLayoutParams(int n, int n2) {
            super(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public MarginLayoutParams(Context context, AttributeSet attributeSet) {
            int[] nArray = R.styleable.ViewGroup_MarginLayout;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
            this.setBaseAttributes(typedArray, 0, 1);
            int n = typedArray.getDimensionPixelSize(2, -1);
            if (n >= 0) {
                this.leftMargin = n;
                this.topMargin = n;
                this.rightMargin = n;
                this.bottomMargin = n;
            } else {
                int n2;
                int n3;
                int n4;
                int n5;
                this.leftMargin = n5 = typedArray.getDimensionPixelSize(3, 0);
                this.topMargin = n4 = typedArray.getDimensionPixelSize(4, 0);
                this.rightMargin = n3 = typedArray.getDimensionPixelSize(5, 0);
                this.bottomMargin = n2 = typedArray.getDimensionPixelSize(6, 0);
            }
            typedArray.recycle();
        }

        public MarginLayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
        }

        public MarginLayoutParams(MarginLayoutParams marginLayoutParams) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            this.width = n6 = marginLayoutParams.width;
            this.height = n5 = marginLayoutParams.height;
            this.leftMargin = n4 = marginLayoutParams.leftMargin;
            this.topMargin = n3 = marginLayoutParams.topMargin;
            this.rightMargin = n2 = marginLayoutParams.rightMargin;
            this.bottomMargin = n = marginLayoutParams.bottomMargin;
        }

        public void setMargins(int n, int n2, int n3, int n4) {
            this.leftMargin = n;
            this.topMargin = n2;
            this.rightMargin = n3;
            this.bottomMargin = n4;
        }
    }

    public static class LayoutParams {
        @Deprecated
        public static final int FILL_PARENT = 255;
        public static final int MATCH_PARENT = 255;
        public static final int WRAP_CONTENT = 254;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=255, to="MATCH_PARENT"), @ViewDebug.IntToString(from=254, to="WRAP_CONTENT")})
        public int height;
        public LayoutAnimationController.AnimationParameters layoutAnimationParameters;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=255, to="MATCH_PARENT"), @ViewDebug.IntToString(from=254, to="WRAP_CONTENT")})
        public int width;

        LayoutParams() {
        }

        public LayoutParams(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            int[] nArray = R.styleable.ViewGroup_Layout;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
            this.setBaseAttributes(typedArray, 0, 1);
            typedArray.recycle();
        }

        public LayoutParams(LayoutParams layoutParams) {
            int n;
            int n2;
            this.width = n2 = layoutParams.width;
            this.height = n = layoutParams.height;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected static String sizeToString(int n) {
            if (n == -1) {
                return "wrap-content";
            }
            if (n != -1) return String.valueOf(n);
            return "match-parent";
        }

        public String debug(String string2) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("ViewGroup.LayoutParams={ width=");
            String string3 = LayoutParams.sizeToString(this.width);
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", height=");
            String string4 = LayoutParams.sizeToString(this.height);
            return stringBuilder2.append(string4).append(" }").toString();
        }

        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            int n3;
            int n4;
            this.width = n4 = typedArray.getLayoutDimension(n, "layout_width");
            this.height = n3 = typedArray.getLayoutDimension(n2, "layout_height");
        }
    }

    public static interface OnHierarchyChangeListener {
        public void onChildViewAdded(View var1, View var2);

        public void onChildViewRemoved(View var1, View var2);
    }
}

