/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.LatencyTimer;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.FocusFinder;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.RootViewSurfaceTaker;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL11;

public final class ViewRoot
extends Handler
implements ViewParent,
View.AttachInfo.Callbacks {
    public static final int CHECK_FOCUS = 1013;
    public static final int CLOSE_SYSTEM_DIALOGS = 1014;
    private static final boolean DBG = false;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_IMF = false;
    private static final boolean DEBUG_INPUT = true;
    private static final boolean DEBUG_INPUT_RESIZE = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean DEBUG_ORIENTATION = false;
    private static final boolean DEBUG_TRACKBALL = false;
    public static final int DIE = 1001;
    public static final int DISPATCH_APP_VISIBILITY = 1008;
    public static final int DISPATCH_GET_NEW_SURFACE = 1009;
    public static final int DISPATCH_KEY = 1005;
    public static final int DISPATCH_KEY_FROM_IME = 1011;
    public static final int DISPATCH_POINTER = 1006;
    public static final int DISPATCH_TRACKBALL = 1007;
    public static final int DO_TRAVERSAL = 1000;
    public static final int FINISHED_EVENT = 1010;
    public static final int FINISH_INPUT_CONNECTION = 1012;
    private static final boolean LOCAL_LOGV = false;
    static final int MAX_TRACKBALL_DELAY = 250;
    private static final boolean MEASURE_LATENCY = false;
    public static final int RESIZED = 1002;
    public static final int RESIZED_REPORT = 1003;
    private static final boolean SHOW_FPS = false;
    private static final String TAG = "ViewRoot";
    private static final boolean WATCH_POINTER = false;
    public static final int WINDOW_FOCUS_CHANGED = 1004;
    private static LatencyTimer lt;
    static boolean mInitialized;
    static final Object mStaticInit;
    static final ArrayList<ComponentCallbacks> sConfigCallbacks;
    private static int sDrawTime;
    static boolean sFirstDrawComplete;
    static final ArrayList<Runnable> sFirstDrawHandlers;
    static long sInstanceCount;
    static final ThreadLocal<RunQueue> sRunQueues;
    static IWindowSession sWindowSession;
    int mAddNesting;
    boolean mAdded;
    boolean mAddedTouchMode;
    boolean mAppVisible;
    final View.AttachInfo mAttachInfo;
    AudioManager mAudioManager;
    int mCurScrollY;
    private final int mDensity;
    Rect mDirty;
    boolean mDrawingAllowed;
    EGL10 mEgl;
    EGLContext mEglContext;
    EGLDisplay mEglDisplay;
    EGLSurface mEglSurface;
    private Runnable mFinishedCallback;
    boolean mFirst;
    View mFocusedView;
    boolean mFullRedrawNeeded;
    GL11 mGL;
    Canvas mGlCanvas;
    boolean mGlWanted;
    boolean mHasHadWindowFocus;
    int mHeight;
    private SurfaceHolder mHolder;
    InputChannel mInputChannel;
    private final InputHandler mInputHandler;
    final InputMethodCallback mInputMethodCallback;
    InputQueue mInputQueue;
    InputQueue.Callback mInputQueueCallback;
    boolean mIsAnimating;
    boolean mIsCreating;
    final Configuration mLastConfiguration;
    final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets;
    View mLastScrolledFocus;
    long mLastTrackballTime = 0L;
    boolean mLastWasImTarget;
    boolean mLayoutRequested;
    final WindowLeaked mLocation;
    boolean mNewSurfaceNeeded;
    final Configuration mPendingConfiguration;
    final Rect mPendingContentInsets;
    int mPendingEventSeq;
    final SparseArray<Object> mPendingEvents;
    final Rect mPendingVisibleInsets;
    final Region mPreviousTransparentRegion;
    private boolean mProfile;
    View mRealFocusedView;
    boolean mReportNextDraw;
    boolean mScrollMayChange;
    int mScrollY;
    Scroller mScroller;
    int mSoftInputMode;
    private final Surface mSurface;
    BaseSurfaceHolder mSurfaceHolder;
    SurfaceHolder.Callback2 mSurfaceHolderCallback;
    final Rect mTempRect;
    final Thread mThread;
    final int[] mTmpLocation;
    final TrackballAxis mTrackballAxisX;
    final TrackballAxis mTrackballAxisY;
    CompatibilityInfo.Translator mTranslator;
    final Region mTransparentRegion;
    boolean mTraversalScheduled;
    boolean mUseGL;
    View mView;
    final ViewConfiguration mViewConfiguration;
    int mViewVisibility;
    final Rect mVisRect;
    int mWidth;
    boolean mWillDrawSoon;
    final Rect mWinFrame;
    final W mWindow;
    final WindowManager.LayoutParams mWindowAttributes;
    boolean mWindowAttributesChanged;

    static {
        sInstanceCount = 0L;
        mStaticInit = new Object();
        mInitialized = false;
        sRunQueues = new ThreadLocal();
        sFirstDrawHandlers = new ArrayList();
        sFirstDrawComplete = false;
        sConfigCallbacks = new ArrayList();
    }

    public ViewRoot(Context context) {
        int n;
        ViewConfiguration viewConfiguration;
        View.AttachInfo attachInfo;
        Region region;
        Region region2;
        InputMethodCallback inputMethodCallback;
        W w;
        Rect rect;
        Rect rect2;
        Rect rect3;
        Rect rect4;
        WindowLeaked windowLeaked;
        Thread thread;
        SurfaceHolder surfaceHolder;
        InputHandler inputHandler;
        Configuration configuration;
        Configuration configuration2;
        ViewTreeObserver.InternalInsetsInfo internalInsetsInfo;
        Rect rect5;
        Rect rect6;
        Surface surface;
        WindowManager.LayoutParams layoutParams;
        TrackballAxis trackballAxis;
        TrackballAxis trackballAxis2;
        this.mTrackballAxisX = trackballAxis2 = new TrackballAxis();
        this.mTrackballAxisY = trackballAxis = new TrackballAxis();
        int[] nArray = new int[2];
        this.mTmpLocation = nArray;
        SparseArray sparseArray = new SparseArray();
        this.mPendingEvents = sparseArray;
        this.mPendingEventSeq = 0;
        this.mWindowAttributes = layoutParams = new WindowManager.LayoutParams();
        this.mAppVisible = true;
        this.mWindowAttributesChanged = false;
        this.mSurface = surface = new Surface();
        this.mPendingVisibleInsets = rect6 = new Rect();
        this.mPendingContentInsets = rect5 = new Rect();
        this.mLastGivenInsets = internalInsetsInfo = new ViewTreeObserver.InternalInsetsInfo();
        this.mLastConfiguration = configuration2 = new Configuration();
        this.mPendingConfiguration = configuration = new Configuration();
        this.mProfile = false;
        this.mInputHandler = inputHandler = new InputHandler(){

            @Override
            public void handleKey(KeyEvent keyEvent, Runnable runnable) {
                ViewRoot.this.startInputEvent(runnable);
                ViewRoot.this.dispatchKey(keyEvent, true);
            }

            @Override
            public void handleMotion(MotionEvent motionEvent, Runnable runnable) {
                ViewRoot.this.startInputEvent(runnable);
                ViewRoot.this.dispatchMotion(motionEvent, true);
            }
        };
        this.mHolder = surfaceHolder = new SurfaceHolder(){

            @Override
            public void addCallback(SurfaceHolder.Callback callback) {
            }

            @Override
            public Surface getSurface() {
                return ViewRoot.this.mSurface;
            }

            @Override
            public Rect getSurfaceFrame() {
                return null;
            }

            @Override
            public boolean isCreating() {
                return false;
            }

            @Override
            public Canvas lockCanvas() {
                return null;
            }

            @Override
            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            @Override
            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            @Override
            public void setFixedSize(int n, int n2) {
            }

            @Override
            public void setFormat(int n) {
            }

            @Override
            public void setKeepScreenOn(boolean bl) {
            }

            @Override
            public void setSizeFromLayout() {
            }

            @Override
            public void setType(int n) {
            }

            @Override
            public void unlockCanvasAndPost(Canvas canvas) {
            }
        };
        IWindowSession iWindowSession = ViewRoot.getWindowSession(context.getMainLooper());
        this.mThread = thread = Thread.currentThread();
        this.mLocation = windowLeaked = new WindowLeaked(null);
        Throwable throwable = this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = rect4 = new Rect();
        this.mTempRect = rect3 = new Rect();
        this.mVisRect = rect2 = new Rect();
        this.mWinFrame = rect = new Rect();
        this.mWindow = w = new W(this, context);
        this.mInputMethodCallback = inputMethodCallback = new InputMethodCallback(this);
        this.mViewVisibility = 8;
        this.mTransparentRegion = region2 = new Region();
        this.mPreviousTransparentRegion = region = new Region();
        this.mFirst = true;
        this.mAdded = false;
        IWindowSession iWindowSession2 = sWindowSession;
        W w2 = this.mWindow;
        this.mAttachInfo = attachInfo = new View.AttachInfo(iWindowSession2, w2, this, this);
        this.mViewConfiguration = viewConfiguration = ViewConfiguration.get(context);
        this.mDensity = n = context.getResources().getDisplayMetrics().densityDpi;
    }

    public static void addConfigCallback(ComponentCallbacks componentCallbacks) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            boolean bl = sConfigCallbacks.add(componentCallbacks);
            return;
        }
    }

    public static void addFirstDrawHandler(Runnable runnable) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                boolean bl = sFirstDrawHandlers.add(runnable);
            }
            return;
        }
    }

    private static void captureKeyLog(String string2, KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        if (SystemProperties.getInt("debug.captureevent", 0) == 0) {
            return;
        }
        String string3 = string2 + ": ";
        StringBuilder stringBuilder = new StringBuilder(string3);
        long l = keyEvent.getDownTime();
        StringBuilder stringBuilder2 = stringBuilder.append(l).append(',');
        long l2 = keyEvent.getEventTime();
        StringBuilder stringBuilder3 = stringBuilder.append(l2).append(',');
        int n = keyEvent.getAction();
        StringBuilder stringBuilder4 = stringBuilder.append(n).append(',');
        int n2 = keyEvent.getKeyCode();
        StringBuilder stringBuilder5 = stringBuilder.append(n2).append(',');
        int n3 = keyEvent.getRepeatCount();
        StringBuilder stringBuilder6 = stringBuilder.append(n3).append(',');
        int n4 = keyEvent.getMetaState();
        StringBuilder stringBuilder7 = stringBuilder.append(n4).append(',');
        int n5 = keyEvent.getDeviceId();
        StringBuilder stringBuilder8 = stringBuilder.append(n5).append(',');
        int n6 = keyEvent.getScanCode();
        StringBuilder stringBuilder9 = stringBuilder.append(n6);
        String string4 = stringBuilder.toString();
        int n7 = Log.d(TAG, string4);
    }

    private static void captureMotionLog(String string2, MotionEvent motionEvent) {
        if (motionEvent == null) {
            return;
        }
        if (SystemProperties.getInt("debug.captureevent", 0) == 0) {
            return;
        }
        String string3 = string2 + ": ";
        StringBuilder stringBuilder = new StringBuilder(string3);
        long l = motionEvent.getDownTime();
        StringBuilder stringBuilder2 = stringBuilder.append(l).append(',');
        long l2 = motionEvent.getEventTime();
        StringBuilder stringBuilder3 = stringBuilder.append(l2).append(',');
        int n = motionEvent.getAction();
        StringBuilder stringBuilder4 = stringBuilder.append(n).append(',');
        float f = motionEvent.getX();
        StringBuilder stringBuilder5 = stringBuilder.append(f).append(',');
        float f2 = motionEvent.getY();
        StringBuilder stringBuilder6 = stringBuilder.append(f2).append(',');
        float f3 = motionEvent.getPressure();
        StringBuilder stringBuilder7 = stringBuilder.append(f3).append(',');
        float f4 = motionEvent.getSize();
        StringBuilder stringBuilder8 = stringBuilder.append(f4).append(',');
        int n2 = motionEvent.getMetaState();
        StringBuilder stringBuilder9 = stringBuilder.append(n2).append(',');
        float f5 = motionEvent.getXPrecision();
        StringBuilder stringBuilder10 = stringBuilder.append(f5).append(',');
        float f6 = motionEvent.getYPrecision();
        StringBuilder stringBuilder11 = stringBuilder.append(f6).append(',');
        int n3 = motionEvent.getDeviceId();
        StringBuilder stringBuilder12 = stringBuilder.append(n3).append(',');
        int n4 = motionEvent.getEdgeFlags();
        StringBuilder stringBuilder13 = stringBuilder.append(n4);
        String string4 = stringBuilder.toString();
        int n5 = Log.d(TAG, string4);
    }

    private void checkEglErrors() {
        if (!this.mUseGL) {
            return;
        }
        int n = this.mEgl.eglGetError();
        if (n == 12288) {
            return;
        }
        this.destroyGL();
        if (n == 12302) {
            return;
        }
        this.mGlWanted = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkForLeavingTouchModeAndConsume(KeyEvent keyEvent) {
        int n = keyEvent.getAction();
        if (n != 0 && n != 2) {
            return false;
        }
        if ((keyEvent.getFlags() & 4) != 0) {
            return false;
        }
        if (!this.mAttachInfo.mInTouchMode) {
            return false;
        }
        if (ViewRoot.isKeyboardKey(keyEvent) && this.mView != null && this.mView.hasFocus()) {
            View view;
            this.mFocusedView = view = this.mView.findFocus();
            if (this.mFocusedView instanceof ViewGroup && ((ViewGroup)this.mFocusedView).getDescendantFocusability() == 262144) {
                return false;
            }
            if (!this.ensureTouchMode(false)) return false;
            throw new IllegalStateException("should not have changed focus when leaving touch mode while a view has focus.");
        }
        if (!ViewRoot.isDirectional(keyEvent.getKeyCode())) return false;
        return this.ensureTouchMode(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverKeyEvent(KeyEvent keyEvent, boolean bl) {
        InputMethodManager inputMethodManager;
        boolean bl2 = this.mView != null ? this.mView.dispatchKeyEventPreIme(keyEvent) : true;
        if (bl2) {
            if (!bl) {
                return;
            }
            this.finishInputEvent();
            return;
        }
        if (this.mLastWasImTarget && (inputMethodManager = InputMethodManager.peekInstance()) != null && this.mView != null) {
            int n = this.enqueuePendingEvent(keyEvent, bl);
            Context context = this.mView.getContext();
            InputMethodCallback inputMethodCallback = this.mInputMethodCallback;
            inputMethodManager.dispatchKeyEvent(context, n, keyEvent, inputMethodCallback);
            return;
        }
        this.deliverKeyEventToViewHierarchy(keyEvent, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverKeyEventToViewHierarchy(KeyEvent keyEvent, boolean bl) {
        try {
            block24: {
                block23: {
                    block21: {
                        boolean bl2;
                        block22: {
                            if (this.mView == null || !this.mAdded) break block21;
                            bl2 = keyEvent.getAction() == 0;
                            boolean bl3 = this.checkForLeavingTouchModeAndConsume(keyEvent);
                            if (!bl3) break block22;
                            if (!bl) {
                                return;
                            }
                            break block23;
                        }
                        if (!this.mView.dispatchKeyEvent(keyEvent) && bl2) {
                            View view;
                            int n = 0;
                            switch (keyEvent.getKeyCode()) {
                                case 21: {
                                    n = 17;
                                    break;
                                }
                                case 22: {
                                    n = 66;
                                    break;
                                }
                                case 19: {
                                    n = 33;
                                    break;
                                }
                                case 20: {
                                    n = 130;
                                }
                            }
                            if (n != 0 && (view = this.mView != null ? this.mView.findFocus() : null) != null) {
                                View view2 = view.focusSearch(n);
                                boolean bl4 = false;
                                if (view2 != null && view2 != view) {
                                    Rect rect = this.mTempRect;
                                    view.getFocusedRect(rect);
                                    if (this.mView instanceof ViewGroup) {
                                        ViewGroup viewGroup = (ViewGroup)this.mView;
                                        Rect rect2 = this.mTempRect;
                                        viewGroup.offsetDescendantRectToMyCoords(view, rect2);
                                        ViewGroup viewGroup2 = (ViewGroup)this.mView;
                                        Rect rect3 = this.mTempRect;
                                        viewGroup2.offsetRectIntoDescendantCoords(view2, rect3);
                                    }
                                    Rect rect4 = this.mTempRect;
                                    bl4 = view2.requestFocus(n, rect4);
                                }
                                if (!bl4) {
                                    boolean bl5 = this.mView.dispatchUnhandledMove(view, n);
                                } else {
                                    int n2 = SoundEffectConstants.getContantForFocusDirection(n);
                                    this.playSoundEffect(n2);
                                }
                            }
                        }
                    }
                    if (!bl) break block24;
                }
                this.finishInputEvent();
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.finishInputEvent();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverPointerEvent(MotionEvent motionEvent) {
        ViewGroup viewGroup;
        int[] nArray;
        int n;
        int n2;
        int n3;
        int n4;
        block20: {
            block21: {
                int n5;
                block19: {
                    if (this.mTranslator != null) {
                        this.mTranslator.translateEventInScreenToAppWindow(motionEvent);
                    }
                    if (this.mView == null) {
                        return;
                    }
                    if (!this.mAdded) {
                        return;
                    }
                    boolean bl = motionEvent.getAction() == 0;
                    if (bl) {
                        boolean bl2 = this.ensureTouchMode(true);
                    }
                    if (this.mCurScrollY != 0) {
                        float f = this.mCurScrollY;
                        motionEvent.offsetLocation(0.0f, f);
                    }
                    if (this.mView.dispatchTouchEvent(motionEvent)) {
                        return;
                    }
                    if (!bl) {
                        return;
                    }
                    n5 = this.mViewConfiguration.getScaledEdgeSlop();
                    n4 = motionEvent.getEdgeFlags();
                    n3 = 33;
                    n2 = (int)motionEvent.getX();
                    n = (int)motionEvent.getY();
                    nArray = new int[2];
                    if ((n4 & 1) == 0) break block19;
                    n3 = 130;
                    if ((n4 & 4) != 0) {
                        nArray[0] = n5;
                        n2 += n5;
                        break block20;
                    } else if ((n4 & 8) != 0) {
                        int n6;
                        nArray[0] = n6 = -n5;
                        n2 -= n5;
                    }
                    break block20;
                }
                if ((n4 & 2) == 0) break block21;
                n3 = 33;
                if ((n4 & 4) != 0) {
                    nArray[0] = n5;
                    n2 += n5;
                    break block20;
                } else if ((n4 & 8) != 0) {
                    int n7;
                    nArray[0] = n7 = -n5;
                    n2 -= n5;
                }
                break block20;
            }
            if ((n4 & 4) != 0) {
                n3 = 66;
            } else if ((n4 & 8) != 0) {
                n3 = 17;
            }
        }
        if (n4 == 0) {
            return;
        }
        if (!(this.mView instanceof ViewGroup)) {
            return;
        }
        FocusFinder focusFinder = FocusFinder.getInstance();
        if (focusFinder.findNearestTouchable(viewGroup = (ViewGroup)this.mView, n2, n, n3, nArray) == null) {
            return;
        }
        float f = nArray[0];
        float f2 = nArray[1];
        motionEvent.offsetLocation(f, f2);
        motionEvent.setEdgeFlags(0);
        boolean bl = this.mView.dispatchTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverTrackballEvent(MotionEvent motionEvent) {
        long l;
        int n;
        int n2;
        int n3;
        float f;
        float f2;
        float f3;
        TrackballAxis trackballAxis;
        MotionEvent motionEvent2;
        View view;
        if (this.mView != null && this.mAdded && (view = this.mView).dispatchTrackballEvent(motionEvent2 = motionEvent)) {
            ViewRoot viewRoot = this;
            boolean bl = false;
            boolean bl2 = viewRoot.ensureTouchMode(bl);
            return;
        }
        TrackballAxis trackballAxis2 = this.mTrackballAxisX;
        TrackballAxis trackballAxis3 = this.mTrackballAxisY;
        long l2 = SystemClock.uptimeMillis();
        if (this.mLastTrackballTime + 250L < l2) {
            long l3;
            TrackballAxis trackballAxis4 = trackballAxis2;
            int n4 = 0;
            trackballAxis4.reset(n4);
            TrackballAxis trackballAxis5 = trackballAxis3;
            int n5 = 0;
            trackballAxis5.reset(n5);
            this.mLastTrackballTime = l3 = l2;
        }
        int n6 = motionEvent.getAction();
        int n7 = motionEvent.getMetaState();
        switch (n6) {
            case 0: {
                TrackballAxis trackballAxis6 = trackballAxis2;
                int n8 = 2;
                trackballAxis6.reset(n8);
                TrackballAxis trackballAxis7 = trackballAxis3;
                int n9 = 2;
                trackballAxis7.reset(n9);
                long l4 = l2;
                KeyEvent keyEvent = new KeyEvent(l2, l4, 0, 23, 0, n7);
                ViewRoot viewRoot = this;
                KeyEvent keyEvent2 = keyEvent;
                boolean bl = false;
                viewRoot.deliverKeyEvent(keyEvent2, bl);
                break;
            }
            case 1: {
                TrackballAxis trackballAxis8 = trackballAxis2;
                int n10 = 2;
                trackballAxis8.reset(n10);
                TrackballAxis trackballAxis9 = trackballAxis3;
                int n11 = 2;
                trackballAxis9.reset(n11);
                long l5 = l2;
                KeyEvent keyEvent = new KeyEvent(l2, l5, 1, 23, 0, n7);
                ViewRoot viewRoot = this;
                KeyEvent keyEvent3 = keyEvent;
                boolean bl = false;
                viewRoot.deliverKeyEvent(keyEvent3, bl);
            }
        }
        float f4 = motionEvent.getX();
        long l6 = motionEvent.getEventTime();
        TrackballAxis trackballAxis10 = trackballAxis2;
        float f5 = f4;
        long l7 = l6;
        String string2 = "X";
        float f6 = trackballAxis10.collect(f5, l7, string2);
        float f7 = motionEvent.getY();
        long l8 = motionEvent.getEventTime();
        TrackballAxis trackballAxis11 = trackballAxis3;
        float f8 = f7;
        long l9 = l8;
        String string3 = "Y";
        float f9 = trackballAxis11.collect(f8, l9, string3);
        int n12 = 0;
        int n13 = 0;
        float f10 = 1.0f;
        if (f6 > f9) {
            TrackballAxis trackballAxis12 = trackballAxis2;
            float f11 = motionEvent.getXPrecision();
            float f12 = 2.0f / f11;
            float f13 = f12;
            n13 = trackballAxis12.generate(f13);
            if (n13 != 0) {
                n12 = n13 > 0 ? 22 : 21;
                f10 = trackballAxis2.acceleration;
                TrackballAxis trackballAxis13 = trackballAxis3;
                int n14 = 2;
                trackballAxis13.reset(n14);
            }
        } else if (f9 > 0.0f && (n13 = (trackballAxis = trackballAxis3).generate(f3 = (f2 = 2.0f / (f = motionEvent.getYPrecision())))) != 0) {
            n12 = n13 > 0 ? 20 : 19;
            f10 = trackballAxis3.acceleration;
            TrackballAxis trackballAxis14 = trackballAxis2;
            int n15 = 2;
            trackballAxis14.reset(n15);
        }
        if (n12 == 0) {
            return;
        }
        if (n13 < 0) {
            n13 = -n13;
        }
        if ((n3 = (n2 = (int)((float)n13 * f10))) > (n = n13)) {
            int n16 = n2 - (n13 += -1);
            long l10 = l2;
            KeyEvent keyEvent = new KeyEvent(l2, l10, 2, n12, n16, n7);
            ViewRoot viewRoot = this;
            KeyEvent keyEvent4 = keyEvent;
            boolean bl = false;
            viewRoot.deliverKeyEvent(keyEvent4, bl);
        }
        while (n13 > 0) {
            n13 += -1;
            l2 = SystemClock.uptimeMillis();
            int n17 = motionEvent.getMetaState();
            long l11 = l2;
            long l12 = l2;
            int n18 = n12;
            KeyEvent keyEvent = new KeyEvent(l11, l12, 0, n18, 0, n17);
            ViewRoot viewRoot = this;
            KeyEvent keyEvent5 = keyEvent;
            boolean bl = false;
            viewRoot.deliverKeyEvent(keyEvent5, bl);
            long l13 = l2;
            KeyEvent keyEvent6 = new KeyEvent(l2, l13, 1, n12, 0, n7);
            ViewRoot viewRoot2 = this;
            KeyEvent keyEvent7 = keyEvent6;
            boolean bl3 = false;
            viewRoot2.deliverKeyEvent(keyEvent7, bl3);
        }
        this.mLastTrackballTime = l = l2;
    }

    private void destroyGL() {
        ViewRoot.nativeAbandonGlCaches();
        EGL10 eGL10 = this.mEgl;
        EGLDisplay eGLDisplay = this.mEglDisplay;
        EGLSurface eGLSurface = EGL10.EGL_NO_SURFACE;
        EGLSurface eGLSurface2 = EGL10.EGL_NO_SURFACE;
        EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
        boolean bl = eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface2, eGLContext);
        EGL10 eGL102 = this.mEgl;
        EGLDisplay eGLDisplay2 = this.mEglDisplay;
        EGLContext eGLContext2 = this.mEglContext;
        boolean bl2 = eGL102.eglDestroyContext(eGLDisplay2, eGLContext2);
        EGL10 eGL103 = this.mEgl;
        EGLDisplay eGLDisplay3 = this.mEglDisplay;
        EGLSurface eGLSurface3 = this.mEglSurface;
        boolean bl3 = eGL103.eglDestroySurface(eGLDisplay3, eGLSurface3);
        EGL10 eGL104 = this.mEgl;
        EGLDisplay eGLDisplay4 = this.mEglDisplay;
        boolean bl4 = eGL104.eglTerminate(eGLDisplay4);
        this.mEglContext = null;
        this.mEglSurface = null;
        this.mEglDisplay = null;
        this.mEgl = null;
        this.mGlCanvas = null;
        this.mGL = null;
        this.mUseGL = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchKey(KeyEvent keyEvent, boolean bl) {
        Message message = this.obtainMessage(1005);
        message.obj = keyEvent;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        long l = keyEvent.getEventTime();
        boolean bl2 = this.sendMessageAtTime(message, l);
    }

    private void dispatchMotion(MotionEvent motionEvent, boolean bl) {
        int n = motionEvent.getSource();
        if ((n & 2) != 0) {
            this.dispatchPointer(motionEvent, bl);
            return;
        }
        if ((n & 4) != 0) {
            this.dispatchTrackball(motionEvent, bl);
            return;
        }
        String string2 = "Dropping unsupported motion event (unimplemented): " + motionEvent;
        int n2 = Log.v(TAG, string2);
        if (!bl) {
            return;
        }
        this.finishInputEvent();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchPointer(MotionEvent motionEvent, boolean bl) {
        Message message = this.obtainMessage(1006);
        message.obj = motionEvent;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        long l = motionEvent.getEventTime();
        boolean bl2 = this.sendMessageAtTime(message, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchTrackball(MotionEvent motionEvent, boolean bl) {
        Message message = this.obtainMessage(1007);
        message.obj = motionEvent;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        long l = motionEvent.getEventTime();
        boolean bl2 = this.sendMessageAtTime(message, l);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void draw(boolean bl) {
        boolean bl2;
        int n;
        Canvas canvas;
        boolean bl3;
        Surface surface;
        block33: {
            int n2;
            int n3;
            int n4;
            surface = this.mSurface;
            if (surface == null) {
                return;
            }
            if (!surface.isValid()) {
                return;
            }
            if (!sFirstDrawComplete) {
                ArrayList<Runnable> arrayList = sFirstDrawHandlers;
                synchronized (arrayList) {
                    int n5;
                    int n6;
                    int n7;
                    Object var4_4 = null;
                    sFirstDrawComplete = var4_4;
                    int n8 = 0;
                    while ((n7 = n8) < (n6 = (n5 = sFirstDrawHandlers.size()))) {
                        ArrayList<Runnable> arrayList2 = sFirstDrawHandlers;
                        int n9 = n8++;
                        Runnable runnable = arrayList2.get(n9);
                        ViewRoot viewRoot = this;
                        Runnable runnable2 = runnable;
                        boolean bl4 = viewRoot.post(runnable2);
                    }
                }
            }
            ViewRoot viewRoot = this;
            Rect rect = null;
            boolean bl5 = false;
            boolean bl6 = viewRoot.scrollToRectOrFocus(rect, bl5);
            if (this.mAttachInfo.mViewScrollChanged) {
                boolean bl7;
                View.AttachInfo attachInfo = this.mAttachInfo;
                attachInfo.mViewScrollChanged = bl7 = false;
                this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
            }
            if ((n4 = this.mCurScrollY) != (n3 = (n2 = (bl3 = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY))) {
                int n10;
                this.mCurScrollY = n10 = n2;
                bl = true;
            }
            float f = this.mAttachInfo.mApplicationScale;
            boolean bl8 = this.mAttachInfo.mScalingRequired;
            Rect rect2 = this.mDirty;
            if (this.mSurfaceHolder != null) {
                rect2.setEmpty();
                return;
            }
            if (this.mUseGL) {
                boolean bl9;
                int n11;
                Canvas canvas2;
                if (!rect2.isEmpty()) {
                    canvas2 = this.mGlCanvas;
                    if (this.mGL != null && canvas2 != null) {
                        boolean bl10;
                        int n12;
                        boolean bl11;
                        long l;
                        this.mGL.glDisable(3089);
                        this.mGL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                        this.mGL.glClear(16384);
                        this.mGL.glEnable(3089);
                        View.AttachInfo attachInfo = this.mAttachInfo;
                        attachInfo.mDrawingTime = l = SystemClock.uptimeMillis();
                        View.AttachInfo attachInfo2 = this.mAttachInfo;
                        attachInfo2.mIgnoreDirtyState = bl11 = true;
                        View view = this.mView;
                        view.mPrivateFlags = n12 = view.mPrivateFlags | 0x20;
                        Canvas canvas3 = canvas2;
                        int n13 = 1;
                        n11 = canvas3.save(n13);
                        int n14 = 0;
                        float f2 = -n2;
                        Canvas canvas4 = canvas2;
                        int n15 = n14;
                        float f3 = f2;
                        canvas4.translate(n15, f3);
                        if (this.mTranslator != null) {
                            CompatibilityInfo.Translator translator = this.mTranslator;
                            Canvas canvas5 = canvas2;
                            translator.translateCanvas(canvas5);
                        }
                        n14 = bl8 ? DisplayMetrics.DENSITY_DEVICE : 0;
                        Canvas canvas6 = canvas2;
                        int n16 = n14;
                        canvas6.setScreenDensity(n16);
                        View view2 = this.mView;
                        Canvas canvas7 = canvas2;
                        view2.draw(canvas7);
                        canvas2.restoreToCount(n11);
                        View.AttachInfo attachInfo3 = this.mAttachInfo;
                        attachInfo3.mIgnoreDirtyState = bl10 = false;
                        EGL10 eGL10 = this.mEgl;
                        EGLDisplay eGLDisplay = this.mEglDisplay;
                        EGLSurface eGLSurface = this.mEglSurface;
                        boolean bl12 = eGL10.eglSwapBuffers(eGLDisplay, eGLSurface);
                        this.checkEglErrors();
                    }
                }
                if (!bl3) {
                    return;
                }
                this.mFullRedrawNeeded = bl9 = true;
                this.scheduleTraversals();
                return;
                catch (Throwable throwable) {
                    canvas2.restoreToCount(n11);
                    throw throwable;
                }
            }
            if (bl) {
                boolean bl13;
                View.AttachInfo attachInfo = this.mAttachInfo;
                attachInfo.mIgnoreDirtyState = bl13 = true;
                int n17 = (int)((float)this.mWidth * f + 0.5f);
                int n18 = (int)((float)this.mHeight * f + 0.5f);
                Rect rect3 = rect2;
                int n19 = 0;
                int n20 = 0;
                int n21 = n17;
                int n22 = n18;
                rect3.union(n19, n20, n21, n22);
            }
            if (!rect2.isEmpty() || this.mIsAnimating) {
                boolean bl14;
                int n23;
                int n24;
                long l;
                boolean bl15;
                int n25;
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32;
                int n33;
                int n34 = rect2.left;
                int n35 = rect2.top;
                int n36 = rect2.right;
                int n37 = rect2.bottom;
                Surface surface2 = surface;
                Rect rect4 = rect2;
                canvas = surface2.lockCanvas(rect4);
                int n38 = rect2.left;
                int n39 = n34;
                int n40 = n38;
                if (n39 == n40 || (n33 = n35) == (n32 = (n31 = rect2.top)) || (n30 = n36) == (n29 = (n28 = rect2.right)) || (n27 = n37) != (n26 = (n25 = rect2.bottom))) {
                    boolean bl16;
                    View.AttachInfo attachInfo = this.mAttachInfo;
                    attachInfo.mIgnoreDirtyState = bl16 = true;
                }
                int n41 = this.mDensity;
                Canvas canvas8 = canvas;
                int n42 = n41;
                canvas8.setDensity(n42);
                if (rect2.isEmpty() && !this.mIsAnimating) break block33;
                if (!canvas.isOpaque() || n2 != 0) {
                    PorterDuff.Mode mode = PorterDuff.Mode.CLEAR;
                    Canvas canvas9 = canvas;
                    int n43 = 0;
                    PorterDuff.Mode mode2 = mode;
                    canvas9.drawColor(n43, mode2);
                }
                rect2.setEmpty();
                this.mIsAnimating = bl15 = false;
                View.AttachInfo attachInfo = this.mAttachInfo;
                attachInfo.mDrawingTime = l = SystemClock.uptimeMillis();
                View view = this.mView;
                view.mPrivateFlags = n24 = view.mPrivateFlags | 0x20;
                Canvas canvas10 = canvas;
                int n44 = 1;
                n = n23 = canvas10.save(n44);
                int n45 = 0;
                float f4 = -n2;
                Canvas canvas11 = canvas;
                int n46 = n45;
                float f5 = f4;
                canvas11.translate(n46, f5);
                if (this.mTranslator != null) {
                    CompatibilityInfo.Translator translator = this.mTranslator;
                    Canvas canvas12 = canvas;
                    translator.translateCanvas(canvas12);
                }
                n45 = bl8 ? DisplayMetrics.DENSITY_DEVICE : 0;
                Canvas canvas13 = canvas;
                int n47 = n45;
                canvas13.setScreenDensity(n47);
                View view3 = this.mView;
                Canvas canvas14 = canvas;
                view3.draw(canvas14);
                View.AttachInfo attachInfo4 = this.mAttachInfo;
                attachInfo4.mIgnoreDirtyState = bl14 = false;
                canvas.restoreToCount(n);
            }
        }
        if (!bl3) {
            return;
        }
        this.mFullRedrawNeeded = bl2 = true;
        this.scheduleTraversals();
        return;
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            String string2 = TAG;
            String string3 = "OutOfResourcesException locking surface";
            Surface.OutOfResourcesException outOfResourcesException2 = outOfResourcesException;
            int n48 = Log.e(string2, string3, outOfResourcesException2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string4 = TAG;
            String string5 = "IllegalArgumentException locking surface";
            IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
            int n49 = Log.e(string4, string5, illegalArgumentException2);
            return;
        }
        catch (Throwable throwable) {
            boolean bl17;
            View.AttachInfo attachInfo = this.mAttachInfo;
            attachInfo.mIgnoreDirtyState = bl17 = false;
            canvas.restoreToCount(n);
            throw throwable;
        }
        finally {
            Surface surface3 = surface;
            Canvas canvas15 = canvas;
            surface3.unlockCanvasAndPost(canvas15);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ensureTouchModeLocally(boolean bl) {
        if (this.mAttachInfo.mInTouchMode != bl) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = bl;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(bl);
        if (!bl) return this.leaveTouchMode();
        return this.enterTouchMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean enterTouchMode() {
        if (this.mView == null) return false;
        if (!this.mView.hasFocus()) return false;
        View view = this.mView.findFocus();
        if (view == null) return false;
        if (view.isFocusableInTouchMode()) return false;
        ViewGroup viewGroup = this.findAncestorToTakeFocusInTouchMode(view);
        if (viewGroup != null) {
            return viewGroup.requestFocus();
        }
        this.mView.unFocus();
        this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(view, null);
        this.mFocusedView = null;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ViewGroup findAncestorToTakeFocusInTouchMode(View view) {
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup.getDescendantFocusability() == 262144 && viewGroup.isFocusableInTouchMode()) {
                return viewGroup;
            }
            if (viewGroup.isRootNamespace()) {
                return null;
            }
            viewParent = viewGroup.getParent();
        }
        return null;
    }

    private void finishInputEvent() {
        if (this.mFinishedCallback != null) {
            this.mFinishedCallback.run();
            this.mFinishedCallback = null;
            return;
        }
        int n = Slog.w(TAG, "Attempted to tell the input queue that the current input event is finished but there is no input event actually in progress.");
    }

    private static void forceLayout(View view) {
        view.forceLayout();
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ViewRoot.forceLayout(viewGroup.getChildAt(n2));
            ++n2;
        }
        return;
    }

    private AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            AudioManager audioManager;
            this.mAudioManager = audioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    public static long getInstanceCount() {
        return sInstanceCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getRootMeasureSpec(int n, int n2) {
        switch (n2) {
            default: {
                return View.MeasureSpec.makeMeasureSpec(n2, 0x40000000);
            }
            case -1: {
                return View.MeasureSpec.makeMeasureSpec(n, 0x40000000);
            }
            case -2: 
        }
        return View.MeasureSpec.makeMeasureSpec(n, Integer.MIN_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RunQueue getRunQueue() {
        RunQueue runQueue = sRunQueues.get();
        if (runQueue != null) {
            return runQueue;
        }
        runQueue = new RunQueue();
        sRunQueues.set(runQueue);
        return runQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IWindowSession getWindowSession(Looper looper) {
        Object object = mStaticInit;
        synchronized (object) {
            boolean bl = mInitialized;
            if (bl) return sWindowSession;
            try {
                InputMethodManager inputMethodManager = InputMethodManager.getInstance(looper);
                IWindowManager iWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                IInputMethodClient iInputMethodClient = inputMethodManager.getClient();
                IInputContext iInputContext = inputMethodManager.getInputContext();
                sWindowSession = iWindowManager.openSession(iInputMethodClient, iInputContext);
                mInitialized = true;
            }
            catch (RemoteException remoteException) {
                return sWindowSession;
            }
            return sWindowSession;
        }
    }

    private void initializeGL() {
        this.initializeGLInner();
        if (this.mEgl.eglGetError() == 12288) {
            return;
        }
        this.destroyGL();
        this.mGlWanted = false;
    }

    private void initializeGLInner() {
        Canvas canvas;
        GL11 gL11;
        EGLSurface eGLSurface;
        EGLContext eGLContext;
        EGLDisplay eGLDisplay;
        EGL10 eGL10;
        this.mEgl = eGL10 = (EGL10)EGLContext.getEGL();
        Object object = EGL10.EGL_DEFAULT_DISPLAY;
        this.mEglDisplay = eGLDisplay = eGL10.eglGetDisplay(object);
        int[] nArray = new int[2];
        boolean bl = eGL10.eglInitialize(eGLDisplay, nArray);
        int[] nArray2 = new int[]{12324, 5, 12323, 6, 12322, 5, 12325, 0, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray3 = new int[1];
        boolean bl2 = eGL10.eglChooseConfig(eGLDisplay, nArray2, eGLConfigArray, 1, nArray3);
        EGLConfig eGLConfig = eGLConfigArray[0];
        EGLContext eGLContext2 = EGL10.EGL_NO_CONTEXT;
        this.mEglContext = eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext2, null);
        SurfaceHolder surfaceHolder = this.mHolder;
        this.mEglSurface = eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, surfaceHolder, null);
        boolean bl3 = eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface, eGLContext);
        this.mGL = gL11 = (GL11)eGLContext.getGL();
        this.mGlCanvas = canvas = new Canvas(gL11);
        this.mUseGL = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isDirectional(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isInTouchMode() {
        if (!mInitialized) return false;
        try {
            boolean bl = sWindowSession.getInTouchMode();
            return bl;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isKeyboardKey(KeyEvent keyEvent) {
        if (keyEvent.getUnicodeChar() <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isViewDescendantOf(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent viewParent = view.getParent();
        if (!(viewParent instanceof ViewGroup)) return false;
        if (!ViewRoot.isViewDescendantOf((View)((Object)viewParent), view2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean leaveTouchMode() {
        View view;
        if (this.mView == null) return false;
        if (this.mView.hasFocus()) {
            View view2;
            this.mFocusedView = view2 = this.mView.findFocus();
            if (!(this.mFocusedView instanceof ViewGroup)) {
                return false;
            }
            if (((ViewGroup)this.mFocusedView).getDescendantFocusability() != 262144) {
                return false;
            }
        }
        if ((view = this.focusSearch(null, 130)) == null) return false;
        return view.requestFocus(130);
    }

    private static native void nativeAbandonGlCaches();

    private static native void nativeShowFPS(Canvas var0, int var1);

    /*
     * Exception decompiling
     */
    private void performTraversals() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int relayoutWindow(WindowManager.LayoutParams layoutParams, int n, boolean bl) throws RemoteException {
        float f = this.mAttachInfo.mApplicationScale;
        boolean bl2 = false;
        if (layoutParams != null && this.mTranslator != null) {
            bl2 = true;
            layoutParams.backup();
            CompatibilityInfo.Translator translator = this.mTranslator;
            WindowManager.LayoutParams layoutParams2 = layoutParams;
            translator.translateWindowLayout(layoutParams2);
        }
        if (layoutParams != null) {
            // empty if block
        }
        this.mPendingConfiguration.seq = 0;
        IWindowSession iWindowSession = sWindowSession;
        W w = this.mWindow;
        int n2 = (int)((float)this.mView.mMeasuredWidth * f + 0.5f);
        int n3 = (int)((float)this.mView.mMeasuredHeight * f + 0.5f);
        Rect rect = this.mWinFrame;
        Rect rect2 = this.mPendingContentInsets;
        Rect rect3 = this.mPendingVisibleInsets;
        Configuration configuration = this.mPendingConfiguration;
        Surface surface = this.mSurface;
        WindowManager.LayoutParams layoutParams3 = layoutParams;
        int n4 = n;
        boolean bl3 = bl;
        int n5 = iWindowSession.relayout(w, layoutParams3, n2, n3, n4, bl3, rect, rect2, rect3, configuration, surface);
        if (bl2) {
            layoutParams.restore();
        }
        if (this.mTranslator != null) {
            CompatibilityInfo.Translator translator = this.mTranslator;
            Rect rect4 = this.mWinFrame;
            translator.translateRectInScreenToAppWinFrame(rect4);
            CompatibilityInfo.Translator translator2 = this.mTranslator;
            Rect rect5 = this.mPendingContentInsets;
            translator2.translateRectInScreenToAppWindow(rect5);
            CompatibilityInfo.Translator translator3 = this.mTranslator;
            Rect rect6 = this.mPendingVisibleInsets;
            translator3.translateRectInScreenToAppWindow(rect6);
        }
        return n5;
    }

    private void sendAccessibilityEvents() {
        if (!AccessibilityManager.getInstance(this.mView.getContext()).isEnabled()) {
            return;
        }
        this.mView.sendAccessibilityEvent(32);
        View view = this.mView.findFocus();
        if (view == null) {
            return;
        }
        View view2 = this.mView;
        if (view == view2) {
            return;
        }
        view.sendAccessibilityEvent(8);
    }

    private void startInputEvent(Runnable runnable) {
        if (this.mFinishedCallback != null) {
            int n = Slog.w(TAG, "Received a new input event from the input queue but there is already an unfinished input event in progress.");
        }
        this.mFinishedCallback = runnable;
    }

    @Override
    public void bringChildToFront(View view) {
    }

    void checkThread() {
        Thread thread = this.mThread;
        Thread thread2 = Thread.currentThread();
        if (thread == thread2) {
            return;
        }
        throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
    }

    @Override
    public void childDrawableStateChanged(View view) {
    }

    @Override
    public void clearChildFocus(View view) {
        this.checkThread();
        View view2 = this.mFocusedView;
        this.mRealFocusedView = null;
        this.mFocusedView = null;
        if (this.mView != null && !this.mView.hasFocus()) {
            if (this.mView.requestFocus(2)) {
                return;
            }
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(view2, null);
            return;
        }
        if (view2 == null) {
            return;
        }
        this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(view2, null);
    }

    @Override
    public void createContextMenu(ContextMenu contextMenu) {
    }

    public void debug() {
        this.mView.debug();
    }

    public void die(boolean bl) {
        if (bl) {
            this.doDie();
            return;
        }
        boolean bl2 = this.sendEmptyMessage(1001);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchAppVisibility(boolean bl) {
        Message message = this.obtainMessage(1008);
        int n = bl ? 1 : 0;
        message.arg1 = n;
        boolean bl2 = this.sendMessage(message);
    }

    public void dispatchCloseSystemDialogs(String string2) {
        Message message = Message.obtain();
        message.what = 1014;
        message.obj = string2;
        boolean bl = this.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchDetachedFromWindow() {
        if (this.mView != null) {
            this.mView.dispatchDetachedFromWindow();
        }
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.mAttachInfo.mSurface = null;
        if (this.mUseGL) {
            this.destroyGL();
        }
        this.mSurface.release();
        if (this.mInputChannel != null) {
            if (this.mInputQueueCallback != null) {
                InputQueue.Callback callback = this.mInputQueueCallback;
                InputQueue inputQueue = this.mInputQueue;
                callback.onInputQueueDestroyed(inputQueue);
                this.mInputQueueCallback = null;
            } else {
                InputQueue.unregisterInputChannel(this.mInputChannel);
            }
        }
        try {
            IWindowSession iWindowSession = sWindowSession;
            W w = this.mWindow;
            iWindowSession.remove(w);
        }
        catch (RemoteException remoteException) {}
        if (this.mInputChannel == null) {
            return;
        }
        this.mInputChannel.dispose();
        this.mInputChannel = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchFinishedEvent(int n, boolean bl) {
        Message message = this.obtainMessage(1010);
        message.arg1 = n;
        int n2 = bl ? 1 : 0;
        message.arg2 = n2;
        boolean bl2 = this.sendMessage(message);
    }

    public void dispatchGetNewSurface() {
        Message message = this.obtainMessage(1009);
        boolean bl = this.sendMessage(message);
    }

    public void dispatchKey(KeyEvent keyEvent) {
        this.dispatchKey(keyEvent, false);
    }

    public void dispatchMotion(MotionEvent motionEvent) {
        this.dispatchMotion(motionEvent, false);
    }

    public void dispatchPointer(MotionEvent motionEvent) {
        this.dispatchPointer(motionEvent, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchResized(int n, int n2, Rect rect, Rect rect2, boolean bl, Configuration configuration) {
        Rect rect3;
        Rect rect4;
        int n3 = bl ? 1003 : 1002;
        Message message = this.obtainMessage(n3);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(rect);
            this.mTranslator.translateRectInScreenToAppWindow(rect2);
            float f = n;
            float f2 = this.mTranslator.applicationInvertedScale;
            n = (int)(f * f2);
            float f3 = n2;
            float f4 = this.mTranslator.applicationInvertedScale;
            n2 = (int)(f3 * f4);
        }
        message.arg1 = n;
        message.arg2 = n2;
        ResizedInfo resizedInfo = new ResizedInfo();
        resizedInfo.coveredInsets = rect4 = new Rect(rect);
        resizedInfo.visibleInsets = rect3 = new Rect(rect2);
        resizedInfo.newConfig = configuration;
        message.obj = resizedInfo;
        boolean bl2 = this.sendMessage(message);
    }

    public void dispatchTrackball(MotionEvent motionEvent) {
        this.dispatchTrackball(motionEvent, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doDie() {
        this.checkThread();
        synchronized (this) {
            if (this.mAdded && !this.mFirst) {
                int n = this.mView.getVisibility();
                boolean bl = this.mViewVisibility != n;
                boolean bl2 = this.mWindowAttributesChanged;
                if (bl2 || bl) {
                    try {
                        WindowManager.LayoutParams layoutParams = this.mWindowAttributes;
                        if ((this.relayoutWindow(layoutParams, n, false) & 2) != 0) {
                            IWindowSession iWindowSession = sWindowSession;
                            W w = this.mWindow;
                            iWindowSession.finishDrawing(w);
                        }
                    }
                    catch (RemoteException remoteException) {}
                }
                this.mSurface.release();
            }
            if (this.mAdded) {
                this.mAdded = false;
                this.dispatchDetachedFromWindow();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int enqueuePendingEvent(Object object, boolean bl) {
        int n = this.mPendingEventSeq + 1;
        if (n < 0) {
            n = 0;
        }
        this.mPendingEventSeq = n;
        this.mPendingEvents.put(n, object);
        if (!bl) return -n;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean ensureTouchMode(boolean bl) {
        if (this.mAttachInfo.mInTouchMode != bl) {
            return false;
        }
        try {
            sWindowSession.setInTouchMode(bl);
            return this.ensureTouchModeLocally(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View focusSearch(View view, int n) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        FocusFinder focusFinder = FocusFinder.getInstance();
        ViewGroup viewGroup = (ViewGroup)this.mView;
        return focusFinder.findNextFocus(viewGroup, view, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void focusableViewAvailable(View view) {
        View view2;
        this.checkThread();
        if (this.mView != null && !this.mView.hasFocus()) {
            boolean bl = view.requestFocus();
            return;
        }
        this.mFocusedView = view2 = this.mView.findFocus();
        if (!(this.mFocusedView instanceof ViewGroup)) return;
        if (((ViewGroup)this.mFocusedView).getDescendantFocusability() != 262144) return;
        boolean bl = true;
        if (!bl) {
            return;
        }
        View view3 = this.mFocusedView;
        if (!ViewRoot.isViewDescendantOf(view, view3)) {
            return;
        }
        boolean bl2 = view.requestFocus();
    }

    @Override
    public boolean getChildVisibleRect(View view, Rect rect, Point point) {
        View view2 = this.mView;
        if (view != view2) {
            throw new RuntimeException("child is not mine, honest!");
        }
        int n = this.mWidth;
        int n2 = this.mHeight;
        return rect.intersect(0, 0, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getHostVisibility() {
        if (!this.mAppVisible) return 8;
        return this.mView.getVisibility();
    }

    final WindowLeaked getLocation() {
        return this.mLocation;
    }

    @Override
    public ViewParent getParent() {
        return null;
    }

    public View getView() {
        return this.mView;
    }

    protected Rect getWindowFrame() {
        return this.mWinFrame;
    }

    void handleAppVisibility(boolean bl) {
        if (this.mAppVisible != bl) {
            return;
        }
        this.mAppVisible = bl;
        this.scheduleTraversals();
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleFinishedEvent(int n, boolean bl) {
        KeyEvent keyEvent = (KeyEvent)this.retrievePendingEvent(n);
        if (keyEvent == null) {
            return;
        }
        boolean bl2 = n >= 0;
        if (!bl) {
            this.deliverKeyEventToViewHierarchy(keyEvent, bl2);
            return;
        }
        if (bl2) {
            this.finishInputEvent();
            return;
        }
        String string2 = "handleFinishedEvent(seq=" + n + " handled=" + bl + " ev=" + keyEvent + ") neither delivering nor finishing key";
        int n2 = Log.w(TAG, string2);
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        int n = 0x3F000000;
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                ((View)message.obj).invalidate();
                return;
            }
            case 2: {
                View.AttachInfo.InvalidateInfo invalidateInfo = (View.AttachInfo.InvalidateInfo)message.obj;
                View view = invalidateInfo.target;
                int n2 = invalidateInfo.left;
                int n3 = invalidateInfo.top;
                int n4 = invalidateInfo.right;
                int n5 = invalidateInfo.bottom;
                view.invalidate(n2, n3, n4, n5);
                invalidateInfo.release();
                return;
            }
            case 1000: {
                if (this.mProfile) {
                    Debug.startMethodTracing(TAG);
                }
                this.performTraversals();
                if (!this.mProfile) {
                    return;
                }
                Debug.stopMethodTracing();
                this.mProfile = false;
                return;
            }
            case 1010: {
                int n6 = message.arg1;
                boolean bl = message.arg2 != 0;
                this.handleFinishedEvent(n6, bl);
                return;
            }
            case 1005: {
                KeyEvent keyEvent = (KeyEvent)message.obj;
                boolean bl = message.arg1 != 0;
                this.deliverKeyEvent(keyEvent, bl);
                return;
            }
            case 1006: {
                MotionEvent motionEvent = (MotionEvent)message.obj;
                try {
                    this.deliverPointerEvent(motionEvent);
                    motionEvent.recycle();
                    if (message.arg1 == 0) {
                        return;
                    }
                    this.finishInputEvent();
                    return;
                }
                catch (Throwable throwable) {
                    motionEvent.recycle();
                    if (message.arg1 != 0) {
                        this.finishInputEvent();
                    }
                    throw throwable;
                }
            }
            case 1007: {
                MotionEvent motionEvent = (MotionEvent)message.obj;
                try {
                    this.deliverTrackballEvent(motionEvent);
                    motionEvent.recycle();
                    if (message.arg1 == 0) {
                        return;
                    }
                    this.finishInputEvent();
                    return;
                }
                catch (Throwable throwable) {
                    motionEvent.recycle();
                    if (message.arg1 != 0) {
                        this.finishInputEvent();
                    }
                    throw throwable;
                }
            }
            case 1008: {
                boolean bl = message.arg1 != 0;
                this.handleAppVisibility(bl);
                return;
            }
            case 1009: {
                this.handleGetNewSurface();
                return;
            }
            case 1002: {
                Rect rect;
                Rect rect2;
                Rect rect3;
                Rect rect4;
                int n7;
                int n8;
                ResizedInfo resizedInfo = (ResizedInfo)message.obj;
                int n9 = this.mWinFrame.width();
                int n10 = message.arg1;
                if (n9 != n10 && (n8 = this.mWinFrame.height()) != (n7 = message.arg2) && (rect4 = this.mPendingContentInsets).equals(rect3 = resizedInfo.coveredInsets) && (rect2 = this.mPendingVisibleInsets).equals(rect = resizedInfo.visibleInsets) && ((ResizedInfo)message.obj).newConfig == null) {
                    return;
                }
            }
            case 1003: {
                int n11;
                int n12;
                if (!this.mAdded) {
                    return;
                }
                Configuration configuration = ((ResizedInfo)message.obj).newConfig;
                if (configuration != null) {
                    this.updateConfiguration(configuration, false);
                }
                this.mWinFrame.left = 0;
                Rect rect = this.mWinFrame;
                rect.right = n12 = message.arg1;
                this.mWinFrame.top = 0;
                Rect rect5 = this.mWinFrame;
                rect5.bottom = n11 = message.arg2;
                Rect rect6 = this.mPendingContentInsets;
                Rect rect7 = ((ResizedInfo)message.obj).coveredInsets;
                rect6.set(rect7);
                Rect rect8 = this.mPendingVisibleInsets;
                Rect rect9 = ((ResizedInfo)message.obj).visibleInsets;
                rect8.set(rect9);
                if (message.what == 1003) {
                    this.mReportNextDraw = true;
                }
                if (this.mView != null) {
                    ViewRoot.forceLayout(this.mView);
                }
                this.requestLayout();
                return;
            }
            case 1004: {
                boolean bl;
                if (!this.mAdded) {
                    return;
                }
                boolean bl2 = message.arg1 != 0;
                this.mAttachInfo.mHasWindowFocus = bl2;
                if (bl2) {
                    boolean bl3 = message.arg2 != 0;
                    boolean bl4 = this.ensureTouchModeLocally(bl3);
                    if (this.mGlWanted) {
                        this.checkEglErrors();
                        if (this.mGlWanted && !this.mUseGL) {
                            this.initializeGL();
                            if (this.mGlCanvas != null) {
                                float f = this.mAttachInfo.mApplicationScale;
                                Canvas canvas = this.mGlCanvas;
                                int n13 = (int)((float)this.mWidth * f + 0.5f);
                                int n14 = (int)((float)this.mHeight * f + 0.5f);
                                canvas.setViewport(n13, n14);
                            }
                        }
                    }
                }
                this.mLastWasImTarget = bl = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags);
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (this.mView != null) {
                    if (bl2 && inputMethodManager != null && this.mLastWasImTarget) {
                        View view = this.mView;
                        inputMethodManager.startGettingWindowFocus(view);
                    }
                    this.mAttachInfo.mKeyDispatchState.reset();
                    this.mView.dispatchWindowFocusChanged(bl2);
                }
                if (bl2) {
                    int n15;
                    int n16;
                    if (inputMethodManager != null && this.mLastWasImTarget) {
                        void var2_4;
                        View view = this.mView;
                        View view2 = this.mView.findFocus();
                        int n17 = this.mWindowAttributes.softInputMode;
                        if (!this.mHasHadWindowFocus) {
                            boolean bl5 = true;
                        } else {
                            boolean bl6 = false;
                        }
                        int n18 = this.mWindowAttributes.flags;
                        inputMethodManager.onWindowFocus(view, view2, n17, (boolean)var2_4, n18);
                    }
                    WindowManager.LayoutParams layoutParams = this.mWindowAttributes;
                    layoutParams.softInputMode = n16 = layoutParams.softInputMode & 0xFFFFFEFF;
                    WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)this.mView.getLayoutParams();
                    layoutParams2.softInputMode = n15 = layoutParams2.softInputMode & 0xFFFFFEFF;
                    this.mHasHadWindowFocus = true;
                }
                if (!bl2) {
                    return;
                }
                if (this.mView == null) {
                    return;
                }
                this.sendAccessibilityEvents();
                return;
            }
            case 1001: {
                this.doDie();
                return;
            }
            case 1011: {
                KeyEvent keyEvent = (KeyEvent)message.obj;
                if ((keyEvent.getFlags() & 8) != 0) {
                    int n19 = keyEvent.getFlags() & 0xFFFFFFF7;
                    KeyEvent keyEvent2 = KeyEvent.changeFlags(keyEvent, n19);
                }
                KeyEvent keyEvent3 = (KeyEvent)message.obj;
                this.deliverKeyEventToViewHierarchy(keyEvent3, false);
                return;
            }
            case 1012: {
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager == null) {
                    return;
                }
                InputConnection inputConnection = (InputConnection)message.obj;
                inputMethodManager.reportFinishInputConnection(inputConnection);
                return;
            }
            case 1013: {
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager == null) {
                    return;
                }
                inputMethodManager.checkFocus();
                return;
            }
            case 1014: 
        }
        if (this.mView == null) {
            return;
        }
        View view = this.mView;
        String string2 = (String)message.obj;
        view.onCloseSystemDialogs(string2);
    }

    @Override
    public void invalidateChild(View view, Rect rect) {
        this.checkThread();
        if (this.mCurScrollY != 0 || this.mTranslator != null) {
            this.mTempRect.set(rect);
            rect = this.mTempRect;
            if (this.mCurScrollY != 0) {
                int n = -this.mCurScrollY;
                rect.offset(0, n);
            }
            if (this.mTranslator != null) {
                this.mTranslator.translateRectInAppWindowToScreen(rect);
            }
            if (this.mAttachInfo.mScalingRequired) {
                rect.inset(-1, -1);
            }
        }
        this.mDirty.union(rect);
        if (this.mWillDrawSoon) {
            return;
        }
        this.scheduleTraversals();
    }

    @Override
    public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
        this.invalidateChild(null, rect);
        return null;
    }

    @Override
    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performHapticFeedback(int n, boolean bl) {
        try {
            IWindowSession iWindowSession = sWindowSession;
            W w = this.mWindow;
            boolean bl2 = iWindowSession.performHapticFeedback(w, n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void playSoundEffect(int n) {
        this.checkThread();
        try {
            AudioManager audioManager = this.getAudioManager();
            switch (n) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("unknown effect id ").append(n).append(" not defined in ");
                    String string2 = SoundEffectConstants.class.getCanonicalName();
                    String string3 = stringBuilder.append(string2).toString();
                    throw new IllegalArgumentException(string3);
                }
                case 0: {
                    int n2 = 0;
                    audioManager.playSoundEffect(n2);
                    return;
                }
                case 4: {
                    audioManager.playSoundEffect(2);
                    return;
                }
                case 1: {
                    audioManager.playSoundEffect(3);
                    return;
                }
                case 3: {
                    audioManager.playSoundEffect(4);
                    return;
                }
                case 2: 
            }
            audioManager.playSoundEffect(1);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            String string4 = "FATAL EXCEPTION when attempting to play sound effect: " + illegalStateException;
            int n3 = Log.e(TAG, string4);
            illegalStateException.printStackTrace();
            return;
        }
    }

    public void profile() {
        this.mProfile = true;
    }

    @Override
    public void recomputeViewAttributes(View view) {
        this.checkThread();
        if (this.mView != view) {
            return;
        }
        this.mAttachInfo.mRecomputeGlobalAttributes = true;
        if (this.mWillDrawSoon) {
            return;
        }
        this.scheduleTraversals();
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        this.checkThread();
        if (this.mFocusedView != view2) {
            ViewTreeObserver viewTreeObserver = this.mAttachInfo.mTreeObserver;
            View view3 = this.mFocusedView;
            viewTreeObserver.dispatchOnGlobalFocusChange(view3, view2);
            this.scheduleTraversals();
        }
        this.mRealFocusedView = view2;
        this.mFocusedView = view2;
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return this.scrollToRectOrFocus(rect, bl);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
    }

    @Override
    public void requestLayout() {
        this.checkThread();
        this.mLayoutRequested = true;
        this.scheduleTraversals();
    }

    @Override
    public void requestTransparentRegion(View view) {
        int n;
        this.checkThread();
        if (this.mView != view) {
            return;
        }
        View view2 = this.mView;
        view2.mPrivateFlags = n = view2.mPrivateFlags | 0x200;
        this.mWindowAttributesChanged = true;
        this.requestLayout();
    }

    Object retrievePendingEvent(int n) {
        Object object;
        if (n < 0) {
            n = -n;
        }
        if ((object = this.mPendingEvents.get(n)) != null) {
            this.mPendingEvents.remove(n);
        }
        return object;
    }

    public void scheduleTraversals() {
        if (this.mTraversalScheduled) {
            return;
        }
        this.mTraversalScheduled = true;
        boolean bl = this.sendEmptyMessage(1000);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean scrollToRectOrFocus(Rect rect, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        View.AttachInfo attachInfo = this.mAttachInfo;
        Rect rect2 = attachInfo.mContentInsets;
        Rect rect3 = attachInfo.mVisibleInsets;
        int n8 = 0;
        boolean bl2 = false;
        int n9 = rect3.left;
        int n10 = rect2.left;
        if (n9 > n10 || (n7 = rect3.top) > (n6 = rect2.top) || (n5 = rect3.right) > (n4 = rect2.right) || (n3 = rect3.bottom) > (n2 = rect2.bottom)) {
            View view;
            View.AttachInfo attachInfo2;
            View.AttachInfo attachInfo3;
            n8 = this.mScrollY;
            View view2 = this.mRealFocusedView;
            if (view2 == null || (attachInfo3 = view2.mAttachInfo) != (attachInfo2 = this.mAttachInfo)) {
                this.mRealFocusedView = null;
                return false;
            }
            View view3 = this.mLastScrolledFocus;
            if (view2 != view3) {
                rect = null;
            }
            if ((view2 != (view = this.mLastScrolledFocus) || this.mScrollMayChange || rect != null) && view2 != null) {
                this.mLastScrolledFocus = view2;
                this.mScrollMayChange = false;
                Rect rect4 = this.mVisRect;
                if (view2.getGlobalVisibleRect(rect4, null)) {
                    Rect rect5;
                    Rect rect6;
                    if (rect == null) {
                        Rect rect7 = this.mTempRect;
                        view2.getFocusedRect(rect7);
                        if (this.mView instanceof ViewGroup) {
                            ViewGroup viewGroup = (ViewGroup)this.mView;
                            Rect rect8 = this.mTempRect;
                            viewGroup.offsetDescendantRectToMyCoords(view2, rect8);
                        }
                    } else {
                        this.mTempRect.set(rect);
                    }
                    if ((rect6 = this.mTempRect).intersect(rect5 = this.mVisRect)) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16 = this.mTempRect.height();
                        if (n16 <= (n15 = (n14 = (n13 = this.mView.getHeight()) - (n12 = rect3.top)) - (n11 = rect3.bottom))) {
                            int n17 = this.mTempRect.top - n8;
                            int n18 = rect3.top;
                            if (n17 < n18) {
                                int n19 = rect3.top;
                                int n20 = this.mTempRect.top - n8;
                                int n21 = n19 - n20;
                                n8 -= n21;
                            } else {
                                int n22;
                                int n23 = this.mTempRect.bottom - n8;
                                int n24 = this.mView.getHeight();
                                int n25 = n24 - (n22 = rect3.bottom);
                                if (n23 > n25) {
                                    int n26 = this.mTempRect.bottom - n8;
                                    int n27 = this.mView.getHeight();
                                    int n28 = rect3.bottom;
                                    int n29 = n27 - n28;
                                    int n30 = n26 - n29;
                                    n8 += n30;
                                }
                            }
                        }
                        bl2 = true;
                    }
                }
            }
        }
        if (n8 == (n = this.mScrollY)) return bl2;
        if (!bl) {
            if (this.mScroller == null) {
                Scroller scroller;
                Context context = this.mView.getContext();
                this.mScroller = scroller = new Scroller(context);
            }
            Scroller scroller = this.mScroller;
            int n31 = this.mScrollY;
            int n32 = this.mScrollY;
            int n33 = n8 - n32;
            scroller.startScroll(0, n31, 0, n33);
        } else if (this.mScroller != null) {
            this.mScroller.abortAnimation();
        }
        this.mScrollY = n8;
        return bl2;
    }

    void setLayoutParams(WindowManager.LayoutParams layoutParams, boolean bl) {
        synchronized (this) {
            int n;
            int n2 = this.mWindowAttributes.softInputMode;
            int n3 = this.mWindowAttributes.flags & 0x20000000;
            int n4 = this.mWindowAttributes.copyFrom(layoutParams);
            WindowManager.LayoutParams layoutParams2 = this.mWindowAttributes;
            layoutParams2.flags = n = layoutParams2.flags | n3;
            if (bl) {
                int n5;
                this.mSoftInputMode = n5 = layoutParams.softInputMode;
                this.requestLayout();
            }
            if ((layoutParams.softInputMode & 0xF0) == 0) {
                int n6;
                WindowManager.LayoutParams layoutParams3 = this.mWindowAttributes;
                int n7 = this.mWindowAttributes.softInputMode & 0xFFFFFF0F;
                int n8 = n2 & 0xF0;
                layoutParams3.softInputMode = n6 = n7 | n8;
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setView(View view, WindowManager.LayoutParams layoutParams, View view2) {
        synchronized (this) {
            if (this.mView == null) {
                int n;
                View.AttachInfo attachInfo;
                block31: {
                    int n2;
                    InputChannel inputChannel;
                    int n3;
                    CompatibilityInfo.Translator translator;
                    this.mView = view;
                    int n4 = this.mWindowAttributes.copyFrom(layoutParams);
                    layoutParams = this.mWindowAttributes;
                    if (view instanceof RootViewSurfaceTaker) {
                        SurfaceHolder.Callback2 callback2;
                        this.mSurfaceHolderCallback = callback2 = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                        if (this.mSurfaceHolderCallback != null) {
                            TakenSurfaceHolder takenSurfaceHolder = new TakenSurfaceHolder();
                            this.mSurfaceHolder = takenSurfaceHolder;
                            this.mSurfaceHolder.setFormat(0);
                        }
                    }
                    Resources resources = this.mView.getContext().getResources();
                    CompatibilityInfo compatibilityInfo = resources.getCompatibilityInfo();
                    this.mTranslator = translator = compatibilityInfo.getTranslator();
                    if (this.mTranslator != null || !compatibilityInfo.supportsScreen()) {
                        Surface surface = this.mSurface;
                        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
                        CompatibilityInfo.Translator translator2 = this.mTranslator;
                        surface.setCompatibleDisplayMetrics(displayMetrics, translator2);
                    }
                    boolean bl = false;
                    if (this.mTranslator != null) {
                        bl = true;
                        layoutParams.backup();
                        this.mTranslator.translateWindowLayout(layoutParams);
                    }
                    if (!compatibilityInfo.supportsScreen()) {
                        int n5;
                        layoutParams.flags = n5 = layoutParams.flags | 0x20000000;
                    }
                    this.mSoftInputMode = n3 = layoutParams.softInputMode;
                    this.mWindowAttributesChanged = true;
                    this.mAttachInfo.mRootView = view;
                    attachInfo = this.mAttachInfo;
                    float f = this.mTranslator != null ? Float.MIN_VALUE : 0.0f;
                    attachInfo.mScalingRequired = f;
                    attachInfo = this.mAttachInfo;
                    f = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                    attachInfo.mApplicationScale = f;
                    if (view2 != null) {
                        IBinder iBinder;
                        View.AttachInfo attachInfo2 = this.mAttachInfo;
                        attachInfo2.mPanelParentWindowToken = iBinder = view2.getApplicationWindowToken();
                    }
                    this.mAdded = true;
                    this.requestLayout();
                    this.mInputChannel = inputChannel = new InputChannel();
                    IWindowSession iWindowSession = sWindowSession;
                    W w = this.mWindow;
                    WindowManager.LayoutParams layoutParams2 = this.mWindowAttributes;
                    int n6 = this.getHostVisibility();
                    Rect rect = this.mAttachInfo.mContentInsets;
                    InputChannel inputChannel2 = this.mInputChannel;
                    n = n2 = iWindowSession.add(w, layoutParams2, n6, rect, inputChannel2);
                    if (bl) {
                        layoutParams.restore();
                    }
                    if (this.mTranslator != null) {
                        CompatibilityInfo.Translator translator3 = this.mTranslator;
                        Rect rect2 = this.mAttachInfo.mContentInsets;
                        translator3.translateRectInScreenToAppWindow(rect2);
                    }
                    Rect rect3 = this.mPendingContentInsets;
                    Rect rect4 = this.mAttachInfo.mContentInsets;
                    rect3.set(rect4);
                    this.mPendingVisibleInsets.set(0, 0, 0, 0);
                    if (n >= 0) break block31;
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.unscheduleTraversals();
                    switch (n) {
                        default: {
                            String string2 = "Unable to add window -- unknown error code " + n;
                            throw new RuntimeException(string2);
                        }
                        catch (RemoteException remoteException) {
                            attachInfo = null;
                            try {
                                this.mAdded = attachInfo;
                                this.mView = null;
                                this.mAttachInfo.mRootView = null;
                                this.mInputChannel = null;
                                this.unscheduleTraversals();
                                throw new RuntimeException("Adding window failed", remoteException);
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    layoutParams.restore();
                                }
                                throw throwable;
                            }
                        }
                        case -2: 
                        case -1: {
                            StringBuilder stringBuilder = new StringBuilder().append("Unable to add window -- token ");
                            IBinder iBinder = layoutParams.token;
                            String string3 = stringBuilder.append(iBinder).append(" is not valid; is your activity running?").toString();
                            throw new WindowManager.BadTokenException(string3);
                        }
                        case -3: {
                            StringBuilder stringBuilder = new StringBuilder().append("Unable to add window -- token ");
                            IBinder iBinder = layoutParams.token;
                            String string4 = stringBuilder.append(iBinder).append(" is not for an application").toString();
                            throw new WindowManager.BadTokenException(string4);
                        }
                        case -4: {
                            StringBuilder stringBuilder = new StringBuilder().append("Unable to add window -- app for token ");
                            IBinder iBinder = layoutParams.token;
                            String string5 = stringBuilder.append(iBinder).append(" is exiting").toString();
                            throw new WindowManager.BadTokenException(string5);
                        }
                        case -5: {
                            StringBuilder stringBuilder = new StringBuilder().append("Unable to add window -- window ");
                            W w2 = this.mWindow;
                            String string6 = stringBuilder.append(w2).append(" has already been added").toString();
                            throw new WindowManager.BadTokenException(string6);
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            StringBuilder stringBuilder = new StringBuilder().append("Unable to add window ");
                            W w3 = this.mWindow;
                            String string7 = stringBuilder.append(w3).append(" -- another window of this type already exists").toString();
                            throw new WindowManager.BadTokenException(string7);
                        }
                        case -8: 
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to add window ");
                    W w4 = this.mWindow;
                    String string8 = stringBuilder.append(w4).append(" -- permission denied for this window type").toString();
                    throw new WindowManager.BadTokenException(string8);
                }
                if (view instanceof RootViewSurfaceTaker) {
                    InputQueue.Callback callback;
                    this.mInputQueueCallback = callback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (this.mInputQueueCallback != null) {
                    InputQueue inputQueue;
                    InputChannel inputChannel = this.mInputChannel;
                    this.mInputQueue = inputQueue = new InputQueue(inputChannel);
                    InputQueue.Callback callback = this.mInputQueueCallback;
                    InputQueue inputQueue2 = this.mInputQueue;
                    callback.onInputQueueCreated(inputQueue2);
                } else {
                    InputChannel inputChannel = this.mInputChannel;
                    InputHandler inputHandler = this.mInputHandler;
                    MessageQueue messageQueue = Looper.myQueue();
                    InputQueue.registerInputChannel(inputChannel, inputHandler, messageQueue);
                }
                view.assignParent(this);
                attachInfo = (n & 1) != 0 ? null : null;
                this.mAddedTouchMode = attachInfo;
                attachInfo = (n & 2) != 0 ? null : null;
                this.mAppVisible = attachInfo;
            }
            return;
        }
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return false;
    }

    public void unscheduleTraversals() {
        if (!this.mTraversalScheduled) {
            return;
        }
        this.mTraversalScheduled = false;
        this.removeMessages(1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updateConfiguration(Configuration configuration, boolean bl) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        // MONITORENTER : arrayList
        for (int i = sConfigCallbacks.size() - 1; i >= 0; i += -1) {
            sConfigCallbacks.get(i).onConfigurationChanged(configuration);
        }
        // MONITOREXIT : arrayList
        if (this.mView == null) {
            return;
        }
        if (this.mView != null) {
            configuration = this.mView.getResources().getConfiguration();
        }
        if (!bl && this.mLastConfiguration.diff(configuration) == 0) {
            return;
        }
        this.mLastConfiguration.setTo(configuration);
        this.mView.dispatchConfigurationChanged(configuration);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void windowFocusChanged(boolean bl, boolean bl2) {
        Message message = Message.obtain();
        message.what = 1004;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        int n2 = bl2 ? 1 : 0;
        message.arg2 = n2;
        boolean bl3 = this.sendMessage(message);
    }

    static final class RunQueue {
        private final ArrayList<HandlerAction> mActions;

        RunQueue() {
            ArrayList arrayList = new ArrayList();
            this.mActions = arrayList;
        }

        void executeActions(Handler handler) {
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> arrayList2 = this.mActions;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    HandlerAction handlerAction = arrayList2.get(i);
                    Runnable runnable = handlerAction.action;
                    long l = handlerAction.delay;
                    boolean bl = handler.postDelayed(runnable, l);
                }
                arrayList2.clear();
                return;
            }
        }

        void post(Runnable runnable) {
            this.postDelayed(runnable, 0L);
        }

        void postDelayed(Runnable runnable, long l) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = runnable;
            handlerAction.delay = l;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                boolean bl = this.mActions.add(handlerAction);
                return;
            }
        }

        void removeCallbacks(Runnable runnable) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = runnable;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> arrayList2 = this.mActions;
                while (arrayList2.remove(handlerAction)) {
                }
                return;
            }
        }

        private static class HandlerAction {
            Runnable action;
            long delay;

            private HandlerAction() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object object) {
                Class<? extends Object> clazz;
                if (this == object) {
                    return true;
                }
                if (object == null) return false;
                Class<? extends Object> clazz2 = this.getClass();
                if (clazz2 != (clazz = object.getClass())) {
                    return false;
                }
                HandlerAction handlerAction = (HandlerAction)object;
                if (this.action != null) {
                    Runnable runnable = this.action;
                    Runnable runnable2 = handlerAction.action;
                    if (runnable.equals(runnable2)) return true;
                    return false;
                }
                if (handlerAction.action != null) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public int hashCode() {
                int n = this.action != null ? this.action.hashCode() : 0;
                int n2 = n * 31;
                long l = this.delay;
                long l2 = this.delay >>> 32;
                int n3 = (int)(l ^ l2);
                return n2 + n3;
            }
        }
    }

    public static final class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String string2) {
            super(string2);
        }
    }

    static final class TrackballAxis {
        static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        static final long FAST_MOVE_TIME = 150L;
        static final float MAX_ACCELERATION = 20.0f;
        float absPosition;
        float acceleration = 1.0f;
        int dir;
        long lastMoveTime = 0L;
        int nonAccelMovement;
        float position;
        int step;

        TrackballAxis() {
        }

        /*
         * Enabled aggressive block sorting
         */
        float collect(float f, long l, String string2) {
            float f2;
            float f3;
            long l2;
            if (f > 0.0f) {
                l2 = (long)(150.0f * f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (f < 0.0f) {
                l2 = (long)(-f * 150.0f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                l2 = 0L;
            }
            if (l2 > 0L) {
                long l3 = this.lastMoveTime;
                long l4 = l - l3;
                this.lastMoveTime = l;
                float f4 = this.acceleration;
                if (l4 < l2) {
                    float f5 = (float)(l2 - l4) * 0.025f;
                    if (f5 > 1.0f) {
                        f4 *= f5;
                    }
                    float f6 = f4 < 20.0f ? f4 : 20.0f;
                    this.acceleration = f6;
                } else {
                    float f7 = (float)(l4 - l2) * 0.025f;
                    if (f7 > 1.0f) {
                        f4 /= f7;
                    }
                    float f8 = f4 > 1.0f ? f4 : 1.0f;
                    this.acceleration = f8;
                }
            }
            this.position = f3 = this.position + f;
            this.absPosition = f2 = Math.abs(this.position);
            return f2;
        }

        /*
         * Enabled aggressive block sorting
         */
        int generate(float f) {
            int n = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                float f2;
                float f3;
                float f4;
                int n2;
                block6: {
                    float f5;
                    float f6;
                    int n3;
                    block7: {
                        n2 = this.position >= 0.0f ? 1 : -1;
                        switch (this.step) {
                            default: {
                                if (this.absPosition < 1.0f) {
                                    return n;
                                }
                                break block6;
                            }
                            case 0: {
                                int n4;
                                if (this.absPosition < f) return n;
                                n += n2;
                                this.nonAccelMovement = n4 = this.nonAccelMovement + n2;
                                this.step = 1;
                                continue block4;
                            }
                            case 1: {
                                if (!(this.absPosition < 2.0f)) break block7;
                            }
                        }
                        return n;
                    }
                    n += n2;
                    this.nonAccelMovement = n3 = this.nonAccelMovement + n2;
                    float f7 = this.position;
                    f4 = n2 > 0 ? -2.0f : 2.0f;
                    this.position = f6 = f7 + f4;
                    this.absPosition = f5 = Math.abs(this.position);
                    this.step = 2;
                    continue;
                }
                n += n2;
                float f8 = this.position;
                f4 = n2 >= 0 ? -1.0f : 1.0f;
                this.position = f3 = f8 + f4;
                this.absPosition = f2 = Math.abs(this.position);
                float f9 = this.acceleration * 1.1f;
                float f10 = f9 < 20.0f ? f9 : this.acceleration;
                this.acceleration = f10;
            }
        }

        void reset(int n) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = n;
            this.dir = 0;
        }
    }

    static class W
    extends IWindow.Stub {
        private final WeakReference<ViewRoot> mViewRoot;

        public W(ViewRoot viewRoot, Context context) {
            WeakReference<ViewRoot> weakReference = new WeakReference<ViewRoot>(viewRoot);
            this.mViewRoot = weakReference;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int checkCallingPermission(String string2) {
            if (!Process.supportsProcesses()) {
                return 0;
            }
            try {
                IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                int n = Binder.getCallingPid();
                int n2 = Binder.getCallingUid();
                int n3 = iActivityManager.checkPermission(string2, n, n2);
                return n3;
            }
            catch (RemoteException remoteException) {
                return -1;
            }
        }

        @Override
        public void closeSystemDialogs(String string2) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null) {
                return;
            }
            viewRoot.dispatchCloseSystemDialogs(string2);
        }

        @Override
        public void dispatchAppVisibility(boolean bl) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null) {
                return;
            }
            viewRoot.dispatchAppVisibility(bl);
        }

        @Override
        public void dispatchGetNewSurface() {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null) {
                return;
            }
            viewRoot.dispatchGetNewSurface();
        }

        @Override
        public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            if (!bl) {
                return;
            }
            try {
                IWindowSession iWindowSession = sWindowSession;
                IBinder iBinder = this.asBinder();
                iWindowSession.wallpaperCommandComplete(iBinder, null);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void dispatchWallpaperOffsets(float f, float f2, float f3, float f4, boolean bl) {
            if (!bl) {
                return;
            }
            try {
                IWindowSession iWindowSession = sWindowSession;
                IBinder iBinder = this.asBinder();
                iWindowSession.wallpaperOffsetsComplete(iBinder);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void executeCommand(String var1_1, String var2_2, ParcelFileDescriptor var3_3) {
            block21: {
                var4_4 = (ViewRoot)this.mViewRoot.get();
                if (var4_4 == null) {
                    return;
                }
                var5_5 = var4_4.mView;
                if (var5_5 == null) {
                    return;
                }
                if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                    var6_6 = new StringBuilder().append("Insufficient permissions to invoke executeCommand() from pid=");
                    var7_7 = Binder.getCallingPid();
                    var8_8 = var6_6.append(var7_7).append(", uid=");
                    var9_9 = Binder.getCallingUid();
                    var10_10 = var8_8.append(var9_9).toString();
                    throw new SecurityException(var10_10);
                }
                var11_11 = null;
                var12_12 = new ParcelFileDescriptor.AutoCloseOutputStream(var3_3);
                ViewDebug.dispatchCommand(var5_5, var1_1, var2_2, var12_12);
                if (var12_12 != null) break block21;
                return;
            }
            var12_12.close();
            return;
            catch (IOException var13_13) lbl-1000:
            // 2 sources

            {
                while (true) {
                    block22: {
                        var13_14.printStackTrace();
                        if (var11_11 != null) break block22;
                        return;
                    }
                    try {
                        var11_11.close();
                        return;
                    }
                    catch (IOException var13_15) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            var13_16.printStackTrace();
                            return;
                        }
                    }
                    catch (Throwable var14_19) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var11_11 != null) {
                                var11_11.close();
                            }
lbl44:
                            // 4 sources

                            throw var14_20;
                            catch (IOException v0) {
                                v0.printStackTrace();
                                ** continue;
                            }
                            break;
                        }
                    }
                    break;
                }
            }
            catch (IOException var13_17) {
                ** continue;
            }
            catch (Throwable var14_21) {
                var11_11 = var12_12;
                ** continue;
            }
            catch (IOException var13_18) {
                var11_11 = var12_12;
                ** continue;
            }
        }

        @Override
        public void resized(int n, int n2, Rect rect, Rect rect2, boolean bl, Configuration configuration) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null) {
                return;
            }
            int n3 = n;
            int n4 = n2;
            Rect rect3 = rect;
            Rect rect4 = rect2;
            boolean bl2 = bl;
            Configuration configuration2 = configuration;
            viewRoot.dispatchResized(n3, n4, rect3, rect4, bl2, configuration2);
        }

        @Override
        public void windowFocusChanged(boolean bl, boolean bl2) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null) {
                return;
            }
            viewRoot.windowFocusChanged(bl, bl2);
        }
    }

    static class InputMethodCallback
    extends IInputMethodCallback.Stub {
        private WeakReference<ViewRoot> mViewRoot;

        public InputMethodCallback(ViewRoot viewRoot) {
            WeakReference<ViewRoot> weakReference = new WeakReference<ViewRoot>(viewRoot);
            this.mViewRoot = weakReference;
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null) {
                return;
            }
            viewRoot.dispatchFinishedEvent(n, bl);
        }

        @Override
        public void sessionCreated(IInputMethodSession iInputMethodSession) throws RemoteException {
        }
    }

    class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        TakenSurfaceHolder() {
        }

        @Override
        public boolean isCreating() {
            return ViewRoot.this.mIsCreating;
        }

        @Override
        public boolean onAllowLockCanvas() {
            return ViewRoot.this.mDrawingAllowed;
        }

        @Override
        public void onRelayoutContainer() {
        }

        @Override
        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        @Override
        public void setFixedSize(int n, int n2) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        @Override
        public void setFormat(int n) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceFormat(n);
        }

        @Override
        public void setKeepScreenOn(boolean bl) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceKeepScreenOn(bl);
        }

        @Override
        public void setType(int n) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceType(n);
        }
    }

    class ResizedInfo {
        Rect coveredInsets;
        Configuration newConfig;
        Rect visibleInsets;

        ResizedInfo() {
        }
    }
}

