/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public final class ViewStub
extends View {
    private OnInflateListener mInflateListener;
    private int mInflatedId;
    private WeakReference<View> mInflatedViewRef;
    private int mLayoutResource = 0;

    public ViewStub(Context context) {
        this.initialize(context);
    }

    public ViewStub(Context context, int n) {
        this.mLayoutResource = n;
        this.initialize(context);
    }

    public ViewStub(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ViewStub(Context context, AttributeSet attributeSet, int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray = R.styleable.ViewStub;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mInflatedId = n4 = typedArray.getResourceId(1, -1);
        this.mLayoutResource = n3 = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        int[] nArray2 = R.styleable.View;
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, nArray2, n, 0);
        this.mID = n2 = typedArray2.getResourceId(8, -1);
        typedArray2.recycle();
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.mContext = context;
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
    }

    @Override
    public void draw(Canvas canvas) {
    }

    public int getInflatedId() {
        return this.mInflatedId;
    }

    public int getLayoutResource() {
        return this.mLayoutResource;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View inflate() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (this.mLayoutResource == 0) {
                throw new IllegalArgumentException("ViewStub must have a valid layoutResource");
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            LayoutInflater layoutInflater = LayoutInflater.from(this.mContext);
            int n = this.mLayoutResource;
            View view = layoutInflater.inflate(n, viewGroup, false);
            if (this.mInflatedId != -1) {
                int n2 = this.mInflatedId;
                view.setId(n2);
            }
            int n3 = viewGroup.indexOfChild(this);
            viewGroup.removeViewInLayout(this);
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams != null) {
                viewGroup.addView(view, n3, layoutParams);
            } else {
                viewGroup.addView(view, n3);
            }
            WeakReference<View> weakReference = new WeakReference<View>(view);
            this.mInflatedViewRef = weakReference;
            if (this.mInflateListener != null) {
                this.mInflateListener.onInflate(this, view);
            }
            return view;
        }
        throw new IllegalStateException("ViewStub must have a non-null ViewGroup viewParent");
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(0, 0);
    }

    public void setInflatedId(int n) {
        this.mInflatedId = n;
    }

    public void setLayoutResource(int n) {
        this.mLayoutResource = n;
    }

    public void setOnInflateListener(OnInflateListener onInflateListener) {
        this.mInflateListener = onInflateListener;
    }

    @Override
    public void setVisibility(int n) {
        if (this.mInflatedViewRef != null) {
            View view = (View)this.mInflatedViewRef.get();
            if (view != null) {
                view.setVisibility(n);
                return;
            }
            throw new IllegalStateException("setVisibility called on un-referenced view");
        }
        super.setVisibility(n);
        if (n != 0 && n != 4) {
            return;
        }
        View view = this.inflate();
    }

    public static interface OnInflateListener {
        public void onInflate(ViewStub var1, View var2);
    }
}

