/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ViewTreeObserver {
    private boolean mAlive = true;
    private CopyOnWriteArrayList<OnComputeInternalInsetsListener> mOnComputeInternalInsetsListeners;
    private CopyOnWriteArrayList<OnGlobalFocusChangeListener> mOnGlobalFocusListeners;
    private CopyOnWriteArrayList<OnGlobalLayoutListener> mOnGlobalLayoutListeners;
    private CopyOnWriteArrayList<OnPreDrawListener> mOnPreDrawListeners;
    private CopyOnWriteArrayList<OnScrollChangedListener> mOnScrollChangedListeners;
    private CopyOnWriteArrayList<OnTouchModeChangeListener> mOnTouchModeChangeListeners;

    ViewTreeObserver() {
    }

    private void checkIsAlive() {
        if (this.mAlive) {
            return;
        }
        throw new IllegalStateException("This ViewTreeObserver is not alive, call getViewTreeObserver() again");
    }

    private void kill() {
        this.mAlive = false;
    }

    public void addOnComputeInternalInsetsListener(OnComputeInternalInsetsListener onComputeInternalInsetsListener) {
        this.checkIsAlive();
        if (this.mOnComputeInternalInsetsListeners == null) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.mOnComputeInternalInsetsListeners = copyOnWriteArrayList;
        }
        boolean bl = this.mOnComputeInternalInsetsListeners.add(onComputeInternalInsetsListener);
    }

    public void addOnGlobalFocusChangeListener(OnGlobalFocusChangeListener onGlobalFocusChangeListener) {
        this.checkIsAlive();
        if (this.mOnGlobalFocusListeners == null) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.mOnGlobalFocusListeners = copyOnWriteArrayList;
        }
        boolean bl = this.mOnGlobalFocusListeners.add(onGlobalFocusChangeListener);
    }

    public void addOnGlobalLayoutListener(OnGlobalLayoutListener onGlobalLayoutListener) {
        this.checkIsAlive();
        if (this.mOnGlobalLayoutListeners == null) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.mOnGlobalLayoutListeners = copyOnWriteArrayList;
        }
        boolean bl = this.mOnGlobalLayoutListeners.add(onGlobalLayoutListener);
    }

    public void addOnPreDrawListener(OnPreDrawListener onPreDrawListener) {
        this.checkIsAlive();
        if (this.mOnPreDrawListeners == null) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.mOnPreDrawListeners = copyOnWriteArrayList;
        }
        boolean bl = this.mOnPreDrawListeners.add(onPreDrawListener);
    }

    public void addOnScrollChangedListener(OnScrollChangedListener onScrollChangedListener) {
        this.checkIsAlive();
        if (this.mOnScrollChangedListeners == null) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.mOnScrollChangedListeners = copyOnWriteArrayList;
        }
        boolean bl = this.mOnScrollChangedListeners.add(onScrollChangedListener);
    }

    public void addOnTouchModeChangeListener(OnTouchModeChangeListener onTouchModeChangeListener) {
        this.checkIsAlive();
        if (this.mOnTouchModeChangeListeners == null) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.mOnTouchModeChangeListeners = copyOnWriteArrayList;
        }
        boolean bl = this.mOnTouchModeChangeListeners.add(onTouchModeChangeListener);
    }

    final void dispatchOnComputeInternalInsets(InternalInsetsInfo internalInsetsInfo) {
        CopyOnWriteArrayList<OnComputeInternalInsetsListener> copyOnWriteArrayList = this.mOnComputeInternalInsetsListeners;
        if (copyOnWriteArrayList == null) {
            return;
        }
        Iterator<OnComputeInternalInsetsListener> iterator = copyOnWriteArrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComputeInternalInsets(internalInsetsInfo);
        }
        return;
    }

    final void dispatchOnGlobalFocusChange(View view, View view2) {
        CopyOnWriteArrayList<OnGlobalFocusChangeListener> copyOnWriteArrayList = this.mOnGlobalFocusListeners;
        if (copyOnWriteArrayList == null) {
            return;
        }
        Iterator<OnGlobalFocusChangeListener> iterator = copyOnWriteArrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onGlobalFocusChanged(view, view2);
        }
        return;
    }

    public final void dispatchOnGlobalLayout() {
        CopyOnWriteArrayList<OnGlobalLayoutListener> copyOnWriteArrayList = this.mOnGlobalLayoutListeners;
        if (copyOnWriteArrayList == null) {
            return;
        }
        Iterator<OnGlobalLayoutListener> iterator = copyOnWriteArrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onGlobalLayout();
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean dispatchOnPreDraw() {
        boolean bl = false;
        CopyOnWriteArrayList<OnPreDrawListener> copyOnWriteArrayList = this.mOnPreDrawListeners;
        if (copyOnWriteArrayList != null) {
            Iterator<OnPreDrawListener> iterator = copyOnWriteArrayList.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = !iterator.next().onPreDraw();
                bl |= bl2;
            }
        }
        return bl;
    }

    final void dispatchOnScrollChanged() {
        CopyOnWriteArrayList<OnScrollChangedListener> copyOnWriteArrayList = this.mOnScrollChangedListeners;
        if (copyOnWriteArrayList == null) {
            return;
        }
        Iterator<OnScrollChangedListener> iterator = copyOnWriteArrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onScrollChanged();
        }
        return;
    }

    final void dispatchOnTouchModeChanged(boolean bl) {
        CopyOnWriteArrayList<OnTouchModeChangeListener> copyOnWriteArrayList = this.mOnTouchModeChangeListeners;
        if (copyOnWriteArrayList == null) {
            return;
        }
        Iterator<OnTouchModeChangeListener> iterator = copyOnWriteArrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onTouchModeChanged(bl);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean hasComputeInternalInsetsListeners() {
        CopyOnWriteArrayList<OnComputeInternalInsetsListener> copyOnWriteArrayList = this.mOnComputeInternalInsetsListeners;
        if (copyOnWriteArrayList == null) return false;
        if (copyOnWriteArrayList.size() <= 0) return false;
        return true;
    }

    public boolean isAlive() {
        return this.mAlive;
    }

    /*
     * Enabled aggressive block sorting
     */
    void merge(ViewTreeObserver viewTreeObserver) {
        if (viewTreeObserver.mOnGlobalFocusListeners != null) {
            if (this.mOnGlobalFocusListeners != null) {
                CopyOnWriteArrayList<OnGlobalFocusChangeListener> copyOnWriteArrayList = this.mOnGlobalFocusListeners;
                CopyOnWriteArrayList<OnGlobalFocusChangeListener> copyOnWriteArrayList2 = viewTreeObserver.mOnGlobalFocusListeners;
                boolean bl = copyOnWriteArrayList.addAll(copyOnWriteArrayList2);
            } else {
                CopyOnWriteArrayList<OnGlobalFocusChangeListener> copyOnWriteArrayList;
                this.mOnGlobalFocusListeners = copyOnWriteArrayList = viewTreeObserver.mOnGlobalFocusListeners;
            }
        }
        if (viewTreeObserver.mOnGlobalLayoutListeners != null) {
            if (this.mOnGlobalLayoutListeners != null) {
                CopyOnWriteArrayList<OnGlobalLayoutListener> copyOnWriteArrayList = this.mOnGlobalLayoutListeners;
                CopyOnWriteArrayList<OnGlobalLayoutListener> copyOnWriteArrayList3 = viewTreeObserver.mOnGlobalLayoutListeners;
                boolean bl = copyOnWriteArrayList.addAll(copyOnWriteArrayList3);
            } else {
                CopyOnWriteArrayList<OnGlobalLayoutListener> copyOnWriteArrayList;
                this.mOnGlobalLayoutListeners = copyOnWriteArrayList = viewTreeObserver.mOnGlobalLayoutListeners;
            }
        }
        if (viewTreeObserver.mOnPreDrawListeners != null) {
            if (this.mOnPreDrawListeners != null) {
                CopyOnWriteArrayList<OnPreDrawListener> copyOnWriteArrayList = this.mOnPreDrawListeners;
                CopyOnWriteArrayList<OnPreDrawListener> copyOnWriteArrayList4 = viewTreeObserver.mOnPreDrawListeners;
                boolean bl = copyOnWriteArrayList.addAll(copyOnWriteArrayList4);
            } else {
                CopyOnWriteArrayList<OnPreDrawListener> copyOnWriteArrayList;
                this.mOnPreDrawListeners = copyOnWriteArrayList = viewTreeObserver.mOnPreDrawListeners;
            }
        }
        if (viewTreeObserver.mOnTouchModeChangeListeners != null) {
            if (this.mOnTouchModeChangeListeners != null) {
                CopyOnWriteArrayList<OnTouchModeChangeListener> copyOnWriteArrayList = this.mOnTouchModeChangeListeners;
                CopyOnWriteArrayList<OnTouchModeChangeListener> copyOnWriteArrayList5 = viewTreeObserver.mOnTouchModeChangeListeners;
                boolean bl = copyOnWriteArrayList.addAll(copyOnWriteArrayList5);
            } else {
                CopyOnWriteArrayList<OnTouchModeChangeListener> copyOnWriteArrayList;
                this.mOnTouchModeChangeListeners = copyOnWriteArrayList = viewTreeObserver.mOnTouchModeChangeListeners;
            }
        }
        if (viewTreeObserver.mOnComputeInternalInsetsListeners != null) {
            if (this.mOnComputeInternalInsetsListeners != null) {
                CopyOnWriteArrayList<OnComputeInternalInsetsListener> copyOnWriteArrayList = this.mOnComputeInternalInsetsListeners;
                CopyOnWriteArrayList<OnComputeInternalInsetsListener> copyOnWriteArrayList6 = viewTreeObserver.mOnComputeInternalInsetsListeners;
                boolean bl = copyOnWriteArrayList.addAll(copyOnWriteArrayList6);
            } else {
                CopyOnWriteArrayList<OnComputeInternalInsetsListener> copyOnWriteArrayList;
                this.mOnComputeInternalInsetsListeners = copyOnWriteArrayList = viewTreeObserver.mOnComputeInternalInsetsListeners;
            }
        }
        viewTreeObserver.kill();
    }

    public void removeGlobalOnLayoutListener(OnGlobalLayoutListener onGlobalLayoutListener) {
        this.checkIsAlive();
        if (this.mOnGlobalLayoutListeners == null) {
            return;
        }
        boolean bl = this.mOnGlobalLayoutListeners.remove(onGlobalLayoutListener);
    }

    public void removeOnComputeInternalInsetsListener(OnComputeInternalInsetsListener onComputeInternalInsetsListener) {
        this.checkIsAlive();
        if (this.mOnComputeInternalInsetsListeners == null) {
            return;
        }
        boolean bl = this.mOnComputeInternalInsetsListeners.remove(onComputeInternalInsetsListener);
    }

    public void removeOnGlobalFocusChangeListener(OnGlobalFocusChangeListener onGlobalFocusChangeListener) {
        this.checkIsAlive();
        if (this.mOnGlobalFocusListeners == null) {
            return;
        }
        boolean bl = this.mOnGlobalFocusListeners.remove(onGlobalFocusChangeListener);
    }

    public void removeOnPreDrawListener(OnPreDrawListener onPreDrawListener) {
        this.checkIsAlive();
        if (this.mOnPreDrawListeners == null) {
            return;
        }
        boolean bl = this.mOnPreDrawListeners.remove(onPreDrawListener);
    }

    public void removeOnScrollChangedListener(OnScrollChangedListener onScrollChangedListener) {
        this.checkIsAlive();
        if (this.mOnScrollChangedListeners == null) {
            return;
        }
        boolean bl = this.mOnScrollChangedListeners.remove(onScrollChangedListener);
    }

    public void removeOnTouchModeChangeListener(OnTouchModeChangeListener onTouchModeChangeListener) {
        this.checkIsAlive();
        if (this.mOnTouchModeChangeListeners == null) {
            return;
        }
        boolean bl = this.mOnTouchModeChangeListeners.remove(onTouchModeChangeListener);
    }

    public static interface OnComputeInternalInsetsListener {
        public void onComputeInternalInsets(InternalInsetsInfo var1);
    }

    public static final class InternalInsetsInfo {
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public final Rect contentInsets;
        int mTouchableInsets;
        public final Rect visibleInsets;

        public InternalInsetsInfo() {
            Rect rect;
            Rect rect2;
            this.contentInsets = rect2 = new Rect();
            this.visibleInsets = rect = new Rect();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            try {
                InternalInsetsInfo internalInsetsInfo = (InternalInsetsInfo)object;
                Rect rect = this.contentInsets;
                Rect rect2 = internalInsetsInfo.contentInsets;
                if (!rect.equals(rect2)) {
                    return false;
                }
                Rect rect3 = this.visibleInsets;
                Rect rect4 = internalInsetsInfo.visibleInsets;
                if (!rect3.equals(rect4)) {
                    return false;
                }
                int n = this.mTouchableInsets;
                int n2 = internalInsetsInfo.mTouchableInsets;
                if (n == n2) return false;
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int getTouchableInsets() {
            return this.mTouchableInsets;
        }

        void reset() {
            Rect rect = this.contentInsets;
            Rect rect2 = this.visibleInsets;
            rect2.bottom = 0;
            rect2.right = 0;
            rect2.top = 0;
            rect2.left = 0;
            rect.bottom = 0;
            rect.right = 0;
            rect.top = 0;
            rect.left = 0;
            this.mTouchableInsets = 0;
        }

        void set(InternalInsetsInfo internalInsetsInfo) {
            int n;
            Rect rect = this.contentInsets;
            Rect rect2 = internalInsetsInfo.contentInsets;
            rect.set(rect2);
            Rect rect3 = this.visibleInsets;
            Rect rect4 = internalInsetsInfo.visibleInsets;
            rect3.set(rect4);
            this.mTouchableInsets = n = internalInsetsInfo.mTouchableInsets;
        }

        public void setTouchableInsets(int n) {
            this.mTouchableInsets = n;
        }
    }

    public static interface OnScrollChangedListener {
        public void onScrollChanged();
    }

    public static interface OnTouchModeChangeListener {
        public void onTouchModeChanged(boolean var1);
    }

    public static interface OnPreDrawListener {
        public boolean onPreDraw();
    }

    public static interface OnGlobalLayoutListener {
        public void onGlobalLayout();
    }

    public static interface OnGlobalFocusChangeListener {
        public void onGlobalFocusChanged(View var1, View var2);
    }
}

