/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.AudioService;
import android.media.AudioSystem;
import android.media.RingtoneManager;
import android.media.ToneGenerator;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class VolumePanel
extends Handler {
    private static final int ALARM_VOLUME_TEXT = 17040141;
    private static final int BEEP_DURATION = 150;
    private static final int BLUETOOTH_INCALL_VOLUME_TEXT = 17040140;
    private static final int FREE_DELAY = 10000;
    private static final int INCALL_VOLUME_TEXT = 17040139;
    private static boolean LOGD = false;
    private static final int MAX_VOLUME = 100;
    private static final int MSG_FREE_RESOURCES = 1;
    private static final int MSG_PLAY_SOUND = 2;
    private static final int MSG_STOP_SOUNDS = 3;
    private static final int MSG_VIBRATE = 4;
    private static final int MSG_VOLUME_CHANGED = 0;
    private static final int MUSIC_VOLUME_TEXT = 17040136;
    private static final int NOTIFICATION_VOLUME_TEXT = 17040142;
    public static final int PLAY_SOUND_DELAY = 300;
    private static final int RINGTONE_VOLUME_TEXT = 17040135;
    private static final String TAG = "VolumePanel";
    private static final int UNKNOWN_VOLUME_TEXT = 17040143;
    public static final int VIBRATE_DELAY = 300;
    private static final int VIBRATE_DURATION = 300;
    private final TextView mAdditionalMessage;
    private AudioManager mAudioManager;
    protected AudioService mAudioService;
    protected Context mContext;
    private final ImageView mLargeStreamIcon;
    private final ProgressBar mLevel;
    private final TextView mMessage;
    private boolean mRingIsSilent;
    private final ImageView mSmallStreamIcon;
    private final Toast mToast;
    private ToneGenerator[] mToneGenerators;
    private Vibrator mVibrator;
    private final View mView;

    static {
        LOGD = false;
    }

    public VolumePanel(Context context, AudioService audioService) {
        Vibrator vibrator;
        ProgressBar progressBar;
        ImageView imageView;
        ImageView imageView2;
        TextView textView;
        TextView textView2;
        View view;
        Toast toast;
        AudioManager audioManager;
        this.mContext = context;
        this.mAudioManager = audioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioService = audioService;
        this.mToast = toast = new Toast(context);
        this.mView = view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367147, null);
        this.mMessage = textView2 = (TextView)view.findViewById(16908299);
        this.mAdditionalMessage = textView = (TextView)view.findViewById(16908842);
        this.mSmallStreamIcon = imageView2 = (ImageView)view.findViewById(16908841);
        this.mLargeStreamIcon = imageView = (ImageView)view.findViewById(16908843);
        this.mLevel = progressBar = (ProgressBar)view.findViewById(16908844);
        ToneGenerator[] toneGeneratorArray = new ToneGenerator[AudioSystem.getNumStreamTypes()];
        this.mToneGenerators = toneGeneratorArray;
        this.mVibrator = vibrator = new Vibrator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ToneGenerator getOrCreateToneGenerator(int n) {
        synchronized (this) {
            ToneGenerator toneGenerator;
            if (this.mToneGenerators[n] != null) return this.mToneGenerators[n];
            ToneGenerator[] toneGeneratorArray = this.mToneGenerators;
            toneGeneratorArray[n] = toneGenerator = new ToneGenerator(n, 100);
            return toneGenerator;
        }
    }

    private void setLargeIcon(int n) {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        this.mLargeStreamIcon.setImageResource(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRingerIcon() {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        int n = this.mAudioService.getRingerMode();
        if (LOGD) {
            String string2 = "setRingerIcon(), ringerMode: " + n;
            int n2 = Log.d(TAG, string2);
        }
        int n3 = n == 0 ? 17301968 : (n == 1 ? 17301963 : 17301965);
        this.mLargeStreamIcon.setImageResource(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSmallIcon(int n) {
        this.mLargeStreamIcon.setVisibility(8);
        this.mSmallStreamIcon.setVisibility(0);
        ImageView imageView = this.mSmallStreamIcon;
        int n2 = n == 0 ? 17301969 : 17301970;
        imageView.setImageResource(n2);
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 0: {
                int n = message.arg1;
                int n2 = message.arg2;
                this.onVolumeChanged(n, n2);
                return;
            }
            case 1: {
                this.onFreeResources();
                return;
            }
            case 3: {
                this.onStopSounds();
                return;
            }
            case 2: {
                int n = message.arg1;
                int n3 = message.arg2;
                this.onPlaySound(n, n3);
                return;
            }
            case 4: 
        }
        this.onVibrate();
    }

    protected void onFreeResources() {
        this.mSmallStreamIcon.setImageDrawable(null);
        this.mLargeStreamIcon.setImageDrawable(null);
        synchronized (this) {
            for (int i = this.mToneGenerators.length - 1; i >= 0; i += -1) {
                if (this.mToneGenerators[i] != null) {
                    this.mToneGenerators[i].release();
                }
                this.mToneGenerators[i] = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onPlaySound(int n, int n2) {
        if (this.hasMessages(3)) {
            this.removeMessages(3);
            this.onStopSounds();
        }
        synchronized (this) {
            boolean bl = this.getOrCreateToneGenerator(n).startTone(24);
        }
        Message message = this.obtainMessage(3);
        boolean bl = this.sendMessageDelayed(message, 150L);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onShowVolumeChanged(int n, int n2) {
        int n3;
        int n4 = this.mAudioService.getStreamVolume(n);
        int n5 = 17040143;
        int n6 = 0;
        this.mRingIsSilent = false;
        if (LOGD) {
            String string2 = "onShowVolumeChanged(streamType: " + n + ", flags: " + n2 + "), index: " + n4;
            int n7 = Log.d(TAG, string2);
        }
        int n8 = this.mAudioService.getStreamMaxVolume(n);
        switch (n) {
            case 2: {
                this.setRingerIcon();
                n5 = 17040135;
                if (RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 1) != null) break;
                n6 = 17040138;
                this.mRingIsSilent = true;
                break;
            }
            case 3: {
                n5 = 17040136;
                if (this.mAudioManager.isBluetoothA2dpOn()) {
                    n6 = 17040137;
                    this.setLargeIcon(17301966);
                    break;
                }
                this.setSmallIcon(n4);
                break;
            }
            case 0: {
                ++n8;
                n5 = 17040139;
                this.setSmallIcon(++n4);
                break;
            }
            case 4: {
                n5 = 17040141;
                this.setSmallIcon(n4);
                break;
            }
            case 5: {
                n5 = 17040142;
                this.setSmallIcon(n4);
                if (RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 2) != null) break;
                n6 = 17040138;
                this.mRingIsSilent = true;
                break;
            }
            case 6: {
                ++n4;
                ++n8;
                n5 = 17040140;
                this.setLargeIcon(17301967);
            }
        }
        String string3 = Resources.getSystem().getString(n5);
        if (!this.mMessage.getText().equals(string3)) {
            this.mMessage.setText(string3);
        }
        if (n6 == 0) {
            this.mAdditionalMessage.setVisibility(8);
        } else {
            this.mAdditionalMessage.setVisibility(0);
            TextView textView = this.mAdditionalMessage;
            String string4 = Resources.getSystem().getString(n6);
            textView.setText(string4);
        }
        if (n8 != (n3 = this.mLevel.getMax())) {
            this.mLevel.setMax(n8);
        }
        this.mLevel.setProgress(n4);
        Toast toast = this.mToast;
        View view = this.mView;
        toast.setView(view);
        this.mToast.setDuration(0);
        this.mToast.setGravity(48, 0, 0);
        this.mToast.show();
        if ((n2 & 0x10) == 0) {
            return;
        }
        if (!this.mAudioService.isStreamAffectedByRingerMode(n)) {
            return;
        }
        if (this.mAudioService.getRingerMode() != 1) {
            return;
        }
        if (!this.mAudioService.shouldVibrate(0)) {
            return;
        }
        Message message = this.obtainMessage(4);
        boolean bl = this.sendMessageDelayed(message, 300L);
    }

    protected void onStopSounds() {
        synchronized (this) {
            for (int i = AudioSystem.getNumStreamTypes() - 1; i >= 0; i += -1) {
                ToneGenerator toneGenerator = this.mToneGenerators[i];
                if (toneGenerator == null) continue;
                toneGenerator.stopTone();
            }
            return;
        }
    }

    protected void onVibrate() {
        if (this.mAudioService.getRingerMode() != 1) {
            return;
        }
        this.mVibrator.vibrate(300L);
    }

    protected void onVolumeChanged(int n, int n2) {
        if (LOGD) {
            String string2 = "onVolumeChanged(streamType: " + n + ", flags: " + n2 + ")";
            int n3 = Log.d(TAG, string2);
        }
        if ((n2 & 1) != 0) {
            this.onShowVolumeChanged(n, n2);
        }
        if ((n2 & 4) != 0 && !this.mRingIsSilent) {
            this.removeMessages(2);
            Message message = this.obtainMessage(2, n, n2);
            boolean bl = this.sendMessageDelayed(message, 300L);
        }
        if ((n2 & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        Message message = this.obtainMessage(1);
        boolean bl = this.sendMessageDelayed(message, 10000L);
    }

    public void postVolumeChanged(int n, int n2) {
        if (this.hasMessages(0)) {
            return;
        }
        this.removeMessages(1);
        this.obtainMessage(0, n, n2).sendToTarget();
    }
}

