/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;

public abstract class Window {
    protected static final int DEFAULT_FEATURES = 65;
    public static final int FEATURE_CONTEXT_MENU = 6;
    public static final int FEATURE_CUSTOM_TITLE = 7;
    public static final int FEATURE_INDETERMINATE_PROGRESS = 5;
    public static final int FEATURE_LEFT_ICON = 3;
    public static final int FEATURE_NO_TITLE = 1;
    public static final int FEATURE_OPENGL = 8;
    public static final int FEATURE_OPTIONS_PANEL = 0;
    public static final int FEATURE_PROGRESS = 2;
    public static final int FEATURE_RIGHT_ICON = 4;
    public static final int ID_ANDROID_CONTENT = 0x1020002;
    public static final int PROGRESS_END = 10000;
    public static final int PROGRESS_INDETERMINATE_OFF = 252;
    public static final int PROGRESS_INDETERMINATE_ON = 253;
    public static final int PROGRESS_SECONDARY_END = 30000;
    public static final int PROGRESS_SECONDARY_START = 20000;
    public static final int PROGRESS_START = 0;
    public static final int PROGRESS_VISIBILITY_OFF = 254;
    public static final int PROGRESS_VISIBILITY_ON = 255;
    private Window mActiveChild;
    private String mAppName;
    private IBinder mAppToken;
    private Callback mCallback;
    private Window mContainer;
    private final Context mContext;
    private int mDefaultWindowFormat = -1;
    private int mFeatures = 65;
    private int mForcedWindowFlags = 0;
    private boolean mHasChildren = false;
    private boolean mHasSoftInputMode = false;
    private boolean mHaveWindowFormat = false;
    private boolean mIsActive = false;
    private int mLocalFeatures = 65;
    private final WindowManager.LayoutParams mWindowAttributes;
    private WindowManager mWindowManager;
    private TypedArray mWindowStyle;

    public Window(Context context) {
        WindowManager.LayoutParams layoutParams;
        this.mWindowAttributes = layoutParams = new WindowManager.LayoutParams();
        this.mContext = context;
    }

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public void addFlags(int n) {
        this.setFlags(n, n);
    }

    public void clearFlags(int n) {
        this.setFlags(0, n);
    }

    public abstract void closeAllPanels();

    public abstract void closePanel(int var1);

    public View findViewById(int n) {
        return this.getDecorView().findViewById(n);
    }

    public final WindowManager.LayoutParams getAttributes() {
        return this.mWindowAttributes;
    }

    public final Callback getCallback() {
        return this.mCallback;
    }

    public final Window getContainer() {
        return this.mContainer;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public abstract View getCurrentFocus();

    public abstract View getDecorView();

    protected final int getFeatures() {
        return this.mFeatures;
    }

    protected final int getForcedWindowFlags() {
        return this.mForcedWindowFlags;
    }

    public abstract LayoutInflater getLayoutInflater();

    protected final int getLocalFeatures() {
        return this.mLocalFeatures;
    }

    public abstract int getVolumeControlStream();

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public final TypedArray getWindowStyle() {
        synchronized (this) {
            if (this.mWindowStyle == null) {
                TypedArray typedArray;
                Context context = this.mContext;
                int[] nArray = R.styleable.Window;
                this.mWindowStyle = typedArray = context.obtainStyledAttributes(nArray);
            }
            TypedArray typedArray = this.mWindowStyle;
            return typedArray;
        }
    }

    public final boolean hasChildren() {
        return this.mHasChildren;
    }

    protected final boolean hasSoftInputMode() {
        return this.mHasSoftInputMode;
    }

    public final boolean isActive() {
        return this.mIsActive;
    }

    public abstract boolean isFloating();

    public abstract boolean isShortcutKey(int var1, KeyEvent var2);

    public final void makeActive() {
        if (this.mContainer != null) {
            if (this.mContainer.mActiveChild != null) {
                this.mContainer.mActiveChild.mIsActive = false;
            }
            this.mContainer.mActiveChild = this;
        }
        this.mIsActive = true;
        this.onActive();
    }

    protected abstract void onActive();

    public abstract void onConfigurationChanged(Configuration var1);

    public abstract void openPanel(int var1, KeyEvent var2);

    public abstract View peekDecorView();

    public abstract boolean performContextMenuIdentifierAction(int var1, int var2);

    public abstract boolean performPanelIdentifierAction(int var1, int var2, int var3);

    public abstract boolean performPanelShortcut(int var1, int var2, KeyEvent var3, int var4);

    /*
     * Enabled aggressive block sorting
     */
    public boolean requestFeature(int n) {
        int n2;
        int n3;
        int n4 = 1 << n;
        this.mFeatures = n3 = this.mFeatures | n4;
        int n5 = this.mLocalFeatures;
        int n6 = this.mContainer != null ? ~this.mContainer.mFeatures & n4 : n4;
        this.mLocalFeatures = n2 = n5 | n6;
        if ((this.mFeatures & n4) == 0) return false;
        return true;
    }

    public abstract void restoreHierarchyState(Bundle var1);

    public abstract Bundle saveHierarchyState();

    public void setAttributes(WindowManager.LayoutParams layoutParams) {
        int n = this.mWindowAttributes.copyFrom(layoutParams);
        if (this.mCallback == null) {
            return;
        }
        Callback callback = this.mCallback;
        WindowManager.LayoutParams layoutParams2 = this.mWindowAttributes;
        callback.onWindowAttributesChanged(layoutParams2);
    }

    public abstract void setBackgroundDrawable(Drawable var1);

    public void setBackgroundDrawableResource(int n) {
        Drawable drawable2 = this.mContext.getResources().getDrawable(n);
        this.setBackgroundDrawable(drawable2);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public abstract void setChildDrawable(int var1, Drawable var2);

    public abstract void setChildInt(int var1, int var2);

    public void setContainer(Window window) {
        int n;
        int n2;
        this.mContainer = window;
        if (window == null) {
            return;
        }
        this.mFeatures = n2 = this.mFeatures | 2;
        this.mLocalFeatures = n = this.mLocalFeatures | 2;
        window.mHasChildren = true;
    }

    public abstract void setContentView(int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    protected void setDefaultWindowFormat(int n) {
        this.mDefaultWindowFormat = n;
        if (this.mHaveWindowFormat) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.format = n;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    public abstract void setFeatureDrawable(int var1, Drawable var2);

    public abstract void setFeatureDrawableAlpha(int var1, int var2);

    public abstract void setFeatureDrawableResource(int var1, int var2);

    public abstract void setFeatureDrawableUri(int var1, Uri var2);

    public abstract void setFeatureInt(int var1, int var2);

    public void setFlags(int n, int n2) {
        int n3;
        int n4;
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        int n5 = layoutParams.flags;
        int n6 = ~n2;
        int n7 = n5 & n6;
        int n8 = n & n2;
        layoutParams.flags = n4 = n7 | n8;
        this.mForcedWindowFlags = n3 = this.mForcedWindowFlags | n2;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFormat(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        if (n != 0) {
            layoutParams.format = n;
            this.mHaveWindowFormat = true;
        } else {
            int n2;
            layoutParams.format = n2 = this.mDefaultWindowFormat;
            this.mHaveWindowFormat = false;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    public void setGravity(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.gravity = n;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    public void setLayout(int n, int n2) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.width = n;
        layoutParams.height = n2;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSoftInputMode(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        if (n != 0) {
            layoutParams.softInputMode = n;
            this.mHasSoftInputMode = true;
        } else {
            this.mHasSoftInputMode = false;
        }
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    public abstract void setTitle(CharSequence var1);

    public abstract void setTitleColor(int var1);

    public void setType(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.type = n;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    public abstract void setVolumeControlStream(int var1);

    public void setWindowAnimations(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.windowAnimations = n;
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.onWindowAttributesChanged(layoutParams);
    }

    public void setWindowManager(WindowManager windowManager, IBinder iBinder, String string2) {
        this.mAppToken = iBinder;
        this.mAppName = string2;
        if (windowManager == null) {
            windowManager = WindowManagerImpl.getDefault();
        }
        LocalWindowManager localWindowManager = new LocalWindowManager(windowManager);
        this.mWindowManager = localWindowManager;
    }

    public abstract boolean superDispatchKeyEvent(KeyEvent var1);

    public abstract boolean superDispatchTouchEvent(MotionEvent var1);

    public abstract boolean superDispatchTrackballEvent(MotionEvent var1);

    public abstract void takeInputQueue(InputQueue.Callback var1);

    public abstract void takeKeyEvents(boolean var1);

    public abstract void takeSurface(SurfaceHolder.Callback2 var1);

    public abstract void togglePanel(int var1, KeyEvent var2);

    private class LocalWindowManager
    implements WindowManager {
        private final Display mDefaultDisplay;
        private final WindowManager mWindowManager;

        LocalWindowManager(WindowManager windowManager) {
            Display display;
            this.mWindowManager = windowManager;
            Resources resources = Window.this.mContext.getResources();
            Display display2 = this.mWindowManager.getDefaultDisplay();
            this.mDefaultDisplay = display = resources.getDefaultDisplay(display2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final void addView(View view, ViewGroup.LayoutParams layoutParams) {
            WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
            CharSequence charSequence = layoutParams2.getTitle();
            if (layoutParams2.type >= 1000 && layoutParams2.type <= 1999) {
                View view2;
                if (layoutParams2.token == null && (view2 = Window.this.peekDecorView()) != null) {
                    IBinder iBinder;
                    layoutParams2.token = iBinder = view2.getWindowToken();
                }
                if (charSequence == null || charSequence.length() == 0) {
                    String string2 = layoutParams2.type == 1001 ? "Media" : (layoutParams2.type == 1004 ? "MediaOvr" : (layoutParams2.type == 1000 ? "Panel" : (layoutParams2.type == 1002 ? "SubPanel" : (layoutParams2.type == 1003 ? "AtchDlg" : Integer.toString(layoutParams2.type)))));
                    if (Window.this.mAppName != null) {
                        StringBuilder stringBuilder = new StringBuilder().append(string2).append(":");
                        String string3 = Window.this.mAppName;
                        string2 = stringBuilder.append(string3).toString();
                    }
                    layoutParams2.setTitle(string2);
                }
            } else {
                if (layoutParams2.token == null) {
                    IBinder iBinder = Window.this.mContainer == null ? Window.this.mAppToken : Window.this.mContainer.mAppToken;
                    layoutParams2.token = iBinder;
                }
                if ((charSequence == null || charSequence.length() == 0) && Window.this.mAppName != null) {
                    String string4 = Window.this.mAppName;
                    layoutParams2.setTitle(string4);
                }
            }
            if (layoutParams2.packageName == null) {
                String string5;
                layoutParams2.packageName = string5 = Window.this.mContext.getPackageName();
            }
            this.mWindowManager.addView(view, layoutParams);
        }

        @Override
        public Display getDefaultDisplay() {
            return this.mDefaultDisplay;
        }

        @Override
        public final void removeView(View view) {
            this.mWindowManager.removeView(view);
        }

        @Override
        public final void removeViewImmediate(View view) {
            this.mWindowManager.removeViewImmediate(view);
        }

        @Override
        public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
            this.mWindowManager.updateViewLayout(view, layoutParams);
        }
    }

    public static interface Callback {
        public boolean dispatchKeyEvent(KeyEvent var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean dispatchTrackballEvent(MotionEvent var1);

        public void onAttachedToWindow();

        public void onContentChanged();

        public boolean onCreatePanelMenu(int var1, Menu var2);

        public View onCreatePanelView(int var1);

        public void onDetachedFromWindow();

        public boolean onMenuItemSelected(int var1, MenuItem var2);

        public boolean onMenuOpened(int var1, Menu var2);

        public void onPanelClosed(int var1, Menu var2);

        public boolean onPreparePanel(int var1, View var2, Menu var3);

        public boolean onSearchRequested();

        public void onWindowAttributesChanged(WindowManager.LayoutParams var1);

        public void onWindowFocusChanged(boolean var1);
    }
}

