/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewManager;

public interface WindowManager
extends ViewManager {
    public Display getDefaultDisplay();

    public void removeViewImmediate(View var1);

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements Parcelable {
        public static final int ALPHA_CHANGED = 128;
        public static final int ANIMATION_CHANGED = 16;
        public static final float BRIGHTNESS_OVERRIDE_FULL = 1.0f;
        public static final float BRIGHTNESS_OVERRIDE_NONE = -1.0f;
        public static final float BRIGHTNESS_OVERRIDE_OFF = 0.0f;
        public static final int BUTTON_BRIGHTNESS_CHANGED = 4096;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            @Override
            public LayoutParams createFromParcel(Parcel parcel) {
                return new LayoutParams(parcel);
            }

            public LayoutParams[] newArray(int n) {
                return new LayoutParams[n];
            }
        };
        public static final int DIM_AMOUNT_CHANGED = 32;
        public static final int FIRST_APPLICATION_WINDOW = 1;
        public static final int FIRST_SUB_WINDOW = 1000;
        public static final int FIRST_SYSTEM_WINDOW = 2000;
        public static final int FLAGS_CHANGED = 4;
        public static final int FLAG_ALLOW_LOCK_WHILE_SCREEN_ON = 1;
        public static final int FLAG_ALT_FOCUSABLE_IM = 131072;
        public static final int FLAG_BLUR_BEHIND = 4;
        public static final int FLAG_COMPATIBLE_WINDOW = 0x20000000;
        public static final int FLAG_DIM_BEHIND = 2;
        public static final int FLAG_DISMISS_KEYGUARD = 0x400000;
        public static final int FLAG_DITHER = 4096;
        public static final int FLAG_FORCE_NOT_FULLSCREEN = 2048;
        public static final int FLAG_FULLSCREEN = 1024;
        public static final int FLAG_IGNORE_CHEEK_PRESSES = 32768;
        public static final int FLAG_KEEP_SCREEN_ON = 128;
        public static final int FLAG_KEEP_SURFACE_WHILE_ANIMATING = 0x10000000;
        public static final int FLAG_LAYOUT_INSET_DECOR = 65536;
        public static final int FLAG_LAYOUT_IN_SCREEN = 256;
        public static final int FLAG_LAYOUT_NO_LIMITS = 512;
        public static final int FLAG_NOT_FOCUSABLE = 8;
        public static final int FLAG_NOT_TOUCHABLE = 16;
        public static final int FLAG_NOT_TOUCH_MODAL = 32;
        public static final int FLAG_SCALED = 16384;
        public static final int FLAG_SECURE = 8192;
        public static final int FLAG_SHOW_WALLPAPER = 0x100000;
        public static final int FLAG_SHOW_WHEN_LOCKED = 524288;
        public static final int FLAG_SPLIT_TOUCH = 0x800000;
        public static final int FLAG_SYSTEM_ERROR = 0x40000000;
        public static final int FLAG_TOUCHABLE_WHEN_WAKING = 64;
        public static final int FLAG_TURN_SCREEN_ON = 0x200000;
        public static final int FLAG_WATCH_OUTSIDE_TOUCH = 262144;
        public static final int FORMAT_CHANGED = 8;
        public static final int LAST_APPLICATION_WINDOW = 99;
        public static final int LAST_SUB_WINDOW = 1999;
        public static final int LAST_SYSTEM_WINDOW = 2999;
        public static final int LAYOUT_CHANGED = 1;
        public static final int MEMORY_TYPE_CHANGED = 256;
        @Deprecated
        public static final int MEMORY_TYPE_GPU = 2;
        @Deprecated
        public static final int MEMORY_TYPE_HARDWARE = 1;
        public static final int MEMORY_TYPE_NORMAL = 0;
        public static final int MEMORY_TYPE_PUSH_BUFFERS = 3;
        public static final int SCREEN_BRIGHTNESS_CHANGED = 2048;
        public static final int SCREEN_ORIENTATION_CHANGED = 1024;
        public static final int SOFT_INPUT_ADJUST_PAN = 32;
        public static final int SOFT_INPUT_ADJUST_RESIZE = 16;
        public static final int SOFT_INPUT_ADJUST_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_IS_FORWARD_NAVIGATION = 256;
        public static final int SOFT_INPUT_MASK_ADJUST = 240;
        public static final int SOFT_INPUT_MASK_STATE = 15;
        public static final int SOFT_INPUT_MODE_CHANGED = 512;
        public static final int SOFT_INPUT_STATE_ALWAYS_HIDDEN = 3;
        public static final int SOFT_INPUT_STATE_ALWAYS_VISIBLE = 5;
        public static final int SOFT_INPUT_STATE_HIDDEN = 2;
        public static final int SOFT_INPUT_STATE_UNCHANGED = 1;
        public static final int SOFT_INPUT_STATE_UNSPECIFIED = 0;
        public static final int SOFT_INPUT_STATE_VISIBLE = 4;
        public static final int TITLE_CHANGED = 64;
        public static final int TYPE_APPLICATION = 2;
        public static final int TYPE_APPLICATION_ATTACHED_DIALOG = 1003;
        public static final int TYPE_APPLICATION_MEDIA = 1001;
        public static final int TYPE_APPLICATION_MEDIA_OVERLAY = 1004;
        public static final int TYPE_APPLICATION_PANEL = 1000;
        public static final int TYPE_APPLICATION_STARTING = 3;
        public static final int TYPE_APPLICATION_SUB_PANEL = 1002;
        public static final int TYPE_BASE_APPLICATION = 1;
        public static final int TYPE_CHANGED = 2;
        public static final int TYPE_INPUT_METHOD = 2011;
        public static final int TYPE_INPUT_METHOD_DIALOG = 2012;
        public static final int TYPE_KEYGUARD = 2004;
        public static final int TYPE_KEYGUARD_DIALOG = 2009;
        public static final int TYPE_PHONE = 2002;
        public static final int TYPE_PRIORITY_PHONE = 2007;
        public static final int TYPE_SEARCH_BAR = 2001;
        public static final int TYPE_SECURE_SYSTEM_OVERLAY = 2015;
        public static final int TYPE_STATUS_BAR = 2000;
        public static final int TYPE_STATUS_BAR_PANEL = 2014;
        public static final int TYPE_SYSTEM_ALERT = 2003;
        public static final int TYPE_SYSTEM_DIALOG = 2008;
        public static final int TYPE_SYSTEM_ERROR = 2010;
        public static final int TYPE_SYSTEM_OVERLAY = 2006;
        public static final int TYPE_TOAST = 2005;
        public static final int TYPE_WALLPAPER = 2013;
        public float alpha = 1.0f;
        public float buttonBrightness = -1.0f;
        public float dimAmount = 1.0f;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(equals=4, mask=4, name="FLAG_BLUR_BEHIND"), @ViewDebug.FlagToString(equals=2, mask=2, name="FLAG_DIM_BEHIND"), @ViewDebug.FlagToString(equals=8, mask=8, name="FLAG_NOT_FOCUSABLE"), @ViewDebug.FlagToString(equals=16, mask=16, name="FLAG_NOT_TOUCHABLE"), @ViewDebug.FlagToString(equals=32, mask=32, name="FLAG_NOT_TOUCH_MODAL"), @ViewDebug.FlagToString(equals=256, mask=256, name="FLAG_LAYOUT_IN_SCREEN"), @ViewDebug.FlagToString(equals=4096, mask=4096, name="FLAG_DITHER"), @ViewDebug.FlagToString(equals=0x200000, mask=0x200000, name="FLAG_TURN_SCREEN_ON"), @ViewDebug.FlagToString(equals=128, mask=128, name="FLAG_KEEP_SCREEN_ON"), @ViewDebug.FlagToString(equals=524288, mask=524288, name="FLAG_SHOW_WHEN_LOCKED"), @ViewDebug.FlagToString(equals=1, mask=1, name="FLAG_ALLOW_LOCK_WHILE_SCREEN_ON"), @ViewDebug.FlagToString(equals=0x400000, mask=0x400000, name="FLAG_DISMISS_KEYGUARD"), @ViewDebug.FlagToString(equals=1024, mask=1024, name="FLAG_FULLSCREEN"), @ViewDebug.FlagToString(equals=2048, mask=2048, name="FLAG_FORCE_NOT_FULLSCREEN"), @ViewDebug.FlagToString(equals=32768, mask=32768, name="FLAG_IGNORE_CHEEK_PRESSES")})
        public int flags;
        public int format;
        public int gravity;
        public float horizontalMargin;
        public float horizontalWeight;
        private int[] mCompatibilityParamsBackup = null;
        private CharSequence mTitle = "";
        public int memoryType;
        public String packageName = null;
        public float screenBrightness = -1.0f;
        public int screenOrientation = -1;
        public int softInputMode;
        public IBinder token = null;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=1, to="TYPE_BASE_APPLICATION"), @ViewDebug.IntToString(from=2, to="TYPE_APPLICATION"), @ViewDebug.IntToString(from=3, to="TYPE_APPLICATION_STARTING"), @ViewDebug.IntToString(from=1000, to="TYPE_APPLICATION_PANEL"), @ViewDebug.IntToString(from=1001, to="TYPE_APPLICATION_MEDIA"), @ViewDebug.IntToString(from=1002, to="TYPE_APPLICATION_SUB_PANEL"), @ViewDebug.IntToString(from=1003, to="TYPE_APPLICATION_ATTACHED_DIALOG"), @ViewDebug.IntToString(from=2000, to="TYPE_STATUS_BAR"), @ViewDebug.IntToString(from=2001, to="TYPE_SEARCH_BAR"), @ViewDebug.IntToString(from=2002, to="TYPE_PHONE"), @ViewDebug.IntToString(from=2003, to="TYPE_SYSTEM_ALERT"), @ViewDebug.IntToString(from=2004, to="TYPE_KEYGUARD"), @ViewDebug.IntToString(from=2005, to="TYPE_TOAST"), @ViewDebug.IntToString(from=2006, to="TYPE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2007, to="TYPE_PRIORITY_PHONE"), @ViewDebug.IntToString(from=2014, to="TYPE_STATUS_BAR_PANEL"), @ViewDebug.IntToString(from=2008, to="TYPE_SYSTEM_DIALOG"), @ViewDebug.IntToString(from=2009, to="TYPE_KEYGUARD_DIALOG"), @ViewDebug.IntToString(from=2010, to="TYPE_SYSTEM_ERROR"), @ViewDebug.IntToString(from=2011, to="TYPE_INPUT_METHOD"), @ViewDebug.IntToString(from=2012, to="TYPE_INPUT_METHOD_DIALOG"), @ViewDebug.IntToString(from=2015, to="TYPE_SECURE_SYSTEM_OVERLAY")})
        public int type;
        public float verticalMargin;
        public float verticalWeight;
        public int windowAnimations;
        public int x;
        public int y;

        public LayoutParams() {
            super(-1, -1);
            this.type = 2;
            this.format = -1;
        }

        public LayoutParams(int n) {
            super(-1, -1);
            this.type = n;
            this.format = -1;
        }

        public LayoutParams(int n, int n2) {
            super(-1, -1);
            this.type = n;
            this.flags = n2;
            this.format = -1;
        }

        public LayoutParams(int n, int n2, int n3) {
            super(-1, -1);
            this.type = n;
            this.flags = n2;
            this.format = n3;
        }

        public LayoutParams(int n, int n2, int n3, int n4, int n5) {
            super(n, n2);
            this.type = n3;
            this.flags = n4;
            this.format = n5;
        }

        public LayoutParams(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            super(n, n2);
            this.x = n3;
            this.y = n4;
            this.type = n5;
            this.flags = n6;
            this.format = n7;
        }

        public LayoutParams(Parcel parcel) {
            int n;
            CharSequence charSequence;
            String string2;
            IBinder iBinder;
            float f;
            float f2;
            float f3;
            float f4;
            int n2;
            int n3;
            float f5;
            float f6;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            this.width = n12 = parcel.readInt();
            this.height = n11 = parcel.readInt();
            this.x = n10 = parcel.readInt();
            this.y = n9 = parcel.readInt();
            this.type = n8 = parcel.readInt();
            this.memoryType = n7 = parcel.readInt();
            this.flags = n6 = parcel.readInt();
            this.softInputMode = n5 = parcel.readInt();
            this.gravity = n4 = parcel.readInt();
            this.horizontalMargin = f6 = parcel.readFloat();
            this.verticalMargin = f5 = parcel.readFloat();
            this.format = n3 = parcel.readInt();
            this.windowAnimations = n2 = parcel.readInt();
            this.alpha = f4 = parcel.readFloat();
            this.dimAmount = f3 = parcel.readFloat();
            this.screenBrightness = f2 = parcel.readFloat();
            this.buttonBrightness = f = parcel.readFloat();
            this.token = iBinder = parcel.readStrongBinder();
            this.packageName = string2 = parcel.readString();
            this.mTitle = charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.screenOrientation = n = parcel.readInt();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean mayUseInputMethod(int n) {
            switch (0x20008 & n) {
                default: {
                    return false;
                }
                case 0: 
                case 131080: 
            }
            return true;
        }

        void backup() {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray = this.mCompatibilityParamsBackup;
            if (nArray == null) {
                this.mCompatibilityParamsBackup = nArray = new int[4];
            }
            nArray[0] = n4 = this.x;
            nArray[1] = n3 = this.y;
            nArray[2] = n2 = this.width;
            nArray[3] = n = this.height;
        }

        public final int copyFrom(LayoutParams layoutParams) {
            int n;
            int n2;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            CharSequence charSequence;
            CharSequence charSequence2;
            int n3;
            int n4;
            int n5;
            int n6;
            float f9;
            float f10;
            float f11;
            float f12;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            float f13;
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            float f19;
            float f20;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23 = 0;
            int n24 = this.width;
            int n25 = layoutParams.width;
            if (n24 != n25) {
                int n26;
                this.width = n26 = layoutParams.width;
                n23 = 0 | 1;
            }
            if ((n22 = this.height) != (n21 = layoutParams.height)) {
                int n27;
                this.height = n27 = layoutParams.height;
                n23 |= 1;
            }
            if ((n20 = this.x) != (n19 = layoutParams.x)) {
                int n28;
                this.x = n28 = layoutParams.x;
                n23 |= 1;
            }
            if ((n18 = this.y) != (n17 = layoutParams.y)) {
                int n29;
                this.y = n29 = layoutParams.y;
                n23 |= 1;
            }
            if ((f20 = this.horizontalWeight) != (f19 = layoutParams.horizontalWeight)) {
                float f21;
                this.horizontalWeight = f21 = layoutParams.horizontalWeight;
                n23 |= 1;
            }
            if ((f18 = this.verticalWeight) != (f17 = layoutParams.verticalWeight)) {
                float f22;
                this.verticalWeight = f22 = layoutParams.verticalWeight;
                n23 |= 1;
            }
            if ((f16 = this.horizontalMargin) != (f15 = layoutParams.horizontalMargin)) {
                float f23;
                this.horizontalMargin = f23 = layoutParams.horizontalMargin;
                n23 |= 1;
            }
            if ((f14 = this.verticalMargin) != (f13 = layoutParams.verticalMargin)) {
                float f24;
                this.verticalMargin = f24 = layoutParams.verticalMargin;
                n23 |= 1;
            }
            if ((n16 = this.type) != (n15 = layoutParams.type)) {
                int n30;
                this.type = n30 = layoutParams.type;
                n23 |= 2;
            }
            if ((n14 = this.memoryType) != (n13 = layoutParams.memoryType)) {
                int n31;
                this.memoryType = n31 = layoutParams.memoryType;
                n23 |= 0x100;
            }
            if ((n12 = this.flags) != (n11 = layoutParams.flags)) {
                int n32;
                this.flags = n32 = layoutParams.flags;
                n23 |= 4;
            }
            if ((n10 = this.softInputMode) != (n9 = layoutParams.softInputMode)) {
                int n33;
                this.softInputMode = n33 = layoutParams.softInputMode;
                n23 |= 0x200;
            }
            if ((n8 = this.gravity) != (n7 = layoutParams.gravity)) {
                int n34;
                this.gravity = n34 = layoutParams.gravity;
                n23 |= 1;
            }
            if ((f12 = this.horizontalMargin) != (f11 = layoutParams.horizontalMargin)) {
                float f25;
                this.horizontalMargin = f25 = layoutParams.horizontalMargin;
                n23 |= 1;
            }
            if ((f10 = this.verticalMargin) != (f9 = layoutParams.verticalMargin)) {
                float f26;
                this.verticalMargin = f26 = layoutParams.verticalMargin;
                n23 |= 1;
            }
            if ((n6 = this.format) != (n5 = layoutParams.format)) {
                int n35;
                this.format = n35 = layoutParams.format;
                n23 |= 8;
            }
            if ((n4 = this.windowAnimations) != (n3 = layoutParams.windowAnimations)) {
                int n36;
                this.windowAnimations = n36 = layoutParams.windowAnimations;
                n23 |= 0x10;
            }
            if (this.token == null) {
                IBinder iBinder;
                this.token = iBinder = layoutParams.token;
            }
            if (this.packageName == null) {
                String string2;
                this.packageName = string2 = layoutParams.packageName;
            }
            if (!(charSequence2 = this.mTitle).equals(charSequence = layoutParams.mTitle)) {
                CharSequence charSequence3;
                this.mTitle = charSequence3 = layoutParams.mTitle;
                n23 |= 0x40;
            }
            if ((f8 = this.alpha) != (f7 = layoutParams.alpha)) {
                float f27;
                this.alpha = f27 = layoutParams.alpha;
                n23 |= 0x80;
            }
            if ((f6 = this.dimAmount) != (f5 = layoutParams.dimAmount)) {
                float f28;
                this.dimAmount = f28 = layoutParams.dimAmount;
                n23 |= 0x20;
            }
            if ((f4 = this.screenBrightness) != (f3 = layoutParams.screenBrightness)) {
                float f29;
                this.screenBrightness = f29 = layoutParams.screenBrightness;
                n23 |= 0x800;
            }
            if ((f2 = this.buttonBrightness) != (f = layoutParams.buttonBrightness)) {
                float f30;
                this.buttonBrightness = f30 = layoutParams.buttonBrightness;
                n23 |= 0x1000;
            }
            if ((n2 = this.screenOrientation) != (n = layoutParams.screenOrientation)) {
                int n37;
                this.screenOrientation = n37 = layoutParams.screenOrientation;
                n23 |= 0x400;
            }
            return n23;
        }

        @Override
        public String debug(String string2) {
            String string3 = string2 + "Contents of " + this + ":";
            int n = Log.d("Debug", string3);
            String string4 = super.debug("");
            int n2 = Log.d("Debug", string4);
            int n3 = Log.d("Debug", "");
            StringBuilder stringBuilder = new StringBuilder().append("WindowManager.LayoutParams={title=");
            CharSequence charSequence = this.mTitle;
            String string5 = stringBuilder.append((Object)charSequence).append("}").toString();
            int n4 = Log.d("Debug", string5);
            return "";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public final CharSequence getTitle() {
            return this.mTitle;
        }

        void restore() {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray = this.mCompatibilityParamsBackup;
            if (nArray == null) {
                return;
            }
            this.x = n4 = nArray[0];
            this.y = n3 = nArray[1];
            this.width = n2 = nArray[2];
            this.height = n = nArray[3];
        }

        public void scale(float f) {
            int n;
            int n2;
            int n3;
            this.x = n3 = (int)((float)this.x * f + 0.5f);
            this.y = n2 = (int)((float)this.y * f + 0.5f);
            if (this.width > 0) {
                int n4;
                this.width = n4 = (int)((float)this.width * f + 0.5f);
            }
            if (this.height <= 0) {
                return;
            }
            this.height = n = (int)((float)this.height * f + 0.5f);
        }

        public final void setTitle(CharSequence charSequence) {
            CharSequence charSequence2;
            if (charSequence == null) {
                charSequence = "";
            }
            this.mTitle = charSequence2 = TextUtils.stringOrSpannedString(charSequence);
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(256);
            StringBuilder stringBuilder2 = stringBuilder.append("WM.LayoutParams{");
            StringBuilder stringBuilder3 = stringBuilder.append("(");
            int n = this.x;
            StringBuilder stringBuilder4 = stringBuilder.append(n);
            StringBuilder stringBuilder5 = stringBuilder.append(',');
            int n2 = this.y;
            StringBuilder stringBuilder6 = stringBuilder.append(n2);
            StringBuilder stringBuilder7 = stringBuilder.append(")(");
            Object object = this.width == -1 ? "fill" : (this.width == -1 ? "wrap" : Integer.valueOf(this.width));
            StringBuilder stringBuilder8 = stringBuilder.append(object);
            StringBuilder stringBuilder9 = stringBuilder.append('x');
            Object object2 = this.height == -1 ? "fill" : (this.height == -1 ? "wrap" : Integer.valueOf(this.height));
            StringBuilder stringBuilder10 = stringBuilder.append(object2);
            StringBuilder stringBuilder11 = stringBuilder.append(")");
            if (this.softInputMode != 0) {
                StringBuilder stringBuilder12 = stringBuilder.append(" sim=#");
                String string2 = Integer.toHexString(this.softInputMode);
                StringBuilder stringBuilder13 = stringBuilder.append(string2);
            }
            if (this.gravity != 0) {
                StringBuilder stringBuilder14 = stringBuilder.append(" gr=#");
                String string3 = Integer.toHexString(this.gravity);
                StringBuilder stringBuilder15 = stringBuilder.append(string3);
            }
            StringBuilder stringBuilder16 = stringBuilder.append(" ty=");
            int n3 = this.type;
            StringBuilder stringBuilder17 = stringBuilder.append(n3);
            StringBuilder stringBuilder18 = stringBuilder.append(" fl=#");
            String string4 = Integer.toHexString(this.flags);
            StringBuilder stringBuilder19 = stringBuilder.append(string4);
            StringBuilder stringBuilder20 = stringBuilder.append(" fmt=");
            int n4 = this.format;
            StringBuilder stringBuilder21 = stringBuilder.append(n4);
            if (this.windowAnimations != 0) {
                StringBuilder stringBuilder22 = stringBuilder.append(" wanim=0x");
                String string5 = Integer.toHexString(this.windowAnimations);
                StringBuilder stringBuilder23 = stringBuilder.append(string5);
            }
            if (this.screenOrientation != -1) {
                StringBuilder stringBuilder24 = stringBuilder.append(" or=");
                int n5 = this.screenOrientation;
                StringBuilder stringBuilder25 = stringBuilder.append(n5);
            }
            if ((this.flags & 0x20000000) != 0) {
                StringBuilder stringBuilder26 = stringBuilder.append(" compatible=true");
            }
            StringBuilder stringBuilder27 = stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.width;
            parcel.writeInt(n2);
            int n3 = this.height;
            parcel.writeInt(n3);
            int n4 = this.x;
            parcel.writeInt(n4);
            int n5 = this.y;
            parcel.writeInt(n5);
            int n6 = this.type;
            parcel.writeInt(n6);
            int n7 = this.memoryType;
            parcel.writeInt(n7);
            int n8 = this.flags;
            parcel.writeInt(n8);
            int n9 = this.softInputMode;
            parcel.writeInt(n9);
            int n10 = this.gravity;
            parcel.writeInt(n10);
            float f = this.horizontalMargin;
            parcel.writeFloat(f);
            float f2 = this.verticalMargin;
            parcel.writeFloat(f2);
            int n11 = this.format;
            parcel.writeInt(n11);
            int n12 = this.windowAnimations;
            parcel.writeInt(n12);
            float f3 = this.alpha;
            parcel.writeFloat(f3);
            float f4 = this.dimAmount;
            parcel.writeFloat(f4);
            float f5 = this.screenBrightness;
            parcel.writeFloat(f5);
            float f6 = this.buttonBrightness;
            parcel.writeFloat(f6);
            IBinder iBinder = this.token;
            parcel.writeStrongBinder(iBinder);
            String string2 = this.packageName;
            parcel.writeString(string2);
            TextUtils.writeToParcel(this.mTitle, parcel, n);
            int n13 = this.screenOrientation;
            parcel.writeInt(n13);
        }
    }

    public static class BadTokenException
    extends RuntimeException {
        public BadTokenException() {
        }

        public BadTokenException(String string2) {
            super(string2);
        }
    }
}

