/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.IBinder;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRoot;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

public class WindowManagerImpl
implements WindowManager {
    public static final int ADD_APP_EXITING = 252;
    public static final int ADD_BAD_APP_TOKEN = 255;
    public static final int ADD_BAD_SUBWINDOW_TOKEN = 254;
    public static final int ADD_DUPLICATE_ADD = 251;
    public static final int ADD_FLAG_APP_VISIBLE = 2;
    public static final int ADD_FLAG_IN_TOUCH_MODE = 1;
    public static final int ADD_MULTIPLE_SINGLETON = 249;
    public static final int ADD_NOT_APP_TOKEN = 253;
    public static final int ADD_OKAY = 0;
    public static final int ADD_PERMISSION_DENIED = 248;
    public static final int ADD_STARTING_NOT_NEEDED = 250;
    public static final int RELAYOUT_FIRST_TIME = 2;
    public static final int RELAYOUT_IN_TOUCH_MODE = 1;
    private static WindowManagerImpl mWindowManager = new WindowManagerImpl();
    private WindowManager.LayoutParams[] mParams;
    private ViewRoot[] mRoots;
    private View[] mViews;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addView(View view, ViewGroup.LayoutParams layoutParams, boolean bl) {
        ViewRoot viewRoot;
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
        View view2 = null;
        synchronized (this) {
            boolean bl2 = false;
            int n = this.findViewLocked(view, bl2);
            if (n >= 0) {
                int n2;
                if (!bl) {
                    String string2 = "View " + view + " has already been added to the window manager.";
                    throw new IllegalStateException(string2);
                }
                ViewRoot viewRoot2 = this.mRoots[n];
                viewRoot2.mAddNesting = n2 = viewRoot2.mAddNesting + 1;
                view.setLayoutParams(layoutParams2);
                viewRoot2.setLayoutParams(layoutParams2, true);
                return;
            }
            if (layoutParams2.type >= 1000 && layoutParams2.type <= 1999) {
                int n3 = this.mViews != null ? this.mViews.length : 0;
                for (int i = 0; i < n3; ++i) {
                    IBinder iBinder;
                    IBinder iBinder2 = this.mRoots[i].mWindow.asBinder();
                    if (iBinder2 != (iBinder = layoutParams2.token)) continue;
                    view2 = this.mViews[i];
                }
            }
            Context context = view.getContext();
            viewRoot = new ViewRoot(context);
            viewRoot.mAddNesting = 1;
            view.setLayoutParams(layoutParams2);
            if (this.mViews == null) {
                n = 1;
                View[] viewArray = new View[1];
                this.mViews = viewArray;
                ViewRoot[] viewRootArray = new ViewRoot[1];
                this.mRoots = viewRootArray;
                WindowManager.LayoutParams[] layoutParamsArray = new WindowManager.LayoutParams[1];
                this.mParams = layoutParamsArray;
            } else {
                n = this.mViews.length + 1;
                View[] viewArray = this.mViews;
                View[] viewArray2 = new View[n];
                View[] viewArray3 = this.mViews = viewArray2;
                int n4 = n - 1;
                System.arraycopy(viewArray, 0, viewArray3, 0, n4);
                ViewRoot[] viewRootArray = this.mRoots;
                ViewRoot[] viewRootArray2 = new ViewRoot[n];
                ViewRoot[] viewRootArray3 = this.mRoots = viewRootArray2;
                int n5 = n - 1;
                System.arraycopy(viewRootArray, 0, viewRootArray3, 0, n5);
                WindowManager.LayoutParams[] layoutParamsArray = this.mParams;
                WindowManager.LayoutParams[] layoutParamsArray2 = new WindowManager.LayoutParams[n];
                WindowManager.LayoutParams[] layoutParamsArray3 = this.mParams = layoutParamsArray2;
                int n6 = n - 1;
                System.arraycopy(layoutParamsArray, 0, layoutParamsArray3, 0, n6);
            }
            int n7 = n + -1;
            this.mViews[n7] = view;
            this.mRoots[n7] = viewRoot;
            this.mParams[n7] = layoutParams2;
        }
        viewRoot.setView(view, layoutParams2, view2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findViewLocked(View view, boolean bl) {
        synchronized (this) {
            int n = this.mViews != null ? this.mViews.length : 0;
            for (int i = 0; i < n; ++i) {
                if (this.mViews[i] != view) continue;
                return i;
            }
            if (!bl) return -1;
            throw new IllegalArgumentException("View not attached to window manager");
        }
    }

    public static WindowManagerImpl getDefault() {
        return mWindowManager;
    }

    private static void removeItem(Object[] objectArray, Object[] objectArray2, int n) {
        int n2;
        if (objectArray.length <= 0) {
            return;
        }
        if (n > 0) {
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
        }
        if (n >= (n2 = objectArray.length)) {
            return;
        }
        int n3 = n + 1;
        int n4 = objectArray2.length - n - 1;
        System.arraycopy(objectArray2, n3, objectArray, n, n4);
    }

    public void addView(View view) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(2, 0, -1);
        this.addView(view, layoutParams);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        this.addView(view, layoutParams, false);
    }

    public void addViewNesting(View view, ViewGroup.LayoutParams layoutParams) {
        this.addView(view, layoutParams, false);
    }

    public void closeAll() {
        this.closeAll(null, null, null);
    }

    public void closeAll(IBinder iBinder, String string2, String string3) {
        synchronized (this) {
            if (this.mViews == null) {
                return;
            }
            int n = this.mViews.length;
            for (int i = 0; i < n; ++i) {
                if (iBinder != null && this.mParams[i].token != iBinder) continue;
                ViewRoot viewRoot = this.mRoots[i];
                viewRoot.mAddNesting = 1;
                if (string2 != null) {
                    StringBuilder stringBuilder = new StringBuilder().append(string3).append(" ").append(string2).append(" has leaked window ");
                    View view = viewRoot.getView();
                    String string4 = stringBuilder.append(view).append(" that was originally added here").toString();
                    WindowLeaked windowLeaked = new WindowLeaked(string4);
                    StackTraceElement[] stackTraceElementArray = viewRoot.getLocation().getStackTrace();
                    windowLeaked.setStackTrace(stackTraceElementArray);
                    String string5 = windowLeaked.getMessage();
                    int n2 = Log.e("WindowManager", string5, windowLeaked);
                }
                View view = this.removeViewLocked(i);
                i += -1;
                n += -1;
            }
            return;
        }
    }

    void finishRemoveViewLocked(View view, int n) {
        int n2 = this.mViews.length;
        Object[] objectArray = new View[n2 - 1];
        Object[] objectArray2 = this.mViews;
        WindowManagerImpl.removeItem(objectArray, objectArray2, n);
        this.mViews = objectArray;
        Object[] objectArray3 = new ViewRoot[n2 - 1];
        Object[] objectArray4 = this.mRoots;
        WindowManagerImpl.removeItem(objectArray3, objectArray4, n);
        this.mRoots = objectArray3;
        Object[] objectArray5 = new WindowManager.LayoutParams[n2 - 1];
        Object[] objectArray6 = this.mParams;
        WindowManagerImpl.removeItem(objectArray5, objectArray6, n);
        this.mParams = objectArray5;
        view.assignParent(null);
    }

    @Override
    public Display getDefaultDisplay() {
        return new Display(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WindowManager.LayoutParams getRootViewLayoutParameter(View view) {
        ViewParent viewParent;
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof ViewRoot); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return null;
        }
        ViewRoot viewRoot = (ViewRoot)viewParent;
        int n = this.mRoots.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mRoots[n2] == viewRoot) {
                return this.mParams[n2];
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void removeView(View view) {
        synchronized (this) {
            int n = this.findViewLocked(view, true);
            View view2 = this.removeViewLocked(n);
            if (view2 == view) {
                return;
            }
            String string2 = "Calling with view " + view + " but the ViewRoot is attached to " + view2;
            throw new IllegalStateException(string2);
        }
    }

    @Override
    public void removeViewImmediate(View view) {
        synchronized (this) {
            int n = this.findViewLocked(view, true);
            ViewRoot viewRoot = this.mRoots[n];
            View view2 = viewRoot.getView();
            viewRoot.mAddNesting = 0;
            viewRoot.die(true);
            this.finishRemoveViewLocked(view2, n);
            if (view2 == view) {
                return;
            }
            String string2 = "Calling with view " + view + " but the ViewRoot is attached to " + view2;
            throw new IllegalStateException(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    View removeViewLocked(int n) {
        int n2;
        ViewRoot viewRoot = this.mRoots[n];
        View view = viewRoot.getView();
        viewRoot.mAddNesting = n2 = viewRoot.mAddNesting - 1;
        if (viewRoot.mAddNesting > 0) {
            return view;
        }
        InputMethodManager inputMethodManager = InputMethodManager.getInstance(view.getContext());
        if (inputMethodManager != null) {
            IBinder iBinder = this.mViews[n].getWindowToken();
            inputMethodManager.windowDismissed(iBinder);
        }
        viewRoot.die(false);
        this.finishRemoveViewLocked(view, n);
        return view;
    }

    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
        view.setLayoutParams(layoutParams2);
        synchronized (this) {
            boolean bl = true;
            int n = this.findViewLocked(view, bl);
            ViewRoot viewRoot = this.mRoots[n];
            this.mParams[n] = layoutParams2;
            viewRoot.setLayoutParams(layoutParams2, false);
            return;
        }
    }
}

