/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;

public abstract class WindowOrientationListener {
    private static final boolean DEBUG = false;
    private static final String TAG = "WindowOrientationListener";
    private static final boolean localLOGV;
    private boolean mEnabled = false;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListenerImpl mSensorEventListener;
    private SensorManager mSensorManager;

    public WindowOrientationListener(Context context) {
        this(context, 3);
    }

    private WindowOrientationListener(Context context, int n) {
        SensorEventListenerImpl sensorEventListenerImpl;
        Sensor sensor;
        SensorManager sensorManager;
        this.mSensorManager = sensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = n;
        this.mSensor = sensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor == null) {
            return;
        }
        this.mSensorEventListener = sensorEventListenerImpl = new SensorEventListenerImpl(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDetectOrientation() {
        if (this.mSensor == null) return false;
        return true;
    }

    public void disable() {
        if (this.mSensor == null) {
            int n = Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (!this.mEnabled) {
            return;
        }
        SensorManager sensorManager = this.mSensorManager;
        SensorEventListenerImpl sensorEventListenerImpl = this.mSensorEventListener;
        sensorManager.unregisterListener(sensorEventListenerImpl);
        this.mEnabled = false;
    }

    public void enable() {
        if (this.mSensor == null) {
            int n = Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (this.mEnabled) {
            return;
        }
        SensorManager sensorManager = this.mSensorManager;
        SensorEventListenerImpl sensorEventListenerImpl = this.mSensorEventListener;
        Sensor sensor = this.mSensor;
        int n = this.mRate;
        boolean bl = sensorManager.registerListener(sensorEventListenerImpl, sensor, n);
        this.mEnabled = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCurrentRotation(int n) {
        if (!this.mEnabled) return n;
        return this.mSensorEventListener.getCurrentRotation(n);
    }

    public abstract void onOrientationChanged(int var1);

    public void setAllow180Rotation(boolean bl) {
        if (this.mSensorEventListener == null) {
            return;
        }
        this.mSensorEventListener.setAllow180Rotation(bl);
    }

    static class SensorEventListenerImpl
    implements SensorEventListener {
        private static final float ACCELERATING_LOWPASS_ALPHA = 0.0f;
        private static final int ACCELERATING_TIME_CONSTANT_MS = 2000;
        private static final float DEFAULT_LOWPASS_ALPHA = 0.0f;
        private static final int DEFAULT_TIME_CONSTANT_MS = 100;
        private static final int[] INTERNAL_TO_SURFACE_ROTATION = new int[]{0, 1, 3, 2};
        private static final float MAX_DEVIATION_FROM_GRAVITY = 1.5f;
        private static final int MAX_TILT = 75;
        private static final int[] MAX_TRANSITION_TILT;
        private static final float MIN_ABS_ACCELERATION = 1.5f;
        private static final int PARTIAL_TILT = 50;
        private static final float RADIANS_TO_DEGREES = 57.29578f;
        private static final int[][] ROTATE_TO;
        private static final int[][] ROTATE_TO_WITH_180;
        private static final int ROTATION_0 = 0;
        private static final int ROTATION_180 = 3;
        private static final int ROTATION_270 = 2;
        private static final int ROTATION_90 = 1;
        private static final int SAMPLING_PERIOD_MS = 200;
        private static final int[] SURFACE_TO_INTERNAL_ROTATION;
        private static final int[][][] THRESHOLDS;
        private static final int[][][] THRESHOLDS_WITH_180;
        private static final float TILTED_LOWPASS_ALPHA = 0.0f;
        private static final int TILTED_TIME_CONSTANT_MS = 500;
        private static final int _DATA_X = 0;
        private static final int _DATA_Y = 1;
        private static final int _DATA_Z = 2;
        private int mAccelerationDistrust = 0;
        private boolean mAllow180Rotation = false;
        private float mOrientationAngle = 0.0f;
        private WindowOrientationListener mOrientationListener;
        private int mRotation = 0;
        private float mTiltAngle = 0.0f;
        private int mTiltDistrust = 0;

        static {
            SURFACE_TO_INTERNAL_ROTATION = new int[]{0, 1, 3, 2};
            int[] nArray = new int[4];
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[]{60, 180};
            nArray2[0] = (int)nArray3;
            int[] nArray4 = new int[]{180, 300};
            nArray2[1] = (int)nArray4;
            nArray[0] = (int)nArray2;
            int[] nArray5 = new int[3];
            int[] nArray6 = new int[]{0, 30};
            nArray5[0] = (int)nArray6;
            int[] nArray7 = new int[]{195, 315};
            nArray5[1] = (int)nArray7;
            int[] nArray8 = new int[]{315, 360};
            nArray5[2] = (int)nArray8;
            nArray[1] = (int)nArray5;
            int[] nArray9 = new int[3];
            int[] nArray10 = new int[]{0, 45};
            nArray9[0] = (int)nArray10;
            int[] nArray11 = new int[]{45, 165};
            nArray9[1] = (int)nArray11;
            int[] nArray12 = new int[]{330, 360};
            nArray9[2] = (int)nArray12;
            nArray[2] = (int)nArray9;
            int[] nArray13 = new int[5];
            int[] nArray14 = new int[]{0, 45};
            nArray13[0] = (int)nArray14;
            int[] nArray15 = new int[]{45, 135};
            nArray13[1] = (int)nArray15;
            int[] nArray16 = new int[]{135, 225};
            nArray13[2] = (int)nArray16;
            int[] nArray17 = new int[]{225, 315};
            nArray13[3] = (int)nArray17;
            int[] nArray18 = new int[]{315, 360};
            nArray13[4] = (int)nArray18;
            nArray[3] = (int)nArray13;
            THRESHOLDS = (int[][][])nArray;
            int[] nArray19 = new int[4];
            int[] nArray20 = new int[]{1, 2};
            nArray19[0] = (int)nArray20;
            int[] nArray21 = new int[]{0, 2, 0};
            nArray19[1] = (int)nArray21;
            int[] nArray22 = new int[]{0, 1, 0};
            nArray19[2] = (int)nArray22;
            int[] nArray23 = new int[]{0, 1, 0, 2, 0};
            nArray19[3] = (int)nArray23;
            ROTATE_TO = (int[][])nArray19;
            int[] nArray24 = new int[4];
            int[] nArray25 = new int[3];
            int[] nArray26 = new int[]{60, 165};
            nArray25[0] = (int)nArray26;
            int[] nArray27 = new int[]{165, 195};
            nArray25[1] = (int)nArray27;
            int[] nArray28 = new int[]{195, 300};
            nArray25[2] = (int)nArray28;
            nArray24[0] = (int)nArray25;
            int[] nArray29 = new int[4];
            int[] nArray30 = new int[]{0, 30};
            nArray29[0] = (int)nArray30;
            int[] nArray31 = new int[]{165, 195};
            nArray29[1] = (int)nArray31;
            int[] nArray32 = new int[]{195, 315};
            nArray29[2] = (int)nArray32;
            int[] nArray33 = new int[]{315, 360};
            nArray29[3] = (int)nArray33;
            nArray24[1] = (int)nArray29;
            int[] nArray34 = new int[4];
            int[] nArray35 = new int[]{0, 45};
            nArray34[0] = (int)nArray35;
            int[] nArray36 = new int[]{45, 165};
            nArray34[1] = (int)nArray36;
            int[] nArray37 = new int[]{165, 195};
            nArray34[2] = (int)nArray37;
            int[] nArray38 = new int[]{330, 360};
            nArray34[3] = (int)nArray38;
            nArray24[2] = (int)nArray34;
            int[] nArray39 = new int[4];
            int[] nArray40 = new int[]{0, 45};
            nArray39[0] = (int)nArray40;
            int[] nArray41 = new int[]{45, 135};
            nArray39[1] = (int)nArray41;
            int[] nArray42 = new int[]{225, 315};
            nArray39[2] = (int)nArray42;
            int[] nArray43 = new int[]{315, 360};
            nArray39[3] = (int)nArray43;
            nArray24[3] = (int)nArray39;
            THRESHOLDS_WITH_180 = (int[][][])nArray24;
            int[] nArray44 = new int[4];
            int[] nArray45 = new int[]{1, 3, 2};
            nArray44[0] = (int)nArray45;
            int[] nArray46 = new int[]{0, 3, 1, 0};
            nArray44[1] = (int)nArray46;
            int[] nArray47 = new int[]{0, 2, 3, 0};
            nArray44[2] = (int)nArray47;
            int[] nArray48 = new int[]{0, 1, 2, 0};
            nArray44[3] = (int)nArray48;
            ROTATE_TO_WITH_180 = (int[][])nArray44;
            MAX_TRANSITION_TILT = new int[]{75, 65, 65, 40};
            DEFAULT_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(100);
            TILTED_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(500);
            ACCELERATING_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(2000);
        }

        public SensorEventListenerImpl(WindowOrientationListener windowOrientationListener) {
            this.mOrientationListener = windowOrientationListener;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void calculateNewRotation(float f, float f2) {
            float f3;
            int n;
            int[][] nArray;
            boolean bl = this.mAllow180Rotation;
            if (bl) {
                int[][][] nArray2 = THRESHOLDS_WITH_180;
                int n2 = this.mRotation;
                nArray = nArray2[n2];
            } else {
                int[][][] nArray3 = THRESHOLDS;
                int n3 = this.mRotation;
                nArray = nArray3[n3];
            }
            int n4 = -1;
            int n5 = 0;
            while (true) {
                block10: {
                    block9: {
                        float f4;
                        int n6;
                        if (n5 >= (n6 = nArray.length)) break block9;
                        float f5 = nArray[n5][0];
                        if (!(f >= f5) || !(f < (f4 = (float)nArray[n5][1]))) break block10;
                        n4 = n5;
                    }
                    if (n4 != -1) break;
                    return;
                }
                ++n5;
            }
            if (bl) {
                int[][] nArray4 = ROTATE_TO_WITH_180;
                int n7 = this.mRotation;
                n = nArray4[n7][n4];
            } else {
                int[][] nArray5 = ROTATE_TO;
                int n8 = this.mRotation;
                n = nArray5[n8][n4];
            }
            if (f2 > (f3 = (float)MAX_TRANSITION_TILT[n])) {
                return;
            }
            this.mRotation = n;
            WindowOrientationListener windowOrientationListener = this.mOrientationListener;
            int[] nArray6 = INTERNAL_TO_SURFACE_ROTATION;
            int n9 = this.mRotation;
            int n10 = nArray6[n9];
            windowOrientationListener.onOrientationChanged(n10);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void checkFullyTilted(float f) {
            int n;
            if (f > 75.0f) {
                this.mOrientationAngle = this.mRotation == 0 ? 0.0f : (this.mRotation == 1 ? 90.0f : 270.0f);
                if (this.mTiltDistrust >= 3) {
                    return;
                }
                this.mTiltDistrust = 3;
                return;
            }
            if (this.mTiltDistrust <= 0) {
                return;
            }
            this.mTiltDistrust = n = this.mTiltDistrust - 1;
        }

        private static float computeLowpassAlpha(int n) {
            float f = n + 200;
            return 200.0f / f;
        }

        private float computeNewOrientation(float f, float f2) {
            double d = -f;
            double d2 = f2;
            float f3 = (float)(-Math.atan2(d, d2)) * 57.29578f;
            if (f3 < 0.0f) {
                f3 += 360.0f;
            }
            return f3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void filterOrientation(float f, float f2) {
            float f3;
            float f4;
            float f5;
            float f6;
            float f7 = DEFAULT_LOWPASS_ALPHA;
            if (this.mAccelerationDistrust > 1) {
                f7 = ACCELERATING_LOWPASS_ALPHA;
            } else if (f > 50.0f || this.mAccelerationDistrust == 1) {
                f7 = TILTED_LOWPASS_ALPHA;
            }
            if ((f6 = f2 - (f5 = this.mOrientationAngle)) > 180.0f) {
                f2 -= 360.0f;
            } else if (f6 < -180.0f) {
                f2 += 360.0f;
            }
            float f8 = this.mOrientationAngle;
            this.mOrientationAngle = f4 = this.lowpassFilter(f2, f8, f7);
            if (this.mOrientationAngle > 360.0f) {
                float f9;
                this.mOrientationAngle = f9 = this.mOrientationAngle - 360.0f;
                return;
            }
            if (!(this.mOrientationAngle < 0.0f)) {
                return;
            }
            this.mOrientationAngle = f3 = this.mOrientationAngle + 360.0f;
        }

        private void handleAccelerationDistrust(float f) {
            int n;
            if (f > 1.5f) {
                int n2;
                if (this.mAccelerationDistrust >= 5) {
                    return;
                }
                this.mAccelerationDistrust = n2 = this.mAccelerationDistrust + 1;
                return;
            }
            if (this.mAccelerationDistrust <= 0) {
                return;
            }
            this.mAccelerationDistrust = n = this.mAccelerationDistrust - 1;
        }

        private float lowpassFilter(float f, float f2, float f3) {
            float f4 = f3 * f;
            float f5 = (1.0f - f3) * f2;
            return f4 + f5;
        }

        private float tiltAngle(float f, float f2) {
            return (float)Math.asin(f / f2) * 57.29578f;
        }

        private float vectorMagnitude(float f, float f2, float f3) {
            float f4 = f * f;
            float f5 = f2 * f2;
            float f6 = f4 + f5;
            float f7 = f3 * f3;
            return (float)Math.sqrt(f6 + f7);
        }

        int getCurrentRotation(int n) {
            if (this.mTiltDistrust > 0) {
                int n2;
                this.mRotation = n2 = SURFACE_TO_INTERNAL_ROTATION[n];
            }
            int[] nArray = INTERNAL_TO_SURFACE_ROTATION;
            int n3 = this.mRotation;
            return nArray[n3];
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            float f;
            float f2 = sensorEvent.values[0];
            float f3 = sensorEvent.values[1];
            float f4 = sensorEvent.values[2];
            float f5 = this.vectorMagnitude(f2, f3, f4);
            float f6 = Math.abs(f5 - 9.80665f);
            this.handleAccelerationDistrust(f6);
            if (f5 < 1.5f) {
                return;
            }
            float f7 = 1.0f;
            if (this.mAccelerationDistrust > 0) {
                f7 = ACCELERATING_LOWPASS_ALPHA;
            }
            float f8 = this.tiltAngle(f4, f5);
            float f9 = this.mTiltAngle;
            this.mTiltAngle = f = this.lowpassFilter(f8, f9, f7);
            float f10 = Math.abs(this.mTiltAngle);
            this.checkFullyTilted(f10);
            if (this.mTiltDistrust > 0) {
                return;
            }
            float f11 = this.computeNewOrientation(f2, f3);
            this.filterOrientation(f10, f11);
            float f12 = this.mOrientationAngle;
            this.calculateNewRotation(f12, f10);
        }

        void setAllow180Rotation(boolean bl) {
            this.mAllow180Rotation = bl;
        }
    }
}

