/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public final class AccessibilityEvent
implements Parcelable {
    private static final int CHECKED = 1;
    public static final Parcelable.Creator<AccessibilityEvent> CREATOR;
    private static final int ENABLED = 2;
    private static final int FULL_SCREEN = 128;
    public static final int INVALID_POSITION = 255;
    private static final int MAX_POOL_SIZE = 2;
    public static final int MAX_TEXT_LENGTH = 500;
    private static final int PASSWORD = 4;
    public static final int TYPES_ALL_MASK = 255;
    public static final int TYPE_NOTIFICATION_STATE_CHANGED = 64;
    public static final int TYPE_VIEW_CLICKED = 1;
    public static final int TYPE_VIEW_FOCUSED = 8;
    public static final int TYPE_VIEW_LONG_CLICKED = 2;
    public static final int TYPE_VIEW_SELECTED = 4;
    public static final int TYPE_VIEW_TEXT_CHANGED = 16;
    public static final int TYPE_WINDOW_STATE_CHANGED = 32;
    private static final Object mPoolLock;
    private static AccessibilityEvent sPool;
    private static int sPoolSize;
    private int mAddedCount;
    private CharSequence mBeforeText;
    private int mBooleanProperties;
    private CharSequence mClassName;
    private CharSequence mContentDescription;
    private int mCurrentItemIndex;
    private long mEventTime;
    private int mEventType;
    private int mFromIndex;
    private boolean mIsInPool;
    private int mItemCount;
    private AccessibilityEvent mNext;
    private CharSequence mPackageName;
    private Parcelable mParcelableData;
    private int mRemovedCount;
    private final List<CharSequence> mText;

    static {
        mPoolLock = new Object();
        CREATOR = new Parcelable.Creator<AccessibilityEvent>(){

            @Override
            public AccessibilityEvent createFromParcel(Parcel parcel) {
                AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
                accessibilityEvent.initFromParcel(parcel);
                return accessibilityEvent;
            }

            public AccessibilityEvent[] newArray(int n) {
                return new AccessibilityEvent[n];
            }
        };
    }

    private AccessibilityEvent() {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        this.mText = arrayList;
        this.mCurrentItemIndex = -1;
    }

    private void clear() {
        this.mEventType = 0;
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = 0;
        this.mFromIndex = 0;
        this.mAddedCount = 0;
        this.mRemovedCount = 0;
        this.mEventTime = 0L;
        this.mClassName = null;
        this.mPackageName = null;
        this.mContentDescription = null;
        this.mBeforeText = null;
        this.mParcelableData = null;
        this.mText.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getBooleanProperty(int n) {
        if ((this.mBooleanProperties & n) == n) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessibilityEvent obtain() {
        Object object = mPoolLock;
        synchronized (object) {
            if (sPool != null) {
                AccessibilityEvent accessibilityEvent = sPool;
                sPool = AccessibilityEvent.sPool.mNext;
                --sPoolSize;
                accessibilityEvent.mNext = null;
                accessibilityEvent.mIsInPool = false;
                return accessibilityEvent;
            }
            AccessibilityEvent accessibilityEvent = new AccessibilityEvent();
            return accessibilityEvent;
        }
    }

    public static AccessibilityEvent obtain(int n) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
        accessibilityEvent.setEventType(n);
        return accessibilityEvent;
    }

    private void setBooleanProperty(int n, boolean bl) {
        int n2;
        if (bl) {
            int n3;
            this.mBooleanProperties = n3 = this.mBooleanProperties | n;
            return;
        }
        int n4 = this.mBooleanProperties;
        int n5 = ~n;
        this.mBooleanProperties = n2 = n4 & n5;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAddedCount() {
        return this.mAddedCount;
    }

    public CharSequence getBeforeText() {
        return this.mBeforeText;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public int getCurrentItemIndex() {
        return this.mCurrentItemIndex;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public int getEventType() {
        return this.mEventType;
    }

    public int getFromIndex() {
        return this.mFromIndex;
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public Parcelable getParcelableData() {
        return this.mParcelableData;
    }

    public int getRemovedCount() {
        return this.mRemovedCount;
    }

    public List<CharSequence> getText() {
        return this.mText;
    }

    public void initFromParcel(Parcel parcel) {
        CharSequence charSequence;
        CharSequence charSequence2;
        CharSequence charSequence3;
        CharSequence charSequence4;
        long l;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.mEventType = n7 = parcel.readInt();
        this.mBooleanProperties = n6 = parcel.readInt();
        this.mCurrentItemIndex = n5 = parcel.readInt();
        this.mItemCount = n4 = parcel.readInt();
        this.mFromIndex = n3 = parcel.readInt();
        this.mAddedCount = n2 = parcel.readInt();
        this.mRemovedCount = n = parcel.readInt();
        this.mEventTime = l = parcel.readLong();
        this.mClassName = charSequence4 = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mPackageName = charSequence3 = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mContentDescription = charSequence2 = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mBeforeText = charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        Object t = parcel.readParcelable(null);
        this.mParcelableData = t;
        List<CharSequence> list = this.mText;
        parcel.readList(list, null);
    }

    public boolean isChecked() {
        return this.getBooleanProperty(1);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(2);
    }

    public boolean isFullScreen() {
        return this.getBooleanProperty(128);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(4);
    }

    public void recycle() {
        if (this.mIsInPool) {
            return;
        }
        this.clear();
        Object object = mPoolLock;
        synchronized (object) {
            if (sPoolSize <= 2) {
                AccessibilityEvent accessibilityEvent;
                this.mNext = accessibilityEvent = sPool;
                sPool = this;
                this.mIsInPool = true;
                ++sPoolSize;
            }
            return;
        }
    }

    public void setAddedCount(int n) {
        this.mAddedCount = n;
    }

    public void setBeforeText(CharSequence charSequence) {
        this.mBeforeText = charSequence;
    }

    public void setChecked(boolean bl) {
        this.setBooleanProperty(1, bl);
    }

    public void setClassName(CharSequence charSequence) {
        this.mClassName = charSequence;
    }

    public void setContentDescription(CharSequence charSequence) {
        this.mContentDescription = charSequence;
    }

    public void setCurrentItemIndex(int n) {
        this.mCurrentItemIndex = n;
    }

    public void setEnabled(boolean bl) {
        this.setBooleanProperty(2, bl);
    }

    public void setEventTime(long l) {
        this.mEventTime = l;
    }

    public void setEventType(int n) {
        this.mEventType = n;
    }

    public void setFromIndex(int n) {
        this.mFromIndex = n;
    }

    public void setFullScreen(boolean bl) {
        this.setBooleanProperty(128, bl);
    }

    public void setItemCount(int n) {
        this.mItemCount = n;
    }

    public void setPackageName(CharSequence charSequence) {
        this.mPackageName = charSequence;
    }

    public void setParcelableData(Parcelable parcelable) {
        this.mParcelableData = parcelable;
    }

    public void setPassword(boolean bl) {
        this.setBooleanProperty(4, bl);
    }

    public void setRemovedCount(int n) {
        this.mRemovedCount = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = super.toString();
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        StringBuilder stringBuilder3 = new StringBuilder().append("; EventType: ");
        int n = this.mEventType;
        String string3 = stringBuilder3.append(n).toString();
        StringBuilder stringBuilder4 = stringBuilder.append(string3);
        StringBuilder stringBuilder5 = new StringBuilder().append("; EventTime: ");
        long l = this.mEventTime;
        String string4 = stringBuilder5.append(l).toString();
        StringBuilder stringBuilder6 = stringBuilder.append(string4);
        StringBuilder stringBuilder7 = new StringBuilder().append("; ClassName: ");
        CharSequence charSequence = this.mClassName;
        String string5 = stringBuilder7.append((Object)charSequence).toString();
        StringBuilder stringBuilder8 = stringBuilder.append(string5);
        StringBuilder stringBuilder9 = new StringBuilder().append("; PackageName: ");
        CharSequence charSequence2 = this.mPackageName;
        String string6 = stringBuilder9.append((Object)charSequence2).toString();
        StringBuilder stringBuilder10 = stringBuilder.append(string6);
        StringBuilder stringBuilder11 = new StringBuilder().append("; Text: ");
        List<CharSequence> list = this.mText;
        String string7 = stringBuilder11.append(list).toString();
        StringBuilder stringBuilder12 = stringBuilder.append(string7);
        StringBuilder stringBuilder13 = new StringBuilder().append("; ContentDescription: ");
        CharSequence charSequence3 = this.mContentDescription;
        String string8 = stringBuilder13.append((Object)charSequence3).toString();
        StringBuilder stringBuilder14 = stringBuilder.append(string8);
        StringBuilder stringBuilder15 = new StringBuilder().append("; ItemCount: ");
        int n2 = this.mItemCount;
        String string9 = stringBuilder15.append(n2).toString();
        StringBuilder stringBuilder16 = stringBuilder.append(string9);
        StringBuilder stringBuilder17 = new StringBuilder().append("; CurrentItemIndex: ");
        int n3 = this.mCurrentItemIndex;
        String string10 = stringBuilder17.append(n3).toString();
        StringBuilder stringBuilder18 = stringBuilder.append(string10);
        StringBuilder stringBuilder19 = new StringBuilder().append("; IsEnabled: ");
        boolean bl = this.isEnabled();
        String string11 = stringBuilder19.append(bl).toString();
        StringBuilder stringBuilder20 = stringBuilder.append(string11);
        StringBuilder stringBuilder21 = new StringBuilder().append("; IsPassword: ");
        boolean bl2 = this.isPassword();
        String string12 = stringBuilder21.append(bl2).toString();
        StringBuilder stringBuilder22 = stringBuilder.append(string12);
        StringBuilder stringBuilder23 = new StringBuilder().append("; IsChecked: ");
        boolean bl3 = this.isChecked();
        String string13 = stringBuilder23.append(bl3).toString();
        StringBuilder stringBuilder24 = stringBuilder.append(string13);
        StringBuilder stringBuilder25 = new StringBuilder().append("; IsFullScreen: ");
        boolean bl4 = this.isFullScreen();
        String string14 = stringBuilder25.append(bl4).toString();
        StringBuilder stringBuilder26 = stringBuilder.append(string14);
        StringBuilder stringBuilder27 = new StringBuilder().append("; BeforeText: ");
        CharSequence charSequence4 = this.mBeforeText;
        String string15 = stringBuilder27.append((Object)charSequence4).toString();
        StringBuilder stringBuilder28 = stringBuilder.append(string15);
        StringBuilder stringBuilder29 = new StringBuilder().append("; FromIndex: ");
        int n4 = this.mFromIndex;
        String string16 = stringBuilder29.append(n4).toString();
        StringBuilder stringBuilder30 = stringBuilder.append(string16);
        StringBuilder stringBuilder31 = new StringBuilder().append("; AddedCount: ");
        int n5 = this.mAddedCount;
        String string17 = stringBuilder31.append(n5).toString();
        StringBuilder stringBuilder32 = stringBuilder.append(string17);
        StringBuilder stringBuilder33 = new StringBuilder().append("; RemovedCount: ");
        int n6 = this.mRemovedCount;
        String string18 = stringBuilder33.append(n6).toString();
        StringBuilder stringBuilder34 = stringBuilder.append(string18);
        StringBuilder stringBuilder35 = new StringBuilder().append("; ParcelableData: ");
        Parcelable parcelable = this.mParcelableData;
        String string19 = stringBuilder35.append(parcelable).toString();
        StringBuilder stringBuilder36 = stringBuilder.append(string19);
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mEventType;
        parcel.writeInt(n2);
        int n3 = this.mBooleanProperties;
        parcel.writeInt(n3);
        int n4 = this.mCurrentItemIndex;
        parcel.writeInt(n4);
        int n5 = this.mItemCount;
        parcel.writeInt(n5);
        int n6 = this.mFromIndex;
        parcel.writeInt(n6);
        int n7 = this.mAddedCount;
        parcel.writeInt(n7);
        int n8 = this.mRemovedCount;
        parcel.writeInt(n8);
        long l = this.mEventTime;
        parcel.writeLong(l);
        TextUtils.writeToParcel(this.mClassName, parcel, 0);
        TextUtils.writeToParcel(this.mPackageName, parcel, 0);
        TextUtils.writeToParcel(this.mContentDescription, parcel, 0);
        TextUtils.writeToParcel(this.mBeforeText, parcel, 0);
        Parcelable parcelable = this.mParcelableData;
        parcel.writeParcelable(parcelable, n);
        List<CharSequence> list = this.mText;
        parcel.writeList(list);
    }
}

