/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import java.util.Collections;
import java.util.List;

public final class AccessibilityManager {
    private static final int DO_SET_ENABLED = 10;
    private static final String LOG_TAG = "AccessibilityManager";
    private static AccessibilityManager sInstance;
    static final Object sInstanceSync;
    final IAccessibilityManagerClient.Stub mClient;
    final Handler mHandler;
    boolean mIsEnabled;
    final IAccessibilityManager mService;

    static {
        sInstanceSync = new Object();
    }

    private AccessibilityManager(Context context) {
        IAccessibilityManager iAccessibilityManager;
        IAccessibilityManagerClient.Stub stub;
        this.mClient = stub = new IAccessibilityManagerClient.Stub(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void setEnabled(boolean bl) {
                Handler handler = AccessibilityManager.this.mHandler;
                int n = bl ? 1 : 0;
                handler.obtainMessage(10, n, 0).sendToTarget();
            }
        };
        Looper looper = context.getMainLooper();
        MyHandler myHandler = new MyHandler(looper);
        this.mHandler = myHandler;
        this.mService = iAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        try {
            IAccessibilityManager iAccessibilityManager2 = this.mService;
            IAccessibilityManagerClient.Stub stub2 = this.mClient;
            iAccessibilityManager2.addClient(stub2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(LOG_TAG, "AccessibilityManagerService is dead", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new AccessibilityManager(context);
            }
            return sInstance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<ServiceInfo> list = null;
        try {
            List<ServiceInfo> list2;
            list = list2 = this.mService.getAccessibilityServiceList();
        }
        catch (RemoteException remoteException) {
            int n = Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", remoteException);
            return Collections.unmodifiableList(list);
        }
        return Collections.unmodifiableList(list);
    }

    public void interrupt() {
        if (!this.mIsEnabled) {
            throw new IllegalStateException("Accessibility off. Did you forget to check that?");
        }
        try {
            this.mService.interrupt();
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", remoteException);
            return;
        }
    }

    public boolean isEnabled() {
        Handler handler = this.mHandler;
        synchronized (handler) {
            boolean bl = this.mIsEnabled;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public void sendAccessibilityEvent(AccessibilityEvent var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type: ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.w(AccessibilityManager.LOG_TAG, string2);
                    return;
                }
                case 10: 
            }
            Handler handler = AccessibilityManager.this.mHandler;
            synchronized (handler) {
                AccessibilityManager accessibilityManager = AccessibilityManager.this;
                boolean bl = message.arg1 == 1;
                accessibilityManager.mIsEnabled = bl;
                return;
            }
        }
    }
}

