/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityManagerClient;
import java.util.ArrayList;
import java.util.List;

public interface IAccessibilityManager
extends IInterface {
    public void addClient(IAccessibilityManagerClient var1) throws RemoteException;

    public List<ServiceInfo> getAccessibilityServiceList() throws RemoteException;

    public void interrupt() throws RemoteException;

    public boolean sendAccessibilityEvent(AccessibilityEvent var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccessibilityManager {
        private static final String DESCRIPTOR = "android.view.accessibility.IAccessibilityManager";
        static final int TRANSACTION_addClient = 1;
        static final int TRANSACTION_getAccessibilityServiceList = 3;
        static final int TRANSACTION_interrupt = 4;
        static final int TRANSACTION_sendAccessibilityEvent = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IAccessibilityManager asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IAccessibilityManager) {
                IAccessibilityManager iAccessibilityManager = (IAccessibilityManager)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IAccessibilityManagerClient iAccessibilityManagerClient = IAccessibilityManagerClient.Stub.asInterface(parcel.readStrongBinder());
                    this.addClient(iAccessibilityManagerClient);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    AccessibilityEvent accessibilityEvent = parcel.readInt() != 0 ? AccessibilityEvent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.sendAccessibilityEvent(accessibilityEvent);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ServiceInfo> list = this.getAccessibilityServiceList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 4: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.interrupt();
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IAccessibilityManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addClient(IAccessibilityManagerClient iAccessibilityManagerClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iAccessibilityManagerClient != null ? iAccessibilityManagerClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public List<ServiceInfo> getAccessibilityServiceList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ArrayList<ServiceInfo> arrayList;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<ServiceInfo> creator = ServiceInfo.CREATOR;
                    ArrayList<ServiceInfo> arrayList2 = arrayList = parcel2.createTypedArrayList(creator);
                    parcel2.recycle();
                    parcel.recycle();
                    return arrayList2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void interrupt() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean sendAccessibilityEvent(AccessibilityEvent accessibilityEvent) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (accessibilityEvent != null) {
                        parcel.writeInt(1);
                        accessibilityEvent.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl2 = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    bl = n != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }
        }
    }
}

