/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class AccelerateInterpolator
implements Interpolator {
    private final double mDoubleFactor;
    private final float mFactor;

    public AccelerateInterpolator() {
        this.mFactor = 1.0f;
        this.mDoubleFactor = 2.0;
    }

    public AccelerateInterpolator(float f) {
        double d;
        float f2 = this.mFactor = f;
        this.mDoubleFactor = d = (double)(2.0f * f2);
    }

    public AccelerateInterpolator(Context context, AttributeSet attributeSet) {
        double d;
        float f;
        int[] nArray = R.styleable.AccelerateInterpolator;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        float f2 = this.mFactor = (f = typedArray.getFloat(0, 1.0f));
        this.mDoubleFactor = d = (double)(2.0f * f2);
        typedArray.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float getInterpolation(float f) {
        if (this.mFactor == 1.0f) {
            return f * f;
        }
        double d = f;
        double d2 = this.mDoubleFactor;
        return (float)Math.pow(d, d2);
    }
}

