/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class AlphaAnimation
extends Animation {
    private float mFromAlpha;
    private float mToAlpha;

    public AlphaAnimation(float f, float f2) {
        this.mFromAlpha = f;
        this.mToAlpha = f2;
    }

    public AlphaAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        float f;
        float f2;
        int[] nArray = R.styleable.AlphaAnimation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mFromAlpha = f2 = typedArray.getFloat(0, 1.0f);
        this.mToAlpha = f = typedArray.getFloat(1, 1.0f);
        typedArray.recycle();
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = this.mFromAlpha;
        float f3 = (this.mToAlpha - f2) * f + f2;
        transformation.setAlpha(f3);
    }

    @Override
    public boolean willChangeBounds() {
        return false;
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return false;
    }
}

