/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;

public abstract class Animation
implements Cloneable {
    public static final int ABSOLUTE = 0;
    public static final int INFINITE = 255;
    public static final int RELATIVE_TO_PARENT = 2;
    public static final int RELATIVE_TO_SELF = 1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int START_ON_FIRST_FRAME = 255;
    public static final int ZORDER_BOTTOM = 255;
    public static final int ZORDER_NORMAL = 0;
    public static final int ZORDER_TOP = 1;
    boolean mCycleFlip = false;
    private boolean mDetachWallpaper = false;
    long mDuration;
    boolean mEnded = false;
    boolean mFillAfter = false;
    boolean mFillBefore = true;
    boolean mFillEnabled = false;
    boolean mInitialized = false;
    Interpolator mInterpolator;
    AnimationListener mListener;
    private boolean mMore = true;
    private boolean mOneMoreTime = true;
    RectF mPreviousRegion;
    Transformation mPreviousTransformation;
    RectF mRegion;
    int mRepeatCount = 0;
    int mRepeatMode = 1;
    int mRepeated = 0;
    long mStartOffset;
    long mStartTime = 65535L;
    boolean mStarted = false;
    Transformation mTransformation;
    private int mZAdjustment;

    public Animation() {
        Transformation transformation;
        Transformation transformation2;
        RectF rectF;
        RectF rectF2;
        this.mPreviousRegion = rectF2 = new RectF();
        this.mRegion = rectF = new RectF();
        this.mTransformation = transformation2 = new Transformation();
        this.mPreviousTransformation = transformation = new Transformation();
        this.ensureInterpolator();
    }

    public Animation(Context context, AttributeSet attributeSet) {
        Transformation transformation;
        Transformation transformation2;
        RectF rectF;
        RectF rectF2;
        this.mPreviousRegion = rectF2 = new RectF();
        this.mRegion = rectF = new RectF();
        this.mTransformation = transformation2 = new Transformation();
        this.mPreviousTransformation = transformation = new Transformation();
        int[] nArray = R.styleable.Animation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        long l = typedArray.getInt(1, 0);
        this.setDuration(l);
        long l2 = typedArray.getInt(4, 0);
        this.setStartOffset(l2);
        boolean bl = this.mFillEnabled;
        boolean bl2 = typedArray.getBoolean(8, bl);
        this.setFillEnabled(bl2);
        boolean bl3 = this.mFillBefore;
        boolean bl4 = typedArray.getBoolean(2, bl3);
        this.setFillBefore(bl4);
        boolean bl5 = this.mFillAfter;
        boolean bl6 = typedArray.getBoolean(3, bl5);
        this.setFillAfter(bl6);
        int n = typedArray.getResourceId(0, 0);
        if (n > 0) {
            this.setInterpolator(context, n);
        }
        int n2 = this.mRepeatCount;
        int n3 = typedArray.getInt(5, n2);
        this.setRepeatCount(n3);
        int n4 = typedArray.getInt(6, 1);
        this.setRepeatMode(n4);
        int n5 = typedArray.getInt(7, 0);
        this.setZAdjustment(n5);
        boolean bl7 = typedArray.getBoolean(9, false);
        this.setDetachWallpaper(bl7);
        this.ensureInterpolator();
        typedArray.recycle();
    }

    protected void applyTransformation(float f, Transformation transformation) {
    }

    public void cancel() {
        if (this.mStarted && !this.mEnded) {
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this);
            }
            this.mEnded = true;
        }
        this.mStartTime = Long.MIN_VALUE;
        this.mOneMoreTime = false;
        this.mMore = false;
    }

    protected Animation clone() throws CloneNotSupportedException {
        Transformation transformation;
        Transformation transformation2;
        RectF rectF;
        RectF rectF2;
        Animation animation = (Animation)super.clone();
        animation.mPreviousRegion = rectF2 = new RectF();
        animation.mRegion = rectF = new RectF();
        animation.mTransformation = transformation2 = new Transformation();
        animation.mPreviousTransformation = transformation = new Transformation();
        return animation;
    }

    public long computeDurationHint() {
        long l = this.getStartOffset();
        long l2 = this.getDuration();
        long l3 = l + l2;
        long l4 = this.getRepeatCount() + 1;
        return l3 * l4;
    }

    public void detach() {
        if (!this.mStarted) {
            return;
        }
        if (this.mEnded) {
            return;
        }
        this.mEnded = true;
        if (this.mListener == null) {
            return;
        }
        this.mListener.onAnimationEnd(this);
    }

    protected void ensureInterpolator() {
        if (this.mInterpolator != null) {
            return;
        }
        AccelerateDecelerateInterpolator accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
        this.mInterpolator = accelerateDecelerateInterpolator;
    }

    public boolean getDetachWallpaper() {
        return this.mDetachWallpaper;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public boolean getFillAfter() {
        return this.mFillAfter;
    }

    public boolean getFillBefore() {
        return this.mFillBefore;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void getInvalidateRegion(int n, int n2, int n3, int n4, RectF rectF, Transformation transformation) {
        RectF rectF2 = this.mRegion;
        RectF rectF3 = this.mPreviousRegion;
        float f = n;
        float f2 = n2;
        float f3 = n3;
        float f4 = n4;
        rectF.set(f, f2, f3, f4);
        boolean bl = transformation.getMatrix().mapRect(rectF);
        rectF.inset(-1.0f, -1.0f);
        rectF2.set(rectF);
        rectF.union(rectF3);
        rectF3.set(rectF2);
        Transformation transformation2 = this.mTransformation;
        Transformation transformation3 = this.mPreviousTransformation;
        transformation2.set(transformation);
        transformation.set(transformation3);
        transformation3.set(transformation2);
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getTransformation(long l, Transformation transformation) {
        block14: {
            block15: {
                float f;
                if (this.mStartTime == 65535L) {
                    this.mStartTime = l;
                }
                long l2 = this.getStartOffset();
                long l3 = this.mDuration;
                if (l3 != 0L) {
                    long l4 = this.mStartTime + l2;
                    float f2 = l - l4;
                    float f3 = l3;
                    f = f2 / f3;
                } else {
                    long l5 = this.mStartTime;
                    f = l < l5 ? 0.0f : 1.0f;
                }
                boolean bl = f >= 1.0f;
                boolean bl2 = !bl;
                this.mMore = bl2;
                if (!this.mFillEnabled) {
                    f = Math.max(Math.min(f, 1.0f), 0.0f);
                }
                if ((f >= 0.0f || this.mFillBefore) && (f <= 1.0f || this.mFillAfter)) {
                    if (!this.mStarted) {
                        if (this.mListener != null) {
                            this.mListener.onAnimationStart(this);
                        }
                        this.mStarted = true;
                    }
                    if (this.mFillEnabled) {
                        f = Math.max(Math.min(f, 1.0f), 0.0f);
                    }
                    if (this.mCycleFlip) {
                        f = 1.0f - f;
                    }
                    float f4 = this.mInterpolator.getInterpolation(f);
                    this.applyTransformation(f4, transformation);
                }
                if (!bl) break block14;
                int n = this.mRepeatCount;
                int n2 = this.mRepeated;
                if (n == n2) break block15;
                if (!this.mEnded) {
                    this.mEnded = true;
                    if (this.mListener != null) {
                        this.mListener.onAnimationEnd(this);
                    }
                }
                break block14;
            }
            if (this.mRepeatCount > 0) {
                int n;
                this.mRepeated = n = this.mRepeated + 1;
            }
            if (this.mRepeatMode == 2) {
                boolean bl = !this.mCycleFlip;
                this.mCycleFlip = bl;
            }
            this.mStartTime = 65535L;
            this.mMore = true;
            if (this.mListener != null) {
                this.mListener.onAnimationRepeat(this);
            }
        }
        if (this.mMore) return this.mMore;
        if (!this.mOneMoreTime) return this.mMore;
        this.mOneMoreTime = false;
        return true;
    }

    public int getZAdjustment() {
        return this.mZAdjustment;
    }

    public boolean hasEnded() {
        return this.mEnded;
    }

    public boolean hasStarted() {
        return this.mStarted;
    }

    public void initialize(int n, int n2, int n3, int n4) {
        this.reset();
        this.mInitialized = true;
    }

    public void initializeInvalidateRegion(int n, int n2, int n3, int n4) {
        RectF rectF = this.mPreviousRegion;
        float f = n;
        float f2 = n2;
        float f3 = n3;
        float f4 = n4;
        rectF.set(f, f2, f3, f4);
        rectF.inset(-1.0f, -1.0f);
        if (!this.mFillBefore) {
            return;
        }
        Transformation transformation = this.mPreviousTransformation;
        float f5 = this.mInterpolator.getInterpolation(0.0f);
        this.applyTransformation(f5, transformation);
    }

    public boolean isFillEnabled() {
        return this.mFillEnabled;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void reset() {
        this.mPreviousRegion.setEmpty();
        this.mPreviousTransformation.clear();
        this.mInitialized = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
        this.mOneMoreTime = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected float resolveSize(int n, float f, int n2, int n3) {
        switch (n) {
            default: {
                return f;
            }
            case 0: {
                return f;
            }
            case 1: {
                return (float)n2 * f;
            }
            case 2: 
        }
        return (float)n3 * f;
    }

    public void restrictDuration(long l) {
        int n;
        if (this.mStartOffset > l) {
            this.mStartOffset = l;
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        long l2 = this.mDuration;
        long l3 = this.mStartOffset;
        long l4 = l2 + l3;
        if (l4 > l) {
            long l5;
            long l6 = this.mStartOffset;
            this.mDuration = l5 = l - l6;
            l4 = l;
        }
        if (this.mDuration <= 0L) {
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        if (this.mRepeatCount >= 0 && (long)this.mRepeatCount <= l && (long)this.mRepeatCount * l4 <= l) {
            return;
        }
        this.mRepeatCount = n = (int)(l / l4) - 1;
        if (this.mRepeatCount >= 0) {
            return;
        }
        this.mRepeatCount = 0;
    }

    public void scaleCurrentDuration(float f) {
        long l;
        this.mDuration = l = (long)((float)this.mDuration * f);
    }

    public void setAnimationListener(AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    public void setDetachWallpaper(boolean bl) {
        this.mDetachWallpaper = bl;
    }

    public void setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative");
        }
        this.mDuration = l;
    }

    public void setFillAfter(boolean bl) {
        this.mFillAfter = bl;
    }

    public void setFillBefore(boolean bl) {
        this.mFillBefore = bl;
    }

    public void setFillEnabled(boolean bl) {
        this.mFillEnabled = bl;
    }

    public void setInterpolator(Context context, int n) {
        Interpolator interpolator = AnimationUtils.loadInterpolator(context, n);
        this.setInterpolator(interpolator);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setRepeatCount(int n) {
        if (n < 0) {
            n = -1;
        }
        this.mRepeatCount = n;
    }

    public void setRepeatMode(int n) {
        this.mRepeatMode = n;
    }

    public void setStartOffset(long l) {
        this.mStartOffset = l;
    }

    public void setStartTime(long l) {
        this.mStartTime = l;
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
    }

    public void setZAdjustment(int n) {
        this.mZAdjustment = n;
    }

    public void start() {
        this.setStartTime(65535L);
    }

    public void startNow() {
        long l = AnimationUtils.currentAnimationTimeMillis();
        this.setStartTime(l);
    }

    public boolean willChangeBounds() {
        return true;
    }

    public boolean willChangeTransformationMatrix() {
        return true;
    }

    public static interface AnimationListener {
        public void onAnimationEnd(Animation var1);

        public void onAnimationRepeat(Animation var1);

        public void onAnimationStart(Animation var1);
    }

    protected static class Description {
        public int type;
        public float value;

        protected Description() {
        }

        /*
         * Enabled aggressive block sorting
         */
        static Description parseValue(TypedValue typedValue) {
            Description description = new Description();
            if (typedValue == null) {
                description.type = 0;
                description.value = 0.0f;
            } else {
                if (typedValue.type == 6) {
                    float f;
                    int n = (typedValue.data & 0xF) == 1 ? 2 : 1;
                    description.type = n;
                    description.value = f = TypedValue.complexToFloat(typedValue.data);
                    return description;
                }
                if (typedValue.type == 4) {
                    float f;
                    description.type = 0;
                    description.value = f = typedValue.getFloat();
                    return description;
                }
                if (typedValue.type >= 16 && typedValue.type <= 31) {
                    float f;
                    description.type = 0;
                    description.value = f = (float)typedValue.data;
                    return description;
                }
            }
            description.type = 0;
            description.value = 0.0f;
            return description;
        }
    }
}

