/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public class AnimationSet
extends Animation {
    private static final int PROPERTY_CHANGE_BOUNDS_MASK = 128;
    private static final int PROPERTY_DURATION_MASK = 32;
    private static final int PROPERTY_FILL_AFTER_MASK = 1;
    private static final int PROPERTY_FILL_BEFORE_MASK = 2;
    private static final int PROPERTY_MORPH_MATRIX_MASK = 64;
    private static final int PROPERTY_REPEAT_MODE_MASK = 4;
    private static final int PROPERTY_SHARE_INTERPOLATOR_MASK = 16;
    private static final int PROPERTY_START_OFFSET_MASK = 8;
    private ArrayList<Animation> mAnimations;
    private int mFlags = 0;
    private long mLastEnd;
    private long[] mStoredOffsets;
    private Transformation mTempTransformation;

    public AnimationSet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Transformation transformation;
        ArrayList arrayList = new ArrayList();
        this.mAnimations = arrayList;
        this.mTempTransformation = transformation = new Transformation();
        int[] nArray = R.styleable.AnimationSet;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        boolean bl = typedArray.getBoolean(0, true);
        this.setFlag(16, bl);
        this.init();
        typedArray.recycle();
    }

    public AnimationSet(boolean bl) {
        Transformation transformation;
        ArrayList arrayList = new ArrayList();
        this.mAnimations = arrayList;
        this.mTempTransformation = transformation = new Transformation();
        this.setFlag(16, bl);
        this.init();
    }

    private void init() {
        this.mStartTime = 0L;
        this.mDuration = 0L;
    }

    private void setFlag(int n, boolean bl) {
        int n2;
        if (bl) {
            int n3;
            this.mFlags = n3 = this.mFlags | n;
            return;
        }
        int n4 = this.mFlags;
        int n5 = ~n;
        this.mFlags = n2 = n4 & n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addAnimation(Animation animation) {
        long l;
        long l2;
        boolean bl;
        boolean bl2 = this.mAnimations.add(animation);
        boolean bl3 = (this.mFlags & 0x40) == 0;
        if (bl3 && animation.willChangeTransformationMatrix()) {
            int n;
            this.mFlags = n = this.mFlags | 0x40;
        }
        if ((bl = (this.mFlags & 0x80) == 0) && animation.willChangeTransformationMatrix()) {
            int n;
            this.mFlags = n = this.mFlags | 0x80;
        }
        if (this.mAnimations.size() == 1) {
            long l3;
            long l4;
            long l5 = animation.getStartOffset();
            long l6 = animation.getDuration();
            this.mDuration = l4 = l5 + l6;
            long l7 = this.mStartOffset;
            long l8 = this.mDuration;
            this.mLastEnd = l3 = l7 + l8;
            return;
        }
        long l9 = this.mLastEnd;
        long l10 = animation.getStartOffset();
        long l11 = animation.getDuration();
        long l12 = l10 + l11;
        long l13 = this.mLastEnd = (l2 = Math.max(l9, l12));
        long l14 = this.mStartOffset;
        this.mDuration = l = l13 - l14;
    }

    @Override
    protected AnimationSet clone() throws CloneNotSupportedException {
        Transformation transformation;
        AnimationSet animationSet = (AnimationSet)super.clone();
        animationSet.mTempTransformation = transformation = new Transformation();
        ArrayList arrayList = new ArrayList();
        animationSet.mAnimations = arrayList;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList2 = this.mAnimations;
        for (int i = 0; i < n; ++i) {
            ArrayList<Animation> arrayList3 = animationSet.mAnimations;
            Animation animation = arrayList2.get(i).clone();
            boolean bl = arrayList3.add(animation);
        }
        return animationSet;
    }

    @Override
    public long computeDurationHint() {
        long l = 0L;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        for (int i = n - 1; i >= 0; i += -1) {
            long l2 = arrayList.get(i).computeDurationHint();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public List<Animation> getAnimations() {
        return this.mAnimations;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getDuration() {
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        long l = 0L;
        boolean bl = (this.mFlags & 0x20) == 32;
        if (bl) {
            return this.mDuration;
        }
        int n2 = 0;
        while (n2 < n) {
            long l2 = arrayList.get(n2).getDuration();
            l = Math.max(l, l2);
            ++n2;
        }
        return l;
    }

    @Override
    public long getStartTime() {
        long l = Long.MAX_VALUE;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        for (int i = 0; i < n; ++i) {
            long l2 = arrayList.get(i).getStartTime();
            l = Math.min(l, l2);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getTransformation(long l, Transformation transformation) {
        boolean bl;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        Transformation transformation2 = this.mTempTransformation;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = true;
        transformation.clear();
        for (int i = n - 1; i >= 0; i += -1) {
            Animation animation = arrayList.get(i);
            transformation2.clear();
            bl2 = animation.getTransformation(l, transformation2) || bl2;
            transformation.compose(transformation2);
            bl2 = bl2 || animation.hasStarted();
            bl3 = animation.hasEnded() && bl3;
        }
        if (bl2 && !this.mStarted) {
            if (this.mListener != null) {
                this.mListener.onAnimationStart(this);
            }
            this.mStarted = true;
        }
        if (bl3 != (bl = this.mEnded)) {
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this);
            }
            this.mEnded = bl3;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        super.initialize(n, n2, n3, n4);
        int n5 = this.mFlags & 0x20;
        int n6 = 32;
        boolean bl = n5 == n6;
        int n7 = this.mFlags & 1;
        int n8 = 1;
        boolean bl2 = n7 == n8;
        int n9 = this.mFlags & 2;
        int n10 = 2;
        boolean bl3 = n9 == n10;
        int n11 = this.mFlags & 4;
        int n12 = 4;
        boolean bl4 = n11 == n12;
        int n13 = this.mFlags & 0x10;
        int n14 = 16;
        boolean bl5 = n13 == n14;
        int n15 = this.mFlags & 8;
        int n16 = 8;
        boolean bl6 = n15 == n16;
        if (bl5) {
            this.ensureInterpolator();
        }
        ArrayList<Animation> arrayList = this.mAnimations;
        int n17 = arrayList.size();
        long l = this.mDuration;
        boolean bl7 = this.mFillAfter;
        boolean bl8 = this.mFillBefore;
        int n18 = this.mRepeatMode;
        Interpolator interpolator = this.mInterpolator;
        long l2 = this.mStartOffset;
        long[] lArray = this.mStoredOffsets;
        if (bl6) {
            int n19;
            int n20;
            if (lArray == false || (n20 = lArray.length) != (n19 = n17)) {
                int n21;
                int n22 = n21 = n17;
                this.mStoredOffsets = (long[])n22;
            }
        } else if (lArray != false) {
            boolean bl9;
            boolean bl10 = bl9 = false;
            this.mStoredOffsets = (long[])bl10;
        }
        int n23 = 0;
        while (n23 < n17) {
            Animation animation = arrayList.get(n23);
            if (bl) {
                animation.setDuration(l);
            }
            if (bl2) {
                animation.setFillAfter(bl7);
            }
            if (bl3) {
                animation.setFillBefore(bl8);
            }
            if (bl4) {
                Animation animation2 = animation;
                int n24 = n18;
                animation2.setRepeatMode(n24);
            }
            if (bl5) {
                Animation animation3 = animation;
                Interpolator interpolator2 = interpolator;
                animation3.setInterpolator(interpolator2);
            }
            if (bl6) {
                long l3 = animation.getStartOffset();
                long l4 = l3 + l2;
                Animation animation4 = animation;
                long l5 = l4;
                animation4.setStartOffset(l5);
                var33_33[n23] = l3;
            }
            Animation animation5 = animation;
            int n25 = n;
            int n26 = n2;
            int n27 = n3;
            int n28 = n4;
            animation5.initialize(n25, n26, n27, n28);
            ++n23;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initializeInvalidateRegion(int n, int n2, int n3, int n4) {
        RectF rectF = this.mPreviousRegion;
        float f = n;
        float f2 = n2;
        float f3 = n3;
        float f4 = n4;
        rectF.set(f, f2, f3, f4);
        rectF.inset(-1.0f, -1.0f);
        if (!this.mFillBefore) {
            return;
        }
        int n5 = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        Transformation transformation = this.mTempTransformation;
        Transformation transformation2 = this.mPreviousTransformation;
        int n6 = n5 - 1;
        while (n6 >= 0) {
            Animation animation = arrayList.get(n6);
            transformation.clear();
            Interpolator interpolator = animation.mInterpolator;
            float f5 = interpolator != null ? interpolator.getInterpolation(0.0f) : 0.0f;
            animation.applyTransformation(f5, transformation);
            transformation2.compose(transformation);
            n6 += -1;
        }
        return;
    }

    @Override
    public void reset() {
        super.reset();
        this.restoreChildrenStartOffset();
    }

    void restoreChildrenStartOffset() {
        long[] lArray = this.mStoredOffsets;
        if (lArray == null) {
            return;
        }
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Animation animation = arrayList.get(n2);
            long l = lArray[n2];
            animation.setStartOffset(l);
            ++n2;
        }
        return;
    }

    @Override
    public void restrictDuration(long l) {
        super.restrictDuration(l);
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).restrictDuration(l);
            ++n2;
        }
        return;
    }

    @Override
    public void scaleCurrentDuration(float f) {
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).scaleCurrentDuration(f);
            ++n2;
        }
        return;
    }

    @Override
    public void setDuration(long l) {
        int n;
        this.mFlags = n = this.mFlags | 0x20;
        super.setDuration(l);
    }

    @Override
    public void setFillAfter(boolean bl) {
        int n;
        this.mFlags = n = this.mFlags | 1;
        super.setFillAfter(bl);
    }

    @Override
    public void setFillBefore(boolean bl) {
        int n;
        this.mFlags = n = this.mFlags | 2;
        super.setFillBefore(bl);
    }

    @Override
    public void setRepeatMode(int n) {
        int n2;
        this.mFlags = n2 = this.mFlags | 4;
        super.setRepeatMode(n);
    }

    @Override
    public void setStartOffset(long l) {
        int n;
        this.mFlags = n = this.mFlags | 8;
        super.setStartOffset(l);
    }

    @Override
    public void setStartTime(long l) {
        super.setStartTime(l);
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).setStartTime(l);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean willChangeBounds() {
        if ((this.mFlags & 0x80) != 128) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean willChangeTransformationMatrix() {
        if ((this.mFlags & 0x40) != 64) return false;
        return true;
    }
}

