/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.GridLayoutAnimationController;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtils {
    private static Animation createAnimationFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
        return AnimationUtils.createAnimationFromXml(context, xmlPullParser, null, attributeSet);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Animation createAnimationFromXml(Context context, XmlPullParser xmlPullParser, AnimationSet animationSet, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        void var4_5;
        int n;
        Object var4_4 = null;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            void var4_7;
            if (n != 2) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("set")) {
                AnimationSet animationSet2;
                AnimationSet animationSet3 = animationSet2 = new AnimationSet(context, attributeSet);
                Animation animation = AnimationUtils.createAnimationFromXml(context, xmlPullParser, animationSet3, attributeSet);
            } else if (string2.equals("alpha")) {
                AlphaAnimation alphaAnimation = new AlphaAnimation(context, attributeSet);
            } else if (string2.equals("scale")) {
                ScaleAnimation scaleAnimation = new ScaleAnimation(context, attributeSet);
            } else if (string2.equals("rotate")) {
                RotateAnimation rotateAnimation = new RotateAnimation(context, attributeSet);
            } else {
                if (!string2.equals("translate")) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown animation name: ");
                    String string3 = xmlPullParser.getName();
                    String string4 = stringBuilder.append(string3).toString();
                    throw new RuntimeException(string4);
                }
                TranslateAnimation translateAnimation = new TranslateAnimation(context, attributeSet);
            }
            if (animationSet == null) continue;
            animationSet.addAnimation((Animation)var4_7);
        }
        return var4_5;
    }

    private static Interpolator createInterpolatorFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        Interpolator interpolator = null;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
            String string2 = xmlPullParser.getName();
            if (string2.equals("linearInterpolator")) {
                interpolator = new LinearInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("accelerateInterpolator")) {
                interpolator = new AccelerateInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("decelerateInterpolator")) {
                interpolator = new DecelerateInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("accelerateDecelerateInterpolator")) {
                interpolator = new AccelerateDecelerateInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("cycleInterpolator")) {
                interpolator = new CycleInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("anticipateInterpolator")) {
                interpolator = new AnticipateInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("overshootInterpolator")) {
                interpolator = new OvershootInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("anticipateOvershootInterpolator")) {
                interpolator = new AnticipateOvershootInterpolator(context, attributeSet);
                continue;
            }
            if (string2.equals("bounceInterpolator")) {
                interpolator = new BounceInterpolator(context, attributeSet);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown interpolator name: ");
            String string3 = xmlPullParser.getName();
            String string4 = stringBuilder.append(string3).toString();
            throw new RuntimeException(string4);
        }
        return interpolator;
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
        return AnimationUtils.createLayoutAnimationFromXml(context, xmlPullParser, attributeSet);
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n;
        LayoutAnimationController layoutAnimationController = null;
        int n2 = xmlPullParser.getDepth();
        while (((n = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            String string2 = xmlPullParser.getName();
            if ("layoutAnimation".equals(string2)) {
                layoutAnimationController = new LayoutAnimationController(context, attributeSet);
                continue;
            }
            if ("gridLayoutAnimation".equals(string2)) {
                layoutAnimationController = new GridLayoutAnimationController(context, attributeSet);
                continue;
            }
            String string3 = "Unknown layout animation name: " + string2;
            throw new RuntimeException(string3);
        }
        return layoutAnimationController;
    }

    public static long currentAnimationTimeMillis() {
        return SystemClock.uptimeMillis();
    }

    /*
     * Exception decompiling
     */
    public static Animation loadAnimation(Context var0, int var1) throws Resources.NotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 105->160)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Interpolator loadInterpolator(Context var0, int var1) throws Resources.NotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 105->160)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static LayoutAnimationController loadLayoutAnimation(Context var0, int var1) throws Resources.NotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 105->160)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Animation makeInAnimation(Context context, boolean bl) {
        Animation animation = bl ? AnimationUtils.loadAnimation(context, 17432578) : AnimationUtils.loadAnimation(context, 17432624);
        DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
        animation.setInterpolator(decelerateInterpolator);
        long l = AnimationUtils.currentAnimationTimeMillis();
        animation.setStartTime(l);
        return animation;
    }

    public static Animation makeInChildBottomAnimation(Context context) {
        Animation animation = AnimationUtils.loadAnimation(context, 17432623);
        AccelerateInterpolator accelerateInterpolator = new AccelerateInterpolator();
        animation.setInterpolator(accelerateInterpolator);
        long l = AnimationUtils.currentAnimationTimeMillis();
        animation.setStartTime(l);
        return animation;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Animation makeOutAnimation(Context context, boolean bl) {
        Animation animation = bl ? AnimationUtils.loadAnimation(context, 17432579) : AnimationUtils.loadAnimation(context, 17432627);
        AccelerateInterpolator accelerateInterpolator = new AccelerateInterpolator();
        animation.setInterpolator(accelerateInterpolator);
        long l = AnimationUtils.currentAnimationTimeMillis();
        animation.setStartTime(l);
        return animation;
    }
}

