/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class AnticipateInterpolator
implements Interpolator {
    private final float mTension;

    public AnticipateInterpolator() {
        this.mTension = 2.0f;
    }

    public AnticipateInterpolator(float f) {
        this.mTension = f;
    }

    public AnticipateInterpolator(Context context, AttributeSet attributeSet) {
        float f;
        int[] nArray = R.styleable.AnticipateInterpolator;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mTension = f = typedArray.getFloat(0, 2.0f);
        typedArray.recycle();
    }

    @Override
    public float getInterpolation(float f) {
        float f2 = f * f;
        float f3 = (this.mTension + 1.0f) * f;
        float f4 = this.mTension;
        float f5 = f3 - f4;
        return f2 * f5;
    }
}

