/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class CycleInterpolator
implements Interpolator {
    private float mCycles;

    public CycleInterpolator(float f) {
        this.mCycles = f;
    }

    public CycleInterpolator(Context context, AttributeSet attributeSet) {
        float f;
        int[] nArray = R.styleable.CycleInterpolator;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mCycles = f = typedArray.getFloat(0, 1.0f);
        typedArray.recycle();
    }

    @Override
    public float getInterpolation(float f) {
        float f2 = this.mCycles;
        double d = (double)(2.0f * f2) * Math.PI;
        double d2 = f;
        return (float)Math.sin(d * d2);
    }
}

