/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class DecelerateInterpolator
implements Interpolator {
    private float mFactor = 1.0f;

    public DecelerateInterpolator() {
    }

    public DecelerateInterpolator(float f) {
        this.mFactor = f;
    }

    public DecelerateInterpolator(Context context, AttributeSet attributeSet) {
        float f;
        int[] nArray = R.styleable.DecelerateInterpolator;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mFactor = f = typedArray.getFloat(0, 1.0f);
        typedArray.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float getInterpolation(float f) {
        if (this.mFactor == 1.0f) {
            float f2 = 1.0f - f;
            float f3 = 1.0f - f;
            float f4 = f2 * f3;
            return 1.0f - f4;
        }
        double d = 1.0f - f;
        float f5 = this.mFactor;
        double d2 = 2.0f * f5;
        double d3 = Math.pow(d, d2);
        return (float)(1.0 - d3);
    }
}

