/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;

public class GridLayoutAnimationController
extends LayoutAnimationController {
    public static final int DIRECTION_BOTTOM_TO_TOP = 2;
    public static final int DIRECTION_HORIZONTAL_MASK = 1;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_TOP_TO_BOTTOM = 0;
    public static final int DIRECTION_VERTICAL_MASK = 2;
    public static final int PRIORITY_COLUMN = 1;
    public static final int PRIORITY_NONE = 0;
    public static final int PRIORITY_ROW = 2;
    private float mColumnDelay;
    private int mDirection;
    private int mDirectionPriority;
    private float mRowDelay;

    public GridLayoutAnimationController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        int n2;
        float f;
        float f2;
        int[] nArray = R.styleable.GridLayoutAnimation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mColumnDelay = f2 = Animation.Description.parseValue((TypedValue)typedArray.peekValue((int)0)).value;
        this.mRowDelay = f = Animation.Description.parseValue((TypedValue)typedArray.peekValue((int)1)).value;
        this.mDirection = n2 = typedArray.getInt(2, 0);
        this.mDirectionPriority = n = typedArray.getInt(3, 0);
        typedArray.recycle();
    }

    public GridLayoutAnimationController(Animation animation) {
        this(animation, 0.5f, 0.5f);
    }

    public GridLayoutAnimationController(Animation animation, float f, float f2) {
        super(animation);
        this.mColumnDelay = f;
        this.mRowDelay = f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getTransformedColumnIndex(AnimationParameters animationParameters) {
        int n;
        switch (this.getOrder()) {
            default: {
                n = animationParameters.column;
                break;
            }
            case 1: {
                int n2 = animationParameters.columnsCount - 1;
                int n3 = animationParameters.column;
                n = n2 - n3;
                break;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    Random random;
                    this.mRandomizer = random = new Random();
                }
                float f = animationParameters.columnsCount;
                float f2 = this.mRandomizer.nextFloat();
                n = (int)(f * f2);
            }
        }
        if ((this.mDirection & 1) != 1) return n;
        return animationParameters.columnsCount - 1 - n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getTransformedRowIndex(AnimationParameters animationParameters) {
        int n;
        switch (this.getOrder()) {
            default: {
                n = animationParameters.row;
                break;
            }
            case 1: {
                int n2 = animationParameters.rowsCount - 1;
                int n3 = animationParameters.row;
                n = n2 - n3;
                break;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    Random random;
                    this.mRandomizer = random = new Random();
                }
                float f = animationParameters.rowsCount;
                float f2 = this.mRandomizer.nextFloat();
                n = (int)(f * f2);
            }
        }
        if ((this.mDirection & 2) != 2) return n;
        return animationParameters.rowsCount - 1 - n;
    }

    public float getColumnDelay() {
        return this.mColumnDelay;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected long getDelayForView(View view) {
        float f;
        long l;
        AnimationParameters animationParameters = (AnimationParameters)view.getLayoutParams().layoutAnimationParameters;
        if (animationParameters == null) {
            return 0L;
        }
        GridLayoutAnimationController gridLayoutAnimationController = this;
        AnimationParameters animationParameters2 = animationParameters;
        int n = gridLayoutAnimationController.getTransformedColumnIndex(animationParameters2);
        GridLayoutAnimationController gridLayoutAnimationController2 = this;
        AnimationParameters animationParameters3 = animationParameters;
        int n2 = gridLayoutAnimationController2.getTransformedRowIndex(animationParameters3);
        int n3 = animationParameters.rowsCount;
        int n4 = animationParameters.columnsCount;
        long l2 = this.mAnimation.getDuration();
        float f2 = this.mColumnDelay;
        float f3 = l2;
        float f4 = f2 * f3;
        float f5 = this.mRowDelay;
        float f6 = l2;
        float f7 = f5 * f6;
        if (this.mInterpolator == null) {
            LinearInterpolator linearInterpolator = new LinearInterpolator();
            this.mInterpolator = linearInterpolator;
        }
        switch (this.mDirectionPriority) {
            default: {
                float f8 = (float)n * f4;
                float f9 = (float)n2 * f7;
                l = (long)(f8 + f9);
                float f10 = (float)n4 * f4;
                float f11 = (float)n3 * f7;
                f = f10 + f11;
                break;
            }
            case 1: {
                float f12 = (float)n2 * f7;
                float f13 = (float)(n * n3) * f7;
                l = (long)(f12 + f13);
                float f14 = (float)n3 * f7;
                float f15 = (float)(n4 * n3) * f7;
                f = f14 + f15;
                break;
            }
            case 2: {
                float f16 = (float)n * f4;
                float f17 = (float)(n2 * n4) * f4;
                l = (long)(f16 + f17);
                float f18 = (float)n4 * f4;
                float f19 = (float)(n3 * n4) * f4;
                f = f18 + f19;
            }
        }
        float f20 = (float)l / f;
        Interpolator interpolator = this.mInterpolator;
        float f21 = f20;
        return (long)(interpolator.getInterpolation(f21) * f);
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getDirectionPriority() {
        return this.mDirectionPriority;
    }

    public float getRowDelay() {
        return this.mRowDelay;
    }

    public void setColumnDelay(float f) {
        this.mColumnDelay = f;
    }

    public void setDirection(int n) {
        this.mDirection = n;
    }

    public void setDirectionPriority(int n) {
        this.mDirectionPriority = n;
    }

    public void setRowDelay(float f) {
        this.mRowDelay = f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean willOverlap() {
        if (this.mColumnDelay < 1.0f) return true;
        if (!(this.mRowDelay < 1.0f)) return false;
        return true;
    }

    public static class AnimationParameters
    extends LayoutAnimationController.AnimationParameters {
        public int column;
        public int columnsCount;
        public int row;
        public int rowsCount;
    }
}

