/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;

public class LayoutAnimationController {
    public static final int ORDER_NORMAL = 0;
    public static final int ORDER_RANDOM = 2;
    public static final int ORDER_REVERSE = 1;
    protected Animation mAnimation;
    private float mDelay;
    private long mDuration;
    protected Interpolator mInterpolator;
    private long mMaxDelay;
    private int mOrder;
    protected Random mRandomizer;

    public LayoutAnimationController(Context context, AttributeSet attributeSet) {
        int n;
        int n2;
        float f;
        int[] nArray = R.styleable.LayoutAnimation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mDelay = f = Animation.Description.parseValue((TypedValue)typedArray.peekValue((int)1)).value;
        this.mOrder = n2 = typedArray.getInt(3, 0);
        int n3 = typedArray.getResourceId(2, 0);
        if (n3 > 0) {
            this.setAnimation(context, n3);
        }
        if ((n = typedArray.getResourceId(0, 0)) > 0) {
            this.setInterpolator(context, n);
        }
        typedArray.recycle();
    }

    public LayoutAnimationController(Animation animation) {
        this(animation, 0.5f);
    }

    public LayoutAnimationController(Animation animation, float f) {
        this.mDelay = f;
        this.setAnimation(animation);
    }

    public Animation getAnimation() {
        return this.mAnimation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Animation getAnimationForView(View view) {
        long l;
        long l2 = this.getDelayForView(view);
        long l3 = this.mAnimation.getStartOffset();
        long l4 = l2 + l3;
        this.mMaxDelay = l = Math.max(this.mMaxDelay, l4);
        try {
            Animation animation = this.mAnimation.clone();
            animation.setStartOffset(l4);
            return animation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public float getDelay() {
        return this.mDelay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getDelayForView(View view) {
        AnimationParameters animationParameters = view.getLayoutParams().layoutAnimationParameters;
        if (animationParameters == null) {
            return 0L;
        }
        float f = this.mDelay;
        float f2 = this.mAnimation.getDuration();
        float f3 = f * f2;
        long l = (long)((float)this.getTransformedIndex(animationParameters) * f3);
        float f4 = animationParameters.count;
        float f5 = f3 * f4;
        if (this.mInterpolator == null) {
            LinearInterpolator linearInterpolator = new LinearInterpolator();
            this.mInterpolator = linearInterpolator;
        }
        float f6 = (float)l / f5;
        return (long)(this.mInterpolator.getInterpolation(f6) * f5);
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public int getOrder() {
        return this.mOrder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getTransformedIndex(AnimationParameters animationParameters) {
        switch (this.getOrder()) {
            default: {
                return animationParameters.index;
            }
            case 1: {
                int n = animationParameters.count - 1;
                int n2 = animationParameters.index;
                return n - n2;
            }
            case 2: 
        }
        if (this.mRandomizer == null) {
            Random random;
            this.mRandomizer = random = new Random();
        }
        float f = animationParameters.count;
        float f2 = this.mRandomizer.nextFloat();
        return (int)(f * f2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDone() {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6 = AnimationUtils.currentAnimationTimeMillis();
        if (l6 <= (l5 = (l4 = (l3 = this.mAnimation.getStartTime()) + (l2 = this.mMaxDelay)) + (l = this.mDuration))) return false;
        return true;
    }

    public void setAnimation(Context context, int n) {
        Animation animation = AnimationUtils.loadAnimation(context, n);
        this.setAnimation(animation);
    }

    public void setAnimation(Animation animation) {
        this.mAnimation = animation;
        this.mAnimation.setFillBefore(true);
    }

    public void setDelay(float f) {
        this.mDelay = f;
    }

    public void setInterpolator(Context context, int n) {
        Interpolator interpolator = AnimationUtils.loadInterpolator(context, n);
        this.setInterpolator(interpolator);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setOrder(int n) {
        this.mOrder = n;
    }

    public void start() {
        long l;
        this.mDuration = l = this.mAnimation.getDuration();
        this.mMaxDelay = Long.MIN_VALUE;
        this.mAnimation.setStartTime(65535L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean willOverlap() {
        if (!(this.mDelay < 1.0f)) return false;
        return true;
    }

    public static class AnimationParameters {
        public int count;
        public int index;
    }
}

