/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class OvershootInterpolator
implements Interpolator {
    private final float mTension;

    public OvershootInterpolator() {
        this.mTension = 2.0f;
    }

    public OvershootInterpolator(float f) {
        this.mTension = f;
    }

    public OvershootInterpolator(Context context, AttributeSet attributeSet) {
        float f;
        int[] nArray = R.styleable.OvershootInterpolator;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mTension = f = typedArray.getFloat(0, 2.0f);
        typedArray.recycle();
    }

    @Override
    public float getInterpolation(float f) {
        float f2 = f - 1.0f;
        float f3 = f2 * f2;
        float f4 = (this.mTension + 1.0f) * f2;
        float f5 = this.mTension;
        float f6 = f4 + f5;
        return f3 * f6 + 1.0f;
    }
}

