/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class RotateAnimation
extends Animation {
    private float mFromDegrees;
    private float mPivotX;
    private int mPivotXType = 0;
    private float mPivotXValue = 0.0f;
    private float mPivotY;
    private int mPivotYType = 0;
    private float mPivotYValue = 0.0f;
    private float mToDegrees;

    public RotateAnimation(float f, float f2) {
        this.mFromDegrees = f;
        this.mToDegrees = f2;
        this.mPivotX = 0.0f;
        this.mPivotY = 0.0f;
    }

    public RotateAnimation(float f, float f2, float f3, float f4) {
        this.mFromDegrees = f;
        this.mToDegrees = f2;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = f3;
        this.mPivotYValue = f4;
    }

    public RotateAnimation(float f, float f2, int n, float f3, int n2, float f4) {
        this.mFromDegrees = f;
        this.mToDegrees = f2;
        this.mPivotXValue = f3;
        this.mPivotXType = n;
        this.mPivotYValue = f4;
        this.mPivotYType = n2;
    }

    public RotateAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        float f;
        int n;
        float f2;
        int n2;
        float f3;
        float f4;
        int[] nArray = R.styleable.RotateAnimation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mFromDegrees = f4 = typedArray.getFloat(0, 0.0f);
        this.mToDegrees = f3 = typedArray.getFloat(1, 0.0f);
        Animation.Description description = Animation.Description.parseValue(typedArray.peekValue(2));
        this.mPivotXType = n2 = description.type;
        this.mPivotXValue = f2 = description.value;
        Animation.Description description2 = Animation.Description.parseValue(typedArray.peekValue(3));
        this.mPivotYType = n = description2.type;
        this.mPivotYValue = f = description2.value;
        typedArray.recycle();
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = this.mFromDegrees;
        float f3 = this.mToDegrees;
        float f4 = this.mFromDegrees;
        float f5 = (f3 - f4) * f;
        float f6 = f2 + f5;
        if (this.mPivotX == 0.0f && this.mPivotY == 0.0f) {
            transformation.getMatrix().setRotate(f6);
            return;
        }
        Matrix matrix = transformation.getMatrix();
        float f7 = this.mPivotX;
        float f8 = this.mPivotY;
        matrix.setRotate(f6, f7, f8);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        super.initialize(n, n2, n3, n4);
        int n5 = this.mPivotXType;
        float f3 = this.mPivotXValue;
        this.mPivotX = f2 = this.resolveSize(n5, f3, n, n3);
        int n6 = this.mPivotYType;
        float f4 = this.mPivotYValue;
        this.mPivotY = f = this.resolveSize(n6, f4, n2, n4);
    }
}

