/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class ScaleAnimation
extends Animation {
    private float mFromX;
    private float mFromY;
    private float mPivotX;
    private int mPivotXType = 0;
    private float mPivotXValue = 0.0f;
    private float mPivotY;
    private int mPivotYType = 0;
    private float mPivotYValue = 0.0f;
    private float mToX;
    private float mToY;

    public ScaleAnimation(float f, float f2, float f3, float f4) {
        this.mFromX = f;
        this.mToX = f2;
        this.mFromY = f3;
        this.mToY = f4;
        this.mPivotX = 0.0f;
        this.mPivotY = 0.0f;
    }

    public ScaleAnimation(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mFromX = f;
        this.mToX = f2;
        this.mFromY = f3;
        this.mToY = f4;
        this.mPivotXType = 0;
        this.mPivotYType = 0;
        this.mPivotXValue = f5;
        this.mPivotYValue = f6;
    }

    public ScaleAnimation(float f, float f2, float f3, float f4, int n, float f5, int n2, float f6) {
        this.mFromX = f;
        this.mToX = f2;
        this.mFromY = f3;
        this.mToY = f4;
        this.mPivotXValue = f5;
        this.mPivotXType = n;
        this.mPivotYValue = f6;
        this.mPivotYType = n2;
    }

    public ScaleAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        float f;
        int n;
        float f2;
        int n2;
        float f3;
        float f4;
        float f5;
        float f6;
        int[] nArray = R.styleable.ScaleAnimation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        this.mFromX = f6 = typedArray.getFloat(2, 0.0f);
        this.mToX = f5 = typedArray.getFloat(3, 0.0f);
        this.mFromY = f4 = typedArray.getFloat(4, 0.0f);
        this.mToY = f3 = typedArray.getFloat(5, 0.0f);
        Animation.Description description = Animation.Description.parseValue(typedArray.peekValue(0));
        this.mPivotXType = n2 = description.type;
        this.mPivotXValue = f2 = description.value;
        Animation.Description description2 = Animation.Description.parseValue(typedArray.peekValue(1));
        this.mPivotYType = n = description2.type;
        this.mPivotYValue = f = description2.value;
        typedArray.recycle();
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (this.mFromX != 1.0f || this.mToX != 1.0f) {
            float f4 = this.mFromX;
            float f5 = this.mToX;
            float f6 = this.mFromX;
            float f7 = (f5 - f6) * f;
            f2 = f4 + f7;
        }
        if (this.mFromY != 1.0f || this.mToY != 1.0f) {
            float f8 = this.mFromY;
            float f9 = this.mToY;
            float f10 = this.mFromY;
            float f11 = (f9 - f10) * f;
            f3 = f8 + f11;
        }
        if (this.mPivotX == 0.0f && this.mPivotY == 0.0f) {
            transformation.getMatrix().setScale(f2, f3);
            return;
        }
        Matrix matrix = transformation.getMatrix();
        float f12 = this.mPivotX;
        float f13 = this.mPivotY;
        matrix.setScale(f2, f3, f12, f13);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        super.initialize(n, n2, n3, n4);
        int n5 = this.mPivotXType;
        float f3 = this.mPivotXValue;
        this.mPivotX = f2 = this.resolveSize(n5, f3, n, n3);
        int n6 = this.mPivotYType;
        float f4 = this.mPivotYValue;
        this.mPivotY = f = this.resolveSize(n6, f4, n2, n4);
    }
}

