/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.graphics.Matrix;
import java.io.PrintWriter;

public class Transformation {
    public static int TYPE_ALPHA;
    public static int TYPE_BOTH;
    public static int TYPE_IDENTITY;
    public static int TYPE_MATRIX;
    protected float mAlpha;
    protected Matrix mMatrix;
    protected int mTransformationType;

    static {
        TYPE_IDENTITY = 0;
        TYPE_ALPHA = 1;
        TYPE_MATRIX = 2;
        int n = TYPE_ALPHA;
        int n2 = TYPE_MATRIX;
        TYPE_BOTH = n | n2;
    }

    public Transformation() {
        this.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clear() {
        int n;
        if (this.mMatrix == null) {
            Matrix matrix;
            this.mMatrix = matrix = new Matrix();
        } else {
            this.mMatrix.reset();
        }
        this.mAlpha = 1.0f;
        this.mTransformationType = n = TYPE_BOTH;
    }

    public void compose(Transformation transformation) {
        float f;
        float f2 = this.mAlpha;
        float f3 = transformation.getAlpha();
        this.mAlpha = f = f2 * f3;
        Matrix matrix = this.mMatrix;
        Matrix matrix2 = transformation.getMatrix();
        boolean bl = matrix.preConcat(matrix2);
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public int getTransformationType() {
        return this.mTransformationType;
    }

    public void printShortString(PrintWriter printWriter) {
        printWriter.print("{alpha=");
        float f = this.mAlpha;
        printWriter.print(f);
        printWriter.print(" matrix=");
        this.mMatrix.printShortString(printWriter);
        printWriter.print('}');
    }

    public void set(Transformation transformation) {
        int n;
        float f;
        this.mAlpha = f = transformation.getAlpha();
        Matrix matrix = this.mMatrix;
        Matrix matrix2 = transformation.getMatrix();
        matrix.set(matrix2);
        this.mTransformationType = n = transformation.getTransformationType();
    }

    public void setAlpha(float f) {
        this.mAlpha = f;
    }

    public void setTransformationType(int n) {
        this.mTransformationType = n;
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.toShortString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toShortString(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder.append("{alpha=");
        float f = this.mAlpha;
        StringBuilder stringBuilder3 = stringBuilder.append(f);
        StringBuilder stringBuilder4 = stringBuilder.append(" matrix=");
        this.mMatrix.toShortString(stringBuilder);
        StringBuilder stringBuilder5 = stringBuilder.append('}');
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = stringBuilder.append("Transformation");
        this.toShortString(stringBuilder);
        return stringBuilder.toString();
    }
}

