/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class TranslateAnimation
extends Animation {
    private float mFromXDelta;
    private int mFromXType = 0;
    private float mFromXValue = 0.0f;
    private float mFromYDelta;
    private int mFromYType = 0;
    private float mFromYValue = 0.0f;
    private float mToXDelta;
    private int mToXType = 0;
    private float mToXValue = 0.0f;
    private float mToYDelta;
    private int mToYType = 0;
    private float mToYValue = 0.0f;

    public TranslateAnimation(float f, float f2, float f3, float f4) {
        this.mFromXValue = f;
        this.mToXValue = f2;
        this.mFromYValue = f3;
        this.mToYValue = f4;
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
    }

    public TranslateAnimation(int n, float f, int n2, float f2, int n3, float f3, int n4, float f4) {
        this.mFromXValue = f;
        this.mToXValue = f2;
        this.mFromYValue = f3;
        this.mToYValue = f4;
        this.mFromXType = n;
        this.mToXType = n2;
        this.mFromYType = n3;
        this.mToYType = n4;
    }

    public TranslateAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        float f;
        int n;
        float f2;
        int n2;
        float f3;
        int n3;
        float f4;
        int n4;
        int[] nArray = R.styleable.TranslateAnimation;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray);
        Animation.Description description = Animation.Description.parseValue(typedArray.peekValue(0));
        this.mFromXType = n4 = description.type;
        this.mFromXValue = f4 = description.value;
        Animation.Description description2 = Animation.Description.parseValue(typedArray.peekValue(1));
        this.mToXType = n3 = description2.type;
        this.mToXValue = f3 = description2.value;
        Animation.Description description3 = Animation.Description.parseValue(typedArray.peekValue(2));
        this.mFromYType = n2 = description3.type;
        this.mFromYValue = f2 = description3.value;
        Animation.Description description4 = Animation.Description.parseValue(typedArray.peekValue(3));
        this.mToYType = n = description4.type;
        this.mToYValue = f = description4.value;
        typedArray.recycle();
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        float f2;
        float f3;
        float f4 = this.mFromXDelta;
        float f5 = this.mFromYDelta;
        float f6 = this.mFromXDelta;
        float f7 = this.mToXDelta;
        if (f6 != f7) {
            float f8 = this.mFromXDelta;
            float f9 = this.mToXDelta;
            float f10 = this.mFromXDelta;
            float f11 = (f9 - f10) * f;
            f4 = f8 + f11;
        }
        if ((f3 = this.mFromYDelta) != (f2 = this.mToYDelta)) {
            float f12 = this.mFromYDelta;
            float f13 = this.mToYDelta;
            float f14 = this.mFromYDelta;
            float f15 = (f13 - f14) * f;
            f5 = f12 + f15;
        }
        transformation.getMatrix().setTranslate(f4, f5);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        float f3;
        float f4;
        super.initialize(n, n2, n3, n4);
        int n5 = this.mFromXType;
        float f5 = this.mFromXValue;
        this.mFromXDelta = f4 = this.resolveSize(n5, f5, n, n3);
        int n6 = this.mToXType;
        float f6 = this.mToXValue;
        this.mToXDelta = f3 = this.resolveSize(n6, f6, n, n3);
        int n7 = this.mFromYType;
        float f7 = this.mFromYValue;
        this.mFromYDelta = f2 = this.resolveSize(n7, f7, n2, n4);
        int n8 = this.mToYType;
        float f8 = this.mToYValue;
        this.mToYDelta = f = this.resolveSize(n8, f8, n2, n4);
    }
}

