/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ComposingText;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;

public class BaseInputConnection
implements InputConnection {
    static final Object COMPOSING = new ComposingText();
    private static final boolean DEBUG = false;
    private static final String TAG = "BaseInputConnection";
    private Object[] mDefaultComposingSpans;
    final boolean mDummyMode;
    Editable mEditable;
    final InputMethodManager mIMM;
    KeyCharacterMap mKeyCharacterMap;
    final View mTargetView;

    /*
     * Enabled aggressive block sorting
     */
    public BaseInputConnection(View view, boolean bl) {
        InputMethodManager inputMethodManager;
        this.mIMM = inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.mTargetView = view;
        boolean bl2 = !bl;
        this.mDummyMode = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    BaseInputConnection(InputMethodManager inputMethodManager, boolean bl) {
        this.mIMM = inputMethodManager;
        this.mTargetView = null;
        boolean bl2 = !bl;
        this.mDummyMode = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureDefaultComposingSpans() {
        Context context;
        if (this.mDefaultComposingSpans != null) {
            return;
        }
        if (this.mTargetView != null) {
            context = this.mTargetView.getContext();
        } else {
            if (this.mIMM.mServedView == null) return;
            context = this.mIMM.mServedView.getContext();
        }
        if (context == null) {
            return;
        }
        Resources.Theme theme = context.getTheme();
        int[] nArray = new int[]{16843312};
        TypedArray typedArray = theme.obtainStyledAttributes(nArray);
        CharSequence charSequence = typedArray.getText(0);
        typedArray.recycle();
        if (charSequence == null) {
            return;
        }
        if (!(charSequence instanceof Spanned)) {
            return;
        }
        Spanned spanned = (Spanned)charSequence;
        int n = charSequence.length();
        Object[] objectArray = spanned.getSpans(0, n, Object.class);
        this.mDefaultComposingSpans = objectArray;
    }

    public static int getComposingSpanEnd(Spannable spannable) {
        Object object = COMPOSING;
        return spannable.getSpanEnd(object);
    }

    public static int getComposingSpanStart(Spannable spannable) {
        Object object = COMPOSING;
        return spannable.getSpanStart(object);
    }

    public static final void removeComposingSpans(Spannable spannable) {
        Object object = COMPOSING;
        spannable.removeSpan(object);
        int n = spannable.length();
        Object[] objectArray = spannable.getSpans(0, n, Object.class);
        if (objectArray == null) {
            return;
        }
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            Object object2 = objectArray[n2];
            if ((spannable.getSpanFlags(object2) & 0x100) != 0) {
                spannable.removeSpan(object2);
            }
            n2 += -1;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void replaceText(CharSequence charSequence, int n, boolean bl) {
        int n2;
        Editable editable = this.getEditable();
        if (editable == null) {
            return;
        }
        boolean bl2 = this.beginBatchEdit();
        int n3 = BaseInputConnection.getComposingSpanStart(editable);
        int n4 = BaseInputConnection.getComposingSpanEnd(editable);
        if (n4 < n3) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (n3 != -1 && n4 != -1) {
            BaseInputConnection.removeComposingSpans(editable);
        } else {
            n3 = Selection.getSelectionStart(editable);
            n4 = Selection.getSelectionEnd(editable);
            if (n3 < 0) {
                // empty if block
            }
            if (n4 < 0) {
                // empty if block
            }
            if (n4 < n3) {
                int n6 = n3;
                n3 = n4;
                n4 = n6;
            }
        }
        if (bl) {
            Spannable spannable;
            if (!(charSequence instanceof Spannable)) {
                spannable = new SpannableStringBuilder(charSequence);
                charSequence = spannable;
                this.ensureDefaultComposingSpans();
                if (this.mDefaultComposingSpans != null) {
                    int n7;
                    for (int i = 0; i < (n7 = this.mDefaultComposingSpans.length); ++i) {
                        Object object = this.mDefaultComposingSpans[i];
                        int n8 = spannable.length();
                        spannable.setSpan(object, 0, n8, 289);
                    }
                }
            } else {
                spannable = (Spannable)charSequence;
            }
            BaseInputConnection.setComposingSpans(spannable);
        }
        if (n > 0) {
            int n9 = n4 - 1;
            n += n9;
        } else {
            n += n3;
        }
        if (n < 0) {
            // empty if block
        }
        if (n > (n2 = editable.length())) {
            int n10 = editable.length();
        }
        Selection.setSelection(editable, n);
        Editable editable2 = editable.replace(n3, n4, charSequence);
        boolean bl3 = this.endBatchEdit();
    }

    private void sendCurrentText() {
        if (!this.mDummyMode) {
            return;
        }
        Editable editable = this.getEditable();
        if (editable == null) {
            return;
        }
        int n = editable.length();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            if (this.mKeyCharacterMap == null) {
                KeyCharacterMap keyCharacterMap;
                this.mKeyCharacterMap = keyCharacterMap = KeyCharacterMap.load(0);
            }
            char[] cArray = new char[1];
            editable.getChars(0, 1, cArray, 0);
            KeyEvent[] keyEventArray = this.mKeyCharacterMap.getEvents(cArray);
            if (keyEventArray != null) {
                int n2;
                for (int i = 0; i < (n2 = keyEventArray.length); ++i) {
                    KeyEvent keyEvent = keyEventArray[i];
                    boolean bl = this.sendKeyEvent(keyEvent);
                }
                editable.clear();
                return;
            }
        }
        long l = SystemClock.uptimeMillis();
        String string2 = editable.toString();
        int n3 = 0;
        KeyEvent keyEvent = new KeyEvent(l, string2, 0, n3);
        boolean bl = this.sendKeyEvent(keyEvent);
        editable.clear();
    }

    public static void setComposingSpans(Spannable spannable) {
        int n = spannable.length();
        BaseInputConnection.setComposingSpans(spannable, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setComposingSpans(Spannable spannable, int n, int n2) {
        Object[] objectArray = spannable.getSpans(n, n2, Object.class);
        if (objectArray != null) {
            for (int i = objectArray.length - 1; i >= 0; i += -1) {
                Object object = objectArray[i];
                Object object2 = COMPOSING;
                if (object == object2) {
                    spannable.removeSpan(object);
                    continue;
                }
                int n3 = spannable.getSpanFlags(object);
                if ((n3 & 0x133) == 289) continue;
                int n4 = spannable.getSpanStart(object);
                int n5 = spannable.getSpanEnd(object);
                int n6 = n3 & 0xFFFFFFCC | 0x100 | 0x21;
                spannable.setSpan(object, n4, n5, n6);
            }
        }
        Object object = COMPOSING;
        spannable.setSpan(object, n, n2, 289);
    }

    @Override
    public boolean beginBatchEdit() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean clearMetaKeyStates(int n) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        MetaKeyKeyListener.clearMetaKeyState(editable, n);
        return true;
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        return false;
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        this.replaceText(charSequence, n, false);
        this.sendCurrentText();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteSurroundingText(int n, int n2) {
        int n3;
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        boolean bl = this.beginBatchEdit();
        int n4 = Selection.getSelectionStart(editable);
        if (n4 > (n3 = Selection.getSelectionEnd(editable))) {
            int n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        int n6 = BaseInputConnection.getComposingSpanStart(editable);
        int n7 = BaseInputConnection.getComposingSpanEnd(editable);
        if (n7 < n6) {
            int n8 = n6;
            n6 = n7;
            n7 = n8;
        }
        if (n6 != -1 && n7 != -1) {
            if (n6 < n4) {
                n4 = n6;
            }
            if (n7 > n3) {
                n3 = n7;
            }
        }
        int n9 = 0;
        if (n > 0) {
            int n10 = n4 - n;
            if (n10 < 0) {
                n10 = 0;
            }
            Editable editable2 = editable.delete(n10, n4);
            n9 = n4 - n10;
        }
        if (n2 > 0) {
            int n11 = (n3 -= n9) + n2;
            int n12 = editable.length();
            if (n11 > n12) {
                n11 = editable.length();
            }
            Editable editable3 = editable.delete(n3, n11);
        }
        boolean bl2 = this.endBatchEdit();
        return true;
    }

    @Override
    public boolean endBatchEdit() {
        return false;
    }

    @Override
    public boolean finishComposingText() {
        Editable editable = this.getEditable();
        if (editable != null) {
            boolean bl = this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(editable);
            boolean bl2 = this.endBatchEdit();
            this.sendCurrentText();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getCursorCapsMode(int n) {
        int n2;
        if (this.mDummyMode) {
            return 0;
        }
        Editable editable = this.getEditable();
        if (editable == null) {
            return 0;
        }
        int n3 = Selection.getSelectionStart(editable);
        if (n3 <= (n2 = Selection.getSelectionEnd(editable))) return TextUtils.getCapsMode(editable, n3, n);
        int n4 = n3;
        n3 = n2;
        int n5 = n4;
        return TextUtils.getCapsMode(editable, n3, n);
    }

    public Editable getEditable() {
        if (this.mEditable == null) {
            Editable editable;
            this.mEditable = editable = Editable.Factory.getInstance().newEditable("");
            Selection.setSelection(this.mEditable, 0);
        }
        return this.mEditable;
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getSelectedText(int n) {
        int n2;
        CharSequence charSequence = null;
        Editable editable = this.getEditable();
        if (editable == null) {
            return charSequence;
        }
        int n3 = Selection.getSelectionStart(editable);
        if (n3 > (n2 = Selection.getSelectionEnd(editable))) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        if (n3 == n2) return charSequence;
        if ((n & 1) == 0) return TextUtils.substring(editable, n3, n2);
        return editable.subSequence(n3, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getTextAfterCursor(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Editable editable = this.getEditable();
        if (editable == null) {
            return null;
        }
        int n6 = Selection.getSelectionStart(editable);
        if (n6 > (n5 = Selection.getSelectionEnd(editable))) {
            int n7 = n6;
            int n8 = n5;
            n5 = n7;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n4 = n5 + n) > (n3 = editable.length())) {
            n = editable.length() - n5;
        }
        if ((n2 & 1) != 0) {
            int n9 = n5 + n;
            return editable.subSequence(n5, n9);
        }
        int n10 = n5 + n;
        return TextUtils.substring(editable, n5, n10);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getTextBeforeCursor(int n, int n2) {
        int n3;
        void var4_5;
        Editable editable = this.getEditable();
        if (editable == null) {
            return var4_5;
        }
        int n4 = Selection.getSelectionStart(editable);
        if (n4 > (n3 = Selection.getSelectionEnd(editable))) {
            int n5 = n4;
            n4 = n3;
            int n6 = n5;
        }
        if (n4 <= 0) {
            return var4_5;
        }
        if (n > n4) {
            n = n4;
        }
        if ((n2 & 1) != 0) {
            int n7 = n4 - n;
            CharSequence charSequence = editable.subSequence(n7, n4);
            return var4_5;
        }
        int n8 = n4 - n;
        String string2 = TextUtils.substring(editable, n8, n4);
        return var4_5;
    }

    @Override
    public boolean performContextMenuAction(int n) {
        return false;
    }

    @Override
    public boolean performEditorAction(int n) {
        long l;
        long l2 = l = SystemClock.uptimeMillis();
        KeyEvent keyEvent = new KeyEvent(l, l2, 0, 66, 0, 0, 0, 0, 22);
        boolean bl = this.sendKeyEvent(keyEvent);
        long l3 = SystemClock.uptimeMillis();
        long l4 = l;
        KeyEvent keyEvent2 = new KeyEvent(l3, l4, 1, 66, 0, 0, 0, 0, 22);
        boolean bl2 = this.sendKeyEvent(keyEvent2);
        return true;
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        return false;
    }

    @Override
    public boolean reportFullscreenMode(boolean bl) {
        this.mIMM.setFullscreenMode(bl);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        InputMethodManager.H h = this.mIMM.mH;
        synchronized (h) {
            Handler handler = this.mTargetView != null ? this.mTargetView.getHandler() : null;
            if (handler == null && this.mIMM.mServedView != null) {
                handler = this.mIMM.mServedView.getHandler();
            }
            if (handler == null) return (boolean)null;
            Message message = handler.obtainMessage(1011, keyEvent);
            boolean bl = handler.sendMessage(message);
            return (boolean)null;
        }
    }

    @Override
    public boolean setComposingRegion(int n, int n2) {
        Editable editable = this.getEditable();
        if (editable != null) {
            boolean bl = this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(editable);
            int n3 = n;
            int n4 = n2;
            if (n3 > n4) {
                int n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            int n6 = editable.length();
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 > n6) {
                n3 = n6;
            }
            if (n4 > n6) {
                n4 = n6;
            }
            this.ensureDefaultComposingSpans();
            if (this.mDefaultComposingSpans != null) {
                int n7;
                for (int i = 0; i < (n7 = this.mDefaultComposingSpans.length); ++i) {
                    Object object = this.mDefaultComposingSpans[i];
                    editable.setSpan(object, n3, n4, 289);
                }
            }
            Object object = COMPOSING;
            editable.setSpan(object, n3, n4, 289);
            boolean bl2 = this.endBatchEdit();
            this.sendCurrentText();
        }
        return true;
    }

    @Override
    public boolean setComposingText(CharSequence charSequence, int n) {
        this.replaceText(charSequence, n, true);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSelection(int n, int n2) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        int n3 = editable.length();
        if (n > n3) return true;
        if (n2 > n3) {
            return true;
        }
        if (n != n2 && MetaKeyKeyListener.getMetaState(editable, 65536) != 0) {
            Selection.extendSelection(editable, n);
            return true;
        }
        Selection.setSelection(editable, n, n2);
        return true;
    }
}

