/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public final class InputMethodInfo
implements Parcelable {
    public static final Parcelable.Creator<InputMethodInfo> CREATOR = new Parcelable.Creator<InputMethodInfo>(){

        @Override
        public InputMethodInfo createFromParcel(Parcel parcel) {
            return new InputMethodInfo(parcel);
        }

        public InputMethodInfo[] newArray(int n) {
            return new InputMethodInfo[n];
        }
    };
    static final String TAG = "InputMethodInfo";
    final String mId;
    final int mIsDefaultResId;
    final ResolveInfo mService;
    final String mSettingsActivityName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputMethodInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        int n;
        String string2;
        int n2;
        String string3;
        XmlResourceParser xmlResourceParser;
        String string4;
        ResolveInfo resolveInfo2;
        this.mService = resolveInfo2 = resolveInfo;
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        String string5 = serviceInfo.packageName;
        String string6 = serviceInfo.name;
        this.mId = string4 = new ComponentName(string5, string6).flattenToShortString();
        PackageManager packageManager = context.getPackageManager();
        try {
            int n3;
            try {
                xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, "android.view.im");
                if (xmlResourceParser == null) {
                    throw new XmlPullParserException("No android.view.im meta-data");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to create context for: ");
                String string7 = serviceInfo.packageName;
                String string8 = stringBuilder.append(string7).toString();
                throw new XmlPullParserException(string8);
            }
            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
            Resources resources = packageManager.getResourcesForApplication(applicationInfo);
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n3 = xmlResourceParser.next()) != 1 && n3 != 2) {
            }
            String string9 = xmlResourceParser.getName();
            if (!"input-method".equals(string9)) {
                throw new XmlPullParserException("Meta-data does not start with input-method tag");
            }
            int[] nArray = R.styleable.InputMethod;
            TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
            string3 = typedArray.getString(1);
            n2 = typedArray.getResourceId(0, 0);
            typedArray.recycle();
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
        this.mSettingsActivityName = string2 = string3;
        this.mIsDefaultResId = n = n2;
    }

    InputMethodInfo(Parcel parcel) {
        ResolveInfo resolveInfo;
        int n;
        String string2;
        String string3;
        this.mId = string3 = parcel.readString();
        this.mSettingsActivityName = string2 = parcel.readString();
        this.mIsDefaultResId = n = parcel.readInt();
        this.mService = resolveInfo = ResolveInfo.CREATOR.createFromParcel(parcel);
    }

    public InputMethodInfo(String string2, String string3, CharSequence charSequence, String string4) {
        String string5;
        ResolveInfo resolveInfo = new ResolveInfo();
        ServiceInfo serviceInfo = new ServiceInfo();
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.packageName = string2;
        applicationInfo.enabled = true;
        serviceInfo.applicationInfo = applicationInfo;
        serviceInfo.enabled = true;
        serviceInfo.packageName = string2;
        serviceInfo.name = string3;
        serviceInfo.exported = true;
        serviceInfo.nonLocalizedLabel = charSequence;
        resolveInfo.serviceInfo = serviceInfo;
        this.mService = resolveInfo;
        String string6 = serviceInfo.packageName;
        String string7 = serviceInfo.name;
        this.mId = string5 = new ComponentName(string6, string7).flattenToShortString();
        this.mSettingsActivityName = string4;
        this.mIsDefaultResId = 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("mId=");
        String string3 = this.mId;
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" mSettingsActivityName=");
        String string4 = this.mSettingsActivityName;
        String string5 = stringBuilder2.append(string4).toString();
        printer.println(string5);
        StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("mIsDefaultResId=0x");
        String string6 = Integer.toHexString(this.mIsDefaultResId);
        String string7 = stringBuilder3.append(string6).toString();
        printer.println(string7);
        String string8 = string2 + "Service:";
        printer.println(string8);
        ResolveInfo resolveInfo = this.mService;
        String string9 = string2 + "  ";
        resolveInfo.dump(printer, string9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof InputMethodInfo)) {
            return false;
        }
        InputMethodInfo inputMethodInfo = (InputMethodInfo)object;
        String string2 = this.mId;
        String string3 = inputMethodInfo.mId;
        return string2.equals(string3);
    }

    public ComponentName getComponent() {
        String string2 = this.mService.serviceInfo.packageName;
        String string3 = this.mService.serviceInfo.name;
        return new ComponentName(string2, string3);
    }

    public String getId() {
        return this.mId;
    }

    public int getIsDefaultResourceId() {
        return this.mIsDefaultResId;
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public String getServiceName() {
        return this.mService.serviceInfo.name;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return this.mService.loadIcon(packageManager);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return this.mService.loadLabel(packageManager);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("InputMethodInfo{");
        String string2 = this.mId;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", settings: ");
        String string3 = this.mSettingsActivityName;
        return stringBuilder2.append(string3).append("}").toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.mId;
        parcel.writeString(string2);
        String string3 = this.mSettingsActivityName;
        parcel.writeString(string3);
        int n2 = this.mIsDefaultResId;
        parcel.writeInt(n2);
        this.mService.writeToParcel(parcel, n);
    }
}

