/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodInfo;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.IInputConnectionWrapper;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class InputMethodManager {
    static final boolean DEBUG = false;
    public static final int HIDE_IMPLICIT_ONLY = 1;
    public static final int HIDE_NOT_ALWAYS = 2;
    static final int MSG_BIND = 2;
    static final int MSG_DUMP = 1;
    static final int MSG_SET_ACTIVE = 4;
    static final int MSG_UNBIND = 3;
    public static final int RESULT_HIDDEN = 3;
    public static final int RESULT_SHOWN = 2;
    public static final int RESULT_UNCHANGED_HIDDEN = 1;
    public static final int RESULT_UNCHANGED_SHOWN = 0;
    public static final int SHOW_FORCED = 2;
    public static final int SHOW_IMPLICIT = 1;
    static final String TAG = "InputMethodManager";
    static InputMethodManager mInstance;
    static final Object mInstanceSync;
    boolean mActive = false;
    int mBindSequence;
    final IInputMethodClient.Stub mClient;
    CompletionInfo[] mCompletions;
    String mCurId;
    IInputMethodSession mCurMethod;
    View mCurRootView;
    EditorInfo mCurrentTextBoxAttribute;
    int mCursorCandEnd;
    int mCursorCandStart;
    Rect mCursorRect;
    int mCursorSelEnd;
    int mCursorSelStart;
    final InputConnection mDummyInputConnection;
    boolean mFullscreenMode;
    final H mH;
    boolean mHasBeenInactive = true;
    final IInputContext mIInputContext;
    final Looper mMainLooper;
    boolean mNextServedNeedsStart;
    View mNextServedView;
    boolean mServedConnecting;
    InputConnection mServedInputConnection;
    View mServedView;
    final IInputMethodManager mService;
    Rect mTmpCursorRect;

    static {
        mInstanceSync = new Object();
    }

    InputMethodManager(IInputMethodManager iInputMethodManager, Looper looper) {
        H h;
        IInputMethodClient.Stub stub;
        Rect rect;
        Rect rect2;
        this.mTmpCursorRect = rect2 = new Rect();
        this.mCursorRect = rect = new Rect();
        this.mBindSequence = -1;
        this.mClient = stub = new IInputMethodClient.Stub(){

            @Override
            protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                HandlerCaller.SomeArgs someArgs = new HandlerCaller.SomeArgs();
                someArgs.arg1 = fileDescriptor;
                someArgs.arg2 = printWriter;
                someArgs.arg3 = stringArray;
                someArgs.arg4 = countDownLatch;
                H h = InputMethodManager.this.mH;
                Message message = InputMethodManager.this.mH.obtainMessage(1, someArgs);
                boolean bl = h.sendMessage(message);
                try {
                    TimeUnit timeUnit = TimeUnit.SECONDS;
                    if (countDownLatch.await(5L, timeUnit)) {
                        return;
                    }
                    printWriter.println("Timeout waiting for dump");
                    return;
                }
                catch (InterruptedException interruptedException) {
                    printWriter.println("Interrupted waiting for dump");
                    return;
                }
            }

            @Override
            public void onBindMethod(InputBindResult inputBindResult) {
                H h = InputMethodManager.this.mH;
                Message message = InputMethodManager.this.mH.obtainMessage(2, inputBindResult);
                boolean bl = h.sendMessage(message);
            }

            @Override
            public void onUnbindMethod(int n) {
                H h = InputMethodManager.this.mH;
                Message message = InputMethodManager.this.mH.obtainMessage(3, n, 0);
                boolean bl = h.sendMessage(message);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void setActive(boolean bl) {
                H h = InputMethodManager.this.mH;
                H h2 = InputMethodManager.this.mH;
                int n = bl ? 1 : 0;
                Message message = h2.obtainMessage(4, n, 0);
                boolean bl2 = h.sendMessage(message);
            }

            @Override
            public void setUsingInputMethod(boolean bl) {
            }
        };
        BaseInputConnection baseInputConnection = new BaseInputConnection(this, false);
        this.mDummyInputConnection = baseInputConnection;
        this.mService = iInputMethodManager;
        this.mMainLooper = looper;
        this.mH = h = new H(looper);
        InputConnection inputConnection = this.mDummyInputConnection;
        ControlledInputConnectionWrapper controlledInputConnectionWrapper = new ControlledInputConnectionWrapper(looper, inputConnection);
        this.mIInputContext = controlledInputConnectionWrapper;
        if (mInstance != null) {
            return;
        }
        mInstance = this;
    }

    public static InputMethodManager getInstance(Context context) {
        return InputMethodManager.getInstance(context.getMainLooper());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputMethodManager getInstance(Looper looper) {
        Object object = mInstanceSync;
        synchronized (object) {
            if (mInstance != null) {
                InputMethodManager inputMethodManager = mInstance;
                return inputMethodManager;
            }
            IInputMethodManager iInputMethodManager = IInputMethodManager.Stub.asInterface(ServiceManager.getService("input_method"));
            mInstance = new InputMethodManager(iInputMethodManager, looper);
            return mInstance;
        }
    }

    public static InputMethodManager peekInstance() {
        return mInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkFocus() {
        View view;
        boolean bl;
        View view2 = this.mServedView;
        View view3 = this.mNextServedView;
        if (view2 == view3 && !this.mNextServedNeedsStart) {
            return;
        }
        H h = this.mH;
        // MONITORENTER : h
        View view4 = this.mServedView;
        View view5 = this.mNextServedView;
        if (view4 == view5 && !this.mNextServedNeedsStart) {
            // MONITOREXIT : h
            return;
        }
        this.mNextServedNeedsStart = bl = false;
        if (this.mNextServedView == null) {
            this.finishInputLocked();
            this.closeCurrentInput();
            // MONITOREXIT : h
            return;
        }
        InputConnection inputConnection = this.mServedInputConnection;
        this.mServedView = view = this.mNextServedView;
        this.mCurrentTextBoxAttribute = null;
        this.mCompletions = null;
        this.mServedConnecting = true;
        // MONITOREXIT : h
        if (inputConnection != null) {
            boolean bl2 = inputConnection.finishComposingText();
        }
        this.startInputInner();
    }

    void clearBindingLocked() {
        this.clearConnectionLocked();
        this.mBindSequence = -1;
        this.mCurId = null;
        this.mCurMethod = null;
    }

    void clearConnectionLocked() {
        this.mCurrentTextBoxAttribute = null;
        this.mServedInputConnection = null;
    }

    void closeCurrentInput() {
        try {
            IInputMethodManager iInputMethodManager = this.mService;
            IInputMethodClient.Stub stub = this.mClient;
            boolean bl = iInputMethodManager.hideSoftInput(stub, 2, null);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchKeyEvent(Context context, int n, KeyEvent keyEvent, IInputMethodCallback iInputMethodCallback) {
        H h = this.mH;
        synchronized (h) {
            block14: {
                block13: {
                    IInputMethodSession iInputMethodSession = this.mCurMethod;
                    if (iInputMethodSession == null) {
                        iInputMethodSession = null;
                        iInputMethodCallback.finishedEvent(n, (boolean)iInputMethodSession);
                        break block13;
                    }
                    if (keyEvent.getAction() == 0 && keyEvent.getKeyCode() == 63) {
                        this.showInputMethodPicker();
                        iInputMethodSession = null;
                        iInputMethodCallback.finishedEvent(n, (boolean)iInputMethodSession);
                        break block14;
                    }
                    try {
                        this.mCurMethod.dispatchKeyEvent(n, keyEvent, iInputMethodCallback);
                    }
                    catch (RemoteException remoteException) {
                        StringBuilder stringBuilder = new StringBuilder().append("IME died: ");
                        String string2 = this.mCurId;
                        String string3 = stringBuilder.append(string2).append(" dropping: ").append(keyEvent).toString();
                        int n2 = Log.w(TAG, string3, remoteException);
                        iInputMethodSession = null;
                        try {
                            iInputMethodCallback.finishedEvent(n, (boolean)iInputMethodSession);
                        }
                        catch (RemoteException remoteException2) {}
                    }
                    return;
                    catch (RemoteException remoteException) {}
                }
                return;
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchTrackballEvent(Context context, int n, MotionEvent motionEvent, IInputMethodCallback iInputMethodCallback) {
        H h = this.mH;
        synchronized (h) {
            block10: {
                EditorInfo editorInfo;
                if (this.mCurMethod == null || (editorInfo = this.mCurrentTextBoxAttribute) == null) {
                    editorInfo = null;
                    iInputMethodCallback.finishedEvent(n, (boolean)editorInfo);
                    break block10;
                }
                try {
                    this.mCurMethod.dispatchTrackballEvent(n, motionEvent, iInputMethodCallback);
                }
                catch (RemoteException remoteException) {
                    StringBuilder stringBuilder = new StringBuilder().append("IME died: ");
                    String string2 = this.mCurId;
                    String string3 = stringBuilder.append(string2).append(" dropping trackball: ").append(motionEvent).toString();
                    int n2 = Log.w(TAG, string3, remoteException);
                    editorInfo = null;
                    try {
                        iInputMethodCallback.finishedEvent(n, (boolean)editorInfo);
                    }
                    catch (RemoteException remoteException2) {}
                }
                return;
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void displayCompletions(View view, CompletionInfo[] completionInfoArray) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mCompletions = completionInfoArray;
            IInputMethodSession iInputMethodSession = this.mCurMethod;
            if (iInputMethodSession != null) {
                try {
                    IInputMethodSession iInputMethodSession2 = this.mCurMethod;
                    CompletionInfo[] completionInfoArray2 = this.mCompletions;
                    iInputMethodSession2.displayCompletions(completionInfoArray2);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void doDump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        PrintWriterPrinter printWriterPrinter = new PrintWriterPrinter(printWriter);
        String string2 = "Input method client state for " + this + ":";
        printWriterPrinter.println(string2);
        StringBuilder stringBuilder = new StringBuilder().append("  mService=");
        IInputMethodManager iInputMethodManager = this.mService;
        String string3 = stringBuilder.append(iInputMethodManager).toString();
        printWriterPrinter.println(string3);
        StringBuilder stringBuilder2 = new StringBuilder().append("  mMainLooper=");
        Looper looper = this.mMainLooper;
        String string4 = stringBuilder2.append(looper).toString();
        printWriterPrinter.println(string4);
        StringBuilder stringBuilder3 = new StringBuilder().append("  mIInputContext=");
        IInputContext iInputContext = this.mIInputContext;
        String string5 = stringBuilder3.append(iInputContext).toString();
        printWriterPrinter.println(string5);
        StringBuilder stringBuilder4 = new StringBuilder().append("  mActive=");
        boolean bl = this.mActive;
        StringBuilder stringBuilder5 = stringBuilder4.append(bl).append(" mHasBeenInactive=");
        boolean bl2 = this.mHasBeenInactive;
        StringBuilder stringBuilder6 = stringBuilder5.append(bl2).append(" mBindSequence=");
        int n = this.mBindSequence;
        StringBuilder stringBuilder7 = stringBuilder6.append(n).append(" mCurId=");
        String string6 = this.mCurId;
        String string7 = stringBuilder7.append(string6).toString();
        printWriterPrinter.println(string7);
        StringBuilder stringBuilder8 = new StringBuilder().append("  mCurMethod=");
        IInputMethodSession iInputMethodSession = this.mCurMethod;
        String string8 = stringBuilder8.append(iInputMethodSession).toString();
        printWriterPrinter.println(string8);
        StringBuilder stringBuilder9 = new StringBuilder().append("  mCurRootView=");
        View view = this.mCurRootView;
        String string9 = stringBuilder9.append(view).toString();
        printWriterPrinter.println(string9);
        StringBuilder stringBuilder10 = new StringBuilder().append("  mServedView=");
        View view2 = this.mServedView;
        String string10 = stringBuilder10.append(view2).toString();
        printWriterPrinter.println(string10);
        StringBuilder stringBuilder11 = new StringBuilder().append("  mNextServedNeedsStart=");
        boolean bl3 = this.mNextServedNeedsStart;
        StringBuilder stringBuilder12 = stringBuilder11.append(bl3).append(" mNextServedView=");
        View view3 = this.mNextServedView;
        String string11 = stringBuilder12.append(view3).toString();
        printWriterPrinter.println(string11);
        StringBuilder stringBuilder13 = new StringBuilder().append("  mServedConnecting=");
        boolean bl4 = this.mServedConnecting;
        String string12 = stringBuilder13.append(bl4).toString();
        printWriterPrinter.println(string12);
        if (this.mCurrentTextBoxAttribute != null) {
            printWriterPrinter.println("  mCurrentTextBoxAttribute:");
            this.mCurrentTextBoxAttribute.dump(printWriterPrinter, "    ");
        } else {
            printWriterPrinter.println("  mCurrentTextBoxAttribute: null");
        }
        StringBuilder stringBuilder14 = new StringBuilder().append("  mServedInputConnection=");
        InputConnection inputConnection = this.mServedInputConnection;
        String string13 = stringBuilder14.append(inputConnection).toString();
        printWriterPrinter.println(string13);
        StringBuilder stringBuilder15 = new StringBuilder().append("  mCompletions=");
        CompletionInfo[] completionInfoArray = this.mCompletions;
        String string14 = stringBuilder15.append(completionInfoArray).toString();
        printWriterPrinter.println(string14);
        StringBuilder stringBuilder16 = new StringBuilder().append("  mCursorRect=");
        Rect rect = this.mCursorRect;
        String string15 = stringBuilder16.append(rect).toString();
        printWriterPrinter.println(string15);
        StringBuilder stringBuilder17 = new StringBuilder().append("  mCursorSelStart=");
        int n2 = this.mCursorSelStart;
        StringBuilder stringBuilder18 = stringBuilder17.append(n2).append(" mCursorSelEnd=");
        int n3 = this.mCursorSelEnd;
        StringBuilder stringBuilder19 = stringBuilder18.append(n3).append(" mCursorCandStart=");
        int n4 = this.mCursorCandStart;
        StringBuilder stringBuilder20 = stringBuilder19.append(n4).append(" mCursorCandEnd=");
        int n5 = this.mCursorCandEnd;
        String string16 = stringBuilder20.append(n5).toString();
        printWriterPrinter.println(string16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void finishInputLocked() {
        Handler handler;
        this.mNextServedView = null;
        if (this.mServedView == null) {
            return;
        }
        if (this.mCurrentTextBoxAttribute != null) {
            try {
                IInputMethodManager iInputMethodManager = this.mService;
                IInputMethodClient.Stub stub = this.mClient;
                iInputMethodManager.finishInput(stub);
            }
            catch (RemoteException remoteException) {}
        }
        if (this.mServedInputConnection != null && (handler = this.mServedView.getHandler()) != null) {
            InputConnection inputConnection = this.mServedInputConnection;
            Message message = handler.obtainMessage(1012, inputConnection);
            boolean bl = handler.sendMessage(message);
        }
        this.mServedView = null;
        this.mCompletions = null;
        this.mServedConnecting = false;
        this.clearConnectionLocked();
    }

    public void focusIn(View view) {
        H h = this.mH;
        synchronized (h) {
            this.focusInLocked(view);
            return;
        }
    }

    void focusInLocked(View view) {
        View view2 = this.mCurRootView;
        View view3 = view.getRootView();
        if (view2 != view3) {
            return;
        }
        this.mNextServedView = view;
        this.scheduleCheckFocusLocked(view);
    }

    public void focusOut(View view) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                // empty if block
            }
            return;
        }
    }

    public IInputMethodClient getClient() {
        return this.mClient;
    }

    public List<InputMethodInfo> getEnabledInputMethodList() {
        try {
            List<InputMethodInfo> list = this.mService.getEnabledInputMethodList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public IInputContext getInputContext() {
        return this.mIInputContext;
    }

    public List<InputMethodInfo> getInputMethodList() {
        try {
            List<InputMethodInfo> list = this.mService.getInputMethodList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void hideSoftInputFromInputMethod(IBinder iBinder, int n) {
        try {
            this.mService.hideMySoftInput(iBinder, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean hideSoftInputFromWindow(IBinder iBinder, int n) {
        return this.hideSoftInputFromWindow(iBinder, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hideSoftInputFromWindow(IBinder iBinder, int n, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            boolean bl2;
            if (this.mServedView == null) return false;
            if (this.mServedView.getWindowToken() != iBinder) {
                return false;
            }
            try {
                boolean bl;
                IInputMethodManager iInputMethodManager = this.mService;
                IInputMethodClient.Stub stub = this.mClient;
                bl2 = bl = iInputMethodManager.hideSoftInput(stub, n, resultReceiver);
            }
            catch (RemoteException remoteException) {
                return false;
            }
            return bl2;
        }
    }

    public void hideStatusIcon(IBinder iBinder) {
        try {
            this.mService.updateStatusIcon(iBinder, null, 0);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAcceptingText() {
        this.checkFocus();
        if (this.mServedInputConnection == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null) return false;
            if (this.mCurrentTextBoxAttribute == null) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view) {
                if (this.mServedView == null) return false;
                if (!this.mServedView.checkInputConnectionProxy(view)) return false;
            }
            if (this.mCurrentTextBoxAttribute == null) return false;
            return true;
        }
    }

    public boolean isFullscreenMode() {
        return this.mFullscreenMode;
    }

    public boolean isWatchingCursor(View view) {
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onWindowFocus(View var1_1, View var2_2, int var3_3, boolean var4_4, int var5_5) {
        var6_6 = false;
        var7_7 = this.mH;
        synchronized (var7_7) {
            if (this.mHasBeenInactive) {
                this.mHasBeenInactive = false;
                this.mNextServedNeedsStart = true;
            }
            var8_8 = var2_2 != null ? var2_2 : var1_1;
            this.focusInLocked((View)var8_8);
        }
        this.checkFocus();
        var9_9 = this.mH;
        synchronized (var9_9) {
            if (var2_2 != null) {
                try {
                    if (var2_2.onCheckIsTextEditor()) {
                        var10_10 = true;
lbl16:
                        // 2 sources

                        while (true) {
                            var7_7 = this.mService;
                            var8_8 = this.mClient;
                            var11_11 = var1_1.getWindowToken();
                            if (var2_2 != null) {
                                var6_6 = true;
                            }
                            var12_12 = var3_3;
                            var13_13 = var4_4;
                            var14_14 = var5_5;
                            var7_7.windowGainedFocus((IInputMethodClient)var8_8, var11_11, var6_6, var10_10, var12_12, var13_13, var14_14);
lbl26:
                            // 2 sources

                            return;
                        }
                    }
                }
                catch (RemoteException var15_15) {
                    ** continue;
                }
            }
            var10_10 = false;
            ** continue;
        }
    }

    public void reportFinishInputConnection(InputConnection inputConnection) {
        if (this.mServedInputConnection == inputConnection) {
            return;
        }
        boolean bl = inputConnection.finishComposingText();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restartInput(View view) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            this.mServedConnecting = true;
        }
        this.startInputInner();
    }

    void scheduleCheckFocusLocked(View view) {
        Handler handler = view.getHandler();
        if (handler == null) {
            return;
        }
        if (handler.hasMessages(1013)) {
            return;
        }
        Message message = handler.obtainMessage(1013);
        boolean bl = handler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAppPrivateCommand(View view, String string2, Bundle bundle) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            try {
                this.mCurMethod.appPrivateCommand(string2, bundle);
            }
            catch (RemoteException remoteException) {
                StringBuilder stringBuilder = new StringBuilder().append("IME died: ");
                String string3 = this.mCurId;
                String string4 = stringBuilder.append(string3).toString();
                int n = Log.w(TAG, string4, remoteException);
            }
            return;
        }
    }

    public void setFullscreenMode(boolean bl) {
        this.mFullscreenMode = bl;
    }

    public void setInputMethod(IBinder iBinder, String string2) {
        try {
            this.mService.setInputMethod(iBinder, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showInputMethodPicker() {
        H h = this.mH;
        synchronized (h) {
            try {
                IInputMethodManager iInputMethodManager = this.mService;
                IInputMethodClient.Stub stub = this.mClient;
                iInputMethodManager.showInputMethodPickerFromClient(stub);
            }
            catch (RemoteException remoteException) {
                StringBuilder stringBuilder = new StringBuilder().append("IME died: ");
                String string2 = this.mCurId;
                String string3 = stringBuilder.append(string2).toString();
                int n = Log.w(TAG, string3, remoteException);
            }
            return;
        }
    }

    public boolean showSoftInput(View view, int n) {
        return this.showSoftInput(view, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean showSoftInput(View view, int n, ResultReceiver resultReceiver) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            boolean bl2;
            if (this.mServedView != view) {
                if (this.mServedView == null) return false;
                if (!this.mServedView.checkInputConnectionProxy(view)) {
                    return false;
                }
            }
            try {
                boolean bl;
                IInputMethodManager iInputMethodManager = this.mService;
                IInputMethodClient.Stub stub = this.mClient;
                bl2 = bl = iInputMethodManager.showSoftInput(stub, n, resultReceiver);
            }
            catch (RemoteException remoteException) {
                return false;
            }
            return bl2;
        }
    }

    public void showSoftInputFromInputMethod(IBinder iBinder, int n) {
        try {
            this.mService.showMySoftInput(iBinder, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void showSoftInputUnchecked(int n, ResultReceiver resultReceiver) {
        try {
            IInputMethodManager iInputMethodManager = this.mService;
            IInputMethodClient.Stub stub = this.mClient;
            boolean bl = iInputMethodManager.showSoftInput(stub, n, resultReceiver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void showStatusIcon(IBinder iBinder, String string2, int n) {
        try {
            this.mService.updateStatusIcon(iBinder, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void startGettingWindowFocus(View view) {
        H h = this.mH;
        synchronized (h) {
            this.mCurRootView = view;
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startInputInner() {
        var1_1 = this.mH;
        synchronized (var1_1) {
            var2_2 = this.mServedView;
            if (var2_2 == null) {
                return;
            }
        }
        var3_3 = var2_2.getHandler();
        if (var3_3 == null) {
            return;
        }
        var4_4 = var3_3.getLooper();
        if (var4_4 != (var5_5 = Looper.myLooper())) {
            var6_6 = new Runnable(){

                @Override
                public void run() {
                    InputMethodManager.this.startInputInner();
                }
            };
            var7_7 = var3_3.post(var6_6);
            return;
        }
        var9_8 = new EditorInfo();
        var9_8.packageName = var10_9 = var2_2.getContext().getPackageName();
        var9_8.fieldId = var11_10 = var2_2.getId();
        var12_11 = var2_2.onCreateInputConnection(var9_8);
        var13_12 = this.mH;
        synchronized (var13_12) {
            block18: {
                block20: {
                    block19: {
                        if (this.mServedView != var2_2 || !this.mServedConnecting) {
                            return;
                        }
                        var15_13 = this.mCurrentTextBoxAttribute == null;
                        this.mCurrentTextBoxAttribute = var9_8;
                        this.mServedConnecting = false;
                        this.mServedInputConnection = var12_11;
                        if (var12_11 != null) {
                            this.mCursorSelStart = var16_14 = var9_8.initialSelStart;
                            this.mCursorSelEnd = var17_15 = var9_8.initialSelEnd;
                            this.mCursorCandStart = -1;
                            this.mCursorCandEnd = -1;
                            this.mCursorRect.setEmpty();
                            var18_16 = var3_3.getLooper();
                            var19_17 = new ControlledInputConnectionWrapper(var18_16, var12_11);
                        } else {
                            var19_17 = null;
                        }
                        var20_18 = this.mService;
                        var21_19 = this.mClient;
                        var22_20 = this.mCurMethod == null;
                        var23_21 = var20_18.startInput(var21_19, var19_17, var9_8, var15_13, var22_20);
                        if (var23_21 != null) {
                            if (var23_21.id == null) break block18;
                            this.mBindSequence = var24_22 = var23_21.sequence;
                            this.mCurMethod = var25_23 = var23_21.method;
                        }
                        if (this.mCurMethod != null && (var20_18 = this.mCompletions) != null) break block19;
lbl46:
                        // 4 sources

                        return;
                    }
                    try {}
                    catch (RemoteException var33_31) {
                        ** GOTO lbl46
                    }
                    break block20;
                    catch (RemoteException var28_26) {
                        var29_27 = new StringBuilder().append("IME died: ");
                        var30_28 = this.mCurId;
                        var31_29 = var29_27.append(var30_28).toString();
                        var32_30 = Log.w("InputMethodManager", var31_29, var28_26);
                        ** GOTO lbl46
                    }
                }
                var26_24 = this.mCurMethod;
                var27_25 = this.mCompletions;
                var26_24.displayCompletions(var27_25);
                ** continue;
            }
            return;
        }
    }

    public void toggleSoftInput(int n, int n2) {
        if (this.mCurMethod == null) {
            return;
        }
        try {
            this.mCurMethod.toggleSoftInput(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toggleSoftInputFromWindow(IBinder iBinder, int n, int n2) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView == null || this.mServedView.getWindowToken() != iBinder) {
                return;
            }
            IInputMethodSession iInputMethodSession = this.mCurMethod;
            if (iInputMethodSession != null) {
                try {
                    this.mCurMethod.toggleSoftInput(n, n2);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateCursor(View view, int n, int n2, int n3, int n4) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            this.mTmpCursorRect.set(n, n2, n3, n4);
            Rect rect = this.mCursorRect;
            Rect rect2 = this.mTmpCursorRect;
            boolean bl = rect.equals(rect2);
            if (!bl) {
                try {
                    IInputMethodSession iInputMethodSession = this.mCurMethod;
                    Rect rect3 = this.mTmpCursorRect;
                    iInputMethodSession.updateCursor(rect3);
                    Rect rect4 = this.mCursorRect;
                    Rect rect5 = this.mTmpCursorRect;
                    rect4.set(rect5);
                }
                catch (RemoteException remoteException) {
                    StringBuilder stringBuilder = new StringBuilder().append("IME died: ");
                    String string2 = this.mCurId;
                    String string3 = stringBuilder.append(string2).toString();
                    int n5 = Log.w(TAG, string3, remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateExtractedText(View view, int n, ExtractedText extractedText) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!(this.mServedView == view || this.mServedView != null && this.mServedView.checkInputConnectionProxy(view))) {
                return;
            }
            IInputMethodSession iInputMethodSession = this.mCurMethod;
            if (iInputMethodSession != null) {
                try {
                    this.mCurMethod.updateExtractedText(n, extractedText);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSelection(View view, int n, int n2, int n3, int n4) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            int n5;
            if (this.mServedView != view && (this.mServedView == null || !this.mServedView.checkInputConnectionProxy(view)) || this.mCurrentTextBoxAttribute == null || this.mCurMethod == null) {
                return;
            }
            if (this.mCursorSelStart == n || this.mCursorSelEnd == n2 || this.mCursorCandStart == n3 || (n5 = this.mCursorCandEnd) != n4) {
                try {
                    IInputMethodSession iInputMethodSession = this.mCurMethod;
                    int n6 = this.mCursorSelStart;
                    int n7 = this.mCursorSelEnd;
                    int n8 = n;
                    int n9 = n2;
                    int n10 = n3;
                    int n11 = n4;
                    iInputMethodSession.updateSelection(n6, n7, n8, n9, n10, n11);
                    this.mCursorSelStart = n;
                    this.mCursorSelEnd = n2;
                    this.mCursorCandStart = n3;
                    this.mCursorCandEnd = n4;
                }
                catch (RemoteException remoteException) {
                    StringBuilder stringBuilder = new StringBuilder().append("IME died: ");
                    String string2 = this.mCurId;
                    String string3 = stringBuilder.append(string2).toString();
                    int n12 = Log.w(TAG, string3, remoteException);
                }
            }
            return;
        }
    }

    public void windowDismissed(IBinder iBinder) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (this.mServedView != null && this.mServedView.getWindowToken() == iBinder) {
                this.finishInputLocked();
            }
            return;
        }
    }

    class ControlledInputConnectionWrapper
    extends IInputConnectionWrapper {
        public ControlledInputConnectionWrapper(Looper looper, InputConnection inputConnection) {
            super(looper, inputConnection);
        }

        @Override
        public boolean isActive() {
            return InputMethodManager.this.mActive;
        }
    }

    class H
    extends Handler {
        H(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                    try {
                        InputMethodManager inputMethodManager = InputMethodManager.this;
                        FileDescriptor fileDescriptor = (FileDescriptor)someArgs.arg1;
                        PrintWriter printWriter = (PrintWriter)someArgs.arg2;
                        String[] stringArray = (String[])someArgs.arg3;
                        inputMethodManager.doDump(fileDescriptor, printWriter, stringArray);
                    }
                    catch (RuntimeException runtimeException) {
                        PrintWriter printWriter = (PrintWriter)someArgs.arg2;
                        String string2 = "Exception: " + runtimeException;
                        printWriter.println(string2);
                    }
                    Object object = someArgs.arg4;
                    synchronized (object) {
                        ((CountDownLatch)someArgs.arg4).countDown();
                        return;
                    }
                }
                case 2: {
                    InputBindResult inputBindResult = (InputBindResult)message.obj;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        int n;
                        int n2;
                        if (InputMethodManager.this.mBindSequence >= 0 && (n2 = InputMethodManager.this.mBindSequence) == (n = inputBindResult.sequence)) {
                            int n3;
                            String string3;
                            IInputMethodSession iInputMethodSession;
                            InputMethodManager inputMethodManager = InputMethodManager.this;
                            inputMethodManager.mCurMethod = iInputMethodSession = inputBindResult.method;
                            InputMethodManager inputMethodManager2 = InputMethodManager.this;
                            inputMethodManager2.mCurId = string3 = inputBindResult.id;
                            InputMethodManager inputMethodManager3 = InputMethodManager.this;
                            inputMethodManager3.mBindSequence = n3 = inputBindResult.sequence;
                            // MONITOREXIT @DISABLED, blocks:[22, 8, 11, 14] lbl33 : MonitorExitStatement: MONITOREXIT : var7_8
                            InputMethodManager.this.startInputInner();
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder().append("Ignoring onBind: cur seq=");
                        int n4 = InputMethodManager.this.mBindSequence;
                        StringBuilder stringBuilder2 = stringBuilder.append(n4).append(", given seq=");
                        int n5 = inputBindResult.sequence;
                        String string4 = stringBuilder2.append(n5).toString();
                        int n6 = Log.w(InputMethodManager.TAG, string4);
                        return;
                    }
                }
                case 3: {
                    int n = message.arg1;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        if (InputMethodManager.this.mBindSequence != n) {
                            InputMethodManager.this.clearBindingLocked();
                            if (InputMethodManager.this.mServedView != null && InputMethodManager.this.mServedView.isFocused()) {
                                InputMethodManager.this.mServedConnecting = true;
                            }
                        }
                        InputMethodManager.this.startInputInner();
                        return;
                    }
                }
                case 4: 
            }
            boolean bl = message.arg1 != 0;
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.mActive = bl;
                InputMethodManager.this.mFullscreenMode = false;
                if (!bl) {
                    InputMethodManager.this.mHasBeenInactive = true;
                    try {
                        InputMethodManager.this.mIInputContext.finishComposingText();
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }
    }
}

