/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.net.http.SslCertificate;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.view.ViewRoot;
import android.view.WindowManager;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CookieSyncManager;
import android.webkit.FrameLoader;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.LoadListener;
import android.webkit.PerfChecker;
import android.webkit.PluginManager;
import android.webkit.URLUtil;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewWorker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class BrowserFrame
extends Handler {
    private static final int DRAWABLEDIR = 3;
    private static final int FILE_UPLOAD_LABEL = 4;
    static final int FRAME_COMPLETED = 1001;
    static final int FRAME_LOADTYPE_BACK = 1;
    static final int FRAME_LOADTYPE_FORWARD = 2;
    static final int FRAME_LOADTYPE_INDEXEDBACKFORWARD = 3;
    static final int FRAME_LOADTYPE_REDIRECT = 7;
    static final int FRAME_LOADTYPE_RELOAD = 4;
    static final int FRAME_LOADTYPE_RELOADALLOWINGSTALEDATA = 5;
    static final int FRAME_LOADTYPE_REPLACE = 8;
    static final int FRAME_LOADTYPE_SAME = 6;
    static final int FRAME_LOADTYPE_STANDARD = 0;
    private static final int LOADERROR = 2;
    private static final String LOGTAG = "webkit";
    private static final int MAX_OUTSTANDING_REQUESTS = 300;
    private static final int NODOMAIN = 1;
    static final int ORIENTATION_CHANGED = 1002;
    static final int POLICY_FUNCTION = 1003;
    static final int POLICY_IGNORE = 2;
    static final int POLICY_USE = 0;
    private static final int RESET_LABEL = 5;
    private static final int SUBMIT_LABEL = 6;
    private static final int TRANSITION_SWITCH_THRESHOLD = 75;
    static ConfigCallback sConfigCallback;
    static JWebCoreJavaBridge sJavaBridge;
    private boolean mBlockMessages = false;
    private final CallbackProxy mCallbackProxy;
    private boolean mCommitted = true;
    private final Context mContext;
    private final WebViewDatabase mDatabase;
    private boolean mFirstLayoutDone = true;
    private boolean mIsMainFrame;
    private Map<String, Object> mJSInterfaceMap;
    boolean mLoadInitFromJava;
    private int mLoadType;
    int mNativeFrame;
    private int mOrientation = -1;
    private final WebSettings mSettings;
    private final WebViewCore mWebViewCore;

    /*
     * Enabled aggressive block sorting
     */
    public BrowserFrame(Context context, WebViewCore webViewCore, CallbackProxy callbackProxy, WebSettings webSettings, Map<String, Object> map) {
        WebViewDatabase webViewDatabase;
        Context context2 = context.getApplicationContext();
        if (sJavaBridge == null) {
            sJavaBridge = new JWebCoreJavaBridge();
            if (((ActivityManager)context.getSystemService("activity")).getMemoryClass() > 16) {
                sJavaBridge.setCacheSize(0x800000);
            } else {
                sJavaBridge.setCacheSize(0x400000);
            }
            CacheManager.init(context2);
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance(context2);
            PluginManager pluginManager = PluginManager.getInstance(context2);
        }
        if (sConfigCallback == null) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            sConfigCallback = new ConfigCallback(windowManager);
            ViewRoot.addConfigCallback(sConfigCallback);
        }
        sConfigCallback.addHandler(this);
        this.mJSInterfaceMap = map;
        this.mSettings = webSettings;
        this.mContext = context;
        this.mCallbackProxy = callbackProxy;
        this.mDatabase = webViewDatabase = WebViewDatabase.getInstance(context2);
        this.mWebViewCore = webViewCore;
        AssetManager assetManager = context.getAssets();
        WebBackForwardList webBackForwardList = callbackProxy.getBackForwardList();
        this.nativeCreateFrame(webViewCore, assetManager, webBackForwardList);
    }

    private void closeWindow(WebViewCore webViewCore) {
        CallbackProxy callbackProxy = this.mCallbackProxy;
        WebView webView = webViewCore.getWebView();
        callbackProxy.onCloseWindow(webView);
    }

    private BrowserFrame createWindow(boolean bl, boolean bl2) {
        return this.mCallbackProxy.createWindow(bl, bl2);
    }

    private void decidePolicyForFormResubmission(int n) {
        Message message = this.obtainMessage(1003, n, 2);
        Message message2 = this.obtainMessage(1003, n, 0);
        this.mCallbackProxy.onFormResubmission(message, message2);
    }

    private float density() {
        return this.mContext.getResources().getDisplayMetrics().density;
    }

    private void didReceiveIcon(Bitmap bitmap) {
        this.mCallbackProxy.onReceivedIcon(bitmap);
    }

    private void didReceiveTouchIconUrl(String string2, boolean bl) {
        this.mCallbackProxy.onReceivedTouchIconUrl(string2, bl);
    }

    private native String documentAsText();

    private native String externalRepresentation();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getFile(String string2, byte[] byArray, int n, int n2) {
        try {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            Uri uri = Uri.parse(string2);
            InputStream inputStream = contentResolver.openInputStream(uri);
            int n3 = inputStream.available();
            if (n3 <= n2 && byArray != null && byArray.length - n >= n3) {
                int n4 = inputStream.read(byArray, n, n3);
            } else {
                n3 = 0;
            }
            inputStream.close();
            return n3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "FileNotFoundException:" + fileNotFoundException;
            int n5 = Log.e(LOGTAG, string3);
            return 0;
        }
        catch (IOException iOException) {
            String string4 = "IOException: " + iOException;
            int n6 = Log.e(LOGTAG, string4);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String string2) {
        int n;
        try {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            Uri uri = Uri.parse(string2);
            InputStream inputStream = contentResolver.openInputStream(uri);
            n = inputStream.available();
            inputStream.close();
            return n;
        }
        catch (Exception exception) {
            return n;
        }
    }

    private native HashMap getFormTextData();

    private native String[] getUsernamePassword();

    private native boolean hasPasswordField();

    private void loadFinished(String string2, int n, boolean bl) {
        if (!bl && n != 0) {
            return;
        }
        if (!bl) {
            return;
        }
        this.resetLoadingStates();
        this.mCallbackProxy.switchOutDrawHistory();
        this.mCallbackProxy.onPageFinished(string2);
    }

    private void loadStarted(String string2, Bitmap bitmap, int n, boolean bl) {
        this.mIsMainFrame = bl;
        if (!bl && n != 0) {
            return;
        }
        this.mLoadType = n;
        if (bl) {
            this.mCallbackProxy.onPageStarted(string2, bitmap);
            this.mFirstLayoutDone = false;
            this.mCommitted = false;
            this.mWebViewCore.removeMessages(130);
        }
        if (n != 0) {
            return;
        }
        if (!this.mSettings.getSaveFormData()) {
            return;
        }
        WebHistoryItem webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        if (webHistoryItem == null) {
            return;
        }
        String string3 = webHistoryItem.getUrl();
        if (string3 == null) {
            return;
        }
        WebViewDatabase webViewDatabase = this.mDatabase;
        HashMap hashMap = this.getFormTextData();
        webViewDatabase.setFormData(string3, hashMap);
    }

    private native void nativeAddJavascriptInterface(int var1, Object var2, String var3);

    private native void nativeCallPolicyFunction(int var1, int var2);

    private native void nativeCreateFrame(WebViewCore var1, AssetManager var2, WebBackForwardList var3);

    private native void nativeGoBackOrForward(int var1);

    private native void nativeLoadData(String var1, String var2, String var3, String var4, String var5);

    private native void nativeLoadUrl(String var1, Map<String, String> var2);

    private native void nativeOrientationChanged(int var1);

    private native void nativePostUrl(String var1, byte[] var2);

    private native void nativeStopLoading();

    private void reportError(int n, String string2, String string3) {
        this.resetLoadingStates();
        this.mCallbackProxy.onReceivedError(n, string2, string3);
    }

    private void requestFocus() {
        this.mCallbackProxy.onRequestFocus();
    }

    private void resetLoadingStates() {
        this.mCommitted = true;
        this.mFirstLayoutDone = true;
    }

    private native void setCacheDisabled(boolean var1);

    private void setProgress(int n) {
        this.mCallbackProxy.onProgressChanged(n);
        if (n == 100) {
            Message message = this.obtainMessage(1001);
            boolean bl = this.sendMessageDelayed(message, 100L);
        }
        if (!this.mFirstLayoutDone) {
            return;
        }
        if (n <= 75) {
            return;
        }
        this.mCallbackProxy.switchOutDrawHistory();
    }

    private void setTitle(String string2) {
        this.mCallbackProxy.onReceivedTitle(string2);
    }

    private native void setUsernamePassword(String var1, String var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LoadListener startLoadingResource(int n, String string2, String string3, HashMap hashMap, byte[] byArray, long l, int n2, boolean bl, boolean bl2, boolean bl3, String string4, String string5) {
        String string6;
        HashMap hashMap2;
        FrameLoader frameLoader;
        PerfChecker perfChecker;
        block11: {
            String string7;
            String string8;
            perfChecker = new PerfChecker();
            if (this.mSettings.getCacheMode() != -1) {
                n2 = this.mSettings.getCacheMode();
            }
            if ((string8 = string3).equals(string7 = "POST")) {
                if (n2 == 0) {
                    n2 = 2;
                }
                if (this.mSettings.getSavePassword() && this.hasPasswordField()) {
                    try {
                        String string9;
                        String string10;
                        String string11;
                        String string12;
                        WebAddress webAddress;
                        String string13 = this.mCallbackProxy.getBackForwardList().getCurrentItem().getUrl();
                        WebAddress webAddress2 = webAddress;
                        String string14 = string13;
                        webAddress2(string14);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string15 = webAddress.mScheme;
                        StringBuilder stringBuilder2 = stringBuilder.append(string15);
                        String string16 = webAddress.mHost;
                        String string17 = stringBuilder2.append(string16).toString();
                        String[] stringArray = this.getUsernamePassword();
                        if (stringArray == null || byArray == null || stringArray[0].length() <= 0 || stringArray[1].length() <= 0) break block11;
                        String string18 = string12;
                        byte[] byArray2 = byArray;
                        string18(byArray2);
                        String string19 = URLEncoder.encode(stringArray[0]);
                        String string20 = string12;
                        String string21 = string19;
                        if (!string20.contains(string21) || !(string11 = string12).contains(string10 = (string9 = URLEncoder.encode(stringArray[1])))) break block11;
                        WebViewDatabase webViewDatabase = this.mDatabase;
                        String string22 = string17;
                        String[] stringArray2 = webViewDatabase.getUsernamePassword(string22);
                        if (stringArray2 != null) {
                            if (stringArray2[0] != null) {
                                WebViewDatabase webViewDatabase2 = this.mDatabase;
                                String string23 = stringArray[0];
                                String string24 = stringArray[1];
                                WebViewDatabase webViewDatabase3 = webViewDatabase2;
                                String string25 = string17;
                                String string26 = string23;
                                String string27 = string24;
                                webViewDatabase3.setUsernamePassword(string25, string26, string27);
                            }
                            break block11;
                        }
                        CallbackProxy callbackProxy = this.mCallbackProxy;
                        String string28 = stringArray[0];
                        String string29 = stringArray[1];
                        CallbackProxy callbackProxy2 = callbackProxy;
                        String string30 = string17;
                        String string31 = string28;
                        String string32 = string29;
                        Message message = null;
                        boolean bl4 = callbackProxy2.onSavePassword(string30, string31, string32, message);
                    }
                    catch (ParseException parseException) {}
                }
            }
        }
        boolean bl5 = this.mIsMainFrame;
        Context context = this.mContext;
        BrowserFrame browserFrame = this;
        String string33 = string2;
        int n3 = n;
        boolean bl6 = bl3;
        boolean bl7 = bl;
        boolean bl8 = bl2;
        long l2 = l;
        String string34 = string4;
        String string35 = string5;
        LoadListener loadListener = LoadListener.getLoadListener(context, browserFrame, string33, n3, bl6, bl5, bl7, bl8, l2, string34, string35);
        CallbackProxy callbackProxy = this.mCallbackProxy;
        String string36 = string2;
        callbackProxy.onLoadResource(string36);
        if (LoadListener.getNativeLoaderCount() > 300) {
            String string37 = this.mContext.getString(17039623);
            LoadListener loadListener2 = loadListener;
            int n4 = -1;
            String string38 = string37;
            loadListener2.error(n4, string38);
            return loadListener;
        }
        WebSettings webSettings = this.mSettings;
        FrameLoader frameLoader2 = frameLoader;
        LoadListener loadListener3 = loadListener;
        WebSettings webSettings2 = webSettings;
        String string39 = string3;
        frameLoader2(loadListener3, webSettings2, string39);
        FrameLoader frameLoader3 = frameLoader;
        HashMap hashMap3 = hashMap;
        frameLoader3.setHeaders(hashMap3);
        FrameLoader frameLoader4 = frameLoader;
        byte[] byArray3 = byArray;
        frameLoader4.setPostData(byArray3);
        HashMap hashMap4 = hashMap;
        String string40 = "If-Modified-Since";
        int n5 = hashMap4.containsKey(string40) || (hashMap2 = hashMap).containsKey(string6 = "If-None-Match") ? 2 : n2;
        FrameLoader frameLoader5 = frameLoader;
        int n6 = n5;
        frameLoader5.setCacheMode(n6);
        if (!frameLoader.executeLoad()) {
            PerfChecker perfChecker2 = perfChecker;
            String string41 = "startLoadingResource fail";
            perfChecker2.responseAlert(string41);
        }
        PerfChecker perfChecker3 = perfChecker;
        String string42 = "startLoadingResource succeed";
        perfChecker3.responseAlert(string42);
        if (bl3) return null;
        return loadListener;
    }

    private void transitionToCommitted(int n, boolean bl) {
        if (!bl) {
            return;
        }
        this.mCommitted = true;
        this.mWebViewCore.getWebView().mViewManager.postResetStateAll();
    }

    private void updateVisitedHistory(String string2, boolean bl) {
        this.mCallbackProxy.doUpdateVisitedHistory(string2, bl);
    }

    private void windowObjectCleared(int n) {
        if (this.mJSInterfaceMap == null) {
            return;
        }
        Iterator<String> iterator = this.mJSInterfaceMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Object object = this.mJSInterfaceMap.get(string2);
            this.nativeAddJavascriptInterface(n, object, string2);
        }
        return;
    }

    public void addJavascriptInterface(Object object, String string2) {
        if (this.mJSInterfaceMap == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.mJSInterfaceMap = hashMap;
        }
        if (this.mJSInterfaceMap.containsKey(string2)) {
            Object object2 = this.mJSInterfaceMap.remove(string2);
        }
        Object object3 = this.mJSInterfaceMap.put(string2, object);
    }

    public native boolean cacheDisabled();

    void certificate(SslCertificate sslCertificate) {
        if (!this.mIsMainFrame) {
            return;
        }
        this.mCallbackProxy.onReceivedCertificate(sslCertificate);
    }

    public native void clearCache();

    boolean committed() {
        return this.mCommitted;
    }

    public void destroy() {
        this.nativeDestroyFrame();
        this.mBlockMessages = true;
        this.removeCallbacksAndMessages(null);
    }

    void didFirstLayout() {
        if (this.mFirstLayoutDone) {
            return;
        }
        this.mFirstLayoutDone = true;
        this.mWebViewCore.contentDraw();
    }

    public void documentAsText(Message message) {
        String string2 = this.documentAsText();
        message.obj = string2;
        message.sendToTarget();
    }

    public native boolean documentHasImages();

    public void externalRepresentation(Message message) {
        String string2 = this.externalRepresentation();
        message.obj = string2;
        message.sendToTarget();
    }

    boolean firstLayoutDone() {
        return this.mFirstLayoutDone;
    }

    CallbackProxy getCallbackProxy() {
        return this.mCallbackProxy;
    }

    /*
     * Unable to fully structure code
     */
    String getRawResFilename(int var1_1) {
        block10: {
            block0 : switch (var1_1) {
                default: {
                    var2_2 = Log.e("webkit", "getRawResFilename got incompatible resource ID");
                    var3_3 = "";
lbl5:
                    // 7 sources

                    return var3_3;
                }
                case 1: {
                    var4_4 = 17563650;
lbl9:
                    // 3 sources

                    while (true) {
                        var5_5 = new TypedValue();
                        this.mContext.getResources().getValue(var4_4, var5_5, true);
                        if (var1_1 != 3) break block10;
                        var6_6 = var5_5.string.toString();
                        var7_7 = var6_6.lastIndexOf(47);
                        if (var7_7 >= 0) break block0;
                        var8_8 = Log.e("webkit", "Can't find drawable directory.");
                        var3_3 = "";
                        ** GOTO lbl5
                        break;
                    }
                }
                case 2: {
                    var4_4 = 0x10C0001;
                    ** GOTO lbl9
                }
                case 3: {
                    var4_4 = 17301688;
                    ** continue;
                }
                case 4: {
                    var3_3 = this.mContext.getResources().getString(17040235);
                    ** GOTO lbl5
                }
                case 5: {
                    var3_3 = this.mContext.getResources().getString(17040236);
                    ** GOTO lbl5
                }
                case 6: {
                    var3_3 = this.mContext.getResources().getString(17040237);
                    ** GOTO lbl5
                }
            }
            var9_9 = var7_7 + 1;
            var3_3 = var6_6.substring(0, var9_9);
            ** GOTO lbl5
        }
        var3_3 = var5_5.string.toString();
        ** while (true)
    }

    String getUserAgentString() {
        return this.mSettings.getUserAgentString();
    }

    public void goBackOrForward(int n) {
        this.mLoadInitFromJava = true;
        this.nativeGoBackOrForward(n);
        this.mLoadInitFromJava = false;
    }

    @Override
    public void handleMessage(Message message) {
        int n;
        if (this.mBlockMessages) {
            return;
        }
        switch (message.what) {
            default: {
                return;
            }
            case 1001: {
                WebHistoryItem webHistoryItem;
                if (this.mSettings.getSavePassword() && this.hasPasswordField() && (webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem()) != null) {
                    String string2;
                    String string3 = webHistoryItem.getUrl();
                    WebAddress webAddress = new WebAddress(string3);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = webAddress.mScheme;
                    StringBuilder stringBuilder2 = stringBuilder.append(string4);
                    String string5 = stringBuilder2.append(string2 = webAddress.mHost).toString();
                    String[] stringArray = this.mDatabase.getUsernamePassword(string5);
                    if (stringArray != null && stringArray[0] != null) {
                        String string6 = stringArray[0];
                        String string7 = stringArray[1];
                        this.setUsernamePassword(string6, string7);
                    }
                }
                boolean bl = WebViewWorker.getHandler().sendEmptyMessage(108);
                return;
            }
            case 1003: {
                int n2 = message.arg1;
                int n3 = message.arg2;
                this.nativeCallPolicyFunction(n2, n3);
                return;
            }
            case 1002: 
        }
        int n4 = this.mOrientation;
        int n5 = message.arg1;
        if (n4 != n5) {
            return;
        }
        this.mOrientation = n = message.arg1;
        int n6 = message.arg1;
        this.nativeOrientationChanged(n6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleUrl(String string2) {
        if (this.mLoadInitFromJava) {
            return false;
        }
        if (!this.mCallbackProxy.shouldOverrideUrlLoading(string2)) return false;
        this.didFirstLayout();
        return true;
    }

    public void loadData(String string2, String string3, String string4, String string5, String string6) {
        this.mLoadInitFromJava = true;
        if (string6 == null || string6.length() == 0) {
            string6 = "about:blank";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "about:blank";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "text/html";
        }
        this.nativeLoadData(string2, string3, string4, string5, string6);
        this.mLoadInitFromJava = false;
    }

    int loadType() {
        return this.mLoadType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadUrl(String string2, Map<String, String> map) {
        this.mLoadInitFromJava = true;
        if (URLUtil.isJavaScriptUrl(string2)) {
            int n = "javascript:".length();
            String string3 = string2.substring(n);
            String string4 = this.stringByEvaluatingJavaScriptFromString(string3);
        } else {
            this.nativeLoadUrl(string2, map);
        }
        this.mLoadInitFromJava = false;
    }

    public native void nativeDestroyFrame();

    public void postUrl(String string2, byte[] byArray) {
        this.mLoadInitFromJava = true;
        this.nativePostUrl(string2, byArray);
        this.mLoadInitFromJava = false;
    }

    public native void reload(boolean var1);

    public void stopLoading() {
        if (this.mIsMainFrame) {
            this.resetLoadingStates();
        }
        this.nativeStopLoading();
    }

    public native String stringByEvaluatingJavaScriptFromString(String var1);

    private static class ConfigCallback
    implements ComponentCallbacks {
        private final ArrayList<WeakReference<Handler>> mHandlers;
        private final WindowManager mWindowManager;

        ConfigCallback(WindowManager windowManager) {
            ArrayList arrayList = new ArrayList();
            this.mHandlers = arrayList;
            this.mWindowManager = windowManager;
        }

        public void addHandler(Handler handler) {
            synchronized (this) {
                ArrayList<WeakReference<Handler>> arrayList = this.mHandlers;
                WeakReference<Handler> weakReference = new WeakReference<Handler>(handler);
                boolean bl = arrayList.add(weakReference);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConfigurationChanged(Configuration configuration) {
            if (this.mHandlers.size() == 0) {
                return;
            }
            int n = this.mWindowManager.getDefaultDisplay().getOrientation();
            switch (n) {
                case 1: {
                    n = 90;
                    break;
                }
                case 2: {
                    n = 180;
                    break;
                }
                case 3: {
                    n = 65446;
                    break;
                }
                case 0: {
                    n = 0;
                }
            }
            synchronized (this) {
                int n2 = this.mHandlers.size();
                ArrayList<WeakReference<Handler>> arrayList = new ArrayList<WeakReference<Handler>>(n2);
                for (WeakReference<Handler> weakReference : this.mHandlers) {
                    Handler handler = (Handler)weakReference.get();
                    if (handler != null) {
                        Message message = handler.obtainMessage(1002, n, 0);
                        boolean bl = handler.sendMessage(message);
                        continue;
                    }
                    boolean bl = arrayList.add(weakReference);
                }
                Iterator<WeakReference<Handler>> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    WeakReference<Handler> weakReference = iterator.next();
                    boolean bl = this.mHandlers.remove(weakReference);
                }
                return;
            }
        }

        @Override
        public void onLowMemory() {
        }
    }
}

