/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.ListIterator;

class ByteArrayBuilder {
    private static final int DEFAULT_CAPACITY = 8192;
    private static final LinkedList<SoftReference<Chunk>> sPool = new LinkedList();
    private static final ReferenceQueue<Chunk> sQueue = new ReferenceQueue();
    private LinkedList<Chunk> mChunks;

    public ByteArrayBuilder() {
        LinkedList linkedList = new LinkedList();
        this.mChunks = linkedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk obtainChunk(int n) {
        if (n < 8192) {
            n = 8192;
        }
        LinkedList<SoftReference<Chunk>> linkedList = sPool;
        synchronized (linkedList) {
            Chunk chunk;
            this.processPoolLocked();
            if (!sPool.isEmpty() && (chunk = (Chunk)sPool.removeFirst().get()) != null) {
                return chunk;
            }
            Chunk chunk2 = new Chunk(n);
            return chunk2;
        }
    }

    private void processPoolLocked() {
        SoftReference softReference;
        while ((softReference = (SoftReference)sQueue.poll()) != null) {
            boolean bl = sPool.remove(softReference);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(byte[] byArray, int n, int n2) {
        synchronized (this) {
            while (n2 > 0) {
                int n3;
                Chunk chunk;
                if (this.mChunks.isEmpty()) {
                    chunk = this.obtainChunk(n2);
                    this.mChunks.addLast(chunk);
                } else {
                    chunk = this.mChunks.getLast();
                    int n4 = chunk.mLength;
                    int n5 = chunk.mArray.length;
                    if (n4 != n5) {
                        chunk = this.obtainChunk(n2);
                        this.mChunks.addLast(chunk);
                    }
                }
                int n6 = chunk.mArray.length;
                int n7 = chunk.mLength;
                int n8 = n6 - n7;
                int n9 = Math.min(n2, n8);
                byte[] byArray2 = chunk.mArray;
                int n10 = chunk.mLength;
                System.arraycopy(byArray, n, byArray2, n10, n9);
                chunk.mLength = n3 = chunk.mLength + n9;
                n2 -= n9;
                n += n9;
            }
            return;
        }
    }

    public void clear() {
        synchronized (this) {
            Chunk chunk = this.getFirstChunk();
            while (chunk != null) {
                Chunk chunk2;
                chunk.release();
                chunk = chunk2 = this.getFirstChunk();
            }
            return;
        }
    }

    public int getByteSize() {
        synchronized (this) {
            int n = 0;
            ListIterator<Chunk> listIterator = this.mChunks.listIterator(0);
            while (listIterator.hasNext()) {
                int n2 = listIterator.next().mLength;
                n += n2;
            }
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chunk getFirstChunk() {
        synchronized (this) {
            block6: {
                boolean bl = this.mChunks.isEmpty();
                if (!bl) break block6;
                return null;
            }
            Chunk chunk = this.mChunks.removeFirst();
            return chunk;
        }
    }

    public boolean isEmpty() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = this.mChunks.isEmpty();
            return bl2;
        }
    }

    public static class Chunk {
        public byte[] mArray;
        public int mLength;

        public Chunk(int n) {
            byte[] byArray = new byte[n];
            this.mArray = byArray;
            this.mLength = 0;
        }

        public void release() {
            this.mLength = 0;
            LinkedList linkedList = sPool;
            synchronized (linkedList) {
                LinkedList linkedList2 = sPool;
                ReferenceQueue referenceQueue = sQueue;
                SoftReference<Chunk> softReference = new SoftReference<Chunk>(this, referenceQueue);
                boolean bl = linkedList2.offer(softReference);
                sPool.notifyAll();
                return;
            }
        }
    }
}

