/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.text.TextUtils;
import android.webkit.CacheManager;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.InputStream;

class CacheLoader
extends StreamLoader {
    CacheManager.CacheResult mCacheResult;

    CacheLoader(LoadListener loadListener, CacheManager.CacheResult cacheResult) {
        super(loadListener);
        this.mCacheResult = cacheResult;
    }

    @Override
    protected void buildHeaders(Headers headers) {
        String string2 = this.mCacheResult.mimeType;
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (!TextUtils.isEmpty(this.mCacheResult.encoding)) {
            StringBuilder stringBuilder2 = stringBuilder.append(';');
            String string3 = this.mCacheResult.encoding;
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
        }
        String string4 = stringBuilder.toString();
        headers.setContentType(string4);
        if (!TextUtils.isEmpty(this.mCacheResult.location)) {
            String string5 = this.mCacheResult.location;
            headers.setLocation(string5);
        }
        if (!TextUtils.isEmpty(this.mCacheResult.expiresString)) {
            String string6 = this.mCacheResult.expiresString;
            headers.setExpires(string6);
        }
        if (!TextUtils.isEmpty(this.mCacheResult.contentdisposition)) {
            String string7 = this.mCacheResult.contentdisposition;
            headers.setContentDisposition(string7);
        }
        if (TextUtils.isEmpty(this.mCacheResult.crossDomain)) {
            return;
        }
        String string8 = this.mCacheResult.crossDomain;
        headers.setXPermittedCrossDomainPolicies(string8);
    }

    @Override
    protected boolean setupStreamAndSendStatus() {
        long l;
        InputStream inputStream;
        this.mDataStream = inputStream = this.mCacheResult.inStream;
        this.mContentLength = l = this.mCacheResult.contentLength;
        LoadListener loadListener = this.mLoadListener;
        int n = this.mCacheResult.httpStatusCode;
        loadListener.status(1, 1, n, "OK");
        return true;
    }
}

