/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.Headers;
import android.os.FileUtils;
import android.util.Log;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public final class CacheManager {
    static long CACHE_MAX_SIZE = 0L;
    private static long CACHE_THRESHOLD = 0L;
    private static long CACHE_TRIM_AMOUNT = 0L;
    static final String HEADER_KEY_IFMODIFIEDSINCE = "if-modified-since";
    static final String HEADER_KEY_IFNONEMATCH = "if-none-match";
    private static final String LOGTAG = "cache";
    private static final String MANIFEST_MIME = "text/cache-manifest";
    private static final String MAX_AGE = "max-age";
    private static final String NO_CACHE = "no-cache";
    private static final String NO_STORE = "no-store";
    private static final int TRIM_CACHE_INTERVAL = 5;
    private static File mBaseDir;
    private static boolean mClearCacheOnInit;
    private static WebViewDatabase mDataBase;
    private static boolean mDisabled;
    private static int mRefCount;
    private static int mTrimCacheCount;

    static {
        CACHE_THRESHOLD = 0x600000L;
        CACHE_TRIM_AMOUNT = 0x200000L;
        long l = CACHE_THRESHOLD;
        long l2 = CACHE_TRIM_AMOUNT;
        CACHE_MAX_SIZE = (l - l2) / 2L;
        mTrimCacheCount = 0;
        mClearCacheOnInit = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void appendAsHex(int n, StringBuffer stringBuffer) {
        String string2 = Integer.toHexString(n);
        switch (string2.length()) {
            case 1: {
                StringBuffer stringBuffer2 = stringBuffer.append("0000000");
                break;
            }
            case 2: {
                StringBuffer stringBuffer3 = stringBuffer.append("000000");
                break;
            }
            case 3: {
                StringBuffer stringBuffer4 = stringBuffer.append("00000");
                break;
            }
            case 4: {
                StringBuffer stringBuffer5 = stringBuffer.append("0000");
                break;
            }
            case 5: {
                StringBuffer stringBuffer6 = stringBuffer.append("000");
                break;
            }
            case 6: {
                StringBuffer stringBuffer7 = stringBuffer.append("00");
                break;
            }
            case 7: {
                StringBuffer stringBuffer8 = stringBuffer.append("0");
                break;
            }
        }
        StringBuffer stringBuffer9 = stringBuffer.append(string2);
    }

    public static boolean cacheDisabled() {
        return mDisabled;
    }

    static boolean cacheEmpty() {
        return mDataBase.hasCache();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkCacheRedirect(int n) {
        if (n == 301) return true;
        if (n == 302) return true;
        if (n != 307) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean cleanupCacheFile(CacheResult cacheResult) {
        try {
            cacheResult.outStream.close();
            return cacheResult.outFile.delete();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static void clearCache() {
        mDataBase.clearCache();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean createCacheDirectory() {
        if (mBaseDir.exists()) return false;
        if (!mBaseDir.mkdirs()) {
            int n = Log.w(LOGTAG, "Unable to create webviewCache directory");
            return false;
        }
        int n = FileUtils.setPermissions(mBaseDir.toString(), 505, -1, -1);
        boolean bl = WebViewWorker.getHandler().sendEmptyMessage(109);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CacheResult createCacheFile(String string2, int n, Headers headers, String string3, long l, boolean bl) {
        if (!bl && mDisabled) {
            return null;
        }
        String string4 = CacheManager.getDatabaseKey(string2, l);
        if (n == 303) {
            mDataBase.removeCache(string4);
            return null;
        }
        if (CacheManager.checkCacheRedirect(n) && !headers.getSetCookie().isEmpty()) {
            mDataBase.removeCache(string4);
            return null;
        }
        CacheResult cacheResult = CacheManager.parseHeaders(n, headers, string3);
        if (cacheResult != null) {
            CacheManager.setupFiles(string4, cacheResult);
            try {
                File file = cacheResult.outFile;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                cacheResult.outStream = fileOutputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!CacheManager.createCacheDirectory()) {
                    return null;
                }
                try {
                    File file = cacheResult.outFile;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    cacheResult.outStream = fileOutputStream;
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    return null;
                }
            }
        } else {
            mDataBase.removeCache(string4);
            return cacheResult;
        }
        cacheResult.mimeType = string3;
        return cacheResult;
    }

    public static CacheResult createCacheFile(String string2, int n, Headers headers, String string3, boolean bl) {
        String string4 = string2;
        int n2 = n;
        Headers headers2 = headers;
        String string5 = string3;
        boolean bl2 = bl;
        return CacheManager.createCacheFile(string4, n2, headers2, string5, 0L, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean disableTransaction() {
        int n;
        mRefCount = n = mRefCount - 1;
        if (n != 0) return false;
        boolean bl = mDataBase.endCacheTransaction();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean enableTransaction() {
        int n;
        mRefCount = n = mRefCount + 1;
        if (n != 1) return false;
        boolean bl = mDataBase.startCacheTransaction();
        return true;
    }

    @Deprecated
    public static boolean endCacheTransaction() {
        return false;
    }

    static boolean endTransaction() {
        int n;
        boolean bl = mDataBase.endCacheTransaction();
        mTrimCacheCount = n = mTrimCacheCount + 1;
        if (n >= 5) {
            mTrimCacheCount = 0;
            CacheManager.trimCacheIfNeeded();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CacheResult getCacheFile(String string2, long l, Map<String, String> map) {
        if (mDisabled) {
            return null;
        }
        String string3 = CacheManager.getDatabaseKey(string2, l);
        CacheResult cacheResult = mDataBase.getCache(string3);
        if (cacheResult == null) {
            return null;
        }
        if (cacheResult.contentLength == 0L) {
            if (!CacheManager.checkCacheRedirect(cacheResult.httpStatusCode)) {
                mDataBase.removeCache(string3);
                return null;
            }
        } else {
            File file = mBaseDir;
            String string4 = cacheResult.localPath;
            File file2 = new File(file, string4);
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                cacheResult.inStream = fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                mDataBase.removeCache(string3);
                return null;
            }
        }
        if (map == null) return cacheResult;
        if (cacheResult.expires < 0L) return cacheResult;
        long l2 = cacheResult.expires;
        long l3 = System.currentTimeMillis();
        if (l2 > l3) return cacheResult;
        if (cacheResult.lastModified == null && cacheResult.etag == null) {
            return null;
        }
        if (cacheResult.etag != null) {
            String string5 = cacheResult.etag;
            String string6 = map.put(HEADER_KEY_IFNONEMATCH, string5);
        }
        if (cacheResult.lastModified == null) return cacheResult;
        String string7 = cacheResult.lastModified;
        String string8 = map.put(HEADER_KEY_IFMODIFIEDSINCE, string7);
        return cacheResult;
    }

    public static CacheResult getCacheFile(String string2, Map<String, String> map) {
        return CacheManager.getCacheFile(string2, 0L, map);
    }

    public static File getCacheFileBaseDir() {
        return mBaseDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDatabaseKey(String string2, long l) {
        if (l != 0L) return l + string2;
        return string2;
    }

    static void init(Context context) {
        mDataBase = WebViewDatabase.getInstance(context.getApplicationContext());
        File file = context.getCacheDir();
        mBaseDir = new File(file, "webviewCache");
        if (!CacheManager.createCacheDirectory()) {
            return;
        }
        if (!mClearCacheOnInit) {
            return;
        }
        boolean bl = CacheManager.removeAllCacheFiles();
        mClearCacheOnInit = false;
    }

    /*
     * Exception decompiling
     */
    private static CacheResult parseHeaders(int var0, Headers var1, String var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean removeAllCacheFiles() {
        if (mBaseDir == null) {
            mClearCacheOnInit = true;
            return true;
        }
        boolean bl = WebViewWorker.getHandler().sendEmptyMessage(109);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String[] stringArray = mBaseDir.list();
                    if (stringArray == null) {
                        return;
                    }
                    int n = 0;
                    while (true) {
                        String string2;
                        int n2;
                        if (n >= (n2 = stringArray.length)) {
                            return;
                        }
                        File file = mBaseDir;
                        File file2 = new File(file, string2 = stringArray[n]);
                        if (!file2.delete()) {
                            StringBuilder stringBuilder = new StringBuilder();
                            String string3 = file2.getPath();
                            String string4 = stringBuilder.append(string3).append(" delete failed.").toString();
                            int n3 = Log.e(CacheManager.LOGTAG, string4);
                        }
                        ++n;
                    }
                }
                catch (SecurityException securityException) {
                    return;
                }
            }
        };
        new Thread(runnable).start();
        return true;
    }

    static void saveCacheFile(String string2, long l, CacheResult cacheResult) {
        try {
            cacheResult.outStream.close();
            if (!cacheResult.outFile.exists()) {
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        boolean bl = CacheManager.checkCacheRedirect(cacheResult.httpStatusCode);
        if (bl) {
            cacheResult.contentLength = 0L;
            cacheResult.localPath = "";
        }
        if ((bl || cacheResult.contentLength == 0L) && !cacheResult.outFile.delete()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = cacheResult.outFile.getPath();
            String string4 = stringBuilder.append(string3).append(" delete failed.").toString();
            int n = Log.e(LOGTAG, string4);
        }
        if (cacheResult.contentLength == 0L) {
            return;
        }
        WebViewDatabase webViewDatabase = mDataBase;
        String string5 = CacheManager.getDatabaseKey(string2, l);
        webViewDatabase.addCache(string5, cacheResult);
    }

    public static void saveCacheFile(String string2, CacheResult cacheResult) {
        CacheManager.saveCacheFile(string2, 0L, cacheResult);
    }

    static void setCacheDisabled(boolean bl) {
        boolean bl2 = mDisabled;
        if (bl != bl2) {
            return;
        }
        mDisabled = bl;
        if (!mDisabled) {
            return;
        }
        boolean bl3 = CacheManager.removeAllCacheFiles();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setupFiles(String string2, CacheResult cacheResult) {
        int n = string2.hashCode();
        StringBuffer stringBuffer = new StringBuffer(8);
        CacheManager.appendAsHex(n, stringBuffer);
        String string3 = stringBuffer.toString();
        File file = mBaseDir;
        File file2 = new File(file, string3);
        boolean bl = true;
        while (file2.exists()) {
            if (bl) {
                CacheResult cacheResult2 = mDataBase.getCache(string2);
                if (cacheResult2 != null && cacheResult2.contentLength > 0L) {
                    String string4 = cacheResult2.localPath;
                    if (string3.equals(string4)) {
                        string3 = cacheResult2.localPath;
                        break;
                    }
                    string3 = cacheResult2.localPath;
                    File file3 = mBaseDir;
                    file2 = new File(file3, string3);
                    break;
                }
                bl = false;
            }
            StringBuffer stringBuffer2 = new StringBuffer(8);
            CacheManager.appendAsHex(++n, stringBuffer2);
            string3 = stringBuffer2.toString();
            File file4 = mBaseDir;
            file2 = new File(file4, string3);
        }
        cacheResult.localPath = string3;
        cacheResult.outFile = file2;
    }

    @Deprecated
    public static boolean startCacheTransaction() {
        return false;
    }

    static boolean startTransaction() {
        return mDataBase.startCacheTransaction();
    }

    static void trimCacheIfNeeded() {
        int n;
        long l;
        long l2 = mDataBase.getCacheTotalSize();
        if (l2 <= (l = CACHE_THRESHOLD)) {
            return;
        }
        WebViewDatabase webViewDatabase = mDataBase;
        long l3 = CACHE_TRIM_AMOUNT;
        List<String> list = webViewDatabase.trimCache(l3);
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            File file = mBaseDir;
            String string2 = list.get(n);
            File file2 = new File(file, string2);
            if (file2.delete()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = file2.getPath();
            String string4 = stringBuilder.append(string3).append(" delete failed.").toString();
            int n3 = Log.e(LOGTAG, string4);
        }
        final List<String> list2 = mDataBase.getAllCacheFileNames();
        if (list2 == null) {
            return;
        }
        File file = mBaseDir;
        FilenameFilter filenameFilter = new FilenameFilter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean accept(File file, String string2) {
                if (!list2.contains(string2)) return true;
                return false;
            }
        };
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return;
        }
        n2 = stringArray.length;
        n = 0;
        while (n < n2) {
            File file3 = mBaseDir;
            String string5 = stringArray[n];
            File file4 = new File(file3, string5);
            if (!file4.delete()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string6 = file4.getPath();
                String string7 = stringBuilder.append(string6).append(" delete failed.").toString();
                int n4 = Log.e(LOGTAG, string7);
            }
            ++n;
        }
        return;
    }

    public static class CacheResult {
        long contentLength;
        String contentdisposition;
        String crossDomain;
        String encoding;
        String etag;
        long expires;
        String expiresString;
        int httpStatusCode;
        InputStream inStream;
        String lastModified;
        String localPath;
        String location;
        String mimeType;
        File outFile;
        OutputStream outStream;

        public String getContentDisposition() {
            return this.contentdisposition;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getETag() {
            return this.etag;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public long getExpires() {
            return this.expires;
        }

        public String getExpiresString() {
            return this.expiresString;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public InputStream getInputStream() {
            return this.inStream;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public OutputStream getOutputStream() {
            return this.outStream;
        }

        public void setEncoding(String string2) {
            this.encoding = string2;
        }

        public void setInputStream(InputStream inputStream) {
            this.inStream = inputStream;
        }
    }
}

