/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.security.Credentials;
import android.util.Log;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.util.encoders.Base64;

class CertTool {
    static final String CERT = "CERT";
    private static final String LOGTAG = "CertTool";
    private static final AlgorithmIdentifier MD5_WITH_RSA;
    static final String PKCS12 = "PKCS12";

    static {
        DERObjectIdentifier dERObjectIdentifier = PKCSObjectIdentifiers.md5WithRSAEncryption;
        MD5_WITH_RSA = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    private CertTool() {
    }

    static void addCertificate(Context context, String string2, byte[] byArray) {
        Credentials.getInstance().install(context, string2, byArray);
    }

    static String[] getKeyStrengthList() {
        String[] stringArray = new String[]{"High Grade", "Medium Grade"};
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getSignedPublicKey(Context context, int n, String string2) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            String string3 = n == 0 ? null : null;
            keyPairGenerator.initialize((int)string3);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            AlgorithmIdentifier algorithmIdentifier = MD5_WITH_RSA;
            PublicKey publicKey = keyPair.getPublic();
            NetscapeCertRequest netscapeCertRequest = new NetscapeCertRequest(string2, algorithmIdentifier, publicKey);
            PrivateKey privateKey = keyPair.getPrivate();
            netscapeCertRequest.sign(privateKey);
            byte[] byArray = netscapeCertRequest.toASN1Object().getDEREncoded();
            Credentials.getInstance().install(context, keyPair);
            byte[] byArray2 = Base64.encode((byte[])byArray);
            return new String(byArray2);
        }
        catch (Exception exception) {
            int n2 = Log.w(LOGTAG, exception);
            return null;
        }
    }
}

