/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.AndroidHttpClient;
import android.util.Log;
import android.webkit.CookieSyncManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

public final class CookieManager {
    private static final String[] BAD_COUNTRY_2LDS;
    private static final char COMMA = ',';
    private static final CookieComparator COMPARATOR;
    private static final String DOMAIN = "domain";
    private static final char EQUAL = '=';
    private static final String EXPIRES = "expires";
    private static final String HTTPS = "https";
    private static final String HTTP_ONLY = "httponly";
    private static final int HTTP_ONLY_LENGTH = 0;
    private static final String LOGTAG = "webkit";
    private static final String MAX_AGE = "max-age";
    private static final int MAX_COOKIE_COUNT_PER_BASE_DOMAIN = 50;
    private static final int MAX_COOKIE_LENGTH = 4096;
    private static final int MAX_DOMAIN_COUNT = 200;
    private static final int MAX_RAM_COOKIES_COUNT = 1000;
    private static final int MAX_RAM_DOMAIN_COUNT = 15;
    private static final String PATH = "path";
    private static final char PATH_DELIM = '/';
    private static final char PERIOD = '.';
    private static final char QUESTION_MARK = '?';
    private static final char QUOTATION = '\"';
    private static final String SECURE = "secure";
    private static final int SECURE_LENGTH = 0;
    private static final char SEMICOLON = ';';
    private static final char WHITE_SPACE = ' ';
    private static CookieManager sRef;
    private boolean mAcceptCookie;
    private Map<String, ArrayList<Cookie>> mCookieMap;

    static {
        SECURE_LENGTH = SECURE.length();
        HTTP_ONLY_LENGTH = HTTP_ONLY.length();
        String[] stringArray = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
        BAD_COUNTRY_2LDS = stringArray;
        Arrays.sort(BAD_COUNTRY_2LDS);
        COMPARATOR = new CookieComparator();
    }

    private CookieManager() {
        LinkedHashMap<String, ArrayList<Cookie>> linkedHashMap = new LinkedHashMap<String, ArrayList<Cookie>>(200, 0.75f, true);
        this.mCookieMap = linkedHashMap;
        this.mAcceptCookie = true;
    }

    static /* synthetic */ Map access$102(CookieManager cookieManager, Map map) {
        cookieManager.mCookieMap = map;
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBaseDomain(String string2) {
        int n = 0;
        int n2 = string2.indexOf(46);
        int n3 = string2.lastIndexOf(46);
        while (n2 < n3) {
            n = n2 + 1;
            n2 = string2.indexOf(46, n);
        }
        if (n <= 0) return string2;
        return string2.substring(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] getHostAndPath(WebAddress webAddress) {
        String string2;
        String string3;
        if (webAddress.mHost == null) return null;
        if (webAddress.mPath == null) return null;
        String string4 = webAddress.mHost.toLowerCase();
        String[] stringArray = new String[]{string4, string3 = webAddress.mPath};
        int n = stringArray[0].indexOf(46);
        if (n == -1) {
            if (webAddress.mScheme.equalsIgnoreCase("file")) {
                stringArray[0] = "localhost";
            }
        } else {
            int n2 = stringArray[0].lastIndexOf(46);
            if (n != n2) {
                String string5;
                StringBuilder stringBuilder = new StringBuilder().append('.');
                String string6 = stringArray[0];
                stringArray[0] = string5 = stringBuilder.append(string6).toString();
            }
        }
        if (stringArray[1].charAt(0) != '/') {
            return null;
        }
        n = stringArray[1].indexOf(63);
        if (n == -1) return stringArray;
        stringArray[1] = string2 = stringArray[1].substring(0, n);
        return stringArray;
    }

    public static CookieManager getInstance() {
        synchronized (CookieManager.class) {
            if (sRef == null) {
                sRef = new CookieManager();
            }
            CookieManager cookieManager = sRef;
            return cookieManager;
        }
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<Cookie> parseCookie(String var1_1, String var2_2, String var3_3) {
        block28: {
            block34: {
                block33: {
                    block32: {
                        block22: {
                            block31: {
                                block30: {
                                    block29: {
                                        block27: {
                                            block26: {
                                                block25: {
                                                    block21: {
                                                        block24: {
                                                            block23: {
                                                                var4_4 = new ArrayList<Cookie>();
                                                                var5_5 = 0;
                                                                var6_6 = var3_3.length();
                                                                block6: while (true) {
                                                                    if (var5_5 < 0 || var5_5 >= var6_6) lbl-1000:
                                                                    // 2 sources

                                                                    {
                                                                        return var4_4;
                                                                    }
                                                                    var7_7 = var3_3;
                                                                    if ((var9_9 = var7_7.charAt(var8_8 = var5_5++)) == (var10_10 = ' ')) continue;
                                                                    var11_11 = var3_3;
                                                                    var12_12 = 59;
                                                                    var13_13 = var5_5;
                                                                    var14_14 = var11_11.indexOf(var12_12, var13_13);
                                                                    var15_15 = var3_3;
                                                                    var16_16 = 61;
                                                                    var17_17 = var5_5;
                                                                    var18_18 = var15_15.indexOf(var16_16, var17_17);
                                                                    var20_20 = var19_19;
                                                                    var21_21 = var1_1;
                                                                    var22_22 = var2_2;
                                                                    var20_20(var21_21, var22_22);
                                                                    var23_23 = var14_14;
                                                                    var24_24 = 65535;
                                                                    if ((var23_23 == var24_24 || (var25_25 = var14_14) >= (var26_26 = var18_18)) && (var27_27 = var18_18) != (var28_28 = 65535)) break;
                                                                    var29_29 = var14_14;
                                                                    var30_30 = 65535;
                                                                    if (var29_29 == var30_30) {
                                                                        var14_14 = var6_6;
                                                                    }
                                                                    var31_31 = var3_3;
                                                                    var32_32 = var5_5;
                                                                    var33_33 = var14_14;
                                                                    var19_19.name = var34_34 = var31_31.substring(var32_32, var33_33);
                                                                    var35_35 = null;
                                                                    var19_19.value = var35_35;
lbl35:
                                                                    // 4 sources

                                                                    while (true) {
                                                                        var5_5 = var14_14;
lbl37:
                                                                        // 19 sources

                                                                        while (true) {
                                                                            if (var5_5 < 0 || var5_5 >= var6_6) lbl-1000:
                                                                            // 4 sources

                                                                            {
                                                                                while (true) {
                                                                                    if (var19_19 == null || var19_19.domain == null) continue block6;
                                                                                    var36_36 = var4_4.add(var19_19);
                                                                                    continue block6;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            break block21;
                                                                            break;
                                                                        }
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                                var37_37 = var3_3;
                                                                var38_38 = var5_5;
                                                                var39_39 = var18_18;
                                                                var19_19.name = var40_40 = var37_37.substring(var38_38, var39_39);
                                                                ** while ((var42_42 = var18_18) < (var43_43 = (var41_41 = var6_6 - 1)) && (var47_47 = (var45_45 = var3_3).charAt((int)(var46_46 = (var44_44 = var18_18 + 1)))) == (var48_48 = '\"') && (var53_53 = (var5_5 = (var50_50 = var3_3).indexOf((int)(var51_51 = 34), (int)(var52_52 = (var49_49 = var18_18 + 2))))) == (var54_54 = 65535))
lbl49:
                                                                // 1 sources

                                                                var55_55 = var3_3;
                                                                var56_56 = 59;
                                                                var57_57 = var5_5;
                                                                var14_14 = var55_55.indexOf(var56_56, var57_57);
                                                                var58_58 = var14_14;
                                                                if (var58_58 == (var59_59 = 65535)) {
                                                                    var60_60 = var6_6;
                                                                }
                                                                if ((var61_61 = var14_14 - var18_18) <= (var62_62 = 4096)) break block23;
                                                                var63_63 = var18_18 + 1;
                                                                var64_64 = var18_18 + 1 + 4096;
                                                                var65_65 = var3_3;
                                                                var66_66 = var63_63;
                                                                var67_67 = var64_64;
                                                                var19_19.value = var68_68 = var65_65.substring(var66_66, var67_67);
                                                                ** GOTO lbl35
                                                            }
                                                            var69_69 = var18_18 + 1;
                                                            var70_70 = var14_14;
                                                            if (var69_69 != var70_70 && (var71_71 = var14_14) >= (var72_72 = var18_18)) break block24;
                                                            var19_19.value = var73_73 = "";
                                                            ** GOTO lbl35
                                                        }
                                                        var74_74 = var18_18 + 1;
                                                        var75_75 = var3_3;
                                                        var76_76 = var74_74;
                                                        var77_77 = var14_14;
                                                        var19_19.value = var78_78 = var75_75.substring(var76_76, var77_77);
                                                        ** while (true)
                                                    }
                                                    var79_79 = var3_3;
                                                    var80_80 = var5_5;
                                                    var81_81 = var79_79.charAt(var80_80);
                                                    if (var81_81 != (var82_82 = ' ') && (var85_85 = (var83_83 = var3_3).charAt(var84_84 = var5_5)) != (var86_86 = ';')) break block25;
                                                    ++var5_5;
                                                    ** GOTO lbl37
                                                }
                                                var87_87 = var3_3;
                                                if ((var89_89 = var87_87.charAt(var88_88 = var5_5++)) == (var90_90 = ',')) ** GOTO lbl-1000
                                                var91_91 = var6_6 - var5_5;
                                                var93_93 = var91_91;
                                                var92_92 = CookieManager.SECURE_LENGTH;
                                                var94_94 = var92_92;
                                                if (var93_93 < var94_94 || !(var96_96 = var3_3).substring(var97_97 = var5_5, var98_98 = (var95_95 = CookieManager.SECURE_LENGTH + var5_5)).equalsIgnoreCase("secure")) break block26;
                                                var99_99 = CookieManager.SECURE_LENGTH;
                                                var19_19.secure = var100_100 = true;
                                                if ((var5_5 += var99_99) == var6_6) ** GOTO lbl-1000
                                                var101_101 = var3_3;
                                                if ((var103_103 = var101_101.charAt(var102_102 = var5_5++)) != (var104_104 = '=')) ** GOTO lbl37
                                                ** GOTO lbl37
                                            }
                                            var105_105 = var6_6 - var5_5;
                                            var107_107 = var105_105;
                                            var106_106 = CookieManager.HTTP_ONLY_LENGTH;
                                            var108_108 = var106_106;
                                            if (var107_107 < var108_108 || !(var110_110 = var3_3).substring(var111_111 = var5_5, var112_112 = (var109_109 = CookieManager.HTTP_ONLY_LENGTH + var5_5)).equalsIgnoreCase("httponly")) break block27;
                                            var113_113 = CookieManager.HTTP_ONLY_LENGTH;
                                            if ((var5_5 += var113_113) != var6_6) ** break;
                                            ** while (true)
                                            var114_114 = var3_3;
                                            if ((var116_116 = var114_114.charAt(var115_115 = var5_5++)) == (var117_117 = '=')) {
                                                // empty if block
                                            }
                                            ** GOTO lbl37
                                        }
                                        var118_118 = var3_3;
                                        var119_119 = 61;
                                        var120_120 = var5_5;
                                        var18_18 = var118_118.indexOf(var119_119, var120_120);
                                        if (var18_18 <= 0) break block28;
                                        var121_121 = var3_3;
                                        var122_122 = var5_5;
                                        var123_123 = var18_18;
                                        var124_124 = var121_121.substring(var122_122, var123_123).toLowerCase();
                                        var125_125 = var124_124;
                                        if (var125_125.equals(var126_126 = "expires") && (var131_131 = (var130_130 = (var127_127 = var3_3).indexOf(var128_128 = 44, var129_129 = var18_18))) != (var132_132 = 65535) && (var133_133 = var130_130 - var18_18) <= (var134_134 = 10)) {
                                            var5_5 = var130_130 + 1;
                                        }
                                        var135_135 = var3_3;
                                        var136_136 = 59;
                                        var137_137 = var5_5;
                                        var14_14 = var135_135.indexOf(var136_136, var137_137);
                                        var138_138 = var3_3;
                                        var139_139 = 44;
                                        var140_140 = var5_5;
                                        var141_141 = var138_138.indexOf(var139_139, var140_140);
                                        var142_142 = var14_14;
                                        var143_143 = 65535;
                                        if (var142_142 != var143_143 || (var144_144 = var141_141) != (var145_145 = 65535)) break block29;
                                        var5_5 = var6_6;
lbl136:
                                        // 4 sources

                                        while (true) {
                                            var147_147 = var3_3;
                                            var146_146 = var18_18 + 1;
                                            var148_148 = var146_146;
                                            var149_149 = var5_5;
                                            var150_150 = var147_147.substring(var148_148, var149_149);
                                            var151_151 = var150_150.length();
                                            if (var151_151 > (var152_152 = 2) && (var153_153 = var150_150.charAt(0)) == (var154_154 = '\"') && (var155_155 = var150_150.indexOf(34, 1)) > 0) {
                                                var156_156 = var150_150;
                                                var157_157 = 1;
                                                var158_158 = var155_155;
                                                var150_150 = var156_156.substring(var157_157, var158_158);
                                            }
                                            if (!(var159_159 = var124_124).equals(var160_160 = "expires")) break block22;
                                            try {
                                                var19_19.expires = var161_161 = AndroidHttpClient.parseDate(var150_150);
                                            }
                                            catch (IllegalArgumentException var163_162) {
                                                var164_163 = new StringBuilder().append("illegal format for expires: ");
                                                var165_164 = var150_150;
                                                var166_165 = var164_163.append(var165_164).toString();
                                                var167_166 = Log.e("webkit", var166_165);
                                            }
                                            ** GOTO lbl37
                                            break;
                                        }
                                    }
                                    var168_167 = var14_14;
                                    var168_167 = 65535;
                                    if (var168_167 != var168_167) break block30;
                                    var5_5 = var141_141;
                                    ** GOTO lbl136
                                }
                                var170_168 = var141_141;
                                var170_168 = 65535;
                                if (var170_168 != var170_168) break block31;
                                var5_5 = var14_14;
                                ** GOTO lbl136
                            }
                            var172_169 = var14_14;
                            var173_170 = var141_141;
                            var5_5 = Math.min(var172_169, var173_170);
                            ** while (true)
                        }
                        var174_171 = var124_124;
                        var175_172 = "max-age";
                        if (!var174_171.equals(var175_172)) break block32;
                        try {
                            var176_173 = System.currentTimeMillis();
                            var178_174 = Long.parseLong(var150_150);
                            var180_175 = 1000L * var178_174;
                            var19_19.expires = var182_176 = var176_173 + var180_175;
                        }
                        catch (NumberFormatException var184_177) {
                            var185_178 = new StringBuilder().append("illegal format for max-age: ");
                            var186_179 = var150_150;
                            var187_180 = var185_178.append(var186_179).toString();
                            var188_181 = Log.e("webkit", var187_180);
                        }
                        ** GOTO lbl37
                    }
                    var189_182 = var124_124;
                    var190_183 = "path";
                    if (!var189_182.equals(var190_183)) break block33;
                    if (var150_150.length() > 0) {
                        var19_19.path = var191_184 = var150_150;
                    }
                    ** GOTO lbl37
                }
                var192_185 = var124_124;
                var193_186 = "domain";
                if (!var192_185.equals(var193_186)) ** GOTO lbl37
                var194_187 = var150_150.lastIndexOf(46);
                if (var194_187 != 0) break block34;
                var195_188 = null;
                var19_19.domain = var195_188;
                ** GOTO lbl37
            }
            var196_189 = var194_187 + 1;
            try {
                var197_190 = Integer.parseInt(var150_150.substring(var196_189));
                var198_191 = var150_150;
                var199_193 = var1_1;
                if (var198_191.equals(var199_193)) ** GOTO lbl37
                var200_194 = null;
                var19_19.domain = var200_194;
            }
            catch (NumberFormatException var201_195) {
                block35: {
                    block37: {
                        block36: {
                            var150_150 = var150_150.toLowerCase();
                            var202_196 = var150_150.charAt(0);
                            var198_192 = '.';
                            if (var202_196 != var198_192) {
                                var204_197 = new StringBuilder().append('.');
                                var205_198 = var150_150;
                                var206_199 = var204_197.append(var205_198).toString();
                                ++var194_187;
                            }
                            if (!(var208_201 = var1_1).endsWith(var209_202 = (var207_200 = var150_150.substring(1)))) break block35;
                            var210_203 = var150_150.length();
                            var211_204 = var1_1.length();
                            var213_206 = var211_204;
                            if (var213_206 <= (var214_207 = (var212_205 = var210_203 - 1)) || (var218_211 = (var216_209 = var1_1).charAt(var217_210 = (var215_208 = var211_204 - var210_203))) == (var214_207 = 46)) break block36;
                            var220_212 = null;
                            var19_19.domain = var220_212;
                            ** GOTO lbl37
                        }
                        var222_214 = var210_203;
                        var221_213 = var194_187 + 3;
                        var223_215 = var221_213;
                        if (var222_214 == var223_215 || (var224_216 = var210_203) < (var225_217 = 6) || (var226_218 = var210_203) > (var227_219 = 8) || Arrays.binarySearch(var232_224 = CookieManager.BAD_COUNTRY_2LDS, var233_225 = (var231_223 = (var228_220 = var150_150).substring(var229_221 = 1, var230_222 = var194_187))) < 0) break block37;
                        var234_226 = null;
                        var19_19.domain = var234_226;
                        ** GOTO lbl37
                    }
                    var19_19.domain = var235_227 = var150_150;
                    ** GOTO lbl37
                }
                var236_228 = null;
                var19_19.domain = var236_228;
            }
            ** GOTO lbl37
        }
        var5_5 = var6_6;
        ** while (true)
    }

    public boolean acceptCookie() {
        synchronized (this) {
            boolean bl = this.mAcceptCookie;
            return bl;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("doesn't implement Cloneable");
    }

    void deleteACookie(Cookie cookie) {
        synchronized (this) {
            String string2;
            String string3;
            ArrayList<Cookie> arrayList;
            if (cookie.mode == 2 && (arrayList = this.mCookieMap.get(string3 = this.getBaseDomain(string2 = cookie.domain))) != null) {
                boolean bl = arrayList.remove(cookie);
                if (arrayList.isEmpty()) {
                    ArrayList<Cookie> arrayList2 = this.mCookieMap.remove(string3);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ArrayList<Cookie> deleteLRUDomain() {
        synchronized (this) {
            int n;
            int n2 = this.mCookieMap.size();
            if (n2 < 15) {
                int n3;
                Iterator<ArrayList<Cookie>> iterator = this.mCookieMap.values().iterator();
                for (n = 0; iterator.hasNext() && n < 1000; n += n3) {
                    n3 = iterator.next().size();
                }
            }
            ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
            if (n2 >= 15 || n >= 1000) {
                Object[] objectArray = this.mCookieMap.keySet().toArray();
                int n4 = n2 / 10 + 1;
                while (true) {
                    int n5 = n4 + -1;
                    if (n4 <= 0) break;
                    String string2 = objectArray[n5].toString();
                    Collection collection = this.mCookieMap.get(string2);
                    boolean bl = arrayList.addAll(collection);
                    ArrayList<Cookie> arrayList2 = this.mCookieMap.remove(string2);
                    n4 = n5;
                }
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCookie(WebAddress webAddress) {
        synchronized (this) {
            boolean bl = this.mAcceptCookie;
            if (!bl) return null;
            if (webAddress == null) {
                return null;
            }
            String[] stringArray = this.getHostAndPath(webAddress);
            if (stringArray == null) {
                return null;
            }
            CookieManager cookieManager = this;
            String string2 = stringArray[0];
            String string3 = string2;
            String string4 = cookieManager.getBaseDomain(string3);
            ArrayList<Cookie> arrayList = this.mCookieMap.get(string4);
            if (arrayList == null) {
                arrayList = CookieSyncManager.getInstance().getCookiesForDomain(string4);
                ArrayList<Cookie> arrayList2 = this.mCookieMap.put(string4, arrayList);
            }
            long l = System.currentTimeMillis();
            String string5 = webAddress.mScheme;
            boolean bl2 = HTTPS.equals(string5);
            Iterator<Cookie> iterator = arrayList.iterator();
            CookieComparator cookieComparator = COMPARATOR;
            TreeSet<Cookie> treeSet = new TreeSet<Cookie>(cookieComparator);
            while (iterator.hasNext()) {
                String string6;
                String string7;
                Cookie cookie = iterator.next();
                if (!cookie.domainMatch(string7 = stringArray[0]) || !cookie.pathMatch(string6 = stringArray[1]) || cookie.expires >= 0L && cookie.expires <= l || cookie.secure && !bl2 || cookie.mode == 2) continue;
                cookie.lastAcessTime = l;
                boolean bl3 = treeSet.add(cookie);
            }
            StringBuilder stringBuilder = new StringBuilder(256);
            for (Cookie cookie : treeSet) {
                if (stringBuilder.length() > 0) {
                    StringBuilder stringBuilder2 = stringBuilder.append(';');
                    StringBuilder stringBuilder3 = stringBuilder.append(' ');
                }
                String string8 = cookie.name;
                StringBuilder stringBuilder4 = stringBuilder.append(string8);
                if (cookie.value == null) continue;
                StringBuilder stringBuilder5 = stringBuilder.append('=');
                String string9 = cookie.value;
                StringBuilder stringBuilder6 = stringBuilder.append(string9);
            }
            if (stringBuilder.length() <= 0) return null;
            String string10 = stringBuilder.toString();
            return string10;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCookie(String string2) {
        WebAddress webAddress;
        try {
            webAddress = new WebAddress(string2);
        }
        catch (ParseException parseException) {
            String string3 = "Bad address: " + string2;
            int n = Log.e(LOGTAG, string3);
            return null;
        }
        return this.getCookie(webAddress);
    }

    ArrayList<Cookie> getUpdatedCookiesSince(long l) {
        synchronized (this) {
            ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
            Iterator<ArrayList<Cookie>> iterator = this.mCookieMap.values().iterator();
            while (iterator.hasNext()) {
                for (Cookie cookie : iterator.next()) {
                    if (cookie.lastUpdateTime <= l) continue;
                    boolean bl = arrayList.add(cookie);
                }
            }
            return arrayList;
        }
    }

    public boolean hasCookies() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = CookieSyncManager.getInstance().hasCookies();
            return bl2;
        }
    }

    public void removeAllCookie() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CookieManager cookieManager = CookieManager.this;
                synchronized (cookieManager) {
                    CookieManager cookieManager2 = CookieManager.this;
                    LinkedHashMap linkedHashMap = new LinkedHashMap(200, 0.75f, true);
                    Map map = CookieManager.access$102(cookieManager2, linkedHashMap);
                    CookieSyncManager.getInstance().clearAllCookies();
                    return;
                }
            }
        };
        new Thread(runnable).start();
    }

    public void removeExpiredCookie() {
        Runnable runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                CookieManager cookieManager = CookieManager.this;
                synchronized (cookieManager) {
                    long l = System.currentTimeMillis();
                    Iterator iterator = CookieManager.this.mCookieMap.values().iterator();
                    block3: while (true) {
                        if (!iterator.hasNext()) {
                            CookieSyncManager.getInstance().clearExpiredCookies(l);
                            return;
                        }
                        Iterator iterator2 = ((ArrayList)iterator.next()).iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block3;
                            Cookie cookie = (Cookie)iterator2.next();
                            if (cookie.expires <= 0L || cookie.expires >= l) continue;
                            iterator2.remove();
                        }
                        break;
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    public void removeSessionCookie() {
        Runnable runnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                CookieManager cookieManager = CookieManager.this;
                synchronized (cookieManager) {
                    Iterator iterator = CookieManager.this.mCookieMap.values().iterator();
                    block3: while (true) {
                        if (!iterator.hasNext()) {
                            CookieSyncManager.getInstance().clearSessionCookies();
                            return;
                        }
                        Iterator iterator2 = ((ArrayList)iterator.next()).iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block3;
                            if (((Cookie)iterator2.next()).expires != 65535L) continue;
                            iterator2.remove();
                        }
                        break;
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    public void setAcceptCookie(boolean bl) {
        synchronized (this) {
            this.mAcceptCookie = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCookie(WebAddress webAddress, String string2) {
        synchronized (this) {
            String[] stringArray;
            int n;
            Object object;
            int n2;
            if ((string2 == null || (n2 = (object = string2.length())) <= (n = 4096)) && this.mAcceptCookie && webAddress != null && (stringArray = this.getHostAndPath(webAddress)) != null) {
                Object object2;
                block17: {
                    int n3;
                    int n4;
                    int n5 = stringArray[1].length();
                    if (n5 > (n4 = 1)) {
                        String string3;
                        int n6 = stringArray[1].lastIndexOf(47);
                        n3 = 1;
                        String string4 = stringArray[1];
                        int n7 = 0;
                        int n8 = n6 > 0 ? n6 : n6 + 1;
                        stringArray[n3] = string3 = string4.substring(n7, n8);
                    }
                    object2 = null;
                    n3 = 0;
                    try {
                        String string5 = stringArray[n3];
                        String string6 = stringArray[1];
                        CookieManager cookieManager = this;
                        String string7 = string5;
                        String string8 = string6;
                        String string9 = string2;
                        object = cookieManager.parseCookie(string7, string8, string9);
                    }
                    catch (RuntimeException runtimeException) {
                        StringBuilder stringBuilder = new StringBuilder().append("parse cookie failed for: ");
                        String string10 = string2;
                        String string11 = stringBuilder.append(string10).toString();
                        int n9 = Log.e(LOGTAG, string11);
                        break block17;
                    }
                    object2 = object;
                }
                if (object2 != null && ((ArrayList)object2).size() != 0) {
                    int n10;
                    int n11;
                    Map<String, ArrayList<Cookie>> map = this.mCookieMap;
                    CookieManager cookieManager = this;
                    String string12 = stringArray[0];
                    String string13 = string12;
                    String string14 = cookieManager.getBaseDomain(string13);
                    String string15 = string14;
                    ArrayList<Cookie> arrayList = map.get(string15);
                    if (arrayList == null) {
                        CookieSyncManager cookieSyncManager = CookieSyncManager.getInstance();
                        String string16 = string14;
                        arrayList = cookieSyncManager.getCookiesForDomain(string16);
                        Map<String, ArrayList<Cookie>> map2 = this.mCookieMap;
                        String string17 = string14;
                        ArrayList<Cookie> arrayList2 = arrayList;
                        ArrayList<Cookie> arrayList3 = map2.put(string17, arrayList2);
                    }
                    long l = System.currentTimeMillis();
                    int n12 = ((ArrayList)object2).size();
                    int n13 = 0;
                    while ((n11 = ++n13) < (n10 = n12)) {
                        int n14;
                        byte by;
                        long l2;
                        long l3;
                        Cookie cookie = (Cookie)((ArrayList)object2).get(n13);
                        boolean bl = false;
                        for (Cookie cookie2 : arrayList) {
                            if (!bl.exactMatch(cookie2)) continue;
                            if (bl.expires < 0L || bl.expires > l) {
                                String string18;
                                if (!cookie2.secure || HTTPS.equals(string18 = webAddress.mScheme)) {
                                    long l4;
                                    long l5;
                                    boolean bl2;
                                    long l6;
                                    String string19;
                                    cookie2.value = string19 = bl.value;
                                    cookie2.expires = l6 = bl.expires;
                                    cookie2.secure = bl2 = bl.secure;
                                    cookie2.lastAcessTime = l5 = l;
                                    cookie2.lastUpdateTime = l4 = l;
                                    int n15 = 3;
                                    cookie2.mode = (byte)n15;
                                }
                            } else {
                                long l7;
                                cookie2.lastUpdateTime = l7 = l;
                                int n16 = 2;
                                cookie2.mode = (byte)n16;
                            }
                            bl = true;
                            break;
                        }
                        if (bl || bl.expires >= 0L && bl.expires <= l) continue;
                        bl.lastAcessTime = l3 = l;
                        bl.lastUpdateTime = l2 = l;
                        bl.mode = by = 0;
                        int n17 = arrayList.size();
                        if (n17 > (n14 = 50)) {
                            long l8;
                            Cookie cookie3 = new Cookie();
                            cookie3.lastAcessTime = l8 = l;
                            for (Cookie cookie4 : arrayList) {
                                byte by2;
                                byte by3;
                                long l9 = cookie4.lastAcessTime;
                                long l10 = cookie3.lastAcessTime;
                                if (l9 >= l10 || (by3 = cookie4.mode) == (by2 = 2)) continue;
                                cookie3 = cookie4;
                            }
                            int n18 = 2;
                            cookie3.mode = (byte)n18;
                        }
                        boolean bl3 = arrayList.add((Cookie)bl);
                    }
                }
            }
            return;
        }
    }

    public void setCookie(String string2, String string3) {
        WebAddress webAddress;
        try {
            webAddress = new WebAddress(string2);
        }
        catch (ParseException parseException) {
            String string4 = "Bad address: " + string2;
            int n = Log.e(LOGTAG, string4);
            return;
        }
        this.setCookie(webAddress, string3);
    }

    void syncedACookie(Cookie cookie) {
        synchronized (this) {
            cookie.mode = 1;
            return;
        }
    }

    private static final class CookieComparator
    implements Comparator<Cookie> {
        private CookieComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(Cookie cookie, Cookie cookie2) {
            int n;
            int n2;
            int n3 = cookie2.path.length();
            int n4 = n3 - (n2 = cookie.path.length());
            if (n4 != 0) {
                return n4;
            }
            int n5 = cookie2.domain.length();
            n4 = n5 - (n = cookie.domain.length());
            if (n4 != 0) {
                return n4;
            }
            if (cookie2.value == null) {
                if (cookie.value != null) {
                    return -1;
                }
            } else if (cookie.value == null) {
                return 1;
            }
            String string2 = cookie.name;
            String string3 = cookie2.name;
            return string2.compareTo(string3);
        }
    }

    static class Cookie {
        static final byte MODE_DELETED = 2;
        static final byte MODE_NEW = 0;
        static final byte MODE_NORMAL = 1;
        static final byte MODE_REPLACED = 3;
        String domain;
        long expires;
        long lastAcessTime;
        long lastUpdateTime;
        byte mode;
        String name;
        String path;
        boolean secure;
        String value;

        Cookie() {
        }

        Cookie(String string2, String string3) {
            this.domain = string2;
            this.path = string3;
            this.expires = 65535L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean domainMatch(String string2) {
            if (this.domain.startsWith(".")) {
                int n;
                String string3 = this.domain.substring(1);
                if (!string2.endsWith(string3)) return false;
                int n2 = this.domain.length();
                int n3 = string2.length();
                if (n3 <= (n = n2 - 1)) return true;
                int n4 = n3 - n2;
                if (string2.charAt(n4) != '.') return false;
                return true;
            }
            String string4 = this.domain;
            return string2.equals(string4);
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean exactMatch(Cookie cookie) {
            boolean bl = this.value == null;
            boolean bl2 = cookie.value == null;
            boolean bl3 = !(bl ^ bl2);
            String string2 = this.domain;
            String string3 = cookie.domain;
            if (!string2.equals(string3)) return false;
            String string4 = this.path;
            String string5 = cookie.path;
            if (!string4.equals(string5)) return false;
            String string6 = this.name;
            String string7 = cookie.name;
            if (!string6.equals(string7)) return false;
            if (!bl3) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean pathMatch(String string2) {
            String string3 = this.path;
            if (!string2.startsWith(string3)) return false;
            int n = this.path.length();
            if (n == 0) {
                int n2 = Log.w(CookieManager.LOGTAG, "Empty cookie path");
                return false;
            }
            int n3 = string2.length();
            String string4 = this.path;
            int n4 = n - 1;
            if (string4.charAt(n4) == '/') return true;
            if (n3 <= n) return true;
            if (string2.charAt(n) != '/') return false;
            return true;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("domain: ");
            String string2 = this.domain;
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append("; path: ");
            String string3 = this.path;
            StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("; name: ");
            String string4 = this.name;
            StringBuilder stringBuilder4 = stringBuilder3.append(string4).append("; value: ");
            String string5 = this.value;
            return stringBuilder4.append(string5).toString();
        }
    }
}

